/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Stretching;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionStyleExpression;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionalStyle;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.CustomReportGroup;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.generator.style.AdvancedColoredDateCondition;
import transport.report.generator.style.AdvancedColoredTimeCondition;
import transport.report.generator.style.ColoredDateCondition;
import transport.report.generator.style.ColoredIntegerCondition;
import transport.report.generator.style.ColoredLineByIdCondition;
import transport.report.generator.style.ColoredTimeCondition;
import transport.report.generator.style.StyleByFieldValue;

public class DJGenerator {
    protected static int MIN_EXCEL_COLUMN_WIDTH = 100;
    public static String PORTRAIT_TEMPLATE = "report/templatePortrait.jrxml";
    public static String LANDSCAPE_TEMPLATE = "report/templateLandscape.jrxml";
    protected CustomReport report = null;
    protected DynamicReport buildReport = null;
    protected JasperReport compiledReport = null;
    protected Style headerStyle = null;
    private Style contentStyle = null;
    private Style footerStyle = null;
    private Style defaultContentStyle = null;
    private int width = 0;
    private int averageSize = 0;
    protected boolean withTotal = true;

    public CustomReport getReport() {
        return this.report;
    }

    public void setReport(CustomReport report) {
        this.report = report;
    }

    public void setWithTotal(boolean withTotal) {
        this.withTotal = withTotal;
    }

    public JasperPrint generate(Map<String, Object> params, JRMapCollectionDataSource jrmcds) {
        TimsLogger.debug("#TDJG.generate#");
        try {
            if (this.buildReport == null) {
                TimsLogger.debug("#generate# report not build... prebuilding...");
                this.prebuild();
            }
            if (jrmcds == null) {
                throw new Exception("data null");
            }
            if (this.compiledReport == null) {
                this.compile(params);
            }
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)this.compiledReport, params, (JRDataSource)jrmcds);
            return jp;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected Style getHeaderStyle() {
        if (this.headerStyle == null) {
            this.headerStyle = this.getDefaultHeaderStyle();
        }
        return this.headerStyle;
    }

    public void setHeaderStyle(Style style) {
        this.headerStyle = style;
    }

    private Style getDefaultHeaderStyle() {
        Style style = new Style();
        style.setFont(Font.ARIAL_MEDIUM_BOLD);
        style.setBorder(Border.THIN());
        style.setBackgroundColor(Color.white);
        style.setTextColor(Color.black);
        style.setHorizontalAlign(HorizontalAlign.CENTER);
        style.setVerticalAlign(VerticalAlign.MIDDLE);
        style.setTransparent(false);
        style.setBackgroundColor(Color.white);
        return style;
    }

    public Style getContentStyle() {
        if (this.contentStyle == null) {
            this.contentStyle = this.getDefaultContentStyle();
        }
        return this.contentStyle;
    }

    public void setContentStyle(Style style) {
        this.contentStyle = style;
    }

    private Style getDefaultContentStyle() {
        if (this.defaultContentStyle == null) {
            this.defaultContentStyle = new Style();
            this.defaultContentStyle.setFont(Font.ARIAL_SMALL);
            this.defaultContentStyle.setBorder(Border.THIN());
            this.defaultContentStyle.setHorizontalAlign(HorizontalAlign.CENTER);
            this.defaultContentStyle.setVerticalAlign(VerticalAlign.MIDDLE);
            this.defaultContentStyle.setStretchWithOverflow(true);
            this.defaultContentStyle.setTransparent(false);
            this.defaultContentStyle.setBackgroundColor(Color.white);
        }
        return this.defaultContentStyle;
    }

    public void setDefaultContentStyle(Style style) {
        this.defaultContentStyle = style;
    }

    protected Style getFooterStyle() {
        if (!this.isDecorated()) {
            return null;
        }
        if (this.footerStyle == null) {
            this.footerStyle = this.getDefaultFooterStyle();
        }
        return this.footerStyle;
    }

    public void setFooterStyle(Style style) {
        this.footerStyle = style;
    }

    private Style getDefaultFooterStyle() {
        Style style = new Style();
        style.setFont(Font.ARIAL_MEDIUM_BOLD);
        style.setBorder(Border.THIN());
        style.setTextColor(Color.black);
        style.setHorizontalAlign(HorizontalAlign.CENTER);
        style.setVerticalAlign(VerticalAlign.MIDDLE);
        style.setStretchWithOverflow(true);
        style.setStreching(Stretching.RELATIVE_TO_TALLEST_OBJECT);
        style.setTransparent(false);
        style.setBackgroundColor(new Color(210, 230, 255));
        return style;
    }

    public DynamicReportBuilder gloablPrebuild(DynamicReportBuilder detailed) {
        int minus;
        int oldFooterSize;
        TimsLogger.info("#DJGenerator.gloablPrebuild# Building " + this.report.getName());
        TimsLogger.debug("#DJGenerator.gloablPrebuild# Building " + this.report.getColumn());
        TimsLogger.debug("#DJGenerator.gloablPrebuild# Building " + this.report.getProperties());
        detailed.setDetailHeight(16);
        detailed.setMargins(30, 20, 0, 0);
        detailed.setHeaderHeight(20);
        detailed.setGrandTotalLegendStyle(this.getFooterStyle());
        detailed.setGrandTotalLegend(LanguageTranslator.getString("generics.total"));
        detailed.setUseFullPageWidth(true);
        detailed.setPrintColumnNames(true);
        detailed.setAllowDetailSplit(false);
        String template = (String)this.report.getProperties().get("TEMPLATE");
        if (template == null) {
            template = PORTRAIT_TEMPLATE;
        }
        if (this.report.getColumn().size() > 12 && !template.equals(LANDSCAPE_TEMPLATE)) {
            TimsLogger.debug("#DJGenerator.gloablPrebuild# too many column, force landscape template");
            template = LANDSCAPE_TEMPLATE;
        }
        TimsLogger.debug("#DJGenerator.gloablPrebuild# template = " + template + " (" + this.report.getProperties().get("TEMPLATE") + ")");
        TimsLogger.debug("#DJGenerator.gloablPrebuild# out = " + this.report.getProperties().get("OUT"));
        if (this.isDecorated()) {
            detailed.setTemplateFile(template, true, true, true, false);
            if (template.equals(LANDSCAPE_TEMPLATE)) {
                TimsLogger.debug("#DJGenerator.gloablPrebuild# Mode paysage");
                detailed.setPageSizeAndOrientation(Page.Page_A4_Landscape());
            }
        } else {
            detailed.setUseFullPageWidth(true);
            detailed.setIgnorePagination(true);
            detailed.setMargins(0, 0, 0, 0);
            int pageWidth = this.report.getColumn().size() * MIN_EXCEL_COLUMN_WIDTH;
            TimsLogger.debug("DjGenerator.globalPrebuild() # !isDecorated, set page width -> " + pageWidth);
            detailed.setPageSizeAndOrientation(new Page(1500, pageWidth));
        }
        int minWidth = 0;
        int preferredWidth = 0;
        for (CustomReportColumn column : this.report.getColumn()) {
            preferredWidth += column.getWidth();
            minWidth += this.getMinWidth(column);
        }
        if (template == LANDSCAPE_TEMPLATE && this.report.getColumn().size() > 20 && this.isDecorated()) {
            int oldContentSize = (int)this.getContentStyle().getFont().getFontSize();
            int oldHeaderSize = (int)this.getHeaderStyle().getFont().getFontSize();
            oldFooterSize = (int)this.getFooterStyle().getFont().getFontSize();
            minus = 1;
            if (this.report.getColumn().size() > 30) {
                ++minus;
            }
            TimsLogger.debug("#DJGenerator.globalPrebuild()# minus " + minus + " due to column size > 20");
            this.getContentStyle().getFont().setFontSize((float)(oldContentSize - minus));
            this.getHeaderStyle().getFont().setFontSize((float)(oldHeaderSize - minus - 1));
            this.getFooterStyle().getFont().setFontSize((float)(oldFooterSize - minus));
        }
        if (template == PORTRAIT_TEMPLATE && this.report.getColumn().size() > 12 && this.isDecorated()) {
            int oldContentSize = (int)this.getContentStyle().getFont().getFontSize();
            int oldHeaderSize = (int)this.getHeaderStyle().getFont().getFontSize();
            oldFooterSize = (int)this.getFooterStyle().getFont().getFontSize();
            minus = 1;
            if (this.report.getColumn().size() > 15) {
                ++minus;
            }
            TimsLogger.debug("#DJGenerator.globalPrebuild()# minus " + minus + " due to column size > 12");
            this.getContentStyle().getFont().setFontSize((float)(oldContentSize - minus));
            this.getHeaderStyle().getFont().setFontSize((float)(oldHeaderSize - minus));
            this.getFooterStyle().getFont().setFontSize((float)(oldFooterSize - minus));
        }
        return detailed;
    }

    private int getMinWidth(CustomReportColumn column) {
        return 0;
    }

    public ColumnBuilder prebuildColumn(CustomReportColumn column) throws ColumnBuilderException {
        return this.prebuildColumn(column, null, null);
    }

    public ColumnBuilder prebuildColumn(CustomReportColumn column, CustomExpression customExpression, CustomExpression customExpressionForCalculation) throws ColumnBuilderException {
        ColumnBuilder columnBuilder = ColumnBuilder.getNew();
        columnBuilder.setColumnProperty(column.getName(), column.getType());
        if (this.isDecorated()) {
            columnBuilder.setHeaderStyle(this.getHeaderStyle());
            columnBuilder.setStyle(this.getContentStyle());
        } else {
            columnBuilder.addFieldProperty("net.sf.jasperreports.export.xls.wrap.text", "false");
        }
        columnBuilder.setTitle(column.getVisibleName());
        columnBuilder.setTruncateSuffix("...");
        if (column.getWidth() != 0 && this.isDecorated()) {
            TimsLogger.debug("#DjGenerator.prebuildColumn# setWitdth for " + column.getVisibleName() + " = " + column.getWidth());
            columnBuilder.setWidth(column.getWidth());
        } else if (!this.isDecorated()) {
            TimsLogger.debug("#DjGenerator.prebuildColumn# setWitdth (min) for " + column.getVisibleName() + " = " + MIN_EXCEL_COLUMN_WIDTH);
            columnBuilder.setWidth(MIN_EXCEL_COLUMN_WIDTH);
        }
        if (column.getExpression() != null && !column.getExpression().equals("")) {
            TimsLogger.debug("#DjGenerator.prebuildColumn# setPattern for " + column.getVisibleName() + " = " + column.getExpression());
            columnBuilder.setPattern(column.getExpression());
        }
        if (customExpression != null) {
            TimsLogger.debug("#DjGenerator.prebuildColumn# setCustomExpression for " + column.getVisibleName() + " = " + customExpression.toString());
            columnBuilder.setCustomExpression(customExpression);
            if (customExpressionForCalculation != null) {
                columnBuilder.setCustomExpressionForCalculation(customExpressionForCalculation);
            }
        } else if (column.getType().equals("java.lang.Integer") && "time".equals(column.getExpression())) {
            columnBuilder.setCustomExpression(this.getTimeExpression(column.getName()));
            columnBuilder.setCustomExpressionForCalculation(this.getTimeSumExpression(column.getName()));
        } else if (column.getType().equals("java.lang.Integer") && "signed-time".equals(column.getExpression())) {
            columnBuilder.setCustomExpression(this.getSignedTimeExpression(column.getName()));
            columnBuilder.setCustomExpressionForCalculation(this.getTimeSumExpression(column.getName()));
        } else {
            column.getType().equals("java.lang.Float");
        }
        return columnBuilder;
    }

    public void prebuild() {
        TimsLogger.debug("#DJG.prebuild# prebuilding with default DJGenerator");
        if (this.report == null) {
            TimsLogger.debug("#DJG.prebuild# Report = null");
            return;
        }
        try {
            DynamicReportBuilder detailed = this.gloablPrebuild(new DynamicReportBuilder());
            Vector<GroupBuilder> gb = new Vector<GroupBuilder>();
            for (CustomReportGroup customReportGroup : this.report.getGroups()) {
                AbstractColumn groupColumn = ColumnBuilder.getNew().setColumnProperty(customReportGroup.getName(), customReportGroup.getType()).setTitle(customReportGroup.getName()).setWidth(150).build();
                detailed.addColumn(groupColumn);
                GroupBuilder groupBuilder = new GroupBuilder();
                groupBuilder.setCriteriaColumn((PropertyColumn)groupColumn).setGroupLayout(GroupLayout.VALUE_IN_HEADER);
                groupBuilder.setDefaultHeaderVariableStyle(this.getFooterStyle());
                groupBuilder.setFooterLabel(new DJGroupLabel(LanguageTranslator.getString("generics.agencyTotal"), this.getFooterStyle(), LabelPosition.LEFT));
                gb.add(groupBuilder);
            }
            for (CustomReportColumn customReportColumn : this.report.getColumn()) {
                AbstractColumn col = this.prebuildColumn(customReportColumn).build();
                detailed.addColumn(col);
                if (customReportColumn.getType().equals("java.lang.Integer") || customReportColumn.getType().equals("java.lang.Float") && this.withTotal) {
                    if ("time".equals(customReportColumn.getExpression())) {
                        detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle(), this.getTimeFormatter());
                    } else {
                        detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle());
                    }
                }
                if (!customReportColumn.isTotalRequired()) continue;
                for (GroupBuilder group : gb) {
                    if ("time".equals(customReportColumn.getExpression())) {
                        group.addFooterVariable(col, DJCalculation.SUM, this.getFooterStyle(), this.getTimeFormatter());
                        continue;
                    }
                    group.addFooterVariable(col, DJCalculation.SUM, this.getFooterStyle());
                }
            }
            for (GroupBuilder groupBuilder : gb) {
                DJGroup g = groupBuilder.build();
                detailed.addGroup(g);
            }
            this.buildReport = detailed.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JasperReport compile(Map<String, Object> params) throws Exception {
        if (this.buildReport == null) {
            throw new Exception("buildReport null");
        }
        this.compiledReport = DynamicJasperHelper.generateJasperReport((DynamicReport)this.buildReport, (LayoutManager)new ClassicLayoutManager(), params);
        return this.compiledReport;
    }

    protected CustomExpression getTimeExpression(final String fieldName) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return ConversionTime.timeToString((Integer)fields.get(fieldName), parameters.get("RESOLUTION") == null ? 1 : Integer.parseInt(parameters.get("RESOLUTION").toString()));
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }

    protected CustomExpression getSignedTimeExpression(final String fieldName) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                int time = (Integer)fields.get(fieldName);
                String sTime = ConversionTime.timeToString(time, parameters.get("RESOLUTION") == null ? 1 : Integer.parseInt(parameters.get("RESOLUTION").toString()));
                return String.valueOf(time > 0 ? "+" : "") + sTime;
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }

    protected CustomExpression getFloatExpression(final String fieldName) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                System.out.print("#DJGenerator.getFloatExpression# " + fieldName + " = " + fields.get(fieldName));
                return new DecimalFormat("# ###.##").format(((Float)fields.get(fieldName)).longValue());
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }

    protected CustomExpression getTimeSumExpression(final String fieldName) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return fields.get(fieldName);
            }

            public String getClassName() {
                return Integer.class.getName();
            }
        };
    }

    protected DJValueFormatter getTimeFormatter() {
        return new DJValueFormatter(){

            public Object evaluate(Object value, Map fields, Map variables, Map parameters) {
                return ConversionTime.timeToString((Integer)value, parameters.get("RESOLUTION") == null ? 1 : Integer.parseInt(parameters.get("RESOLUTION").toString()));
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }

    protected ArrayList<ConditionalStyle> coloredIntegerStyle(Style baseStyle, Vector<Integer> thresholds, Vector<Color> colors) {
        if (thresholds.size() != colors.size() + 1) {
            TimsLogger.warn("#DJGenerator.coloredIntegerStyle# Warning incorrect numbers of thresholds and colors");
        }
        ArrayList<ConditionalStyle> styles = new ArrayList<ConditionalStyle>();
        try {
            int x = 0;
            while (x < colors.size()) {
                int lowerThreshold = thresholds.get(x);
                int higherThreshold = thresholds.get(x + 1);
                Color color = colors.get(x);
                TimsLogger.debug("#DJGenerator.coloredIntegerStyle# add style : color =>" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + " min = " + lowerThreshold + " max = " + higherThreshold);
                Style style = (Style)baseStyle.clone();
                style.setBackgroundColor(color);
                ConditionalStyle conditional = new ConditionalStyle((ConditionStyleExpression)new ColoredIntegerCondition(lowerThreshold, higherThreshold), style);
                styles.add(conditional);
                ++x;
            }
        }
        catch (CloneNotSupportedException ex) {
            TimsLogger.warn("#DJGenerator.coloredTimeStyle# Can't clone style");
        }
        return styles;
    }

    protected ArrayList<ConditionalStyle> coloredDateStyle(Style baseStyle, Vector<Integer> thresholds, Vector<Color> colors) {
        if (thresholds.size() != colors.size() + 1) {
            TimsLogger.warn("#DJGenerator.coloredDateStyle# Warning incorrect numbers of thresholds and colors");
        }
        ArrayList<ConditionalStyle> styles = new ArrayList<ConditionalStyle>();
        try {
            int x = 0;
            while (x < colors.size()) {
                Color color = colors.get(x);
                Style style = (Style)baseStyle.clone();
                style.setBackgroundColor(color);
                int lowerThreshold = thresholds.get(x);
                int higherThreshold = thresholds.get(x + 1);
                ConditionalStyle conditional = new ConditionalStyle((ConditionStyleExpression)new ColoredDateCondition(lowerThreshold, higherThreshold), style);
                TimsLogger.debug("#DJGenerator.coloredDateStyle# add style : color =>" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + " min = " + lowerThreshold + " max = " + higherThreshold);
                styles.add(conditional);
                ++x;
            }
        }
        catch (CloneNotSupportedException ex) {
            TimsLogger.warn("#DJGenerator.coloredTimeStyle# Can't clone style");
        }
        return styles;
    }

    protected ArrayList<ConditionalStyle> advancedColoredDateStyle(Style baseStyle, Vector<String> thresholds, Vector<Color> colors) {
        if (thresholds.size() != colors.size() + 1) {
            TimsLogger.warn("#DJGenerator.coloredDateStyle# Warning incorrect numbers of thresholds and colors");
        }
        ArrayList<ConditionalStyle> styles = new ArrayList<ConditionalStyle>();
        try {
            int x = 0;
            while (x < colors.size()) {
                Color color = colors.get(x);
                Style style = (Style)baseStyle.clone();
                style.setBackgroundColor(color);
                String fieldMinDayCount = thresholds.get(x);
                String fieldMaxDayCount = thresholds.get(x + 1);
                ConditionalStyle conditional = new ConditionalStyle((ConditionStyleExpression)new AdvancedColoredDateCondition(fieldMinDayCount, fieldMaxDayCount), style);
                TimsLogger.debug("#DJGenerator.advancedColoredDateStyle# add style : color =>" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + " min = " + fieldMinDayCount + " max = " + fieldMaxDayCount);
                styles.add(conditional);
                ++x;
            }
        }
        catch (CloneNotSupportedException ex) {
            TimsLogger.warn("#DJGenerator.coloredTimeStyle# Can't clone style");
        }
        return styles;
    }

    protected ArrayList<ConditionalStyle> coloredTimeStyle(Style baseStyle, Vector<Integer> thresholds, Vector<Color> colors) {
        if (thresholds.size() != colors.size() + 1) {
            TimsLogger.warn("#DJGenerator.coloredTimeStyle# Warning incorrect numbers of thresholds and colors");
        }
        ArrayList<ConditionalStyle> styles = new ArrayList<ConditionalStyle>();
        try {
            int x = 0;
            while (x < colors.size()) {
                int lowerThreshold = thresholds.get(x);
                int higherThreshold = thresholds.get(x + 1);
                Color color = colors.get(x);
                Style style = (Style)baseStyle.clone();
                style.setBackgroundColor(color);
                ConditionalStyle conditional = new ConditionalStyle((ConditionStyleExpression)new ColoredTimeCondition(lowerThreshold, higherThreshold), style);
                styles.add(conditional);
                ++x;
            }
        }
        catch (CloneNotSupportedException ex) {
            TimsLogger.warn("#DJGenerator.coloredTimeStyle# Can't clone style");
        }
        return styles;
    }

    protected ArrayList<ConditionalStyle> advancedColoredIntegerStyle(Style baseStyle, Vector<String> thresholds, Vector<Color> colors) {
        if (thresholds.size() != colors.size() + 1) {
            TimsLogger.warn("#DJGenerator.advancedColoredTimeStyle# Warning incorrect numbers of thresholds and colors");
        }
        ArrayList<ConditionalStyle> styles = new ArrayList<ConditionalStyle>();
        try {
            int x = 0;
            while (x < colors.size()) {
                Color color = colors.get(x);
                Style style = (Style)baseStyle.clone();
                style.setBackgroundColor(color);
                String fieldMin = thresholds.get(x);
                String fieldMax = thresholds.get(x + 1);
                ConditionalStyle conditional = new ConditionalStyle((ConditionStyleExpression)new AdvancedColoredTimeCondition(fieldMin, fieldMax), style);
                TimsLogger.debug("#DJGenerator.advancedColoredTimeStyle# add style : color =>" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + " : min = " + fieldMin + ", max = " + fieldMax);
                styles.add(conditional);
                ++x;
            }
        }
        catch (CloneNotSupportedException ex) {
            TimsLogger.warn("#DJGenerator.advancedColoredTimeStyle# Can't clone style");
        }
        return styles;
    }

    private CustomExpression getGroupExpression(CustomReportGroup group) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return String.valueOf(LanguageTranslator.getString("generics.total")) + " : " + fields.get(LanguageTranslator.getString("vehicle.registrationNumber"));
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }

    protected ArrayList<ConditionalStyle> coloredLineIdStyle(Style baseStyle, Vector<Integer> thresholds, Vector<Color> colors) {
        if (thresholds.size() != colors.size()) {
            TimsLogger.warn("#DJGenerator.coloredLineIdStyle# Warning incorrect numbers of thresholds and colors");
        }
        ArrayList<ConditionalStyle> styles = new ArrayList<ConditionalStyle>();
        try {
            int x = 0;
            while (x < colors.size()) {
                Color color = colors.get(x);
                Style style = (Style)baseStyle.clone();
                style.setBackgroundColor(color);
                int threshold = thresholds.get(x);
                ConditionalStyle conditional = new ConditionalStyle((ConditionStyleExpression)new ColoredLineByIdCondition(threshold), style);
                TimsLogger.debug("#DJGenerator.coloredLineIdStyle# add style : color =>" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + " for ID = " + threshold);
                styles.add(conditional);
                ++x;
            }
        }
        catch (CloneNotSupportedException ex) {
            TimsLogger.warn("#DJGenerator.coloredTimeStyle# Can't clone style");
        }
        return styles;
    }

    public boolean isDecorated() {
        return !"xls".equals(this.report.getProperties().get("OUT")) && !"csv".equals(this.report.getProperties().get("OUT"));
    }

    protected ArrayList<ConditionalStyle> fontStyle(Style baseStyle, String field, Vector<Integer> types, Vector<Font> fonts) {
        if (types.size() != fonts.size()) {
            TimsLogger.warn("#DJGenerator.fontStyle# Warning incorrect numbers of type and fonts");
        }
        ArrayList<ConditionalStyle> styles = new ArrayList<ConditionalStyle>();
        try {
            int x = 0;
            while (x < fonts.size()) {
                int type = types.get(x);
                Font font = fonts.get(x);
                TimsLogger.debug("#DJGenerator.fontStyle# add style : font => " + font.getFontSize() + "," + font.isBold() + " for type " + type);
                Style style = (Style)baseStyle.clone();
                style.setFont(font);
                ConditionalStyle conditional = new ConditionalStyle((ConditionStyleExpression)new StyleByFieldValue(field, type), style);
                styles.add(conditional);
                ++x;
            }
        }
        catch (CloneNotSupportedException ex) {
            TimsLogger.warn("#DJGenerator.coloredTimeStyle# Can't clone style");
        }
        return styles;
    }
}

