/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionStyleExpression;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionalStyle;
import fr.pgh.data.bdd.CustomReportColumn;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;
import transpo.system.TimsLogger;
import transport.report.generator.DJGenerator;
import transport.report.generator.style.StyleByFieldValue;

public class DJGeneratorColoredCellStyle
extends DJGenerator {
    private Vector<Color> conditionalColors = null;
    private Vector<Integer> conditionalThresholds = null;

    public DJGeneratorColoredCellStyle(Vector<Color> conditionalColors, Vector<Integer> conditionalThresholds) {
        this.conditionalColors = conditionalColors;
        this.conditionalThresholds = conditionalThresholds;
    }

    @Override
    public void prebuild() {
        if (this.report == null) {
            return;
        }
        try {
            DynamicReportBuilder detailed = this.gloablPrebuild(new DynamicReportBuilder());
            for (CustomReportColumn column : this.report.getColumn()) {
                ColumnBuilder cb = this.prebuildColumn(column, null, null);
                detailed.addField(String.valueOf(column.getName()) + "_ID", Integer.class.getName());
                if (!"xls".equals(this.report.getProperties().get("OUT")) && column.getType().equals("java.util.Date")) {
                    cb.addConditionalStyles(this.coloredCellStyle(this.getContentStyle(), String.valueOf(column.getName()) + "_ID", this.conditionalThresholds, this.conditionalColors));
                    cb.setPattern(column.getExpression());
                }
                AbstractColumn col = cb.build();
                if (column.getType().equals("java.lang.Integer") && this.withTotal) {
                    if ("time".equals(column.getExpression())) {
                        detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle(), this.getTimeFormatter());
                    } else {
                        detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle());
                    }
                }
                detailed.addColumn(col);
            }
            this.buildReport = detailed.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected ArrayList<ConditionalStyle> coloredCellStyle(Style baseStyle, String fieldName, Vector<Integer> thresholds, Vector<Color> colors) {
        if (thresholds.size() != colors.size()) {
            TimsLogger.warn("#DJGenerator.coloredCellStyle# Warning incorrect numbers of thresholds and colors");
        }
        ArrayList<ConditionalStyle> styles = new ArrayList<ConditionalStyle>();
        try {
            int x = 0;
            while (x < colors.size()) {
                Color color = colors.get(x);
                Style style = (Style)baseStyle.clone();
                style.setBackgroundColor(color);
                int threshold = thresholds.get(x);
                ConditionalStyle conditional = new ConditionalStyle((ConditionStyleExpression)new StyleByFieldValue(fieldName, threshold), style);
                TimsLogger.debug("#DJGenerator.coloredLineIdStyle# add style : color =>" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + " for ID = " + threshold);
                styles.add(conditional);
                ++x;
            }
        }
        catch (CloneNotSupportedException ex) {
            TimsLogger.warn("#DJGenerator.coloredTimeStyle# Can't clone style");
        }
        return styles;
    }
}

