/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionStyleExpression;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionalStyle;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.DayPlanning;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.exception.DayTypeNotFoundException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;
import transport.report.generator.DJGenerator;
import transport.report.generator.style.PlanningBackgroundColor;

public class DJPlanning
extends DJGenerator {
    private ArrayList<ConditionalStyle> getConditionnalStyles(String fieldName) {
        ArrayList<ConditionalStyle> conditionalStyles = new ArrayList<ConditionalStyle>();
        for (JourType day : JourType.getList()) {
            PlanningBackgroundColor b = new PlanningBackgroundColor(fieldName, day.getCle());
            Style cellBackgroundStyle = new Style();
            cellBackgroundStyle.setTransparency(Transparency.OPAQUE);
            cellBackgroundStyle.setBackgroundColor(new Color(day.getColor()));
            ConditionalStyle cs = new ConditionalStyle((ConditionStyleExpression)b, cellBackgroundStyle);
            conditionalStyles.add(cs);
        }
        return conditionalStyles;
    }

    @Override
    public void prebuild() {
        if (this.report == null) {
            return;
        }
        try {
            DynamicReportBuilder detailed = this.gloablPrebuild(new DynamicReportBuilder());
            detailed.setDetailHeight(45);
            for (CustomReportColumn column : this.report.getColumn()) {
                CustomExpression ce = null;
                if (!column.getName().equals(LanguageTranslator.getString("generics.driver"))) {
                    ce = this.getColumnContent(column.getName());
                }
                ColumnBuilder cb = this.prebuildColumn(column, ce, null);
                if (!column.getName().equals(LanguageTranslator.getString("generics.driver"))) {
                    ArrayList<ConditionalStyle> listCondStyle = this.getConditionnalStyles(column.getName());
                    cb.addConditionalStyles(listCondStyle);
                }
                AbstractColumn col = cb.build();
                col.setMarkup("html");
                detailed.addColumn(col);
            }
            this.buildReport = detailed.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected CustomExpression getColumnContent(final String fieldName) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                String toReturn = "";
                Vector abs = (Vector)fields.get(fieldName);
                if (abs == null || abs.size() == 0) {
                    toReturn = null;
                } else {
                    if (abs.size() > 1) {
                        TimsLogger.debug("DJPlanning# more than one row");
                    }
                    try {
                        JourType dayType = JourType.getDayType(((DayPlanning)abs.get(0)).getDayTypeId());
                        String vehicles = "";
                        for (Integer id : ((DayPlanning)abs.get(0)).getVehicles()) {
                            try {
                                vehicles = String.valueOf(vehicles) + ", " + Vehicule.getVehicule(null, id).getRegistrationNumber();
                            }
                            catch (DBObjectNotFoundException e) {
                                TimsLogger.warn("#PlanningAgence.loadTable# Vehicle not found");
                            }
                        }
                        toReturn = "<html><center><span><b>" + dayType.getCode() + "</b></span><br/>" + (vehicles.equals("") ? "" : vehicles.substring(2)) + "<br/>" + ((DayPlanning)abs.get(0)).getComm() + "</center></html>";
                    }
                    catch (DayTypeNotFoundException ex) {
                        TimsLogger.warn("#PlanningAgence.loadTable# DayType not found");
                    }
                }
                Fonctions.afficheMap(fields);
                TimsLogger.debug("#DJPlanning.getColumnContent# " + fieldName + " returns " + toReturn);
                return toReturn;
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }
}

