/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import fr.pgh.data.bdd.CustomReportColumn;
import java.awt.Color;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transport.report.generator.DJGenerator;

public class DJRoundAnalysisGenerator
extends DJGenerator {
    private Vector<Color> conditionalColors = new Vector();

    public DJRoundAnalysisGenerator() {
        this.conditionalColors.add(MainFrameTransport.BG_PASTEL_GREEN);
        this.conditionalColors.add(Color.white);
        this.conditionalColors.add(MainFrameTransport.BG_PASTEL_RED);
    }

    @Override
    public void prebuild() {
        if (this.report == null) {
            return;
        }
        try {
            DynamicReportBuilder detailed = this.gloablPrebuild(new DynamicReportBuilder());
            for (CustomReportColumn column : this.report.getColumn()) {
                ColumnBuilder cb = this.prebuildColumn(column, null, null);
                if (column.getType().equals("java.lang.Integer") && column.getExpression().equals("signed-time") && !"xls".equals(this.report.getProperties().get("OUT"))) {
                    TimsLogger.debug("#DJRoundAnalysisGenerator.prebuild# ajout des couleurs pour " + column.getName());
                    Vector<String> conditionalThresholds = new Vector<String>();
                    conditionalThresholds.add(String.valueOf(column.getName()) + "_ALWAYS");
                    conditionalThresholds.add(String.valueOf(column.getName()) + "_THRESHOLD1");
                    conditionalThresholds.add(String.valueOf(column.getName()) + "_THRESHOLD2");
                    conditionalThresholds.add(String.valueOf(column.getName()) + "_ALWAYS");
                    cb.setPattern(column.getExpression());
                    cb.addConditionalStyles(this.advancedColoredIntegerStyle(this.getContentStyle(), conditionalThresholds, this.conditionalColors));
                    detailed.addField(String.valueOf(column.getName()) + "_THRESHOLD1", Integer.class.getName());
                    detailed.addField(String.valueOf(column.getName()) + "_THRESHOLD2", Integer.class.getName());
                }
                AbstractColumn col = cb.build();
                if (column.getType().equals("java.lang.Integer") && this.withTotal) {
                    if ("signed-time".equals(column.getExpression())) {
                        detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle(), this.getTimeFormatter());
                    } else {
                        detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle());
                    }
                }
                detailed.addColumn(col);
            }
            this.buildReport = detailed.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

