/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.DJVariableIncrementType;
import ar.com.fdvs.dj.domain.constants.DJVariableResetType;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.DJVariable;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import fr.pgh.data.bdd.CustomReportColumn;
import java.awt.Color;
import java.util.Map;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.CustomReportFactory;
import transport.report.generator.DJGenerator;

public class DJServiceGenerator
extends DJGenerator {
    @Override
    public void prebuild() {
        if (this.report == null) {
            this.report = CustomReportFactory.getDriverServiceDefault();
        }
        try {
            AbstractColumn columnWeek;
            boolean weeklySum;
            DynamicReportBuilder detailed = this.gloablPrebuild(new DynamicReportBuilder());
            GroupBuilder weekGroupBuilder = null;
            GroupBuilder hsGB = null;
            Style weekFGS = null;
            Style hsFGS = null;
            boolean hs = this.report.getProperties().get("HS") == null ? false : this.report.getProperties().get("HS").toString().equals("1");
            boolean bl = weeklySum = this.report.getProperties().get("WEEKLY_SUBTOTAL") == null ? false : this.report.getProperties().get("WEEKLY_SUBTOTAL").equals("1");
            if (weeklySum) {
                weekFGS = new Style();
                weekFGS.setFont(Font.ARIAL_MEDIUM_BOLD);
                weekFGS.setBorder(Border.PEN_1_POINT());
                weekFGS.setBackgroundColor(new Color(240, 240, 240));
                weekFGS.setTextColor(Color.black);
                weekFGS.setHorizontalAlign(HorizontalAlign.CENTER);
                weekFGS.setVerticalAlign(VerticalAlign.MIDDLE);
                weekFGS.setTransparency(Transparency.OPAQUE);
                columnWeek = ColumnBuilder.getNew().setColumnProperty("SEMAINE", Integer.class.getName()).setTitle("SEMAINE").setWidth(100).setShowText(false).setHeaderStyle(this.getContentStyle()).build();
                detailed.addColumn(columnWeek);
                weekGroupBuilder = new GroupBuilder();
                weekGroupBuilder.setCriteriaColumn((PropertyColumn)columnWeek).setGroupLayout(GroupLayout.EMPTY);
            }
            if (hs) {
                detailed.addParameter("HE_THRESHOLD", Integer.class.getName());
                detailed.addParameter("HN_THRESHOLD", Integer.class.getName());
                detailed.addParameter("HS_THRESHOLD", Integer.class.getName());
                hsFGS = new Style();
                hsFGS.setFont(Font.ARIAL_MEDIUM_BOLD);
                hsFGS.setBorder(Border.PEN_1_POINT());
                hsFGS.setBackgroundColor(new Color(150, 150, 150));
                hsFGS.setTextColor(Color.black);
                hsFGS.setHorizontalAlign(HorizontalAlign.CENTER);
                hsFGS.setVerticalAlign(VerticalAlign.MIDDLE);
                hsFGS.setTransparency(Transparency.OPAQUE);
                columnWeek = ColumnBuilder.getNew().setColumnProperty(LanguageTranslator.getString("generics.contract"), Integer.class.getName()).setTitle(LanguageTranslator.getString("generics.contract")).setWidth(100).setShowText(false).setHeaderStyle(this.getContentStyle()).build();
                detailed.addColumn(columnWeek);
                hsGB = new GroupBuilder();
                hsGB.setCriteriaColumn((PropertyColumn)columnWeek).setGroupLayout(GroupLayout.EMPTY);
            }
            for (CustomReportColumn column : this.report.getColumn()) {
                AbstractColumn col = this.prebuildColumn(column).build();
                detailed.addColumn(col);
                if (!column.getType().equals("java.lang.Integer") && !column.getType().equals("java.lang.Float")) continue;
                TimsLogger.debug("#DJSG.process()# on est sur un entier ... on g\u00e9n\u00e8re les totaux");
                if (weeklySum) {
                    if ("time".equals(column.getExpression())) {
                        weekGroupBuilder.addFooterVariable(col, DJCalculation.SUM, weekFGS, this.getTimeFormatter());
                    } else {
                        weekGroupBuilder.addFooterVariable(col, DJCalculation.SUM, weekFGS);
                    }
                }
                if (hs) {
                    if ("time".equals(column.getExpression())) {
                        hsGB.addFooterVariable(col, DJCalculation.SUM, hsFGS, this.getTimeFormatter());
                    } else {
                        hsGB.addFooterVariable(col, DJCalculation.SUM, hsFGS);
                    }
                }
                if (hs && column.getName().equals(LanguageTranslator.getString("generics.serviceTotal"))) {
                    DJGroupVariable variable = new DJGroupVariable(col, this.getHSSumCalculationExpression("HN_THRESHOLD", "HE_THRESHOLD"));
                    AbstractColumn columnHE252 = ColumnBuilder.getNew().setColumnProperty("HS 25% 2", Integer.class.getName()).setTitle("HS 25% 2").setHeaderStyle(this.headerStyle).setStyle(this.getContentStyle()).setWidth(col.getWidth()).setCustomExpression(this.getHSCalculationExpression()).build();
                    detailed.addColumn(columnHE252);
                    hsGB.addFooterVariable(columnHE252, this.getHSSumCalculationExpression2(), hsFGS);
                    detailed.addGlobalFooterVariable(variable);
                }
                if ("time".equals(column.getExpression())) {
                    detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle(), this.getTimeFormatter());
                    continue;
                }
                detailed.addGlobalFooterVariable(col, DJCalculation.SUM, this.getFooterStyle());
            }
            if (weeklySum) {
                DJGroup weekGroup = weekGroupBuilder.build();
                detailed.addGroup(weekGroup);
            }
            if (hs) {
                DJGroup hsGroup = hsGB.build();
                DJVariable he = new DJVariable("HE", "java.lang.Integer", DJCalculation.NOTHING, this.getHSSumCalculationExpression("HN_THRESHOLD", "HE_THRESHOLD"));
                he.setResetGroup(hsGroup);
                he.setResetType(DJVariableResetType.GROUP);
                he.setIncrementGroup(hsGroup);
                he.setIncrementType(DJVariableIncrementType.GROUP);
                DJVariable hs25 = new DJVariable("HS25", "java.lang.Integer", DJCalculation.NOTHING, this.getHSSumCalculationExpression("HE_THRESHOLD", "HS_THRESHOLD"));
                hs25.setResetGroup(hsGroup);
                hs25.setResetType(DJVariableResetType.GROUP);
                DJVariable hs50 = new DJVariable("HS50", "java.lang.Integer", DJCalculation.NOTHING, this.getHSSumCalculationExpression("HS_THRESHOLD", null));
                hs50.setResetGroup(hsGroup);
                hs50.setResetType(DJVariableResetType.GROUP);
                detailed.addGroup(hsGroup);
            }
            this.buildReport = detailed.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ColumnBuilder getHSColumn(String name, Style style, String minThreshold, String maxThreshold) throws ColumnBuilderException {
        return ColumnBuilder.getNew().setColumnProperty(name, Integer.class.getName()).setTitle(name).setHeaderStyle(this.headerStyle).setStyle(style).setCustomExpression(this.getHSCalculationExpression()).setCustomExpressionForCalculation(this.getHSSumCalculationExpression(minThreshold, maxThreshold));
    }

    private CustomExpression getHSCalculationExpression() {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                System.err.println("getHSCalculationExpression");
                return "-";
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }

    private CustomExpression getHSSumCalculationExpression(final String firstThreshold, final String secondThreshold) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                int toReturn = 0;
                System.err.print("#getHSSumCalculationExpression# " + firstThreshold + "=>" + parameters.get(firstThreshold) + " " + secondThreshold + "=>" + parameters.get(secondThreshold) + " on calcule ");
                int value = (Integer)variables.get("variable-footer_" + LanguageTranslator.getString("generics.serviceTotal"));
                System.err.print(value);
                int first = firstThreshold != null ? Integer.parseInt(parameters.get(firstThreshold).toString()) : 0;
                System.err.print("par rapport a " + first);
                int second = secondThreshold != null ? Integer.parseInt(parameters.get(secondThreshold).toString()) : 100000;
                System.err.print(" et " + second);
                System.err.print("#getHSSumCalculationExpression# on calcule " + value + " par rapport a " + first + " et " + second);
                toReturn = value > first ? (value > second ? second - first : value - first) : 0;
                System.err.println(" retourne " + toReturn);
                return toReturn;
            }

            public String getClassName() {
                return Integer.class.getName();
            }
        };
    }

    private CustomExpression getHSSumCalculationExpression2() {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                int value = (Integer)variables.get("variable-footer_" + LanguageTranslator.getString("generics.serviceTotal"));
                System.err.println("service =>" + value);
                return variables.get("HE");
            }

            public String getClassName() {
                return Integer.class.getName();
            }
        };
    }
}

