/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionStyleExpression;
import fr.pgh.data.bdd.CustomReportColumn;
import java.awt.Color;
import java.util.Map;
import java.util.Vector;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.generator.DJGenerator;
import transport.report.generator.style.BornedConditionStyle;

public class DJVehicleLocationGenerator
extends DJGenerator {
    private Vector<Color> conditionalColors = new Vector();
    private Vector<Integer> conditionalThresholds = null;

    public DJVehicleLocationGenerator() {
        this.conditionalColors.add(MainFrameTransport.BG_COLOR_UNUSED_DEFAULT);
        this.conditionalColors.add(MainFrameTransport.BG_COLOR_OK_DEFAULT);
        this.conditionalColors.add(MainFrameTransport.BG_COLOR_ALERTE_DEFAULT);
        this.conditionalColors.add(MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT);
        this.conditionalThresholds = new Vector();
        this.conditionalThresholds.add(BornedConditionStyle.ALWAYS_VALUE);
        this.conditionalThresholds.add(Integer.parseInt(System.getProperty("location_ok", "-5000")));
        this.conditionalThresholds.add(Integer.parseInt(System.getProperty("location_warning", "0")));
        this.conditionalThresholds.add(Integer.parseInt(System.getProperty("location_error", "10000")));
        this.conditionalThresholds.add(Integer.parseInt(System.getProperty("location_error", "250000")));
        this.conditionalThresholds.add(BornedConditionStyle.ALWAYS_VALUE);
    }

    @Override
    public void prebuild() {
        if (this.report == null) {
            return;
        }
        try {
            DynamicReportBuilder detailed = this.gloablPrebuild(new DynamicReportBuilder());
            for (CustomReportColumn column : this.report.getColumn()) {
                ColumnBuilder cb = this.prebuildColumn(column, null, null);
                if (!"xls".equals(this.report.getProperties().get("OUT"))) {
                    cb.setPattern(column.getExpression());
                    if (column.getName().equals("delta")) {
                        cb.addConditionalStyles(this.coloredIntegerStyle(this.getContentStyle(), this.conditionalThresholds, this.conditionalColors));
                    }
                }
                AbstractColumn col = cb.build();
                detailed.addColumn(col);
            }
            this.buildReport = detailed.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected class ColoredKm
    extends ConditionStyleExpression
    implements CustomExpression {
        public Object evaluate(Map fields, Map variables, Map parameters) {
            Object value = this.getCurrentValue();
            try {
                if (value == null || !(value instanceof Integer)) {
                    return Boolean.FALSE;
                }
                int km = (Integer)fields.get(LanguageTranslator.getString("vehicle.locationKm"));
                System.err.println("DJVehicleLocationGenerator.ColoredKm# " + value.toString() + " km = " + km);
                if (km < (Integer)value) {
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return Boolean.FALSE;
            }
        }

        public String getClassName() {
            return Boolean.class.getName();
        }
    }
}

