/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator.style;

import java.util.Map;
import transpo.system.Transport;
import transport.report.generator.style.BornedConditionStyle;

public class ColoredIntegerCondition
extends BornedConditionStyle {
    public ColoredIntegerCondition(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public Object evaluate(Map fields, Map variables, Map parameters) {
        Object value = this.getCurrentValue();
        try {
            if (value == null || !(value instanceof Integer) || this.error()) {
                return Boolean.FALSE;
            }
            int field = (Integer)value;
            if (Transport.debug >= 1) {
                System.err.println("ColoredIntegerCondition : " + value + " minValue = " + this.min + ", maxValue = " + this.max);
            }
            if (!(this.min > field && this.min != ALWAYS_VALUE || field >= this.max && this.max != ALWAYS_VALUE)) {
                if (Transport.debug >= 1) {
                    System.err.println("ColoredIntegerCondition : TRUE " + value + " minValue = " + this.min + ", maxValue = " + this.max);
                }
                return Boolean.TRUE;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return Boolean.FALSE;
    }

    public String getClassName() {
        return Boolean.class.getName();
    }
}

