/*
 * Decompiled with CFR 0.152.
 */
package transport.report.generator.style;

import java.util.Map;
import transpo.system.TimsLogger;
import transport.report.generator.TimeConverter;
import transport.report.generator.TimeConverterFactory;
import transport.report.generator.style.BornedConditionStyle;

public class ColoredTimeCondition
extends BornedConditionStyle {
    public ColoredTimeCondition(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public ColoredTimeCondition() {
    }

    public Object evaluate(Map fields, Map variables, Map parameters) {
        Object value = this.getCurrentValue();
        int resolution = parameters.get("RESOLUTION") == null ? 0 : Integer.valueOf(parameters.get("RESOLUTION").toString());
        TimeConverter convert = TimeConverterFactory.getTimeConverter(resolution);
        if (value == null || this.error()) {
            System.err.println(" (NULL) => FALSE (1)");
            return Boolean.FALSE;
        }
        try {
            int time = convert.parse(value.toString());
            if (!(this.min >= time && this.min != ALWAYS_VALUE || time > this.max && this.max != ALWAYS_VALUE)) {
                System.err.println(" (" + time + ") => TRUE");
                return Boolean.TRUE;
            }
            System.err.println(" (" + time + ") => FALSE (2)");
        }
        catch (Exception ex) {
            TimsLogger.warn("#ColoredTimeCondition.evaluate# parse error " + value + " " + ex.getMessage());
            ex.printStackTrace();
        }
        System.err.println(" (" + value.toString() + ") => FALSE (3)");
        return Boolean.FALSE;
    }

    public String getClassName() {
        return Boolean.class.getName();
    }
}

