/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.client.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class BeIDDigest
extends Enum<BeIDDigest> {
    public static final /* enum */ BeIDDigest PLAIN_TEXT = new BeIDDigest(new byte[]{48, -1, 48, 9, 6, 7, 96, 56, 1, 2, 1, 3, 1, 4, -1});
    public static final /* enum */ BeIDDigest SHA_1;
    public static final /* enum */ BeIDDigest SHA_224;
    public static final /* enum */ BeIDDigest SHA_256;
    public static final /* enum */ BeIDDigest SHA_384;
    public static final /* enum */ BeIDDigest SHA_512;
    public static final /* enum */ BeIDDigest RIPEMD_128;
    public static final /* enum */ BeIDDigest RIPEMD_160;
    public static final /* enum */ BeIDDigest RIPEMD_256;
    public static final /* enum */ BeIDDigest SHA_1_PSS;
    public static final /* enum */ BeIDDigest SHA_256_PSS;
    public static final /* enum */ BeIDDigest NONE;
    private final byte[] prefix;
    private final byte algorithmReference;
    private static final /* synthetic */ BeIDDigest[] ENUM$VALUES;

    static {
        byte[] byArray = new byte[15];
        byArray[0] = 48;
        byArray[1] = 33;
        byArray[2] = 48;
        byArray[3] = 9;
        byArray[4] = 6;
        byArray[5] = 5;
        byArray[6] = 43;
        byArray[7] = 14;
        byArray[8] = 3;
        byArray[9] = 2;
        byArray[10] = 26;
        byArray[11] = 5;
        byArray[13] = 4;
        byArray[14] = 20;
        SHA_1 = new BeIDDigest(byArray);
        byte[] byArray2 = new byte[19];
        byArray2[0] = 48;
        byArray2[1] = 45;
        byArray2[2] = 48;
        byArray2[3] = 13;
        byArray2[4] = 6;
        byArray2[5] = 9;
        byArray2[6] = 96;
        byArray2[7] = -122;
        byArray2[8] = 72;
        byArray2[9] = 1;
        byArray2[10] = 101;
        byArray2[11] = 3;
        byArray2[12] = 4;
        byArray2[13] = 2;
        byArray2[14] = 4;
        byArray2[15] = 5;
        byArray2[17] = 4;
        byArray2[18] = 28;
        SHA_224 = new BeIDDigest(byArray2);
        byte[] byArray3 = new byte[19];
        byArray3[0] = 48;
        byArray3[1] = 49;
        byArray3[2] = 48;
        byArray3[3] = 13;
        byArray3[4] = 6;
        byArray3[5] = 9;
        byArray3[6] = 96;
        byArray3[7] = -122;
        byArray3[8] = 72;
        byArray3[9] = 1;
        byArray3[10] = 101;
        byArray3[11] = 3;
        byArray3[12] = 4;
        byArray3[13] = 2;
        byArray3[14] = 1;
        byArray3[15] = 5;
        byArray3[17] = 4;
        byArray3[18] = 32;
        SHA_256 = new BeIDDigest(byArray3);
        byte[] byArray4 = new byte[19];
        byArray4[0] = 48;
        byArray4[1] = 65;
        byArray4[2] = 48;
        byArray4[3] = 13;
        byArray4[4] = 6;
        byArray4[5] = 9;
        byArray4[6] = 96;
        byArray4[7] = -122;
        byArray4[8] = 72;
        byArray4[9] = 1;
        byArray4[10] = 101;
        byArray4[11] = 3;
        byArray4[12] = 4;
        byArray4[13] = 2;
        byArray4[14] = 2;
        byArray4[15] = 5;
        byArray4[17] = 4;
        byArray4[18] = 48;
        SHA_384 = new BeIDDigest(byArray4);
        byte[] byArray5 = new byte[19];
        byArray5[0] = 48;
        byArray5[1] = 81;
        byArray5[2] = 48;
        byArray5[3] = 13;
        byArray5[4] = 6;
        byArray5[5] = 9;
        byArray5[6] = 96;
        byArray5[7] = -122;
        byArray5[8] = 72;
        byArray5[9] = 1;
        byArray5[10] = 101;
        byArray5[11] = 3;
        byArray5[12] = 4;
        byArray5[13] = 2;
        byArray5[14] = 3;
        byArray5[15] = 5;
        byArray5[17] = 4;
        byArray5[18] = 64;
        SHA_512 = new BeIDDigest(byArray5);
        byte[] byArray6 = new byte[15];
        byArray6[0] = 48;
        byArray6[1] = 29;
        byArray6[2] = 48;
        byArray6[3] = 9;
        byArray6[4] = 6;
        byArray6[5] = 5;
        byArray6[6] = 43;
        byArray6[7] = 36;
        byArray6[8] = 3;
        byArray6[9] = 2;
        byArray6[10] = 2;
        byArray6[11] = 5;
        byArray6[13] = 4;
        byArray6[14] = 16;
        RIPEMD_128 = new BeIDDigest(byArray6);
        byte[] byArray7 = new byte[15];
        byArray7[0] = 48;
        byArray7[1] = 33;
        byArray7[2] = 48;
        byArray7[3] = 9;
        byArray7[4] = 6;
        byArray7[5] = 5;
        byArray7[6] = 43;
        byArray7[7] = 36;
        byArray7[8] = 3;
        byArray7[9] = 2;
        byArray7[10] = 1;
        byArray7[11] = 5;
        byArray7[13] = 4;
        byArray7[14] = 20;
        RIPEMD_160 = new BeIDDigest(byArray7);
        byte[] byArray8 = new byte[15];
        byArray8[0] = 48;
        byArray8[1] = 45;
        byArray8[2] = 48;
        byArray8[3] = 9;
        byArray8[4] = 6;
        byArray8[5] = 5;
        byArray8[6] = 43;
        byArray8[7] = 36;
        byArray8[8] = 3;
        byArray8[9] = 2;
        byArray8[10] = 3;
        byArray8[11] = 5;
        byArray8[13] = 4;
        byArray8[14] = 32;
        RIPEMD_256 = new BeIDDigest(byArray8);
        SHA_1_PSS = new BeIDDigest(new byte[0], 16);
        SHA_256_PSS = new BeIDDigest(new byte[0], 32);
        NONE = new BeIDDigest(new byte[0]);
        ENUM$VALUES = new BeIDDigest[]{PLAIN_TEXT, SHA_1, SHA_224, SHA_256, SHA_384, SHA_512, RIPEMD_128, RIPEMD_160, RIPEMD_256, SHA_1_PSS, SHA_256_PSS, NONE};
    }

    private BeIDDigest(byte[] prefix, int algorithmReference) {
        this.prefix = prefix;
        this.algorithmReference = (byte)algorithmReference;
    }

    private BeIDDigest(byte[] prefix) {
        this(prefix, 1);
    }

    public static BeIDDigest getInstance(String name) {
        return BeIDDigest.valueOf(name);
    }

    public byte[] getPrefix(int valueLength) {
        if (this.equals((Object)PLAIN_TEXT)) {
            byte[] digestInfoPrefix = Arrays.copyOf(this.prefix, this.prefix.length);
            digestInfoPrefix[1] = (byte)(valueLength + 13);
            digestInfoPrefix[14] = (byte)valueLength;
            return digestInfoPrefix;
        }
        return this.prefix;
    }

    public byte getAlgorithmReference() {
        return this.algorithmReference;
    }

    public String getStandardName() {
        return this.name().replace('_', '-');
    }

    public MessageDigest getMessageDigestInstance() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.getStandardName());
    }

    public static BeIDDigest[] values() {
        BeIDDigest[] beIDDigestArray = ENUM$VALUES;
        int n = beIDDigestArray.length;
        BeIDDigest[] beIDDigestArray2 = new BeIDDigest[n];
        System.arraycopy(ENUM$VALUES, 0, beIDDigestArray2, 0, n);
        return beIDDigestArray2;
    }

    public static BeIDDigest valueOf(String string) {
        return Enum.valueOf(BeIDDigest.class, string);
    }
}

