/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.client.impl;

import be.fedict.commons.eid.client.spi.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class CCID {
    public static final int GET_FEATURES = 1107299656;
    public static final int GET_FEATURES_MICROSOFT = 3224864;
    public static final int MIN_PIN_SIZE = 4;
    public static final int MAX_PIN_SIZE = 12;
    public static final String DUTCH_LANGUAGE = "nl";
    public static final String FRENCH_LANGUAGE = Locale.FRENCH.getLanguage();
    public static final String GERMAN_LANGUAGE = Locale.GERMAN.getLanguage();
    public static final int DUTCH_LANGUAGE_CODE = 19;
    public static final int FRENCH_LANGUAGE_CODE = 12;
    public static final int GERMAN_LANGUAGE_CODE = 7;
    public static final int ENGLISH_LANGUAGE_CODE = 9;
    public static Set<String> ppduNames = new HashSet<String>();
    private final Logger logger;
    private final Card card;
    private final EnumMap<FEATURE, Integer> features;
    private boolean usesPPDU;

    public static void addPPDUName(String name) {
        ppduNames.add(name.toLowerCase());
    }

    private boolean isPPDUCardTerminal(String name) {
        name = name.toLowerCase();
        for (String ppduName : ppduNames) {
            if (!name.contains(ppduName)) continue;
            return true;
        }
        return false;
    }

    public boolean usesPPDU() {
        return this.usesPPDU;
    }

    public CCID(Card card, CardTerminal cardTerminal, Logger logger) {
        this.card = card;
        this.logger = logger;
        this.features = new EnumMap(FEATURE.class);
        this.usesPPDU = false;
        boolean onMSWindows = System.getProperty("os.name") != null && System.getProperty("os.name").startsWith("Windows");
        this.logger.debug("Getting CCID FEATURES using standard control command");
        try {
            this.getFeaturesUsingControlChannel(card, onMSWindows);
            if (this.features.isEmpty() && onMSWindows && this.isPPDUCardTerminal(cardTerminal.getName())) {
                this.getFeaturesUsingPPDU(card);
            }
        }
        catch (CardException cexInNormal) {
            this.logger.debug("GET_FEATURES over standard control command failed: " + cexInNormal.getMessage());
            if (onMSWindows && this.isPPDUCardTerminal(cardTerminal.getName())) {
                this.logger.debug("Attempting To get CCID FEATURES using Pseudo-APDU Fallback Strategy");
                try {
                    this.getFeaturesUsingPPDU(card);
                }
                catch (CardException cexInPseudo) {
                    this.logger.error("Pseudo-APDU Fallback strategy failed as well: " + cexInPseudo.getMessage());
                }
            }
            this.logger.debug("Not risking PPDU Fallback strategy for CardTerminal [" + cardTerminal.getName() + "] on this platform");
        }
    }

    private void getFeaturesUsingControlChannel(Card card, boolean onMSWindows) throws CardException {
        byte[] featureBytes = card.transmitControlCommand(onMSWindows ? 3224864 : 1107299656, new byte[0]);
        this.logger.debug("CCID FEATURES found using standard control command");
        FEATURE[] fEATUREArray = FEATURE.values();
        int n = fEATUREArray.length;
        int n2 = 0;
        while (n2 < n) {
            FEATURE feature = fEATUREArray[n2];
            Integer featureCode = this.findFeatureTLV(feature.getTag(), featureBytes);
            if (featureCode != null) {
                this.features.put(feature, featureCode);
                this.logger.debug("FEATURE " + feature.name() + " = " + Integer.toHexString(featureCode));
            }
            ++n2;
        }
    }

    private void getFeaturesUsingPPDU(Card card) throws CardException {
        ResponseAPDU responseAPDU = card.getBasicChannel().transmit(new CommandAPDU(-1, -62, 1, 0, new byte[0], 32));
        this.logger.debug("PPDU response: " + Integer.toHexString(responseAPDU.getSW()));
        if (responseAPDU.getSW() == 36864) {
            byte[] featureBytes = responseAPDU.getData();
            this.logger.debug("CCID FEATURES found using Pseudo-APDU Fallback Strategy");
            FEATURE[] fEATUREArray = FEATURE.values();
            int n = fEATUREArray.length;
            int n2 = 0;
            while (n2 < n) {
                FEATURE feature = fEATUREArray[n2];
                Integer featureCode = this.findFeaturePPDU(feature.getTag(), featureBytes);
                if (featureCode != null) {
                    this.features.put(feature, featureCode);
                    this.logger.debug("FEATURE " + feature.name() + " = " + Integer.toHexString(featureCode));
                }
                ++n2;
            }
            this.usesPPDU = true;
        } else {
            this.logger.error("CCID Features via PPDU Not Supported");
        }
    }

    public boolean hasFeature(FEATURE feature) {
        return this.getFeature(feature) != null;
    }

    public Integer getFeature(FEATURE feature) {
        return this.features.get((Object)feature);
    }

    private Integer findFeatureTLV(byte featureTag, byte[] features) {
        int idx = 0;
        while (idx < features.length) {
            byte tag = features[idx];
            idx += 2;
            if (featureTag == tag) {
                int feature = 0;
                int count = 0;
                while (count < 3) {
                    feature |= features[idx] & 0xFF;
                    ++idx;
                    feature <<= 8;
                    ++count;
                }
                return feature |= features[idx] & 0xFF;
            }
            idx += 4;
        }
        return null;
    }

    private Integer findFeaturePPDU(byte featureTag, byte[] features) {
        int idx = 0;
        while (idx < features.length) {
            byte tag = features[idx];
            if (featureTag == tag) {
                return new Integer(tag);
            }
            ++idx;
        }
        return null;
    }

    protected byte[] transmitPPDUCommand(int controlCode, byte[] command) throws CardException {
        ResponseAPDU responseAPDU = this.card.getBasicChannel().transmit(new CommandAPDU(-1, -62, 1, controlCode, command));
        if (responseAPDU.getSW() != 36864) {
            throw new CardException("PPDU Command Failed: ResponseAPDU=" + responseAPDU.getSW());
        }
        if (responseAPDU.getData().length == 0) {
            return responseAPDU.getBytes();
        }
        return responseAPDU.getData();
    }

    protected byte[] transmitControlCommand(int controlCode, byte[] command) throws CardException {
        if (this.usesPPDU()) {
            return this.transmitPPDUCommand(controlCode, command);
        }
        return this.card.transmitControlCommand(controlCode, command);
    }

    public void waitForOK() throws CardException, InterruptedException {
        block8: while (true) {
            byte[] getKeyPressedResult = this.transmitControlCommand(this.getFeature(FEATURE.GET_KEY_PRESSED), new byte[0]);
            byte key = getKeyPressedResult[0];
            switch (key) {
                case 0: {
                    this.logger.debug("waiting for CCID...");
                    Thread.sleep(200L);
                    continue block8;
                }
                case 43: {
                    this.logger.debug("PIN digit");
                    continue block8;
                }
                case 10: {
                    this.logger.debug("erase PIN digit");
                    continue block8;
                }
                case 13: {
                    this.logger.debug("user confirmed");
                    break block8;
                }
                case 27: {
                    this.logger.debug("user canceled");
                    throw new SecurityException("canceled by user");
                }
                case 64: {
                    this.logger.debug("PIN abort");
                    break block8;
                }
                default: {
                    this.logger.debug("CCID get key pressed result: " + key + " hex: " + Integer.toHexString(key));
                    continue block8;
                }
            }
            break;
        }
    }

    public final byte getLanguageId(Locale locale) {
        String language = locale.getLanguage();
        if (DUTCH_LANGUAGE.equals(language)) {
            return 19;
        }
        if (FRENCH_LANGUAGE.equals(language)) {
            return 12;
        }
        if (GERMAN_LANGUAGE.equals(language)) {
            return 7;
        }
        return 9;
    }

    public byte[] createPINVerificationDataStructure(Locale locale, INS ins) throws IOException {
        ByteArrayOutputStream verifyCommand = new ByteArrayOutputStream();
        verifyCommand.write(30);
        verifyCommand.write(30);
        verifyCommand.write(137);
        verifyCommand.write(71);
        verifyCommand.write(4);
        verifyCommand.write(new byte[]{12, 4});
        verifyCommand.write(2);
        verifyCommand.write(1);
        verifyCommand.write(new byte[]{this.getLanguageId(locale), 4});
        verifyCommand.write(0);
        verifyCommand.write(new byte[3]);
        byte[] byArray = new byte[13];
        byArray[1] = (byte)ins.getIns();
        byArray[3] = 1;
        byArray[4] = 8;
        byArray[5] = 32;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byte[] verifyApdu = byArray;
        verifyCommand.write(verifyApdu.length & 0xFF);
        verifyCommand.write(0);
        verifyCommand.write(0);
        verifyCommand.write(0);
        verifyCommand.write(verifyApdu);
        byte[] verifyCommandData = verifyCommand.toByteArray();
        return verifyCommandData;
    }

    public byte[] createPINModificationDataStructure(Locale locale, INS ins) throws IOException {
        ByteArrayOutputStream modifyCommand = new ByteArrayOutputStream();
        modifyCommand.write(30);
        modifyCommand.write(30);
        modifyCommand.write(137);
        modifyCommand.write(71);
        modifyCommand.write(4);
        modifyCommand.write(0);
        modifyCommand.write(8);
        modifyCommand.write(new byte[]{12, 4});
        modifyCommand.write(3);
        modifyCommand.write(2);
        modifyCommand.write(3);
        modifyCommand.write(new byte[]{this.getLanguageId(locale), 4});
        modifyCommand.write(0);
        modifyCommand.write(1);
        modifyCommand.write(2);
        modifyCommand.write(new byte[3]);
        byte[] byArray = new byte[21];
        byArray[1] = (byte)ins.getIns();
        byArray[3] = 1;
        byArray[4] = 16;
        byArray[5] = 32;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = 32;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byte[] modifyApdu = byArray;
        modifyCommand.write(modifyApdu.length & 0xFF);
        modifyCommand.write(0);
        modifyCommand.write(0);
        modifyCommand.write(0);
        modifyCommand.write(modifyApdu);
        byte[] modifyCommandData = modifyCommand.toByteArray();
        return modifyCommandData;
    }

    public static enum FEATURE {
        VERIFY_PIN_START(1),
        VERIFY_PIN_FINISH(2),
        VERIFY_PIN_DIRECT(6),
        MODIFY_PIN_START(3),
        MODIFY_PIN_FINISH(4),
        MODIFY_PIN_DIRECT(7),
        GET_KEY_PRESSED(5),
        EID_PIN_PAD_READER(128);

        private final byte tag;

        private FEATURE(int tag) {
            this.tag = (byte)tag;
        }

        public byte getTag() {
            return this.tag;
        }
    }

    public static enum INS {
        VERIFY_PIN(32),
        MODIFY_PIN(36),
        VERIFY_PUK(44);

        private final int ins;

        private INS(int ins) {
            this.ins = ins;
        }

        int getIns() {
            return this.ins;
        }
    }
}

