/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.component;

import fr.pgh.component.model.MultiListBoxModel;
import fr.pgh.component.ui.MultiListBoxUI;
import fr.pgh.component.ui.renderer.MultiBoxRenderer;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import transpo.system.TimsLogger;

public class JMultiListBox<T>
extends JComponent
implements ItemSelectable,
ListSelectionListener {
    public static final String uiClassID = "MultiListBoxUI";
    MultiListBoxModel<T> model = null;
    private boolean layingOut;
    protected int maximumRowCount = 15;
    protected String actionCommand = "multiSelBoxChanged";
    private Object selectionDetailReminder;
    MultiBoxRenderer printer = null;
    private boolean firingActionEvent = false;
    private boolean selectingItem = false;
    private Action action;
    private PropertyChangeListener actionPropertyChangeListener;

    public JMultiListBox() {
        this.setModel(new MultiListBoxModel(new Vector(), false));
        this.updateUI();
    }

    public JMultiListBox(Vector<T> items, boolean selectAllOption) {
        this.setModel(new MultiListBoxModel<T>(items, selectAllOption));
        this.init();
    }

    @Override
    public void doLayout() {
        this.layingOut = true;
        super.doLayout();
        this.layingOut = false;
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut) {
            dim.width = Math.max(dim.width, this.getPreferredSize().width);
        }
        return dim;
    }

    public void setSelectAllOption(boolean value) {
        this.model.setSelectAllOption(value);
    }

    private void init() {
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI((MultiListBoxUI)UIManager.getUI(this));
    }

    public void setModel(MultiListBoxModel<T> aModel) {
        MultiListBoxModel<T> oldModel = this.model;
        if (oldModel != null) {
            oldModel.removeListSelectionListener(this);
        }
        this.model = aModel;
        this.model.addListSelectionListener(this);
        this.firePropertyChange("model", oldModel, this.model);
    }

    public MultiListBoxModel<T> getModel() {
        return this.model;
    }

    public void setMaximumRowCount(int count) {
        int oldCount = this.maximumRowCount;
        this.maximumRowCount = count;
        this.firePropertyChange("maximumRowCount", oldCount, this.maximumRowCount);
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setPrinter(MultiBoxRenderer aPrinter) {
        MultiBoxRenderer oldRenderer = this.printer;
        this.printer = aPrinter;
        this.firePropertyChange("renderer", oldRenderer, this.printer);
        this.invalidate();
    }

    public MultiBoxRenderer getPrinter() {
        return this.printer;
    }

    public void addSelectedItem(T anObject) {
        this.selectingItem = true;
        this.model.addSelectedItem(anObject);
        this.selectingItem = false;
        if (this.selectionDetailReminder == null || !this.selectionDetailReminder.equals(this.getSelectionDetail())) {
            this.selectedItemChanged();
        }
        this.fireActionEvent();
    }

    public void addSelectedIndex(int index) {
        this.selectingItem = true;
        this.model.addSelectedIndex(index);
        this.selectingItem = false;
        if (this.selectionDetailReminder == null || !this.selectionDetailReminder.equals(this.getSelectionDetail())) {
            this.selectedItemChanged();
        }
        this.fireActionEvent();
    }

    public void addSelectedId(int itemId) {
        this.selectingItem = true;
        this.model.addSelectedId(itemId);
        this.selectingItem = false;
        if (this.selectionDetailReminder == null || !this.selectionDetailReminder.equals(this.getSelectionDetail())) {
            this.selectedItemChanged();
        }
        this.fireActionEvent();
    }

    public void clearSelection() {
        this.model.clearSelection();
    }

    public Object getSelectionDetail() {
        return this.model == null ? null : this.model.selectionDetail();
    }

    public Vector<T> getSelectedItems() {
        return this.model.getSelectedItems();
    }

    @Override
    public Object[] getSelectedObjects() {
        Vector<T> sel = this.getSelectedItems();
        Object[] toReturn = sel.toArray();
        return toReturn;
    }

    public int getIndexOf(T anObject) {
        return this.model.getIndexOf(anObject);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        if (l != null && this.getAction() == l) {
            this.setAction(null);
        } else {
            this.listenerList.remove(ActionListener.class, l);
        }
    }

    public void setActionCommand(String aCommand) {
        this.actionCommand = aCommand;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    protected void selectedItemChanged() {
        TimsLogger.debug("#JMultiBox.selectedItemChanged# selection changed");
        if (this.selectionDetailReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectionDetailReminder, 2));
        }
        this.selectionDetailReminder = this.model.selectionDetail();
        if (this.selectionDetailReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectionDetailReminder, 1));
        }
    }

    public void firePopupMenuWillBecomeVisible() {
        Object[] listeners = this.listenerList.getListenerList();
        PopupMenuEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == PopupMenuListener.class) {
                if (e == null) {
                    e = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)listeners[i + 1]).popupMenuWillBecomeVisible(e);
            }
            i -= 2;
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        Object[] listeners = this.listenerList.getListenerList();
        PopupMenuEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == PopupMenuListener.class) {
                if (e == null) {
                    e = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)listeners[i + 1]).popupMenuWillBecomeInvisible(e);
            }
            i -= 2;
        }
    }

    public void firePopupMenuCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        PopupMenuEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == PopupMenuListener.class) {
                if (e == null) {
                    e = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)listeners[i + 1]).popupMenuCanceled(e);
            }
            i -= 2;
        }
    }

    public void setAction(Action a) {
        Action oldValue = this.getAction();
        if (this.action == null || !this.action.equals(a)) {
            this.action = a;
            if (oldValue != null) {
                this.removeActionListener(oldValue);
                oldValue.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
            this.configurePropertiesFromAction(this.action);
            if (this.action != null) {
                if (!this.isListener(ActionListener.class, this.action)) {
                    this.addActionListener(this.action);
                }
                this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
                this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.firePropertyChange("action", oldValue, this.action);
            this.revalidate();
            this.repaint();
        }
    }

    public void contentsChanged(ListDataEvent e) {
        Object oldSelection = this.selectionDetailReminder;
        Object newSelection = this.model.selectionDetail();
        if (oldSelection == null || !oldSelection.equals(newSelection)) {
            this.selectedItemChanged();
            if (!this.selectingItem) {
                this.fireActionEvent();
            }
        }
    }

    private boolean isListener(Class c, ActionListener a) {
        boolean isListener = false;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == c && listeners[i + 1] == a) {
                isListener = true;
            }
            i -= 2;
        }
        return isListener;
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action a) {
        this.setEnabled(a != null ? a.isEnabled() : true);
        this.setToolTipText(a != null ? (String)a.getValue("ShortDescription") : null);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return null;
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ItemListener.class) {
                ((ItemListener)listeners[i + 1]).itemStateChanged(e);
            }
            i -= 2;
        }
    }

    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            long mostRecentEventTime = EventQueue.getMostRecentEventTime();
            int modifiers = 0;
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof InputEvent) {
                modifiers = ((InputEvent)currentEvent).getModifiers();
            } else if (currentEvent instanceof ActionEvent) {
                modifiers = ((ActionEvent)currentEvent).getModifiers();
            }
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == ActionListener.class) {
                    if (e == null) {
                        e = new ActionEvent(this, 1001, this.getActionCommand(), mostRecentEventTime, modifiers);
                    }
                    ((ActionListener)listeners[i + 1]).actionPerformed(e);
                }
                i -= 2;
            }
            this.firingActionEvent = false;
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public MultiListBoxUI getUI() {
        return (MultiListBoxUI)this.ui;
    }

    @Override
    public void addItemListener(ItemListener aListener) {
        this.listenerList.add(ItemListener.class, aListener);
    }

    @Override
    public void removeItemListener(ItemListener aListener) {
        this.listenerList.remove(ItemListener.class, aListener);
    }

    public void addPopupMenuListener(PopupMenuListener aListener) {
        this.listenerList.add(PopupMenuListener.class, aListener);
    }

    public void removePopupMenuListener(PopupMenuListener aListener) {
        this.listenerList.remove(PopupMenuListener.class, aListener);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        TimsLogger.debug("#JMultiListBox.valueChanged# value changed... need to update label ");
    }
}

