/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.component;

import fr.pgh.conversion.ConversionTime;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import transpo.system.TimsLogger;

public class JTextHour
extends JTextField
implements FocusListener,
KeyListener {
    private String value = "__h__";
    private int pos = 0;
    private boolean isDayHour = true;

    public JTextHour() {
        this(false);
    }

    public JTextHour(boolean isDayHour) {
        super("__h__");
        this.isDayHour = isDayHour;
        this.setMinimumSize(new Dimension(45, 20));
        this.setPreferredSize(new Dimension(45, 20));
        this.setMaximumSize(new Dimension(45, 20));
        this.setHorizontalAlignment(0);
        this.addFocusListener(this);
        this.getKeyListeners();
        this.addKeyListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.setSelectionStart(this.pos);
        this.setSelectionEnd(this.pos + 1);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int code = e.getKeyCode();
        char charCode = e.getKeyChar();
        TimsLogger.debug("#JTextHour.keyReleased# Code " + code + " (" + e.getKeyChar() + ") " + e.getKeyChar());
        if (charCode >= '0' && charCode <= '9') {
            if (this.pos < 5) {
                this.insert(e.getKeyChar());
            }
        } else if (e.getKeyChar() == 'h' || e.getKeyChar() == ':') {
            while (this.pos < 3) {
                this.insert('0');
            }
        } else if (code == 39) {
            if (this.pos < 5) {
                this.insert('0');
            }
        } else if (code == 37 || code == 8 || code == 127) {
            this.deleteLast();
        }
        this.setText(this.value);
        this.setSelectionStart(this.pos);
        this.setSelectionEnd(this.pos + 1);
    }

    private void insert(char car) {
        TimsLogger.debug("#JTextHour.insert# set value = " + this.value.substring(0, this.pos) + car + this.value.substring(this.pos + 1));
        if (this.isDayHour && this.pos == 0 && car != '0' && car != '1' && car != '2') {
            return;
        }
        if (this.isDayHour && this.pos == 1 && this.value.substring(0, 1).equals("2") && car != '0' && car != '1' && car != '2' && car != '3') {
            return;
        }
        if (this.pos == 3 && car != '0' && car != '1' && car != '2' && car != '3' && car != '4' && car != '5') {
            return;
        }
        this.value = String.valueOf(this.value.substring(0, this.pos)) + car + this.value.substring(this.pos + 1);
        ++this.pos;
        if (this.pos == 2) {
            ++this.pos;
        }
    }

    private void deleteLast() {
        TimsLogger.debug("#JTextHour.insert# delete last on " + this.value + " (pos=" + this.pos + ")");
        if (this.pos == 0) {
            return;
        }
        if (this.pos == 3) {
            --this.pos;
        }
        this.value = String.valueOf(this.value.substring(0, this.pos - 1)) + "_" + this.value.substring(this.pos);
        --this.pos;
    }

    public boolean isFilled() {
        return !this.value.contains("_");
    }

    @Override
    public String getText() {
        return this.value.replace("_", "0");
    }

    @Override
    public void setText(String text) {
        if (text == null || text.equals("")) {
            text = "__h__";
        }
        this.value = text;
        super.setText(text);
    }

    public boolean isValidHour() {
        return this.value != null && !this.value.contains("_");
    }

    public int getMinuteHour() {
        return ConversionTime.heureStringToInt(this.getText(), "h");
    }

    public void setHourMinute(int length) {
        String toSet = ConversionTime.heureIntToString(length, "h");
        this.value = toSet.substring(toSet.length() - 5);
        this.setText(this.value);
    }
}

