/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.component.ui.metal;

import fr.pgh.component.JMultiListBox;
import fr.pgh.component.ui.renderer.MultiBoxRenderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalMultiListBoxButton
extends JButton {
    protected JMultiListBox multiBox;
    protected JList list;
    protected CellRendererPane rendererPane;
    protected Icon multiIcon;
    protected boolean iconOnly = false;

    public final JMultiListBox getMultiBox() {
        return this.multiBox;
    }

    public final void setMultiBox(JMultiListBox cb) {
        this.multiBox = cb;
    }

    public final Icon getComboIcon() {
        return this.multiIcon;
    }

    public final void setComboIcon(Icon i) {
        this.multiIcon = i;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean isIconOnly) {
        this.iconOnly = isIconOnly;
    }

    MetalMultiListBoxButton() {
        super("");
        DefaultButtonModel model = new DefaultButtonModel(){

            @Override
            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() ? true : armed);
            }
        };
        this.setModel(model);
    }

    public MetalMultiListBoxButton(JMultiListBox cb, Icon i, CellRendererPane pane, JList list) {
        this();
        this.multiBox = cb;
        this.multiIcon = i;
        this.rendererPane = pane;
        this.list = list;
        this.setEnabled(this.multiBox.isEnabled());
    }

    public MetalMultiListBoxButton(JMultiListBox cb, Icon i, boolean onlyIcon, CellRendererPane pane, JList list) {
        this(cb, i, pane, list);
        this.iconOnly = onlyIcon;
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBackground(this.multiBox.getBackground());
            this.setForeground(this.multiBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int iconLeft;
        boolean leftToRight = false;
        super.paintComponent(g);
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (height <= 0 || width <= 0) {
            return;
        }
        int left = insets.left;
        int top = insets.top;
        int right = left + (width - 1);
        int bottom = top + (height - 1);
        int iconWidth = 0;
        int n = iconLeft = leftToRight ? right : left;
        if (this.multiIcon != null) {
            iconWidth = this.multiIcon.getIconWidth();
            int iconHeight = this.multiIcon.getIconHeight();
            int iconTop = 0;
            if (this.iconOnly) {
                iconLeft = this.getWidth() / 2 - iconWidth / 2;
                iconTop = this.getHeight() / 2 - iconHeight / 2;
            } else {
                iconLeft = leftToRight ? left + (width - 1) - iconWidth : left;
                iconTop = top + (bottom - top) / 2 - iconHeight / 2;
            }
            this.multiIcon.paintIcon(this, g, iconLeft, iconTop);
            if (this.multiBox.hasFocus() && !(MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme)) {
                g.setColor(MetalLookAndFeel.getFocusColor());
                g.drawRect(left - 1, top - 1, width + 3, height + 1);
            }
        }
        if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
            return;
        }
        if (!this.iconOnly && this.multiBox != null) {
            MultiBoxRenderer renderer = this.multiBox.getPrinter();
            boolean renderPressed = this.getModel().isPressed();
            Component c = renderer.getListCellRendererComponent(this.list, this.multiBox.getSelectionDetail(), -1, renderPressed, false);
            c.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    c.setBackground(UIManager.getColor("Button.select"));
                }
                c.setForeground(this.multiBox.getForeground());
            } else if (!this.multiBox.isEnabled()) {
                if (this.isOpaque()) {
                    c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                }
                c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            } else {
                c.setForeground(this.multiBox.getForeground());
                c.setBackground(this.multiBox.getBackground());
            }
            int cWidth = width - (insets.right + iconWidth);
            boolean shouldValidate = false;
            if (c instanceof JPanel) {
                shouldValidate = true;
            }
            if (leftToRight) {
                this.rendererPane.paintComponent(g, c, this, left, top, cWidth, height, shouldValidate);
            } else {
                this.rendererPane.paintComponent(g, c, this, left + iconWidth, top, cWidth, height, shouldValidate);
            }
        }
    }
}

