/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.component.ui.metal;

import fr.pgh.component.ui.basic.BasicMultiListBoxUI;
import fr.pgh.component.ui.metal.MetalMultiListBoxButton;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalComboBoxIcon;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalMultiListBoxUI
extends BasicMultiListBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new MetalMultiListBoxUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.usingOcean()) {
            super.paint(g, c);
        }
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        if (this.usingOcean()) {
            bounds.x += 2;
            bounds.y += 2;
            bounds.width -= 3;
            bounds.height -= 4;
            super.paintCurrentValue(g, bounds, hasFocus);
        } else if (g == null || bounds == null) {
            throw new NullPointerException("Must supply a non-null Graphics and Rectangle");
        }
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        if (this.usingOcean()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height - 1);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawRect(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 3);
        } else if (g == null || bounds == null) {
            throw new NullPointerException("Must supply a non-null Graphics and Rectangle");
        }
    }

    @Override
    protected JButton createPopupButton() {
        boolean iconOnly = this.usingOcean();
        MetalMultiListBoxButton button = new MetalMultiListBoxButton(this.multiBox, new MetalComboBoxIcon(), iconOnly, this.currentValuePane, this.list);
        button.setMargin(new Insets(0, 1, 1, 3));
        this.usingOcean();
        this.updateButtonForOcean(button);
        return button;
    }

    private void updateButtonForOcean(JButton button) {
        if (this.usingOcean()) {
            button.setFocusPainted(false);
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    public boolean usingOcean() {
        return MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
    }

    @Deprecated
    protected void editablePropertyChanged(PropertyChangeEvent e) {
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    public void layoutMultiBox(Container parent, MetalComboBoxLayoutManager manager) {
        if (this.popupButton != null) {
            if (this.usingOcean() && this.popupButton instanceof MetalMultiListBoxButton) {
                int width = this.multiBox.getWidth();
                int height = this.multiBox.getHeight();
                Insets insets = this.getInsets();
                int buttonSize = height - (insets.top + insets.bottom);
                if (this.multiBox.getComponentOrientation().isLeftToRight()) {
                    this.popupButton.setBounds(width - (insets.right + buttonSize), insets.top, buttonSize, buttonSize);
                } else {
                    this.popupButton.setBounds(insets.left, insets.top, buttonSize, buttonSize);
                }
            } else {
                Insets insets = this.multiBox.getInsets();
                int width = this.multiBox.getWidth();
                int height = this.multiBox.getHeight();
                this.popupButton.setBounds(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
            }
        }
    }

    @Deprecated
    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.multiBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = null;
        if (this.popupButton != null && this.popupButton instanceof MetalMultiListBoxButton) {
            MetalMultiListBoxButton button = (MetalMultiListBoxButton)this.popupButton;
            Insets buttonInsets = button.getInsets();
            Insets insets = this.multiBox.getInsets();
            size = this.getDisplaySize();
            size.width += insets.left + insets.right;
            size.width += buttonInsets.left + buttonInsets.right;
            size.width += buttonInsets.right + button.getComboIcon().getIconWidth();
            size.height += insets.top + insets.bottom;
            size.height += buttonInsets.top + buttonInsets.bottom;
        } else if (this.popupButton != null) {
            size = super.getMinimumSize(c);
            Insets margin = this.popupButton.getMargin();
            size.height += margin.top + margin.bottom;
            size.width += margin.left + margin.right;
        } else {
            size = super.getMinimumSize(c);
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public class MetalComboBoxLayoutManager
    extends BasicMultiListBoxUI.ComboBoxLayoutManager {
        @Override
        public void layoutContainer(Container parent) {
            MetalMultiListBoxUI.this.layoutMultiBox(parent, this);
        }

        public void superLayout(Container parent) {
            super.layoutContainer(parent);
        }
    }

    public class MetalPropertyChangeListener
    extends BasicMultiListBoxUI.PropertyChangeHandler {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName == "editable") {
                MetalMultiListBoxButton button = (MetalMultiListBoxButton)MetalMultiListBoxUI.this.popupButton;
                button.setIconOnly(MetalMultiListBoxUI.this.usingOcean());
                MetalMultiListBoxUI.this.multiBox.repaint();
                MetalMultiListBoxUI.this.updateButtonForOcean(button);
            } else if (propertyName == "background") {
                Color color = (Color)e.getNewValue();
                MetalMultiListBoxUI.this.popupButton.setBackground(color);
                MetalMultiListBoxUI.this.list.setBackground(color);
            } else if (propertyName == "foreground") {
                Color color = (Color)e.getNewValue();
                MetalMultiListBoxUI.this.popupButton.setForeground(color);
                MetalMultiListBoxUI.this.list.setForeground(color);
            }
        }
    }
}

