/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.connexion;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Connexion;
import fr.pgh.data.bdd.Droit;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Societe;
import fr.pgh.data.bdd.Utilisateur;
import java.util.Iterator;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.Fmresources;
import transpo.system.util.Fonctions;

public class ConnexionSettings {
    public static final String LOGIN_ADMIN = "PGH";
    public static final String PASS_ADMIN = "a30b6fed42bfd22a01c5e70b228e2bb8";
    private static ConnexionSettings instance;
    public Utilisateur user;
    private Connexion userConnexion;
    private Vector<Droit> droitFiche = new Vector();
    private Vector<Report> droitRapport = new Vector();
    private int jourChangement;
    private Fmresources res = new Fmresources();
    public static final int UNKNOWN_USER = 0;
    public static final int GOD_MOD = 1;
    public static final int CONNECTED = 2;
    public static final int UNKNOWN_COMPANY = 3;
    public static final int PASSWORD_EXPIRED = 4;
    public static final int DISABLED = 5;

    public static ConnexionSettings getInstance() {
        if (instance == null) {
            instance = new ConnexionSettings();
        }
        return instance;
    }

    private ConnexionSettings() {
        this.jourChangement = Integer.valueOf(this.res.getResourceString("joursPwdChange"));
    }

    public void loadDefault(BddTransport bdd) {
        this.user = new Utilisateur();
        Vector<Societe> db = Societe.loadList(null);
        if (db.size() != 0) {
            this.user.setSociete(db.get(0).getNomSociete());
        }
        this.chargerDroit(bdd);
    }

    public void chargerDroit(BddTransport bdd) {
        int cleProfil = this.user.getCleProfil();
        if (cleProfil != 0) {
            this.droitFiche = bdd.loadProfileAccess(cleProfil);
            this.droitRapport = Report.loadAccessible(cleProfil);
        } else {
            TimsLogger.warn("#ConnexionSettings.chargerDroit# cleProfil = 0");
        }
    }

    public int chargerUser(String utilisateur, String passe) {
        Vector<Societe> db = Societe.loadList(null);
        if (utilisateur.equals(LOGIN_ADMIN) && Fonctions.md5ciphering(passe.substring(2)).equals(PASS_ADMIN)) {
            this.user = new Utilisateur();
            if (db.size() != 0) {
                this.user.setSociete(db.get(0).getNomSociete());
            }
            return 1;
        }
        this.user = Utilisateur.loadByLogin(utilisateur, passe);
        if (this.user != null) {
            if (!this.user.isEnable()) {
                return 5;
            }
            if (this.jourChangement < this.user.getNbJours() && this.jourChangement != 0) {
                return 4;
            }
            Iterator<Societe> iter = db.iterator();
            while (iter.hasNext()) {
                String dataBase = iter.next().getNomSociete();
                if (!dataBase.equals(this.user.getSociete())) continue;
                this.user.setLastVersion(Connexion.getMaxVersion(this.user.getCleUser()));
                this.userConnexion = new Connexion();
                this.userConnexion.setCleUser(this.user.getCleUser());
                TimsLogger.debug("#ConnexionSettings.chargerUser# Nouvelle connexion");
                if (Transport.apiMode == 0) {
                    this.userConnexion.insert();
                }
                return 2;
            }
            return 3;
        }
        return 0;
    }

    public void closeConnexion() {
        if (this.userConnexion != null && Transport.apiMode == 0) {
            this.userConnexion.close();
        }
    }

    public void afficheFiche() {
        TimsLogger.debug("#ConnexionSettings.afficheFiche# profil = " + this.user.getCleProfil());
        TimsLogger.debug("#ConnexionSettings.afficheFiche# soci\u00e9t\u00e9 = " + this.user.getSociete());
        for (Droit tmp : this.droitFiche) {
            TimsLogger.debug("#ConnexionSettings.afficheFiche# fiche = " + tmp.getNomFiche() + " : " + tmp.isConsultation() + ", " + tmp.isAjout() + ", " + tmp.isSuppression() + ", " + tmp.isModification());
        }
    }

    public String getUserSociete() {
        return this.user.getSociete();
    }

    public Vector<Integer> getUserCleA() {
        return this.user == null ? new Vector() : this.user.getResAgence();
    }

    public int getUserCleC() {
        return this.user == null ? 0 : this.user.getCleConducteur();
    }

    public int getUserCle() {
        return this.user == null ? 0 : this.user.getCleUser();
    }

    public boolean isConsultable(String fiche) {
        for (Droit tmp : this.droitFiche) {
            if (!tmp.getNomFiche().equals(fiche)) continue;
            return tmp.isConsultation();
        }
        return false;
    }

    public boolean isModifiable(String fiche) {
        for (Droit tmp : this.droitFiche) {
            if (!tmp.getNomFiche().equals(fiche)) continue;
            return tmp.isModification();
        }
        return false;
    }

    public boolean isAjoutable(String fiche) {
        for (Droit tmp : this.droitFiche) {
            if (!tmp.getNomFiche().equals(fiche)) continue;
            return tmp.isAjout();
        }
        return false;
    }

    public boolean isSupprimable(String fiche) {
        for (Droit tmp : this.droitFiche) {
            if (!tmp.getNomFiche().equals(fiche)) continue;
            return tmp.isSuppression();
        }
        return false;
    }

    public boolean isUserRestreintSociete() {
        return this.user.isRestreintSociete();
    }

    public boolean isUserRestreintAgence() {
        return this.user.isRestreintAgence();
    }

    public boolean isUserRestreintConducteur() {
        return this.user.isRestreintConducteur();
    }

    public boolean verifPassword(String pwd) {
        return pwd != null && pwd.equals(this.user.getMdp());
    }

    public Vector<Report> getDroitRapport() {
        return this.droitRapport;
    }

    public void setDroitRapport(Vector<Report> droitRapport) {
        this.droitRapport = droitRapport;
    }

    public boolean isConnected() {
        return this.user != null;
    }
}

