/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.connexion;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Utilisateur;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class MdpUI
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPasswordField txtNouveauPass = null;
    private JPasswordField txtConfirmation = null;
    private JLabel lblNouveauPass = null;
    private JLabel Confirmation = null;
    private JButton btnValider = null;
    private JButton btnQuitter = null;
    public Utilisateur user = null;
    public boolean changement = false;

    public MdpUI(Frame owner, Utilisateur user) {
        super(owner);
        this.user = user;
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 150);
        this.setModal(true);
        this.setTitle(LanguageTranslator.getString("password.title"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.weightx = 0.2;
            gridBagConstraints1.gridy = 1;
            this.Confirmation = new JLabel();
            this.Confirmation.setText(LanguageTranslator.getString("user.confirmPwd"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 0.2;
            gridBagConstraints.gridy = 0;
            this.lblNouveauPass = new JLabel();
            this.lblNouveauPass.setText(LanguageTranslator.getString("user.newPwd"));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.lblNouveauPass, gridBagConstraints);
            this.jContentPane.add((Component)this.Confirmation, gridBagConstraints1);
            this.jContentPane.add((Component)this.getTxtNouveauPass(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getTxtConfirmation(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getBtnValider(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getBtnQuitter(), gridBagConstraints5);
        }
        return this.jContentPane;
    }

    private JPasswordField getTxtNouveauPass() {
        if (this.txtNouveauPass == null) {
            this.txtNouveauPass = new JPasswordField();
        }
        return this.txtNouveauPass;
    }

    private JPasswordField getTxtConfirmation() {
        if (this.txtConfirmation == null) {
            this.txtConfirmation = new JPasswordField();
            this.txtConfirmation.setPreferredSize(new Dimension(60, 20));
        }
        return this.txtConfirmation;
    }

    private JButton getBtnValider() {
        if (this.btnValider == null) {
            this.btnValider = new JButton();
            this.btnValider.setText(LanguageTranslator.getString("button.valid"));
            this.btnValider.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MdpUI.this.verifPasse();
                }
            });
        }
        return this.btnValider;
    }

    public void verifPasse() {
        String newPass = new String(new StringBuffer().append(this.getTxtNouveauPass().getPassword()).toString());
        String confirmPass = new String(new StringBuffer().append(this.getTxtConfirmation().getPassword()).toString());
        if (newPass.length() >= 8 || confirmPass.length() >= 8) {
            if (newPass.equals(confirmPass)) {
                if (this.isAncienPassword(newPass)) {
                    BddTransport.getInstance().updatePassword(this.user, newPass);
                    JOptionPane.showMessageDialog(this, LanguageTranslator.getString("password.updated"), LanguageTranslator.getString("message.saveSuceed"), 1);
                    this.changement = true;
                    this.dispose();
                } else {
                    JOptionPane.showMessageDialog(this, LanguageTranslator.getString("password.bad"), LanguageTranslator.getString("message.inputError"), 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, LanguageTranslator.getString("password.badConfirm"), LanguageTranslator.getString("message.inputError"), 0);
            }
        } else {
            String[] ltp = new String[]{"8"};
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("password.lengthError", ltp), LanguageTranslator.getString("message.inputError"), 0);
        }
    }

    boolean isAncienPassword(String password) {
        int x = 0;
        while (x < this.user.getPasse().length) {
            if (this.user.getPasse()[x].equals(password)) {
                return false;
            }
            ++x;
        }
        return true;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MdpUI.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }
}

