/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data;

import com.mysql.jdbc.CommunicationsException;
import com.mysql.jdbc.MysqlDataTruncation;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.LBasedData;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Comment;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Configuration;
import fr.pgh.data.bdd.Conflit;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.Droit;
import fr.pgh.data.bdd.ElementArbre;
import fr.pgh.data.bdd.EmployeeObligationType;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.Garage;
import fr.pgh.data.bdd.InterventionType;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.JourUEV;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.OffenceType;
import fr.pgh.data.bdd.Offense;
import fr.pgh.data.bdd.PayPeriod;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Place;
import fr.pgh.data.bdd.Profil;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.RoundType;
import fr.pgh.data.bdd.Societe;
import fr.pgh.data.bdd.SpecificCondition;
import fr.pgh.data.bdd.TailleAgence;
import fr.pgh.data.bdd.Tournee;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.data.bdd.UevCalibration;
import fr.pgh.data.bdd.Utilisateur;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DayException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jfree.util.Log;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ProgressBarIndetermine;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;

public class BddTransport
extends LBasedData {
    private static final long serialVersionUID = 1L;
    private static BddTransport connexionBase = null;
    public static final String tableAnomalieParent = "t_anomalie_parent";
    public static final String tableAnomalieUEV = "t_anomalie_uev";
    public static final String tableComment = "comment";
    public static final String tableCommentOracle = "T_COMMENT";
    public static final String tableConducteur = "t_conducteur";
    public static final String tableConflit = "t_conflit";
    public static final String tableConflitAnalyse = "t_activite_conflit_analyse";
    public static final String tableConflitBase = "t_activite_conflit_base";
    public static final String tableDroit = "t_droit";
    public static final String tableEtalonnage = "t_etalonnage";
    public static final String tableEventUEV = "t_event_uev";
    public static final String tableExport = "t_export";
    public static final String tableExportUpdate = "t_export_update";
    public static final String tableFiche = "t_fiche";
    public static final String tableFrais = "t_frais";
    public static final String tableHistorisationActivite = "t_historique_activite";
    public static final String tableImageScan = "t_scan_image";
    public static final String tableInfraction = "t_infractions";
    public static final String tableIOUEV = "t_io_uev";
    public static final String tableJourModifie = "t_jour_modifie";
    public static final String tableLienJourCommass = "t_lien_jour_commass";
    public static final String tableLienJourTournee = "t_lien_jour_tournee";
    public static final String tablePays = "t_pays";
    public static final String tableProfil = "t_profil";
    public static final String tableRaisonAnomalie = "t_raison_anomalie";
    public static final String tableRegleFrais = "t_regle_frais";
    public static final String tableRestriction = "t_restriction";
    public static final String tableService = "t_service";
    public static final String tableSociete = "t_societe";
    public static final String tableSpeedUEV = "t_speed_uev";
    public static final String tableSuppression = "t_suppression";
    public static final String tableTblInfraction = "t_tbl_infractions";
    public static final String tableTailleAgence = "t_taille_agence";
    public static final String tableTelechargement = "t_telechargement";
    public static final String tableTelechargementUEV = "t_telechargement_UEV";
    public static final String tableTournee = "t_tournee";
    public static final String tableTracking = "tracking";
    public static final String tableTypeActivite = "t_type_activite";
    public static final String tableTypeAnomalie = "t_type_anomalie";
    public static final String tableTypeAgence = "t_type_agence";
    public static final String tableTypePersonnel = "t_type_chauffeur";
    public static final String tableUtilisateur = "t_utilisateur";
    public static final String tableVehicule = "t_vehicule";
    public static final String tableUEV = "t_uev";
    public static final Fmresources res = new Fmresources();
    private Connection connection = null;
    private long lastConnectionTime = 0L;
    public Societe societeCourante = null;
    private static ConnexionSettings conn = ConnexionSettings.getInstance();
    private boolean loadingConnexion = false;

    public static BddTransport getInstance() {
        if (connexionBase == null) {
            connexionBase = new BddTransport();
        }
        return connexionBase;
    }

    public static void closeConnection() {
        try {
            BddTransport.getInstance().getConnection().close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void closeStatement(Statement stm) {
        if (stm != null) {
            try {
                stm.close();
            }
            catch (Exception ex) {
                TimsLogger.error("Erreur closeStatement " + ex.getMessage());
            }
        }
    }

    public void startTransaction() {
        block7: {
            Statement stm = null;
            try {
                try {
                    this.getConnection().setAutoCommit(false);
                    stm = this.getConnection().createStatement();
                    if (System.getProperty("SGBDR", "oracle").equals("mysql")) {
                        this.getConnection().commit();
                    }
                    if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                        stm.executeUpdate("start transaction");
                    }
                }
                catch (Exception ex) {
                    TimsLogger.error("Erreur startTransaction " + ex.getMessage());
                    this.closeStatement(stm);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(stm);
                throw throwable;
            }
            this.closeStatement(stm);
        }
    }

    public void commit() {
        Statement stm = null;
        try {
            try {
                stm = this.getConnection().createStatement();
                this.getConnection().commit();
                this.getConnection().setAutoCommit(true);
            }
            catch (Exception ex) {
                TimsLogger.error("Erreur commit " + ex.getMessage());
                this.closeStatement(stm);
            }
        }
        finally {
            this.closeStatement(stm);
        }
    }

    public void rollback() {
        try {
            this.getConnection().rollback();
            this.getConnection().setAutoCommit(true);
        }
        catch (Exception ex) {
            TimsLogger.error("Erreur rollback " + ex.getMessage());
        }
    }

    public void showTimeout() {
        if (Transport.apiMode == 0) {
            JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("connexion.lost"), LanguageTranslator.getString("connexion.error"), 0);
        }
        Log.error((Object)"Connection timed out");
        System.exit(0);
    }

    public static String addSlashes(String str) {
        String quote = "\"";
        String echap = "\\";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            echap = "'";
            quote = "'";
        }
        if (str == null) {
            return "";
        }
        StringBuffer s = new StringBuffer(str);
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\'' || s.charAt(i) == '\\') {
                s.insert(i++, echap);
            }
            ++i;
        }
        return s.toString();
    }

    public Utilisateur getAuteurLecture(String date, int cleConducteur) {
        Utilisateur user = null;
        String sql = "";
        try {
            sql = "SELECT NOM_UTILISATEUR, PRENOM_UTILISATEUR FROM " + BddTransport.getBaseDefault(true) + tableUtilisateur + " WHERE CLE_UTILISATEUR = " + "(SELECT CLE_USER FROM " + "t_jour" + " WHERE DATE_JOUR = " + BddTransport.getDateStringToSGBDR(date, false) + " AND CLE_CHAUFFEUR = " + cleConducteur + " AND MODIFICATION = 0" + " AND SUPPRESSION = 0)";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            user = rs.next() ? new Utilisateur(rs.getString(1), rs.getString(2)) : new Utilisateur("ADMIN", "");
        }
        catch (CommunicationsException ex) {
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getAuteurLecture()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return user;
    }

    public Utilisateur getAuteurModification(String date, int cleConducteur) {
        Utilisateur user = null;
        String sql = "";
        try {
            sql = "SELECT NOM_UTILISATEUR, PRENOM_UTILISATEUR FROM " + BddTransport.getBaseDefault(true) + tableUtilisateur + " WHERE CLE_UTILISATEUR = " + "(SELECT CLE_USER FROM " + tableJourModifie + " WHERE DATE_JOUR = " + BddTransport.getDateStringToSGBDR(date, false) + " AND CLE_CHAUFFEUR = " + cleConducteur + " AND CURRENT_VALUE = 1" + " AND SUPPRESSION = 0)";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                user = new Utilisateur(rs.getString(1), rs.getString(2));
            }
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getAuteurModification()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return user;
    }

    public int getKmJour(String jour, int cleCond, int modification) {
        int result = 0;
        String sql = "";
        try {
            String table = "t_jour";
            if (modification != 0) {
                table = tableJourModifie;
            }
            sql = "SELECT DISTANCE FROM " + table + " WHERE DATE_JOUR = " + BddTransport.getDateStringToSGBDR(jour, false) + " AND CLE_CHAUFFEUR=" + cleCond + " AND SUPPRESSION=0";
            if (modification != 0) {
                sql = String.valueOf(sql) + " AND CURRENT_VALUE=1";
            }
            Transport.ps.startOperation();
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate getKmJour", "#BddT.getKmJour => %s# sql = " + sql, 1);
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getKmJour()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getNumeroDerniereImage(String strAGENCE) {
        int result = 0;
        String sql = "";
        try {
            sql = "SELECT max(NUMERO) FROM t_scan_image WHERE NOM  LIKE '" + strAGENCE.replace("'", "_") + "%'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                if (rs.getString(1) == null) continue;
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getNumeroDerniereImage()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Droit> loadProfileAccess(int cleProfil) {
        Vector<Droit> result = new Vector<Droit>();
        String sql = "";
        try {
            sql = "SELECT CLE_DROIT, fi.CLE_FICHE, NOM_FICHE, ECRITURE, MODIFICATION, SUPPRESSION, CONSULTATION FROM " + BddTransport.getBaseDefault(true) + tableDroit + " dr join " + BddTransport.getBaseDefault(true) + tableFiche + " fi" + " ON dr.CLE_FICHE=fi.CLE_FICHE" + " WHERE dr.CLE_PROFIL =" + cleProfil + " ORDER BY NOM_FICHE";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Droit(rs.getInt("CLE_DROIT"), cleProfil, rs.getInt(2), rs.getString(3), rs.getBoolean(4), rs.getBoolean(5), rs.getBoolean(6), rs.getBoolean(7)));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#loadProfileAccess()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Droit> loadProfileDefaultAccess(int cleProfil) {
        Vector<Droit> result = new Vector<Droit>();
        String sql = "";
        try {
            sql = "SELECT CLE_FICHE, NOM_FICHE, DROIT_DEFAUT FROM " + BddTransport.getBaseDefault(true) + tableFiche + " ORDER BY NOM_FICHE";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                boolean cons = Integer.parseInt(rs.getString(3).substring(0, 1)) == 1;
                boolean add = Integer.parseInt(rs.getString(3).substring(1, 2)) == 1;
                boolean mod = Integer.parseInt(rs.getString(3).substring(2, 3)) == 1;
                boolean sup = Integer.parseInt(rs.getString(3).substring(3, 4)) == 1;
                result.add(new Droit(0, cleProfil, rs.getInt(1), rs.getString(2), add, mod, sup, cons));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#loadProfileDefaultAccess()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Profil> getProfil() {
        Vector<Profil> result = new Vector<Profil>();
        String sql = "";
        try {
            sql = "SELECT CLE_PROFIL, NOM_PROFIL, DEFAUT FROM " + BddTransport.getBaseDefault(true) + tableProfil;
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Profil(rs.getInt(1), rs.getString(2), rs.getInt("DEFAUT") == 1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getProfil()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getCleProfil(String nomProfil) {
        int result = 0;
        String sql = "";
        try {
            sql = "SELECT CLE_PROFIL FROM " + BddTransport.getBaseDefault(true) + tableProfil + " WHERE NOM_PROFIL ='" + BddTransport.addSlashes(nomProfil) + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getCleProfil()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public void updateUtilisateur(Utilisateur user, int cleUser, boolean updateRestriction) {
        String[] lib = new String[]{"CLE_PROFIL", "NOM_UTILISATEUR", "PRENOM_UTILISATEUR", "NOM_SOCIETE", "CLE_AGENCE", "CLE_CHAUFFEUR", "ADRESSE", "VILLE", "CODE_POSTAL", "TELEPHONE", "EMAIL", "RESTRICTION_SOCIETE", "RESTRICTION_AGENCE", "RESTRICTION_CONDUCTEUR", "ENABLE", "ALERTED"};
        String[] val = new String[]{String.valueOf(user.getCleProfil()), user.getNom(), user.getPrenom(), user.getSociete(), String.valueOf(user.getCleAgence()), String.valueOf(user.getCleConducteur()), user.getAdresse(), user.getVille(), user.getCp(), user.getTelephone(), user.getEmail(), user.isRestreintSociete() ? "1" : "0", user.isRestreintAgence() ? "1" : "0", user.isRestreintConducteur() ? "1" : "0", user.isEnable() ? "1" : "0", user.isAlerted() ? "1" : "0"};
        int[] type = new int[]{4, 12, 12, 12, 4, 4, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
        String[] libRef = new String[]{"CLE_UTILISATEUR"};
        String[] valRef = new String[]{String.valueOf(cleUser)};
        int[] typeRef = new int[]{4};
        this.updateRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableUtilisateur, lib, val, type, libRef, valRef, typeRef);
        if (updateRestriction || !user.isRestreintAgence()) {
            String[] libToDel = new String[]{"CLE_USER"};
            String[] valToDel = new String[]{String.valueOf(cleUser)};
            int[] typeToDel = new int[]{4};
            this.delRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableRestriction, libToDel, valToDel, typeToDel);
            if (updateRestriction) {
                String[] libRes = new String[]{"CLE_RESTRICTION", "CLE_USER", "CLE_AGENCE"};
                int[] typeRes = new int[]{4, 4, 4};
                int x = 0;
                while (x < user.getResAgence().size()) {
                    String[] valRes = new String[]{"GEN_T_RESTRICTION.nextval", String.valueOf(cleUser), user.getResAgence().get(x).toString()};
                    this.addRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableRestriction, libRes, valRes, typeRes);
                    ++x;
                }
            }
        }
    }

    public void updatePassword(Utilisateur user, String mdp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date dateJour = new java.util.Date();
        String ancienPassword = mdp;
        int limiteMdp = Integer.parseInt(res.getResourceString("ancien"));
        int x = 0;
        while (x < user.getPasse().length) {
            if (x < limiteMdp) {
                ancienPassword = String.valueOf(ancienPassword) + ";" + user.getPasse()[x];
            }
            ++x;
        }
        String[] lib = new String[]{"PASSWORD_UTILISATEUR", "CHANGEMENT_PASSE", "ANCIEN_PASSE"};
        String[] val = new String[]{mdp, dateFormat.format(dateJour), ancienPassword};
        int[] type = new int[]{12, 91, 12};
        String[] libRef = new String[]{"CLE_UTILISATEUR"};
        String[] valRef = new String[]{String.valueOf(user.getCleUser())};
        int[] typeRef = new int[]{4};
        this.updateRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableUtilisateur, lib, val, type, libRef, valRef, typeRef);
        user.setMdp(mdp);
    }

    public void addUser(Utilisateur user) {
        int cleP = user.getCleProfil();
        String cleS = user.getSociete();
        String nom = user.getNom();
        String prenom = user.getPrenom();
        String login = user.getLogin();
        String password = user.getMdp();
        String[] lib = new String[]{"CLE_UTILISATEUR", "NOM_UTILISATEUR", "PRENOM_UTILISATEUR", "LOGIN_UTILISATEUR", "PASSWORD_UTILISATEUR", "CLE_PROFIL", "", "ANCIEN_PASSE"};
        String[] val = new String[]{"GEN_T_UTILISATEUR.nextval", nom, prenom, login, password, String.valueOf(cleP), cleS, String.valueOf(password) + ";"};
        int[] type = new int[]{1111, 12, 12, 12, 12, 4, 12, 12};
        this.addRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableUtilisateur, lib, val, type);
    }

    public void addSociete(String nomSociete, String nomBase) {
        String[] lib = new String[]{"CLE_SOCIETE", "", "NOM_BASE"};
        String[] val = new String[]{"GEN_T_SOCIETE.nextval", nomSociete, nomBase};
        int[] type = new int[]{1111, 12, 12};
        this.addRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableSociete, lib, val, type);
    }

    public void updateProfil(Vector<Droit> detailFiches, int cleProfilToUpdate) {
        String cons = "";
        String mod = "";
        String add = "";
        String sup = "";
        for (Droit ficheToUpdate : detailFiches) {
            cons = ficheToUpdate.isConsultation() ? "1" : "0";
            mod = ficheToUpdate.isModification() ? "1" : "0";
            add = ficheToUpdate.isAjout() ? "1" : "0";
            sup = ficheToUpdate.isSuppression() ? "1" : "0";
            String[] lib = new String[]{"CONSULTATION", "MODIFICATION", "ECRITURE", "SUPPRESSION"};
            String[] val = new String[]{cons, mod, add, sup};
            int[] type = new int[]{12, 12, 12, 12};
            String[] libRef = new String[]{"CLE_FICHE", "CLE_PROFIL"};
            String[] valRef = new String[]{String.valueOf(ficheToUpdate.getCleFiche()), String.valueOf(cleProfilToUpdate)};
            int[] typeRef = new int[]{4, 4};
            this.updateRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableDroit, lib, val, type, libRef, valRef, typeRef);
        }
    }

    public boolean addFicheProfil(Vector<Droit> detailFiches, int cleProfilToAdd) {
        String cons = "";
        String mod = "";
        String add = "";
        String sup = "";
        for (Droit ficheToUpdate : detailFiches) {
            cons = ficheToUpdate.isConsultation() ? "1" : "0";
            mod = ficheToUpdate.isModification() ? "1" : "0";
            add = ficheToUpdate.isAjout() ? "1" : "0";
            sup = ficheToUpdate.isSuppression() ? "1" : "0";
            String[] lib = new String[]{"CLE_DROIT", "CLE_FICHE", "CLE_PROFIL", "CONSULTATION", "MODIFICATION", "ECRITURE", "SUPPRESSION"};
            String[] val = new String[]{"GEN_T_DROIT.nextval", String.valueOf(ficheToUpdate.getCleFiche()), String.valueOf(cleProfilToAdd), cons, mod, add, sup};
            int[] type = new int[]{1111, 4, 4, 4, 4, 4, 4};
            if (this.addRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableDroit, lib, val, type)) continue;
            return false;
        }
        return true;
    }

    public void addFiche(Droit ficheToAdd) {
        String cons = "";
        String mod = "";
        String add = "";
        String sup = "";
        cons = ficheToAdd.isConsultation() ? "1" : "0";
        mod = ficheToAdd.isModification() ? "1" : "0";
        add = ficheToAdd.isAjout() ? "1" : "0";
        sup = ficheToAdd.isSuppression() ? "1" : "0";
        String[] libFiche = new String[]{"CLE_FICHE", "NOM_FICHE", "DROIT_DEFAUT"};
        String[] valFiche = new String[]{"GEN_T_FICHE.nextval", ficheToAdd.getNomFiche(), String.valueOf(cons) + mod + add + sup};
        int[] typeFiche = new int[]{1111, 12, 12};
        this.addRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableFiche, libFiche, valFiche, typeFiche);
        int cleFiche = this.getCleFiche(ficheToAdd.getNomFiche());
        String[] lib = new String[]{"CLE_DROIT", "CLE_FICHE", "CLE_PROFIL", "CONSULTATION", "MODIFICATION", "ECRITURE", "SUPPRESSION"};
        Iterator<Profil> iter = this.getProfil().iterator();
        while (iter.hasNext()) {
            String[] val = new String[]{"GEN_T_DROIT.nextval", String.valueOf(cleFiche), String.valueOf(iter.next().getCle()), cons, mod, add, sup};
            int[] type = new int[]{1111, 4, 4, 4, 4, 4, 4};
            this.addRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableDroit, lib, val, type);
        }
    }

    public int getCleFiche(String nomFiche) {
        int result = 0;
        String sql = "";
        try {
            sql = "SELECT CLE_FICHE FROM " + BddTransport.getBaseDefault(true) + tableFiche + " WHERE NOM_FICHE ='" + BddTransport.addSlashes(nomFiche) + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getCleFiche()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int creeProfilEtDroit(Vector<Droit> detailFiches, String nomProfil, boolean defaut) {
        int profilId = this.addProfil(nomProfil, defaut);
        if (profilId == 0) {
            return profilId;
        }
        if (!this.addFicheProfil(detailFiches, profilId)) {
            return 0;
        }
        return profilId;
    }

    public int addProfil(String nomProfil, boolean defaut) {
        String[] lib = new String[]{"CLE_PROFIL", "NOM_PROFIL", "DEFAUT"};
        String[] val = new String[]{"GEN_T_PROFIL.nextval", nomProfil, defaut ? "1" : "0"};
        int[] type = new int[]{1111, 12, 4};
        this.addRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableProfil, lib, val, type);
        return this.getCleProfil(nomProfil);
    }

    public Vector<Conducteur> getConducteurOrangeList() {
        Vector<Conducteur> result = new Vector<Conducteur>();
        String sql = "";
        try {
            sql = "SELECT CLE_CHAUFFEUR, CLE_AGENCE, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, NUM_CARTE_CHAUFFEUR, MATRICULE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_DERNIER_TELECHARGEMENT", false, "") + " FROM " + tableConducteur + " WHERE " + BddTransport.getDateDiff(BddTransport.getCurrentDate(), "DATE_DERNIER_TELECHARGEMENT") + " BETWEEN " + BddTransport.getNBJour(System.getProperty("driver.orange.threshold", String.valueOf(15))) + " AND " + BddTransport.getNBJour(System.getProperty("driver.red.threshold", String.valueOf(25))) + " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            String restriction = BddTransport.addRestriction(tableConducteur, tableConducteur);
            if (restriction != "") {
                sql = String.valueOf(sql) + " AND " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY NOM_CONDUCTEUR,PRENOM_CONDUCTEUR";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Conducteur toAdd = new Conducteur(rs.getInt("CLE_CHAUFFEUR"), rs.getString("NOM_CONDUCTEUR"), rs.getString("PRENOM_CONDUCTEUR"), rs.getString("DATE_DERNIER_TELECHARGEMENT"));
                toAdd.setNumeroCarte(rs.getString("NUM_CARTE_CHAUFFEUR"));
                toAdd.setMatricule(rs.getString("MATRICULE_CHAUFFEUR"));
                toAdd.setCleAgence(rs.getInt("CLE_AGENCE"));
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getConducteurOrangeList()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Conducteur> getConducteurRougeList() {
        Vector<Conducteur> result = new Vector<Conducteur>();
        String sql = "";
        try {
            sql = "SELECT CLE_AGENCE, CLE_CHAUFFEUR, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, NUM_CARTE_CHAUFFEUR, MATRICULE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_DERNIER_TELECHARGEMENT", false, "") + " FROM " + tableConducteur + " WHERE " + BddTransport.getDateDiff(BddTransport.getCurrentDate(), "DATE_DERNIER_TELECHARGEMENT") + " > " + BddTransport.getNBJour(System.getProperty("driver.red.threshold", String.valueOf(25))) + " AND DATE_DERNIER_TELECHARGEMENT>" + BddTransport.getDateStringToSGBDR("2000-01-01", false) + " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            String restriction = BddTransport.addRestriction(tableConducteur, tableConducteur);
            if (restriction != "") {
                sql = String.valueOf(sql) + " AND " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Conducteur toAdd = new Conducteur(rs.getInt("CLE_CHAUFFEUR"), rs.getString("NOM_CONDUCTEUR"), rs.getString("PRENOM_CONDUCTEUR"), rs.getString("DATE_DERNIER_TELECHARGEMENT"));
                toAdd.setNumeroCarte(rs.getString("NUM_CARTE_CHAUFFEUR"));
                toAdd.setMatricule(rs.getString("MATRICULE_CHAUFFEUR"));
                toAdd.setCleAgence(rs.getInt("CLE_AGENCE"));
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getConducteurRougeList()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Vehicule> getVehiculeOrangeList() {
        Vector<Vehicule> result = new Vector<Vehicule>();
        String sql = "";
        try {
            sql = "SELECT CLE_AGENCE, N_IMMATRICULATION, DESIGNATION_VEHICULE, " + BddTransport.getDateSGBDRToString("DERNIER_TELECHARGEMENT", false, "") + " FROM " + tableVehicule + " WHERE " + BddTransport.getDateDiff(BddTransport.getCurrentDate(), "DERNIER_TELECHARGEMENT") + " BETWEEN " + BddTransport.getNBJour(System.getProperty("vehicle.orange.threshold", String.valueOf(60))) + " AND " + BddTransport.getNBJour(System.getProperty("vehicle.red.threshold", String.valueOf(90))) + " AND DERNIER_TELECHARGEMENT>" + BddTransport.getDateStringToSGBDR("2000-01-01", false) + " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            String restriction = BddTransport.addRestriction(tableVehicule, "");
            if (restriction != "") {
                sql = String.valueOf(sql) + " AND " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY N_IMMATRICULATION, DESIGNATION_VEHICULE";
            TimsLogger.debug("vehicule orange sql = " + sql);
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Vehicule toAdd = new Vehicule(rs.getString("DESIGNATION_VEHICULE"), rs.getString("N_IMMATRICULATION"), rs.getString("DERNIER_TELECHARGEMENT"));
                toAdd.setAgencyId(rs.getInt("CLE_AGENCE"));
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getVehiculeOrangeList()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Vehicule> getVehiculeRougeList() {
        Vector<Vehicule> result = new Vector<Vehicule>();
        String sql = "";
        try {
            sql = "SELECT CLE_AGENCE, N_IMMATRICULATION, DESIGNATION_VEHICULE, " + BddTransport.getDateSGBDRToString("DERNIER_TELECHARGEMENT", false, "") + " FROM " + tableVehicule + " WHERE " + BddTransport.getDateDiff(BddTransport.getCurrentDate(), "DERNIER_TELECHARGEMENT") + " > " + BddTransport.getNBJour(System.getProperty("vehicle.red.threshold", String.valueOf(90))) + " AND DERNIER_TELECHARGEMENT>" + BddTransport.getDateStringToSGBDR("2000-01-01", false) + " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            String restriction = BddTransport.addRestriction(tableVehicule, "");
            if (restriction != "") {
                sql = String.valueOf(sql) + " AND " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY N_IMMATRICULATION, DESIGNATION_VEHICULE";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Vehicule toAdd = new Vehicule(rs.getString("DESIGNATION_VEHICULE"), rs.getString("N_IMMATRICULATION"), rs.getString("DERNIER_TELECHARGEMENT"));
                toAdd.setAgencyId(rs.getInt("CLE_AGENCE"));
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getVehiculeRougeList()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<ActiviteConducteur> getActivite(int cleConducteur, java.util.Date debut, java.util.Date fin, int brut, int supprime) {
        return this.getActivite(cleConducteur, ConversionTime.dateToString(debut, "yyyy-MM-dd"), ConversionTime.dateToString(fin, "yyyy-MM-dd"), brut, supprime);
    }

    public Vector<ActiviteConducteur> getActivite(int cleConducteur, String dateDebut, String dateFin, int brut, int supprime) {
        String resDate = "";
        if (dateDebut != null) {
            resDate = dateFin != null && !dateFin.equals("") ? String.valueOf(resDate) + " AND DATE_JOUR BETWEEN " + BddTransport.getDateStringToSGBDR(dateDebut, false) + " AND " + BddTransport.getDateStringToSGBDR(dateFin, false) : String.valueOf(resDate) + " AND DATE_JOUR =" + BddTransport.getDateStringToSGBDR(dateDebut, false);
        }
        return this.getActivite(cleConducteur, resDate, brut, supprime);
    }

    public Vector<ActiviteConducteur> getActivite(int cleConducteur, Vector<java.util.Date> date, int brut, int supprime) {
        String resDate = "";
        if (date != null) {
            resDate = String.valueOf(resDate) + " AND DATE_JOUR IN ( ";
            String sDate = "";
            for (java.util.Date tmp : date) {
                sDate = String.valueOf(sDate) + "," + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(tmp, "yyyy-MM-dd"), false);
            }
            resDate = String.valueOf(resDate) + sDate.substring(1) + ")";
        }
        if (supprime != -1) {
            resDate = String.valueOf(resDate) + " AND SUPPRESSION=" + supprime;
        }
        return this.getActivite(cleConducteur, resDate, brut, supprime);
    }

    public Vector<ActiviteConducteur> getActivite(int cleConducteur, String resDate, int brut, int supprime) {
        Vector<ActiviteConducteur> result = new Vector<ActiviteConducteur>();
        String sql = "";
        try {
            String res = "";
            res = cleConducteur != 0 ? String.valueOf(res) + " AND CLE_CHAUFFEUR = " + cleConducteur : String.valueOf(res) + " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            if (resDate != null && !resDate.equals("")) {
                res = String.valueOf(res) + resDate;
            }
            if (supprime != -1) {
                res = String.valueOf(res) + " AND SUPPRESSION=" + supprime;
            }
            sql = "SELECT " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "") + ", CLE_CHAUFFEUR, MODIFICATION, SUPPRESSION, DISTANCE, CONDUITE, ACTIVITIES" + " FROM " + "t_jour";
            if (res.length() != 0) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            if (brut != 1) {
                sql = String.valueOf(sql) + " AND MODIFICATION = 0";
            }
            if (brut != 1) {
                sql = String.valueOf(sql) + " UNION ALL SELECT " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "") + ", CLE_CHAUFFEUR, MODIFICATION, SUPPRESSION, DISTANCE, CONDUITE, ACTIVITIES" + " FROM " + tableJourModifie + " WHERE CURRENT_VALUE = 1";
                if (res.length() != 0) {
                    sql = String.valueOf(sql) + " AND " + res.substring(5);
                }
            }
            sql = String.valueOf(sql) + " ORDER BY DATE_JOUR";
            Transport.ps.startOperation();
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate activit\u00e9", "#BddTransport.getActivite() => %s# sql = " + sql, 1);
            while (rs.next()) {
                int driving = rs.getInt("CONDUITE");
                float distancePerMin = driving == 0 ? 0.0f : (float)rs.getInt("DISTANCE") / (float)driving;
                Blob blobActivities = rs.getBlob("ACTIVITIES");
                if (blobActivities == null) {
                    TimsLogger.warn("Activity null on " + rs.getString("DATE_JOUR"));
                }
                result.addAll(ActiviteConducteur.fromCondensed(blobActivities.getBytes(1L, (int)blobActivities.length()), rs.getString("DATE_JOUR"), rs.getInt("CLE_CHAUFFEUR"), rs.getBoolean("SUPPRESSION"), rs.getInt("MODIFICATION"), distancePerMin));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getActivite()# " + ex.getMessage() + " - Erreur sql = " + sql);
            ex.printStackTrace();
        }
        return result;
    }

    public Vector<ActiviteConducteur> getActiviteOldTActivite(int cleConducteur, String dateDebut, String dateFin, int brut, Statement stm) {
        String resDate = "";
        if (dateDebut != null) {
            resDate = dateFin != null && !dateFin.equals("") ? String.valueOf(resDate) + " AND ANNEE_ACTIVITE BETWEEN " + BddTransport.getDateStringToSGBDR(dateDebut, false) + " AND " + BddTransport.getDateStringToSGBDR(dateFin, false) : String.valueOf(resDate) + " AND ANNEE_ACTIVITE =" + BddTransport.getDateStringToSGBDR(dateDebut, false);
        }
        Vector<ActiviteConducteur> result = new Vector<ActiviteConducteur>();
        String sql = "";
        try {
            String res = "";
            res = cleConducteur != 0 ? String.valueOf(res) + " AND CLE_CHAUFFEUR = " + cleConducteur : String.valueOf(res) + " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            if (resDate != null && !resDate.equals("")) {
                res = String.valueOf(res) + resDate;
            }
            sql = "SELECT CLE_ACTIVITE, a.CLE_CHAUFFEUR, CLE_JOUR, a.CLE_TYPE_ACTIV, " + BddTransport.getDateSGBDRToString("ANNEE_ACTIVITE", false, "a") + ", HEURE_DEBUT, HEURE_FIN, DUREE_EN_MINUTE, " + "ETAT_CARTE, SOURCE, NOM_SOURCE, CLE_DISQUE,ta.DESIGNATION, COULEUR, ETAT_CONDUITE, " + "MODIFICATION, LECTEUR, SUPPRESSION" + " FROM t_activite a " + " JOIN " + tableTypeActivite + " ta ON a.CLE_TYPE_ACTIV=ta.ID" + " WHERE MODIFICATION = 0";
            if (res.length() != 0) {
                sql = String.valueOf(sql) + " AND " + res.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY ANNEE_ACTIVITE,HEURE_DEBUT";
            Transport.ps.startOperation();
            ResultSet rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate activit\u00e9", "#BddTransport.getActivite() => %s# sql = " + sql, 1);
            while (rs.next()) {
                result.add(new ActiviteConducteur(rs.getInt("CLE_ACTIVITE"), rs.getInt("CLE_CHAUFFEUR"), rs.getInt("CLE_JOUR"), rs.getInt("CLE_TYPE_ACTIV"), rs.getString("DESIGNATION"), rs.getString("COULEUR"), rs.getInt("HEURE_DEBUT"), rs.getInt("HEURE_FIN"), rs.getInt("DUREE_EN_MINUTE"), rs.getString("ANNEE_ACTIVITE"), rs.getString("SOURCE"), rs.getString("NOM_SOURCE"), rs.getString("ETAT_CARTE"), rs.getString("ETAT_CONDUITE"), rs.getString("LECTEUR"), rs.getInt("CLE_DISQUE"), rs.getInt("MODIFICATION"), rs.getInt("SUPPRESSION")));
            }
            rs.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getActivite()# Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<ActiviteConducteur> getActiviteOldTActiviteUpdated(int cleConducteur, String dateDebut, String dateFin, Statement stm) {
        String resDate = "";
        if (dateDebut != null) {
            resDate = dateFin != null && !dateFin.equals("") ? String.valueOf(resDate) + " AND ANNEE_ACTIVITE BETWEEN " + BddTransport.getDateStringToSGBDR(dateDebut, false) + " AND " + BddTransport.getDateStringToSGBDR(dateFin, false) : String.valueOf(resDate) + " AND ANNEE_ACTIVITE =" + BddTransport.getDateStringToSGBDR(dateDebut, false);
        }
        Vector<ActiviteConducteur> result = new Vector<ActiviteConducteur>();
        String sql = "";
        try {
            String res = " AND MODIFICATION=1 AND SUPPRESSION=0";
            res = cleConducteur != 0 ? String.valueOf(res) + " AND CLE_CHAUFFEUR = " + cleConducteur : String.valueOf(res) + " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            if (resDate != null && !resDate.equals("")) {
                res = String.valueOf(res) + resDate;
            }
            sql = "SELECT CLE_ACTIVITE, a.CLE_CHAUFFEUR, CLE_JOUR, a.CLE_TYPE_ACTIV, " + BddTransport.getDateSGBDRToString("ANNEE_ACTIVITE", false, "a") + ", HEURE_DEBUT, HEURE_FIN, DUREE_EN_MINUTE, " + "ETAT_CARTE, SOURCE, NOM_SOURCE, CLE_DISQUE,ta.DESIGNATION, COULEUR, ETAT_CONDUITE, " + "MODIFICATION, LECTEUR, SUPPRESSION" + " FROM t_activite a " + " JOIN " + tableTypeActivite + " ta ON a.CLE_TYPE_ACTIV=ta.ID";
            if (res.length() != 0) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY ANNEE_ACTIVITE,HEURE_DEBUT";
            Transport.ps.startOperation();
            ResultSet rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate activit\u00e9", "#BddTransport.getActivite() => %s# sql = " + sql, 1);
            while (rs.next()) {
                result.add(new ActiviteConducteur(rs.getInt("CLE_ACTIVITE"), rs.getInt("CLE_CHAUFFEUR"), rs.getInt("CLE_JOUR"), rs.getInt("CLE_TYPE_ACTIV"), rs.getString("DESIGNATION"), rs.getString("COULEUR"), rs.getInt("HEURE_DEBUT"), rs.getInt("HEURE_FIN"), rs.getInt("DUREE_EN_MINUTE"), rs.getString("ANNEE_ACTIVITE"), rs.getString("SOURCE"), rs.getString("NOM_SOURCE"), rs.getString("ETAT_CARTE"), rs.getString("ETAT_CONDUITE"), rs.getString("LECTEUR"), rs.getInt("CLE_DISQUE"), rs.getInt("MODIFICATION"), rs.getInt("SUPPRESSION")));
            }
            rs.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getActivite()# Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<ActiviteConducteur> getActiviteOldTActiviteM(int cleConducteur, String dateDebut, String dateFin, int brut, Statement stm) {
        String resDate = "";
        if (dateDebut != null) {
            resDate = dateFin != null && !dateFin.equals("") ? String.valueOf(resDate) + " AND ANNEE_ACTIVITE BETWEEN " + BddTransport.getDateStringToSGBDR(dateDebut, false) + " AND " + BddTransport.getDateStringToSGBDR(dateFin, false) : String.valueOf(resDate) + " AND ANNEE_ACTIVITE =" + BddTransport.getDateStringToSGBDR(dateDebut, false);
        }
        Vector<ActiviteConducteur> result = new Vector<ActiviteConducteur>();
        String sql = "";
        try {
            String table = "t_activite_modifie";
            if (brut == 1) {
                table = "t_activite";
            }
            String res = "";
            if (cleConducteur != 0) {
                res = String.valueOf(res) + " AND CLE_CHAUFFEUR = " + cleConducteur;
            }
            res = brut == 1 ? String.valueOf(res) + " AND MODIFICATION = 0" : String.valueOf(res) + " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            if (resDate != null && !resDate.equals("")) {
                res = String.valueOf(res) + resDate;
            }
            sql = "SELECT CLE_ACTIVITE, a.CLE_CHAUFFEUR, CLE_JOUR, a.CLE_TYPE_ACTIV, " + BddTransport.getDateSGBDRToString("ANNEE_ACTIVITE", false, "a") + ", HEURE_DEBUT, HEURE_FIN, DUREE_EN_MINUTE, " + "ETAT_CARTE, SOURCE, NOM_SOURCE, CLE_DISQUE,ta.DESIGNATION, COULEUR, ETAT_CONDUITE, " + "MODIFICATION, LECTEUR, SUPPRESSION" + " FROM t_activite_modifie a " + " JOIN " + tableTypeActivite + " ta ON a.CLE_TYPE_ACTIV=ta.ID";
            if (res.length() != 0) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY ANNEE_ACTIVITE,HEURE_DEBUT";
            Transport.ps.startOperation();
            ResultSet rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate activit\u00e9", "#BddTransport.getActivite() => %s# sql = " + sql, 1);
            while (rs.next()) {
                result.add(new ActiviteConducteur(rs.getInt("CLE_ACTIVITE"), rs.getInt("CLE_CHAUFFEUR"), rs.getInt("CLE_JOUR"), rs.getInt("CLE_TYPE_ACTIV"), rs.getString("DESIGNATION"), rs.getString("COULEUR"), rs.getInt("HEURE_DEBUT"), rs.getInt("HEURE_FIN"), rs.getInt("DUREE_EN_MINUTE"), rs.getString("ANNEE_ACTIVITE"), rs.getString("SOURCE"), rs.getString("NOM_SOURCE"), rs.getString("ETAT_CARTE"), rs.getString("ETAT_CONDUITE"), rs.getString("LECTEUR"), rs.getInt("CLE_DISQUE"), rs.getInt("MODIFICATION"), rs.getInt("SUPPRESSION")));
            }
            rs.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getActivite()# Erreur sql = " + sql);
        }
        return result;
    }

    public void updateJour(PreparedStatement statement, int driverId, String dayOfAct, byte[] condensed, String source) {
        try {
            statement.setObject(1, (Object)condensed, 2004);
            statement.setObject(2, (Object)source, 12);
            statement.setObject(3, (Object)driverId, 4);
            statement.setDate(4, Date.valueOf(dayOfAct));
            statement.executeUpdate();
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateJourM(int driverId, String dayOfAct, byte[] condensed, String source) {
    }

    public void updateDriverOffenceDate(String date, int cleAgence, int cleChauffeur, boolean brut) {
        String sql = "";
        try {
            Statement stm = this.getConnection().createStatement();
            String champ = brut ? "DATE_CALCUL_BRUT" : "DATE_CALCUL_MODIFIE";
            sql = "UPDATE t_conducteur SET " + champ + "=" + BddTransport.getDateStringToSGBDR(date, false);
            if (cleChauffeur != 0) {
                sql = String.valueOf(sql) + " WHERE CLE_CHAUFFEUR = " + cleChauffeur;
            } else if (cleAgence != 0) {
                sql = String.valueOf(sql) + " WHERE CLE_AGENCE = " + cleAgence;
            }
            stm.executeUpdate(sql);
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#updateDriverOffenceDate()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    public Vector<Offense> getInfractionAgence(int cleAgence, String begin, String end, boolean brut) {
        Vector<Offense> result = new Vector<Offense>();
        String sql = "";
        String res = "";
        if (brut) {
            res = String.valueOf(res) + " AND BRUTE=1";
        }
        if (begin != null) {
            res = end != null && !end.equals("") ? String.valueOf(res) + " AND " + BddTransport.getChampDate() + " BETWEEN " + BddTransport.getDateStringToSGBDR(begin, false) + " AND " + BddTransport.getDateStringToSGBDR(end, false) : String.valueOf(res) + " AND DATE >=" + BddTransport.getDateStringToSGBDR(begin, false);
        } else if (end != null) {
            res = String.valueOf(res) + " AND DATE =<" + BddTransport.getDateStringToSGBDR(end, false);
        }
        try {
            sql = "SELECT " + BddTransport.getChampDate() + ",HEURE_DEPASSEMENT,DESIGNATION,SEUIL,SEUIL_CONSTATE," + "NOM_CONDUCTEUR,PRENOM_CONDUCTEUR,BRUTE" + " FROM " + tableInfraction + " JOIN " + tableTblInfraction + " ON NUM_INFRACTIONS=CLE_DESIGNATION" + " JOIN " + tableConducteur + " ON " + tableConducteur + ".CLE_CHAUFFEUR=" + tableInfraction + ".CLE_CHAUFFEUR" + " WHERE " + tableConducteur + ".CLE_AGENCE =" + cleAgence;
            if (!res.equals("")) {
                sql = String.valueOf(sql) + res;
            }
            sql = String.valueOf(sql) + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, " + BddTransport.getChampDate() + " DESC,DESIGNATION";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Offense(rs.getString(1), rs.getInt(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getBoolean(8)));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getInfractionAgence()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Offense> getInfractionConducteur(int cleCond, java.util.Date dateJour, boolean brut) {
        Vector<Offense> result = new Vector<Offense>();
        String sql = "";
        try {
            sql = "SELECT " + BddTransport.getChampDate() + ",HEURE_DEPASSEMENT,DESIGNATION,SEUIL,SEUIL_CONSTATE," + "NOM_CONDUCTEUR,PRENOM_CONDUCTEUR,BRUTE" + " FROM " + tableInfraction + " JOIN " + tableTblInfraction + " ON NUM_INFRACTIONS=CLE_DESIGNATION" + " JOIN " + tableConducteur + " ON " + tableConducteur + ".CLE_CHAUFFEUR=" + tableInfraction + ".CLE_CHAUFFEUR" + " WHERE " + tableInfraction + ".CLE_CHAUFFEUR =" + cleCond;
            if (brut) {
                sql = String.valueOf(sql) + " AND BRUTE=1";
            }
            if (dateJour != null) {
                String dd = ConversionTime.dateToString(dateJour, "yyyy-MM-dd");
                sql = String.valueOf(sql) + " AND " + BddTransport.getChampDate() + "=" + BddTransport.getDateStringToSGBDR(dd, false);
            }
            sql = String.valueOf(sql) + " ORDER BY " + BddTransport.getChampDate() + " DESC,DESIGNATION";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Offense(rs.getString(1), rs.getInt(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getBoolean(8)));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getInfractionConducteur()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public boolean isInfraction(int cleConducteur, String date, String hd, String numInfraction, String duree, boolean brute) {
        boolean is = false;
        String sql = "SELECT CLE FROM t_infractions WHERE CLE_CHAUFFEUR =" + cleConducteur + " AND " + BddTransport.getChampDate() + "=" + BddTransport.getDateStringToSGBDR(date, false) + " AND HEURE_DEPASSEMENT=" + hd + " AND NUM_INFRACTIONS='" + numInfraction + "'" + " AND SEUIL_CONSTATE=" + duree + " AND BRUTE=" + (brute ? "1" : "0");
        try {
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            if (rs.next()) {
                is = true;
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#isInfraction()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return is;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector<Offence>[] getInfractionConducteurSemaine(int cleCond, java.util.Date dateJour, boolean brut) {
        Vector[] result = new Vector[7];
        int i = 0;
        while (i < 7) {
            result[i] = new Vector();
            ++i;
        }
        GregorianCalendar calendrier = new GregorianCalendar();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        calendrier.setTime(dateJour);
        String dateBDDDebut = dateFormat.format(calendrier.getTime());
        calendrier.add(5, 6);
        String dateBDDFin = dateFormat.format(calendrier.getTime());
        String sql = "";
        try {
            Vector<Offence> tmp = Offence.loadList(0, cleCond, dateBDDDebut, dateBDDFin, brut, false);
            if (tmp.size() == 0) return result;
            calendrier.setTime(dateJour);
            int y = 0;
            int x = 0;
            block3: while (true) {
                if (x >= 7) {
                    return result;
                }
                while (true) {
                    if (y >= tmp.size() || !tmp.get(y).getDate().equals(calendrier.getTime())) {
                        calendrier.add(5, 1);
                        ++x;
                        continue block3;
                    }
                    result[x].add(tmp.get(y));
                    ++y;
                }
                break;
            }
        }
        catch (Exception ex) {
            TimsLogger.error("#getInfractionConducteurSemaine()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Conducteur> getConducteurListAgence(String database) {
        Vector<Conducteur> result = new Vector<Conducteur>();
        String sql = "";
        try {
            sql = "SELECT CLE_CHAUFFEUR ,NOM_CONDUCTEUR, PRENOM_CONDUCTEUR FROM ";
            if (!database.equals("") && System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = String.valueOf(sql) + database + ".";
            }
            sql = String.valueOf(sql) + "t_conducteur WHERE ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0") + " ORDER BY NOM_CONDUCTEUR,PRENOM_CONDUCTEUR";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Conducteur(rs.getInt(1), rs.getString(2), rs.getString(3)));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getConducteurListAgence()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Conflit> getConflitList(int cleConducteur, String date, int processed, boolean restricted) {
        Vector<Conflit> result = new Vector<Conflit>();
        String sql = "";
        try {
            String restriction;
            sql = "SELECT CLE_CONFLIT, t_conducteur.CLE_CHAUFFEUR , CLE_USER, CLE_TRAITANT, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, DES_AGENCE, DATE_CONFLIT, DATE_CREATION, DATE_PROCESSION, KM_ANALYSE, KM_BASE, TRAITE FROM t_conducteur JOIN t_conflit ON t_conducteur.CLE_CHAUFFEUR=t_conflit.CLE_CHAUFFEUR JOIN t_agence ON t_conducteur.CLE_AGENCE=t_agence.CLE_AGENCE WHERE 1=1";
            if (processed != -1) {
                sql = String.valueOf(sql) + " AND TRAITE=" + processed;
            }
            if (cleConducteur != 0) {
                sql = String.valueOf(sql) + " AND t_conflit.CLE_CHAUFFEUR = " + cleConducteur;
            }
            if (date != null) {
                sql = String.valueOf(sql) + " AND t_conflit.DATE_CONFLIT = " + BddTransport.getDateStringToSGBDR(date, false);
            }
            if ((restriction = BddTransport.addRestriction(tableConducteur, tableConducteur)) != "" && restricted) {
                sql = String.valueOf(sql) + " AND " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY DATE_CONFLIT DESC, NOM_CONDUCTEUR";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Conflit(rs.getInt("CLE_CONFLIT"), rs.getInt("CLE_CHAUFFEUR"), rs.getInt("CLE_USER"), rs.getInt("CLE_TRAITANT"), rs.getString("NOM_CONDUCTEUR"), rs.getString("PRENOM_CONDUCTEUR"), rs.getString("DES_AGENCE"), rs.getString("DATE_CONFLIT"), ConversionTime.dateToString(rs.getDate("DATE_CREATION"), "yyyy-MM-dd"), ConversionTime.dateToString(rs.getDate("DATE_PROCESSION"), "yyyy-MM-dd"), rs.getInt("KM_ANALYSE"), rs.getInt("KM_BASE"), rs.getBoolean("TRAITE")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getConflitList()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public boolean getNombreConflit(int cleCond, String dateJour) {
        boolean result = false;
        String sql = "";
        try {
            sql = "SELECT count(*) FROM t_conflit WHERE CLE_CHAUFFEUR=" + cleCond + " AND DATE_CONFLIT=" + BddTransport.getDateStringToSGBDR(dateJour, false) + " AND TRAITE=0";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                if (rs.getInt(1) <= 0) continue;
                result = true;
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getNombreConflit()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public void updateConflit(int cleCond, String dateBDD, int cleTraitant, boolean traite, String dateProcess) {
        String[] lib = new String[]{"TRAITE", "CLE_TRAITANT", "DATE_PROCESSION"};
        String[] val = new String[]{traite ? "1" : "0", String.valueOf(cleTraitant), dateProcess};
        int[] type = new int[]{12, 12, 93};
        String[] lib_ = new String[]{"CLE_CHAUFFEUR", "DATE_CONFLIT"};
        String[] val_ = new String[]{String.valueOf(cleCond), dateBDD};
        int[] type_ = new int[]{12, 91};
        this.updateRecord(tableConflit, lib, val, type, lib_, val_, type_);
    }

    public Vector<Conducteur> getConducteurAAffecter(int cleAgence) {
        String sql = "";
        Vector<Conducteur> result = new Vector<Conducteur>();
        try {
            sql = "SELECT CLE_CHAUFFEUR, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR FROM t_conducteur WHERE (NUM_CARTE_CHAUFFEUR = '' OR NUM_CARTE_CHAUFFEUR IS NULL) AND CLE_AGENCE = " + cleAgence + " AND ARCHIVAGE = 0" + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Conducteur(rs.getInt("CLE_CHAUFFEUR"), rs.getString("NOM_CONDUCTEUR"), rs.getString("PRENOM_CONDUCTEUR")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getConducteurAAffecter()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Conducteur> getConducteurListInfraction(int cleAgence, int cleConducteur) {
        Vector<Conducteur> result = new Vector<Conducteur>();
        String sql = "";
        try {
            sql = "SELECT CLE_CHAUFFEUR , CLE_AGENCE, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, MEMBER_STATE, TRAVAIL_NUIT, DATE_CALCUL_BRUT, DATE_CALCUL_MODIFIE, TYPE_CONDUCTEUR  FROM t_conducteur WHERE ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            if (cleAgence != 0) {
                sql = String.valueOf(sql) + " AND CLE_AGENCE = " + cleAgence;
            }
            if (cleConducteur != 0) {
                sql = String.valueOf(sql) + " AND CLE_CHAUFFEUR = " + cleConducteur;
            }
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Conducteur toAdd = new Conducteur(rs.getInt("CLE_CHAUFFEUR"), rs.getString("NOM_CONDUCTEUR"), rs.getString("PRENOM_CONDUCTEUR"), rs.getString("DATE_CALCUL_BRUT") == null ? "1970-01-01" : rs.getString("DATE_CALCUL_BRUT"), rs.getString("DATE_CALCUL_MODIFIE") == null ? "1970-01-01" : rs.getString("DATE_CALCUL_MODIFIE"), rs.getInt("TYPE_CONDUCTEUR"));
                toAdd.setMemberState(rs.getInt("MEMBER_STATE"));
                toAdd.setCleAgence(rs.getInt("CLE_AGENCE"));
                toAdd.setNightWorker(rs.getInt("TRAVAIL_NUIT") == 1);
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getConducteurListInfraction()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Pays> getPays() {
        String sql = "";
        Vector<Pays> result = new Vector<Pays>();
        try {
            sql = "SELECT CLE_PAYS, DES_PAYS FROM t_pays ORDER BY DES_PAYS";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Pays(rs.getInt(1), rs.getString(2), rs.getString(2)));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getPays()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getVehiculeCle(String immat) {
        String sql = "";
        int result = 0;
        try {
            sql = "SELECT CLE_VEHICULE FROM t_vehicule WHERE N_IMMATRICULATION ='" + BddTransport.addSlashes(immat) + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getVehiculeCle()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Tournee> getTournee() {
        String sql = "";
        Vector<Tournee> result = new Vector<Tournee>();
        try {
            sql = "SELECT t_tournee.CLE_TOURNEE, t_tournee.DESIGNATION_TOURNEE DES, t_tournee.LIEU_DEPART, t_tournee.LIEU_ARRIVEE, t_tournee.HEURE_DEPART, t_tournee.HEURE_ARRIVEE, t_tournee.DUREE_CONDUITE, t_tournee.DUREE_TRAVAIL, t_tournee.DUREE_DISPO, t_tournee.DUREE_REPOS, t_tournee.DUREE_TOTALE, t_tournee.DISTANCE, t_tournee.NB_DESSERTES, t_tournee.DESSERTES_H, t_tournee.KM_DESSERTES, t_tournee.TPS_MOY_DESSERTES, t_tournee.FRAIS, t_tournee.REMARQUES, t_tournee.HEURE_DEBUT_COUPURE, t_tournee.HEURE_FIN_COUPURE from t_tournee ORDER BY DES";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Tournee(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getString(8), rs.getString(9), rs.getString(10), rs.getString(11), rs.getString(12), rs.getString(13), rs.getString(14), rs.getString(15), rs.getString(16), rs.getString(17), rs.getString(18), rs.getString(19), rs.getString(20)));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getTournee()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Tournee> getTournee(String CLE_TOURNEE) {
        String sql = "";
        Vector<Tournee> result = new Vector<Tournee>();
        try {
            sql = "SELECT t_tournee.CLE_TOURNEE, t_tournee.DESIGNATION_TOURNEE DES, t_tournee.LIEU_DEPART, t_tournee.LIEU_ARRIVEE, t_tournee.HEURE_DEPART, t_tournee.HEURE_ARRIVEE, t_tournee.DUREE_CONDUITE, t_tournee.DUREE_TRAVAIL, t_tournee.DUREE_DISPO, t_tournee.DUREE_REPOS, t_tournee.DUREE_TOTALE, t_tournee.DISTANCE, t_tournee.NB_DESSERTES, t_tournee.DESSERTES_H, t_tournee.KM_DESSERTES, t_tournee.TPS_MOY_DESSERTES, t_tournee.FRAIS, t_tournee.REMARQUES, t_tournee.HEURE_DEBUT_COUPURE, t_tournee.HEURE_FIN_COUPURE from t_tournee WHERE t_tournee.CLE_TOURNEE=" + CLE_TOURNEE;
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Tournee(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getString(8), rs.getString(9), rs.getString(10), rs.getString(11), rs.getString(12), rs.getString(13), rs.getString(14), rs.getString(15), rs.getString(16), rs.getString(17), rs.getString(18), rs.getString(19), rs.getString(20)));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getTournee()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<UevCalibration> getEtalonnage(int cleVehicule) {
        Vector<UevCalibration> result = new Vector<UevCalibration>();
        String sql = "";
        try {
            sql = "SELECT CLE_VEHICULE, TYPE, NOM_MAGASIN, ADRESSE_MAGASIN, TYPE_CARTE, NUMERO_CARTE, EXPIRATION_CARTE, IDENTIFICATION_VEHICULE, CLE_PAYS, ENREGISTREMENT_VEHICULE, W_VEHICULE, K_VEHICULE, L_VEHICULE, TYRE_SIZE, AUTHORIZED_SPEED, ANCIEN_KM, NOUVEAU_KM, ANCIENNE_DATE, NOUVELLE_DATE, PROCHAIN_ETALONNAGE FROM t_etalonnage WHERE CLE_VEHICULE=" + cleVehicule + " ORDER BY CLE_ETALONNAGE";
            Transport.ps.startOperation();
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate \u00e9talonnage", "#BddT.getEtalonnage() => %s# sql = " + sql, 1);
            while (rs.next()) {
                String nouvelleDate = ConversionTime.dateToStringDb(rs.getDate("NOUVELLE_DATE"));
                String ancienneDate = ConversionTime.dateToStringDb(rs.getDate("ANCIENNE_DATE"));
                String prochainEtalonnage = ConversionTime.dateToStringDb(rs.getDate("PROCHAIN_ETALONNAGE"));
                String expirationCarte = ConversionTime.dateToStringDb(rs.getDate("EXPIRATION_CARTE"));
                result.add(new UevCalibration(cleVehicule, rs.getInt("TYPE"), rs.getString("NOM_MAGASIN"), rs.getString("ADRESSE_MAGASIN"), rs.getInt("TYPE_CARTE"), rs.getString("NUMERO_CARTE"), expirationCarte, rs.getString("IDENTIFICATION_VEHICULE"), rs.getInt("CLE_PAYS"), rs.getString("ENREGISTREMENT_VEHICULE"), rs.getInt("W_VEHICULE"), rs.getInt("K_VEHICULE"), rs.getInt("L_VEHICULE"), rs.getString("TYRE_SIZE"), rs.getInt("AUTHORIZED_SPEED"), rs.getInt("ANCIEN_KM"), rs.getInt("NOUVEAU_KM"), ancienneDate, nouvelleDate, prochainEtalonnage));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#BddTransport.getEtalonnage()# " + ex.getMessage() + " - Erreur sql = " + sql);
            ex.printStackTrace();
        }
        return result;
    }

    public Vector<VehicleUsed>[] getCycleInsertionCarteSemaine(int cleVehicule, java.util.Date dateDebut, int dureeMin) {
        Vector[] result = new Vector[7];
        SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
        int i = 0;
        while (i < 7) {
            result[i] = new Vector();
            ++i;
        }
        GregorianCalendar calendrier = new GregorianCalendar();
        calendrier.setTime(dateDebut);
        java.util.Date dateBDDDebut = calendrier.getTime();
        calendrier.add(5, 7);
        java.util.Date dateBDDFin = calendrier.getTime();
        String sql = "";
        try {
            Vector<VehicleUsed> tmp = VehicleUsed.loadListVehicle(0, cleVehicule, dateBDDDebut, dateBDDFin, true);
            TimsLogger.debug("#BddTransport.getCycleInsertionCarteSemaine# " + tmp.size() + " insertions entre " + dateBDDDebut + " et " + dateBDDFin);
            if (tmp.size() != 0) {
                int x = 0;
                while (x < 7) {
                    java.util.Date dateTmp = ConversionTime.addDay(dateDebut, x);
                    int y = 0;
                    while (y < tmp.size()) {
                        java.util.Date insertion = ConversionTime.dateTruncate(tmp.get(y).getDateDebut());
                        java.util.Date retrait = ConversionTime.dateTruncate(tmp.get(y).getDateFin());
                        TimsLogger.debug("#BddTransport.getCycleInsertionCarteSemaine# " + dateTmp + " => " + insertion + " : " + retrait);
                        if (insertion.compareTo(dateTmp) <= 0 && retrait.compareTo(dateTmp) >= 0) {
                            result[x].add(tmp.get(y));
                        }
                        if (insertion.after(dateTmp)) break;
                        ++y;
                    }
                    ++x;
                }
            }
        }
        catch (Exception ex) {
            TimsLogger.error("#getCycleInsertionCarteSemaine()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<String[]> getAmplitudeCarte(String dateDebut, String dateFin, int cleAgence) {
        String sql = "";
        Vector<String[]> result = new Vector<String[]>();
        try {
            sql = "SELECT au.CLE_VEHICULE, N_IMMATRICULATION, DATE_DEBUT, DATE_FIN  FROM t_vehicule v JOIN vehicle_used au ON v.cle_vehicule = au.cle_vehicule WHERE DATE_DEBUT BETWEEN " + BddTransport.getDateStringToSGBDR(dateDebut, false) + " AND " + BddTransport.getDateStringToSGBDR(dateFin, false) + " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            if (cleAgence != 0) {
                sql = String.valueOf(sql) + " AND v.CLE_AGENCE = " + cleAgence;
            }
            sql = String.valueOf(sql) + " ORDER BY N_IMMATRICULATION, DATE_DEBUT";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                String[] tmp = new String[]{rs.getString("CLE_VEHICULE"), rs.getString("DATE_DEBUT"), rs.getString("DATE_FIN")};
                result.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getAmplitudeCarte()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<JourUEV> getOccupationUEV(String dateDebut, String dateFin, int cleAgence) {
        String sql = "";
        Vector<JourUEV> result = new Vector<JourUEV>();
        try {
            sql = "SELECT au.CLE_VEHICULE, N_IMMATRICULATION, JOUR_TELECHARGE, sum(DUREE) as TOTAL FROM t_vehicule v JOIN t_activite_uev au ON v.cle_vehicule = au.cle_vehicule WHERE type_activ in (1,2,3) and lecteur = 'CONDUCTEUR'  AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0") + " AND jour_telecharge BETWEEN " + BddTransport.getDateStringToSGBDR(dateDebut, false) + " AND " + BddTransport.getDateStringToSGBDR(dateFin, false);
            if (cleAgence != 0) {
                sql = String.valueOf(sql) + " AND v.CLE_AGENCE = " + cleAgence;
            }
            sql = String.valueOf(sql) + " GROUP BY au.CLE_VEHICULE, N_IMMATRICULATION, JOUR_TELECHARGE ORDER BY N_IMMATRICULATION, JOUR_TELECHARGE";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new JourUEV(0, rs.getInt("CLE_VEHICULE"), 0, ConversionTime.stringToDate(rs.getString("JOUR_TELECHARGE"), "yyyy-MM-dd"), 0, 0, rs.getInt("TOTAL"), null, null));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getOccupationUEV()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<String[]> getAmplitudeUEV(String dateDebut, String dateFin, int cleAgence) {
        String sql = "";
        Vector<String[]> result = new Vector<String[]>();
        try {
            sql = "SELECT au.CLE_VEHICULE, N_IMMATRICULATION, DATE_DEBUT, DATE_FIN  FROM t_vehicule v JOIN vehicle_used au ON v.cle_vehicule = au.cle_vehicule WHERE DATE_DEBUT BETWEEN " + BddTransport.getDateStringToSGBDR(dateDebut, false) + " AND " + BddTransport.getDateStringToSGBDR(dateFin, false) + " AND LECTEUR = 0" + " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            if (cleAgence != 0) {
                sql = String.valueOf(sql) + " AND v.CLE_AGENCE = " + cleAgence;
            }
            sql = String.valueOf(sql) + " ORDER BY N_IMMATRICULATION, DATE_DEBUT";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                String[] tmp = new String[]{rs.getString("CLE_VEHICULE"), rs.getString("DATE_DEBUT"), rs.getString("DATE_FIN")};
                result.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getAmplitudeUEV()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Agence> getAgenceSScarte() {
        String sql = "";
        Vector<Agence> result = new Vector<Agence>();
        try {
            sql = "SELECT t_agence.CLE_AGENCE, DES_AGENCE FROM t_agence WHERE CLE_AGENCE IN (SELECT DISTINCT CLE_AGENCE FROM t_conducteur WHERE NUM_CARTE_CHAUFFEUR = '' OR NUM_CARTE_CHAUFFEUR IS NULL)";
            String restriction = BddTransport.addRestriction("t_agence", "");
            if (restriction != "") {
                sql = String.valueOf(sql) + " AND " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY DES_AGENCE";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Agence(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getAgenceSScarte()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public String getPaysCle(String desPays) {
        String sql = "";
        String result = "0";
        try {
            sql = "SELECT CLE_PAYS FROM t_pays WHERE DES_PAYS ='" + BddTransport.addSlashes(desPays) + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getPaysCle()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getTypeAgenceCle(String desType) {
        String sql = "";
        int result = 0;
        try {
            sql = "SELECT CLE_TYPE_AGENCE FROM t_type_agence WHERE DESIGNATION_AGENCE ='" + BddTransport.addSlashes(desType) + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getTypeAgenceCle()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public String getTypeAgenceDes(int cleType) {
        String sql = "";
        String result = "";
        try {
            sql = "SELECT DESIGNATION_AGENCE FROM t_type_agence WHERE CLE_TYPE_AGENCE =" + cleType;
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getTypeAgenceDes()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getChauffeurCle(String nom, String prenom, int cleAgence) {
        String sql = "";
        int result = 0;
        try {
            sql = "SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE NOM_CONDUCTEUR ='" + BddTransport.addSlashes(nom) + "' AND" + " PRENOM_CONDUCTEUR ='" + BddTransport.addSlashes(prenom) + "' AND" + " CLE_AGENCE =" + cleAgence;
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getChauffeurCle()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getTypeChauffeurCle(String desChauffeur) {
        String sql = "";
        int result = 0;
        try {
            sql = "SELECT CLE_TYPE_CHAUFFEUR FROM t_type_chauffeur WHERE DESIGNATION_CHAUFFEUR ='" + BddTransport.addSlashes(desChauffeur) + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getTypeChauffeurCle()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public String getTypeChauffeurDes(int cleType) {
        String sql = "";
        String result = "";
        try {
            sql = "SELECT DESIGNATION_CHAUFFEUR FROM t_type_chauffeur WHERE CLE_TYPE_CHAUFFEUR =" + cleType;
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getTypeChauffeurDes()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getTypeActiviteCle(String desActivite) {
        String sql = "";
        int result = 0;
        try {
            sql = "SELECT ID FROM t_type_activite WHERE DESIGNATION ='" + BddTransport.addSlashes(desActivite) + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getTypeActiviteCle()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getAgenceCle(String desAgence) {
        String sql = "";
        int result = 0;
        try {
            sql = "SELECT CLE_AGENCE FROM t_agence WHERE DES_AGENCE ='" + BddTransport.addSlashes(desAgence) + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getAgenceCle()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public String getDateSortie(int cleCond) {
        String sql = "";
        String result = "";
        try {
            sql = "SELECT DATE_SORTIE FROM t_conducteur WHERE CLE_CHAUFFEUR =" + cleCond;
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getString(1);
                if (!result.equals("1970-01-01")) continue;
                result = "";
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getDateSortie()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public String getTourneeCle(String desTournee) {
        String sql = "";
        String result = "";
        try {
            sql = "SELECT CLE_TOURNEE FROM t_tournee WHERE DESIGNATION_TOURNEE ='" + BddTransport.addSlashes(desTournee) + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getTourneeCle()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public String getPaysDes(int clePays) {
        String sql = "";
        String result = "";
        try {
            sql = "SELECT DES_PAYS FROM t_pays WHERE CLE_PAYS =" + clePays;
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getPaysDes()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public String getTailleAgenceDes(int cleTaille) {
        String sql = "";
        String result = "";
        try {
            sql = "SELECT DESIGNATION_TAILLE FROM t_taille_agence WHERE CLE_TAILLE_AGENCE =" + cleTaille;
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getTailleAgenceDes()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getTailleAgenceCle(String desTaille) {
        String sql = "";
        int result = 0;
        try {
            sql = "SELECT CLE_TAILLE_AGENCE FROM t_taille_agence WHERE DESIGNATION_TAILLE ='" + BddTransport.addSlashes(desTaille) + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getTailleAgenceCle()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public String getDateDernierChangement(int cleConducteur) {
        String sql = "";
        String result = "";
        try {
            sql = "SELECT DATE_DERNIER_CHANGEMENT FROM t_conducteur WHERE CLE_CHAUFFEUR =" + cleConducteur;
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getDateDernierChangement()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public String getLienJourTourneeCle(int cleChauffeur, String dateJour, String cleTournee) {
        String sql = "";
        String result = "";
        try {
            sql = "SELECT CLE_LIEN_JOUR_TOURNEE FROM t_lien_jour_tournee where CLE_CHAUFFEUR=" + cleChauffeur + " AND DATE_JOUR =" + BddTransport.getDateStringToSGBDR(dateJour, false) + " AND CLE_TOURNEE ='" + cleTournee + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getLienJourTourneeCle()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public String getJourCle(int cleConducteur, String dateJour) {
        String sql = "";
        String result = "";
        try {
            sql = "SELECT CLE FROM t_jour WHERE CLE_CHAUFFEUR=" + cleConducteur + " AND DATE_JOUR =" + BddTransport.getDateStringToSGBDR(dateJour, false) + " AND SUPPRESSION =0";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getJourCle()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public String getJourSupprimeCle(String cleConducteur, String dateJour) {
        String sql = "";
        String result = "";
        try {
            sql = "SELECT CLE FROM t_jour WHERE CLE_CHAUFFEUR=" + cleConducteur + " AND DATE_JOUR ='" + dateJour + "'" + " AND SUPPRESSION =1";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getJourSupprimeCle()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getEtatJour(int cleConducteur, String dateJour) {
        String sql = "";
        int result = 2;
        try {
            sql = "SELECT SUPPRESSION FROM t_jour WHERE CLE_CHAUFFEUR=" + cleConducteur + " AND DATE_JOUR =" + BddTransport.getDateStringToSGBDR(dateJour, false);
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getInt("SUPPRESSION") == 0 ? 0 : 1;
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getEtatJour()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<String> getCleJourSup(int cleConducteur, String date) {
        String sql = "";
        Vector<String> result = new Vector<String>();
        try {
            sql = "SELECT CLE FROM t_jour WHERE CLE_CHAUFFEUR=" + cleConducteur + " AND DATE_JOUR =" + BddTransport.getDateStringToSGBDR(date, false) + " AND SUPPRESSION=1";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getString(1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getCleJourSup()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<ElementArbre> getArbreConducteura() {
        String sql = "";
        Vector<ElementArbre> result = new Vector<ElementArbre>();
        try {
            sql = "select t_agence.CLE_AGENCE, DES_AGENCE, CLE_INTERNE_AGENCE, t_agence.REGION_ID,CLE_CHAUFFEUR, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, " + BddTransport.getDateDiff(BddTransport.getCurrentDate(), "DATE_DERNIER_TELECHARGEMENT") + " as NB_JOUR," + tableConducteur + ".ARCHIVAGE, NUM_IMPORT_CHAUFFEUR" + " FROM " + "t_agence" + " LEFT JOIN " + tableConducteur + " ON  " + "t_agence" + ".cle_agence=" + tableConducteur + ".cle_agence" + " OR " + tableConducteur + ".cle_agence IS NULL ";
            String restriction = BddTransport.addRestriction("t_agence", tableConducteur);
            if (restriction != "") {
                sql = String.valueOf(sql) + " WHERE " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY DES_AGENCE, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Agence currentagence = null;
            while (rs.next()) {
                Agence agence = new Agence(rs.getInt("CLE_AGENCE"), rs.getString("DES_AGENCE"), rs.getString("CLE_INTERNE_AGENCE"), rs.getInt("REGION_ID"));
                Conducteur conducteur = new Conducteur(rs.getInt("CLE_CHAUFFEUR"), rs.getString("NOM_CONDUCTEUR"), rs.getString("PRENOM_CONDUCTEUR"), rs.getString("NB_JOUR"), rs.getBoolean("ARCHIVAGE"), rs.getString("NUM_IMPORT_CHAUFFEUR"));
                if (!agence.equals(currentagence)) {
                    result.add(agence);
                    currentagence = agence;
                }
                if (conducteur == null || conducteur.isArchive() != MainFrameTransport.archivage) continue;
                result.add(conducteur);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getArbreConducteura()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<ElementArbre> getArbreVehicule() {
        String sql = "";
        Vector<ElementArbre> result = new Vector<ElementArbre>();
        try {
            sql = "SELECT t_agence.CLE_AGENCE, DES_AGENCE, CLE_INTERNE_AGENCE, REGION_ID  CLE_VEHICULE, N_IMMATRICULATION, DESIGNATION_VEHICULE,t_vehicule.ARCHIVAGE," + BddTransport.getDateDiff(BddTransport.getCurrentDate(), "DERNIER_TELECHARGEMENT") + " AS NB_JOUR " + "FROM " + "t_agence" + " LEFT JOIN " + tableVehicule + " ON " + "t_agence" + ".cle_agence=" + tableVehicule + ".cle_agence";
            String restriction = BddTransport.addRestriction("t_agence", null);
            if (restriction != "") {
                sql = String.valueOf(sql) + " WHERE " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY DES_AGENCE, N_IMMATRICULATION";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Agence currentagence = null;
            Vehicule currentVehicule = null;
            while (rs.next()) {
                Agence agence = new Agence(rs.getInt("CLE_AGENCE"), rs.getString("DES_AGENCE"), rs.getString("CLE_INTERNE_AGENCE"), rs.getInt("REGION_ID"));
                Vehicule vehicule = new Vehicule(rs.getInt("CLE_VEHICULE"), rs.getString("N_IMMATRICULATION"), rs.getString("DESIGNATION_VEHICULE"), rs.getString("NB_JOUR"), rs.getBoolean("ARCHIVAGE"));
                if (!agence.equals(currentagence)) {
                    result.add(agence);
                    currentagence = agence;
                    currentVehicule = null;
                }
                if (vehicule.equals(currentVehicule) || vehicule.isArchive() != MainFrameTransport.archivage) continue;
                result.add(vehicule);
                currentVehicule = vehicule;
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getArbreVehicule()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public void delAgence(int cleAgence) {
        String[] lib = new String[]{"CLE_AGENCE"};
        String[] val = new String[]{String.valueOf(cleAgence)};
        int[] type = new int[]{4};
        this.delRecord("t_agence", lib, val, type);
    }

    public void delTournee(String cleTournee) {
        String[] lib = new String[]{"CLE_TOURNEE"};
        String[] val = new String[]{cleTournee};
        int[] type = new int[]{4};
        this.delRecord(tableTournee, lib, val, type);
    }

    public void delConducteur(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        long start1 = System.currentTimeMillis();
        String[] lib = new String[]{"CLE_CHAUFFEUR"};
        String[] val = new String[]{String.valueOf(conducteur.getCleConducteur())};
        int[] type = new int[]{4};
        this.delRecord(tableConducteur, lib, val, type);
        if (res.getResourceString("horoquartz").equals("1") || System.getProperty("horoquartz", "0").equals("1")) {
            this.delRecord(tableExport, lib, val, type);
            this.delRecord(tableExportUpdate, lib, val, type);
        }
        TimsLogger.info("\t#delConducteur# TOTAL=" + (System.currentTimeMillis() - start1));
    }

    public void addPays(String pays) {
        String[] lib = new String[]{"CLE_PAYS", "DES_PAYS"};
        String[] val = new String[]{"GEN_T_PAYS.nextval", pays};
        int[] type = new int[]{1111, 12};
        this.addRecord(tablePays, lib, val, type);
    }

    public void delPays(String pays) {
        String[] lib = new String[]{"CLE_PAYS"};
        String[] val = new String[]{this.getPaysCle(pays)};
        int[] type = new int[]{4};
        this.delRecord(tablePays, lib, val, type);
    }

    public void addTailleAgence(String TailleAgence2) {
        String[] lib = new String[]{"CLE_TAILLE_AGENCE", "DESIGNATION_TAILLE"};
        String[] val = new String[]{"GEN_T_TAILLE_AGENCE.nextval", TailleAgence2};
        int[] type = new int[]{1111, 12};
        this.addRecord(tableTailleAgence, lib, val, type);
    }

    public void delTailleAgence(String TailleAGENCE) {
        String[] lib = new String[]{"CLE_TAILLE_AGENCE"};
        String[] val = new String[]{String.valueOf(this.getTailleAgenceCle(TailleAGENCE))};
        int[] type = new int[]{4};
        this.delRecord(tableTailleAgence, lib, val, type);
    }

    public void addTourneeJ(int b1, String b2, String b3, String b4, String b5, String b6) {
        String[] lib = new String[]{"CLE_LIEN_JOUR_TOURNEE", "CLE_CHAUFFEUR", "DATE_JOUR", "CLE_TOURNEE", "HRPOINT", "HRDEBUT", "HRFIN"};
        String[] val = new String[]{"GEN_T_LIEN_JOUR_TOURNEE.nextval", String.valueOf(b1), b2, b3, b4, b5, b6};
        int[] type = new int[]{1111, 4, 91, 4, 12, 12, 12};
        this.addRecord(tableLienJourTournee, lib, val, type);
    }

    public void addComment(int cleConducteur, String date, String commentaire) {
        String[] lib = new String[]{"CLE_LIEN_JOUR_COMMASS", "CLE_CHAUFFEUR", "DATE_JOUR", "COMM_ASS"};
        String[] val = new String[]{"GEN_T_LIEN_JOUR_COMMASS.nextval", String.valueOf(cleConducteur), date, commentaire};
        int[] type = new int[]{1111, 4, 91, 12};
        this.addRecord(tableLienJourCommass, lib, val, type);
    }

    public void updateComment(int cleConducteur, String date, String comment) {
        String[] lib = new String[]{"COMM_ASS"};
        String[] val = new String[]{comment};
        int[] type = new int[]{12};
        String[] lib_ = new String[]{"CLE_CHAUFFEUR", "DATE_JOUR"};
        String[] val_ = new String[]{String.valueOf(cleConducteur), date};
        int[] type_ = new int[]{4, 91};
        this.updateRecord(tableLienJourCommass, lib, val, type, lib_, val_, type_);
    }

    public void prepareUpdateJour(int cleUser, int cleCond, String dateBDD) {
        String[] libj = new String[]{"MODIFICATION"};
        String[] valj = new String[]{"MODIFICATION+1"};
        int[] typej = new int[]{4};
        String[] lib_ = new String[]{"CLE_CHAUFFEUR", "DATE_JOUR", "SUPPRESSION"};
        String[] val_ = new String[]{String.valueOf(cleCond), dateBDD, "0"};
        int[] type_ = new int[]{4, 91, 4};
        this.updateRecord("t_jour", libj, valj, typej, lib_, val_, type_);
        String[] libjm = new String[]{"CURRENT_VALUE"};
        String[] valjm = new String[]{"0"};
        this.updateRecord(tableJourModifie, libjm, valjm, typej, lib_, val_, type_);
    }

    public java.util.Date getLastExport(int cleConducteur) {
        Date result = null;
        String sql = "";
        try {
            sql = "SELECT max(TIMESTAMP_EXPORT) as DERNIER_EXPORT FROM t_export WHERE CLE_CHAUFFEUR =" + cleConducteur + " GROUP BY CLE_CHAUFFEUR";
            Transport.ps.startOperation();
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            long duration = Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate last export paie");
            TimsLogger.debug("#BddTransport.getLastExport() => " + duration + " ms# sql = " + sql);
            while (rs.next()) {
                result = rs.getDate("DERNIER_EXPORT");
            }
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getLastExport()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public void updateExportHoroquartz(int cleConducteur, String date) {
        String sql = "";
        if (!this.isToUpdate(cleConducteur, date)) {
            try {
                sql = "INSERT INTO t_export_update (CLE_CHAUFFEUR, TIMESTAMP_EXPORT) VALUES (" + cleConducteur + ",'" + date + "')";
                Statement stm = this.getConnection().createStatement();
                stm.executeUpdate(sql);
                stm.close();
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                this.showTimeout();
            }
            catch (Exception ex) {
                TimsLogger.error("#updateExportHoroquartz()# " + ex.getMessage() + " - Erreur sql = " + sql);
            }
        }
    }

    public boolean isToUpdate(int cleConducteur, String date) {
        ResultSet rs;
        Statement stm;
        String sql;
        block4: {
            sql = "";
            sql = "SELECT CLE_CHAUFFEUR FROM t_export_update WHERE CLE_CHAUFFEUR =" + cleConducteur + " AND DATE_FORMAT(TIMESTAMP_EXPORT,\"%Y-%m-%d\") = '" + date + "'";
            stm = this.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            if (!rs.next()) break block4;
            return true;
        }
        try {
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#isToUpdate()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public boolean loadFile(String file, String sql) {
        boolean toReturn;
        block20: {
            toReturn = false;
            Statement stm = null;
            ResultSet rs = null;
            try {
                stm = this.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                this.showTimeout();
                try {
                    rs.close();
                    stm.close();
                }
                catch (Exception ex2) {
                    TimsLogger.error("#loadFile()# Erreur " + ex2.getMessage());
                }
                break block20;
            }
            catch (MysqlDataTruncation ex) {
                TimsLogger.error("#loadFile()#" + ex.getMessage() + " - erreur chargement fichier = " + sql);
                toReturn = true;
                break block20;
            }
            catch (Exception ex) {
                TimsLogger.error("#loadFile()# " + ex.getMessage() + " - Erreur sql = " + sql);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    rs.close();
                    stm.close();
                }
                catch (Exception ex3) {
                    TimsLogger.error("#loadFile()# Erreur " + ex3.getMessage());
                }
                break block20;
            }
            {
                finally {
                    try {
                        rs.close();
                        stm.close();
                    }
                    catch (Exception ex) {
                        TimsLogger.error("#loadFile()# Erreur " + ex.getMessage());
                    }
                }
            }
            try {
                rs.close();
                stm.close();
            }
            catch (Exception ex) {
                TimsLogger.error("#loadFile()# Erreur " + ex.getMessage());
            }
        }
        if (!toReturn) {
            File error = new File(file);
            File dest = new File(String.valueOf(file.substring(0, file.length() - 4)) + ConversionTime.dateToString(new java.util.Date(), "yyMMddHHmm") + ".txt");
            error.renameTo(dest);
            FileManager.moveTemporaryFile(dest);
            dest.delete();
        }
        return toReturn;
    }

    /*
     * Loose catch block
     */
    public boolean loadFile(String sql) {
        boolean toReturn = false;
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                stm = this.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                this.showTimeout();
                try {
                    rs.close();
                    stm.close();
                }
                catch (Exception ex2) {
                    TimsLogger.error("#loadFile()# Erreur " + ex2.getMessage());
                }
            }
            catch (MysqlDataTruncation ex) {
                TimsLogger.error("#loadFile()#" + ex.getMessage() + " - erreur chargement fichier = " + sql);
                toReturn = true;
                try {
                    rs.close();
                    stm.close();
                }
                catch (Exception ex3) {
                    TimsLogger.error("#loadFile()# Erreur " + ex3.getMessage());
                }
            }
            catch (Exception ex) {
                TimsLogger.error("#loadFile()# " + ex.getMessage() + " - Erreur sql = " + sql);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    rs.close();
                    stm.close();
                }
                catch (Exception ex4) {
                    TimsLogger.error("#loadFile()# Erreur " + ex4.getMessage());
                }
            }
        }
        finally {
            try {
                rs.close();
                stm.close();
            }
            catch (Exception ex) {
                TimsLogger.error("#loadFile()# Erreur " + ex.getMessage());
            }
        }
        return toReturn;
    }

    public boolean loadDriverService(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table t_service" + " (CLE_CHAUFFEUR, DATE_DEBUT, DATE_FIN, HEURE_DEBUT, HEURE_FIN, CONDUITE, TRAVAIL, " + "DISPO, REPOS, DOUBLE_EQUIPAGE, INCONNU, EVENEMENT, SERVICE, COUPURE, REPOS_JOURNALIER, " + "AMPLITUDE, HEURE_NUIT, NUIT_PENIBILITE, FRAIS, DISTANCE, FIRST_WORK, LAST_WORK, FIRST_WORK_AFTER_REST, " + "SECOND_WORK_AFTER_REST, ROUND_ID, THEORIC_SERVICE_POINT, CALCULATED_SERVICE_POINT)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadDriverExpenses(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table t_lien_jour_frais" + " (CLE_CHAUFFEUR, DATE_JOUR, CLE_FRAIS, MONTANT, ETRANGER, BASE, TAUX, FORFAIT, AUTOMATIC)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadDriverChangedActivity(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table t_activite_modifie" + " (CLE_CHAUFFEUR,CLE_TYPE_ACTIV,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE," + " ETAT_CARTE,SOURCE,ANNEE_ACTIVITE,ETAT_CONDUITE,LECTEUR,CLE_DISQUE,NOM_SOURCE)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadActivityDetail(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table activity_detail" + " (BEGIN, END, ACTIVITY_ID, DRIVER_ID, VEHICLE_ID, VEHICLE_REGISTRATION, AVG_KM)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadDay(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table " + "t_jour" + " (" + "CLE_CHAUFFEUR, DATE_JOUR, CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, AUTRE, EVENEMENT," + " DISTANCE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, CLE_USER, MANUAL_INPUT, SOURCE_NAME" + ", @HEX_ACTIVITIES) SET ACTIVITIES = UNHEX(@HEX_ACTIVITIES)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadDriverActivityConflictB(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table t_activite_conflit_base" + " (CLE_CHAUFFEUR, CLE_TYPE_ACTIV, HEURE_DEBUT, HEURE_FIN, DUREE_EN_MINUTE," + " ETAT_CARTE, SOURCE, NOM_SOURCE, ANNEE_ACTIVITE, ETAT_CONDUITE, LECTEUR)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadDriverActivityConflictA(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table t_activite_conflit_analyse" + " (CLE_CHAUFFEUR,CLE_TYPE_ACTIV,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE," + " ETAT_CARTE,SOURCE, NOM_SOURCE, ANNEE_ACTIVITE,ETAT_CONDUITE,LECTEUR)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadDriverOffense(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table " + "offence" + "(" + "DRIVER_ID, DAY, HOUR, OFFENCE_PART_ID, THRESHOLD, ON_UPDATED, TYPE, COST)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadDriverPlaces(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table " + "place" + " (DRIVER_ID, TYPE, DATE_CHANGE, COUNTRY, REGION, KM)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadSpecific(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table " + "SPECIFIC_CONDITION" + " (DRIVER_ID, SPECIFIC_TIMESTAMP, SPECIFIC_TYPE)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadGnss(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table " + "gnss_place" + " (DRIVER_ID, VEHICLE_ID, POINT_TIME, TYPE, ACCURACY, LONGITUDE, LATITUDE, HEADING, ODOMETER_VALUE)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadLoadUnload(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table " + "DRIVER_LOAD" + " (DRIVER_ID, DATE_LOAD, TYPE_LOAD)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadVehicleFileData(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table t_uev(CLE_VEHICULE,DATE_MIN,DATE_MAX)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadVehicleUsed(String filePath, String tableToInsert) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table " + tableToInsert + " (CLE_VEHICULE, CLE_CHAUFFEUR," + " PRENOM, NOM, NUMERO_CARTE, IMMATRICULATION, DATE_DEBUT, KM_DEBUT, DATE_FIN, KM_FIN, KM_EFFECTUE," + " MANUAL_INPUT, LECTEUR, SOURCE)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadVehicleActivity(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table t_activite_uev(JOUR_TELECHARGE," + "LECTEUR,ETAT_CONDUITE,ETAT_CARTE,TYPE_ACTIV,HEURE_DEBUT,HEURE_FIN,DUREE,CLE_VEHICULE)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadVehicleDay(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table " + "t_jour_uev" + " (" + "VEHICLE_ID, USER_ID, DATE_USE, KM, DAILY_KM, TOTAL, DAY_COMMENT" + ", @HEX_ACTIVITIES) SET ACTIVITIES = UNHEX(@HEX_ACTIVITIES)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadVehicleEventsFaults(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table UEV_EVENT_FAULT(VEHICLE_ID, TYPE_ID, PURPOSE_ID," + "BEGIN, END, DRIVER_CARD_BEGIN, CODRIVER_CARD_BEGIN, DRIVER_CARD_END, CODRIVER_CARD_END, SIMILAR)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadVehicleEvent(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table t_event_uev(CLE_VEHICULE,TYPE_EVENT," + "RAISON_EVENT,DATE_DEBUT,DATE_FIN,NUM_CARTE_COND_DEBUT,NUM_CARTE_CONV_DEBUT,NUM_CARTE_COND_FIN," + "NUM_CARTE_CONV_FIN,NBR_SIMILAIRE)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadVehicleSpeed(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table t_speed_uev(CLE_VEHICULE,TYPE_SPEED," + "RAISON_SPEED,DATE_DEBUT,DATE_FIN,SPEED_MAX,SPEED_MOY,NUM_CARTE_COND,NBR_SIMILAIRE)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadVehicleOffence(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table " + "UEV_OFFENCE" + " (VEHICLE_ID, DRIVER_ID, OFFENCE_TYPE_ID, BEGIN, END, THRESHOLD, LENGTH, GRAVITY)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadVehicleCalibration(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table t_etalonnage(CLE_VEHICULE,TYPE,NOM_MAGASIN," + "ADRESSE_MAGASIN,TYPE_CARTE,NUMERO_CARTE,EXPIRATION_CARTE,IDENTIFICATION_VEHICULE,CLE_PAYS,ENREGISTREMENT_VEHICULE," + "W_VEHICULE,K_VEHICULE,L_VEHICULE,TYRE_SIZE,AUTHORIZED_SPEED,ANCIEN_KM,NOUVEAU_KM,ANCIENNE_DATE,NOUVELLE_DATE," + "PROCHAIN_ETALONNAGE)";
        return this.loadFile(fichier, sql);
    }

    public boolean loadDriverComment(String filePath) throws IOException {
        if (!new File(filePath).exists()) {
            throw new IOException(String.valueOf(filePath) + " doesn't exist");
        }
        String fichier = BddTransport.addSlashes(filePath);
        String sql = "load data local infile '" + fichier + "' into table t_lien_jour_commass" + " FIELDS ENCLOSED BY '" + "\"" + "'" + "(CLE_CHAUFFEUR,DATE_JOUR,COMM_ASS)";
        return this.loadFile(fichier, sql);
    }

    public void saveStatementConducteurExecution(String sql, Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        try {
            PreparedStatement stm = this.getConnection().prepareStatement(sql);
            stm.setObject(1, (Object)conducteur.getCleConducteur(), 4);
            if (dateDebut != null) {
                stm.setDate(2, new Date(dateDebut.getTime()));
                stm.setDate(3, new Date(dateFin.getTime()));
            }
            ResultSet rs = stm.executeQuery();
            PrintWriter ecrivain = new PrintWriter(new BufferedWriter(new FileWriter(savePath)));
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnNumber = rsmd.getColumnCount();
            while (rs.next()) {
                String line = "";
                int x = 1;
                while (x <= columnNumber) {
                    line = String.valueOf(line) + rs.getString(x);
                    if (x != columnNumber) {
                        line = String.valueOf(line) + "\t";
                    }
                    ++x;
                }
                ecrivain.print(String.valueOf(line) + "\r\n");
                ecrivain.flush();
            }
            ecrivain.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.data.BddTransport.saveStatementConducteurExecution()  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
    }

    public void saveDriverInformation(Conducteur conducteur, String savePath) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\conducteur.txt");
        String sql = "";
        sql = "SELECT TAUX_HORAIRE, DATE_NAISSANCE, CLE_TYPE_PAYE, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, MATRICULE_CHAUFFEUR, NUM_CARTE_CHAUFFEUR, NUM_IMPORT_CHAUFFEUR, ADRESSE, CODE_POSTAL, VILLE, TEL1, TEL2, DATE_ENTREE_SOCIETE, DATE_DERNIERE_VISITE_MEDICALE, TYPE_CONDUCTEUR, NUM_SECURITE_SOCIALE, CLE_TYPE_CHAUFFEUR, CLE_CALENDRIER_INTERV, LOGO, DATE_DEBUT_VALIDITE_CARTE, DATE_EXPIRATION_CARTE, DATE_SORTIE,DATE_DERNIER_CHANGEMENT, IO_COUNTER,NUMERO, A, B, C, D, E, DATE_DELIVRANCE, DATE_VISITE FROM t_conducteur WHERE c.CLE_CHAUFFEUR = ?";
        this.saveStatementConducteurExecution(sql, conducteur, fichier, null, null);
    }

    public void saveDriverConflit(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\conflit.txt");
        String sql = "";
        sql = "SELECT DATE_CONFLIT,TRAITE,CLE_TRAITANT,KM_ANALYSE,KM_BASE FROM t_conflit WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_CONFLIT BETWEEN ? AND ?";
        }
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void saveDriverActivityConflitAnalyse(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\conflitAnalyse.txt");
        String sql = "";
        sql = "SELECT CLE_TYPE_ACTIV,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE, ETAT_CARTE,SOURCE,ANNEE_ACTIVITE,ETAT_CONDUITE,LECTEUR,CLE_DISQUE,NOM_SOURCE FROM t_activite_conflit_analyse WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND ANNEE_ACTIVITE BETWEEN ? AND ?";
        }
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void saveDriverActivityConflitBase(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\conflitBase.txt");
        String sql = "";
        sql = "SELECT CLE_TYPE_ACTIV,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE, ETAT_CARTE,SOURCE,ANNEE_ACTIVITE,ETAT_CONDUITE,LECTEUR,CLE_DISQUE,NOM_SOURCE FROM t_activite_conflit_base WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND ANNEE_ACTIVITE BETWEEN ? AND ?";
        }
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void saveDriverHistorisedActivity(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\activiteHistoris\u00e9e.txt");
        String sql = "";
        sql = "SELECT CLE_TYPE_ACTIV,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE, ETAT_CARTE,SOURCE,ANNEE_ACTIVITE,ETAT_CONDUITE,LECTEUR FROM t_historique_activite WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND ANNEE_ACTIVITE BETWEEN ? AND ?";
        }
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void saveDriverDay(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\jour.txt");
        String sql = "";
        sql = "SELECT DATE_JOUR,JOUR,CONDUITE,TRAVAIL,DISPO,REPOS,DOUBLE_EQUIP,AUTRE,EVENEMENT,DISTANCE,CUMUL_T_C_D_DE,CLE_AGENCE,HEURE_DEBUT,HEURE_FIN,HEURE_NUIT FROM t_jour WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_JOUR BETWEEN ? AND ?";
        }
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void saveDriverChangedDay(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\jourModifi\u00e9.txt");
        String sql = "";
        sql = "SELECT DATE_JOUR,JOUR,CONDUITE,TRAVAIL,DISPO,REPOS,DOUBLE_EQUIP,AUTRE,EVENEMENT,DISTANCE,CUMUL_T_C_D_DE,CLE_AGENCE,HEURE_DEBUT,HEURE_FIN,HEURE_NUIT FROM t_jour_modifie WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_JOUR BETWEEN ? AND ?";
        }
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void saveDriverDeletedDay(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\jourSupprime.txt");
        String sql = "";
        sql = "SELECT CLE_JOUR, DATE_SUPPRESSION, COMMENTAIRE, CLE_USER FROM t_suppression WHERE CLE_JOUR = (SELECT CLE_JOUR FROM t_jour WHERE CLE_CHAUFFEUR = ? AND SUPPRESSION=1";
        sql = dateDebut != null ? String.valueOf(sql) + " AND DATE_JOUR BETWEEN ? AND ?)" : String.valueOf(sql) + ")";
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void saveDriverService(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\service.txt");
        String sql = "";
        sql = "SELECT DATE_DEBUT, DATE_FIN, HEURE_DEBUT, HEURE_FIN, CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIPAGE, INCONNU, EVENEMENT, SERVICE, REPOS_JOURNALIER, AMPLITUDE, HEURE_NUIT, FRAIS, DISTANCE FROM t_service WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void saveDriverComment(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\commentaire.txt");
        String sql = "";
        sql = "SELECT DATE_JOUR,COMM_ASS FROM t_lien_jour_commass WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_JOUR BETWEEN ? AND ?";
        }
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void saveDriverUsed(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\priseVehicule.txt");
        String sql = "";
        sql = "SELECT CLE_VEHICULE, PRENOM, NOM, NUMERO_CARTE, IMMATRICULATION, DATE_DEBUT, KM_DEBUT, DATE_FIN, KM_FIN, SOURCE FROM driver_vehicle_used WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void saveDriverInfraction(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\infraction.txt");
        String sql = "";
        sql = "SELECT \"DATE\", HEURE_DEPASSEMENT, NUM_INFRACTIONS ,SEUIL_CONSTATE, BRUTE FROM t_infractions WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND \"DATE\" BETWEEN ? AND ?";
        }
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void saveDriverFrais(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\frais.txt");
        String sql = "";
        sql = "SELECT DATE_JOUR,CLE_FRAIS,MONTANT,ETRANGER FROM t_lien_jour_frais WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_JOUR BETWEEN ? AND ?";
        }
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void saveDriverCardDownload(Conducteur conducteur, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\telechargement.txt");
        String sql = "";
        sql = "SELECT DATE_TELECHARGEMENT, NOM_FICHIER FROM t_telechargement WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_TELECHARGEMENT BETWEEN ? AND ?";
        }
        this.saveStatementConducteurExecution(sql, conducteur, fichier, dateDebut, dateFin);
    }

    public void deleteStatementConducteurExecution(String sql, Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        try {
            PreparedStatement stm = this.getConnection().prepareStatement(sql);
            stm.setObject(1, (Object)conducteur.getCleConducteur(), 4);
            if (dateDebut != null) {
                stm.setDate(2, new Date(dateDebut.getTime()));
                stm.setDate(3, new Date(dateFin.getTime()));
            }
            stm.executeUpdate();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#deleteStatementConducteurExecution()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    public void delDriverConflit(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_conflit WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_CONFLIT BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverActivityConflitAnalyse(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_activite_conflit_analyse WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND ANNEE_ACTIVITE BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverActivityConflitBase(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_activite_conflit_base WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND ANNEE_ACTIVITE BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverHistorisedActivity(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_historique_activite WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND ANNEE_ACTIVITE BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverDay(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_jour WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_JOUR BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverChangedDay(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_jour_modifie WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_JOUR BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverDeletedDay(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_suppression WHERE CLE_JOUR IN (SELECT CLE FROM t_jour WHERE CLE_CHAUFFEUR = ? AND SUPPRESSION=1";
        sql = dateDebut != null ? String.valueOf(sql) + " AND DATE_JOUR BETWEEN ? AND ?)" : String.valueOf(sql) + ")";
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverService(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_service WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverComment(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_lien_jour_commass WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_JOUR BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverPlaces(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM place WHERE DRIVER_ID = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_CHANGE BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverUsed(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM driver_vehicle_used WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
        sql = "UPDATE vehicle_used SET CLE_CHAUFFEUR = 0 WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverInfraction(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_infractions WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND \"DATE\" BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverCardDownload(Conducteur conducteur, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_telechargement WHERE CLE_CHAUFFEUR = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_TELECHARGEMENT BETWEEN ? AND ?";
        }
        this.deleteStatementConducteurExecution(sql, conducteur, dateDebut, dateFin);
    }

    public void delDriverInformation(Conducteur conducteur) {
        String sql = "DELETE FROM t_conducteur WHERE CLE_CHAUFFEUR = ?";
        this.deleteStatementConducteurExecution(sql, conducteur, null, null);
    }

    public void saveStatementVehiculeExecution(String sql, Vehicule vehicule, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        try {
            PreparedStatement stm = this.getConnection().prepareStatement(sql);
            stm.setObject(1, (Object)vehicule.getCleVehicule(), 4);
            if (dateDebut != null) {
                stm.setDate(2, new Date(dateDebut.getTime()));
                stm.setDate(3, new Date(dateFin.getTime()));
            }
            ResultSet rs = stm.executeQuery();
            PrintWriter ecrivain = new PrintWriter(new BufferedWriter(new FileWriter(savePath)));
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnNumber = rsmd.getColumnCount();
            while (rs.next()) {
                String line = "";
                int x = 1;
                while (x <= columnNumber) {
                    line = String.valueOf(line) + rs.getString(x);
                    if (x != columnNumber) {
                        line = String.valueOf(line) + "\t";
                    }
                    ++x;
                }
                ecrivain.print(String.valueOf(line) + "\r\n");
                ecrivain.flush();
            }
            ecrivain.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#saveStatementVehiculeExecution()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    public void saveUEVInformation(Vehicule vehicule, String savePath) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\informationUEV.txt");
        String sql = "";
        sql = "SELECT * FROM t_uev WHERE CLE_VEHICULE = ?";
        this.saveStatementVehiculeExecution(sql, vehicule, fichier, null, null);
    }

    public void saveUEVActivity(Vehicule vehicule, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\activiteUEV.txt");
        String sql = "";
        sql = "SELECT JOUR_TELECHARGE,LECTEUR,ETAT_CONDUITE,ETAT_CARTE,TYPE_ACTIV,HEURE_DEBUT,HEURE_FIN,DUREE FROM t_activite_uev WHERE CLE_VEHICULE = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND JOUR_TELECHARGE BETWEEN ? AND ?";
        }
        this.saveStatementVehiculeExecution(sql, vehicule, fichier, dateDebut, dateFin);
    }

    public void saveUEVFaults(Vehicule vehicule, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\anomalieUEV.txt");
        String sql = "";
        sql = "SELECT TYPE_ANOMALIE, RAISON_ANOMALIE,DATE_DEBUT,DATE_FIN,NUM_CARTE_COND_DEBUT,NUM_CARTE_CONV_DEBUT, NUM_CARTE_COND_FIN, NUM_CARTE_CONV_FIN FROM t_anomalie_uev WHERE CLE_VEHICULE = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.saveStatementVehiculeExecution(sql, vehicule, fichier, dateDebut, dateFin);
    }

    public void saveUEVEvents(Vehicule vehicule, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\evenementUEV.txt");
        String sql = "";
        sql = "SELECT TYPE_EVENT, RAISON_EVENT, DATE_DEBUT, DATE_FIN, NUM_CARTE_COND_DEBUT,NUM_CARTE_CONV_DEBUT, NUM_CARTE_COND_FIN, NUM_CARTE_CONV_FIN, NBR_SIMILAIRE FROM t_event_uev WHERE CLE_VEHICULE = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.saveStatementVehiculeExecution(sql, vehicule, fichier, dateDebut, dateFin);
    }

    public void saveUEVUsed(Vehicule vehicule, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\utilisationUEV.txt");
        String sql = "";
        sql = "SELECT CLE_CHAUFFEUR, PRENOM, NOM, NUMERO_CARTE, IMMATRICULATION, DATE_DEBUT, KM_DEBUT, DATE_FIN, KM_FIN, MANUAL_INPUT, LECTEUR FROM vehicle_used WHERE CLE_VEHICULE = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.saveStatementVehiculeExecution(sql, vehicule, fichier, dateDebut, dateFin);
    }

    public void saveUEVSpeed(Vehicule vehicule, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\speedUEV.txt");
        String sql = "";
        sql = "SELECT TYPE_SPEED, RAISON_SPEED, DATE_DEBUT, DATE_FIN, SPEED_MAX,SPEED_MOY, NUM_CARTE_COND, NBR_SIMILAIRE FROM t_speed_uev WHERE CLE_VEHICULE = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.saveStatementVehiculeExecution(sql, vehicule, fichier, dateDebut, dateFin);
    }

    public void saveUEVTechnic(Vehicule vehicule, String savePath, java.util.Date dateDebut, java.util.Date dateFin) {
        String fichier = BddTransport.addSlashes(String.valueOf(savePath) + "\\techniqueUEV.txt");
        String sql = "";
        sql = "SELECT TYPE, NOM_MAGASIN, ADRESSE_MAGASIN, TYPE_CARTE, NUMERO_CARTE, EXPIRATION_CARTE, IDENTIFICATION_VEHICULE, CLE_PAYS, ENREGISTREMENT_VEHICULE,W_VEHICULE, K_VEHICULE, L_VEHICULE, TYRE_SIZE, AUTHORIZED_SPEED, ANCIEN_KM, NOUVEAU_KM,ANCIENNE_DATE, NOUVELLE_DATE, PROCHAIN_ETALONNAGE FROM t_etalonnage WHERE CLE_VEHICULE = ?";
        this.saveStatementVehiculeExecution(sql, vehicule, fichier, null, null);
    }

    public void deleteStatementVehiculeExecution(String sql, Vehicule vehicule, java.util.Date dateDebut, java.util.Date dateFin) {
        try {
            PreparedStatement stm = this.getConnection().prepareStatement(sql);
            stm.setObject(1, (Object)vehicule.getCleVehicule(), 4);
            if (dateDebut != null) {
                stm.setDate(2, new Date(dateDebut.getTime()));
                if (dateFin != null) {
                    stm.setDate(3, new Date(dateFin.getTime()));
                }
            }
            stm.executeUpdate();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#deleteStatementVehiculeExecution()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    public void delUEVInformation(Vehicule vehicule) {
        String sql = "DELETE FROM t_uev WHERE CLE_VEHICULE = ?";
        this.deleteStatementVehiculeExecution(sql, vehicule, null, null);
    }

    public void delUEVActivity(Vehicule vehicule, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_activite_uev WHERE CLE_VEHICULE = ?";
        if (dateDebut != null) {
            sql = dateFin != null ? String.valueOf(sql) + " AND JOUR_TELECHARGE BETWEEN ? AND ?" : String.valueOf(sql) + " AND JOUR_TELECHARGE = ?";
        }
        this.deleteStatementVehiculeExecution(sql, vehicule, dateDebut, dateFin);
    }

    public void delUEVActivityAndDay(Vehicule vehicule, String dates) {
        String sql = "DELETE FROM t_activite_uev WHERE CLE_VEHICULE = " + vehicule.getCleVehicule() + " AND JOUR_TELECHARGE IN(" + dates + ")";
        this.executeCmd(sql);
        sql = "DELETE FROM t_jour_uev WHERE VEHICLE_ID = " + vehicule.getCleVehicule() + " AND DATE_USE IN(" + dates + ")";
        this.executeCmd(sql);
    }

    public void delUEVFaults(Vehicule vehicule, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_anomalie_uev WHERE CLE_VEHICULE = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.deleteStatementVehiculeExecution(sql, vehicule, dateDebut, dateFin);
    }

    public void delUEVEvents(Vehicule vehicule, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_event_uev WHERE CLE_VEHICULE = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.deleteStatementVehiculeExecution(sql, vehicule, dateDebut, dateFin);
    }

    public void delUEVUsed(Vehicule vehicule, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM vehicle_used WHERE CLE_VEHICULE = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.deleteStatementVehiculeExecution(sql, vehicule, dateDebut, dateFin);
        sql = "UPDATE driver_vehicle_used SET CLE_VEHICULE = 0 WHERE CLE_VEHICULE = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.deleteStatementVehiculeExecution(sql, vehicule, dateDebut, dateFin);
    }

    public void delUEVSpeed(Vehicule vehicule, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_speed_uev WHERE CLE_VEHICULE = ?";
        if (dateDebut != null) {
            sql = String.valueOf(sql) + " AND DATE_DEBUT BETWEEN ? AND ?";
        }
        this.deleteStatementVehiculeExecution(sql, vehicule, dateDebut, dateFin);
    }

    public void delUEVTechnic(Vehicule vehicule, java.util.Date dateDebut, java.util.Date dateFin) {
        String sql = "DELETE FROM t_etalonnage WHERE CLE_VEHICULE = ?";
        this.deleteStatementVehiculeExecution(sql, vehicule, dateDebut, dateFin);
    }

    public void updateDateDernierChangement(int cleConducteur, String dateChangement, String dateTelechargement) {
        String[] lib = new String[]{"DATE_DERNIER_CHANGEMENT", "DATE_DERNIER_TELECHARGEMENT"};
        String[] val = new String[]{dateChangement, dateTelechargement};
        int[] type = new int[]{93, 93};
        String[] lib_ = new String[]{"CLE_CHAUFFEUR"};
        String[] val_ = new String[]{String.valueOf(cleConducteur)};
        int[] type_ = new int[]{4};
        this.updateRecord(tableConducteur, lib, val, type, lib_, val_, type_);
    }

    public void addTournee(String b1, String b2, String b3, String b4, String b5, String b6, String b7, String b8, String b9, String b10, String b11, String b12, String b13, String b14, String b15, String b16, String b17, String b18, String b19) {
        String[] lib = new String[]{"CLE_T_TOURNEE", "DESIGNATION_TOURNEE", "LIEU_DEPART", "LIEU_ARRIVEE", "HEURE_DEPART", "HEURE_ARRIVEE", "DUREE_CONDUITE", "DUREE_TRAVAIL", "DUREE_DISPO", "DUREE_REPOS", "DUREE_TOTALE", "DISTANCE", "NB_DESSERTES", "DESSERTES_H", "KM_DESSERTES", "TPS_MOY_DESSERTES", "FRAIS", "REMARQUES", "HEURE_DEBUT_COUPURE", "HEURE_FIN_COUPURE"};
        String[] val = new String[]{"GEN_T_TOURNEE.nextval", b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13, b14, b15, b16, b17, b18, b19};
        int[] type = new int[]{1111, 12, 12, 12, 12, 12, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 12, 4, 4};
        this.addRecord(tableTournee, lib, val, type);
    }

    public void updateTournee(String CLE_TOURNEE, String b2, String b3, String b4, String b5, String b6, String b7, String b8, String b9, String b10, String b11, String b12, String b13, String b14, String b15, String b16, String b17, String b18, String b19) {
        String[] lib = new String[]{"LIEU_DEPART", "LIEU_ARRIVEE", "HEURE_DEPART", "HEURE_ARRIVEE", "DUREE_CONDUITE", "DUREE_TRAVAIL", "DUREE_DISPO", "DUREE_REPOS", "DUREE_TOTALE", "DISTANCE", "NB_DESSERTES", "DESSERTES_H", "KM_DESSERTES", "TPS_MOY_DESSERTES", "FRAIS", "REMARQUES", "HEURE_DEBUT_COUPURE", "HEURE_FIN_COUPURE"};
        String[] val = new String[]{b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13, b14, b15, b16, b17, b18, b19};
        int[] type = new int[]{12, 12, 12, 12, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 12, 12, 12};
        String[] lib_ = new String[]{"CLE_TOURNEE"};
        String[] val_ = new String[]{CLE_TOURNEE};
        int[] type_ = new int[]{4};
        this.updateRecord(tableTournee, lib, val, type, lib_, val_, type_);
    }

    public void updateSeuil(String cleRegle, int seuil) {
        String[] lib = new String[]{"SEUIL"};
        String[] val = new String[]{String.valueOf(seuil)};
        int[] type = new int[]{4};
        String[] lib_ = new String[]{"CLE"};
        String[] val_ = new String[]{cleRegle};
        int[] type_ = new int[]{4};
        this.updateRecord(tableTblInfraction, lib, val, type, lib_, val_, type_);
    }

    public String getCommentJour(int cleConducteur, String date) {
        String sql = "";
        String result = "";
        try {
            sql = "SELECT COMM_ASS FROM t_lien_jour_commass WHERE CLE_CHAUFFEUR=" + cleConducteur + " AND DATE_JOUR=" + BddTransport.getDateStringToSGBDR(date, false);
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getCommentJour()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Comment> getComment(int cleConducteur, String date) {
        String sql = "";
        Vector<Comment> result = new Vector<Comment>();
        try {
            sql = "SELECT CLE_LIEN_JOUR_COMMASS, COMM_ASS, CLE_CHAUFFEUR, DATE_JOUR FROM t_lien_jour_commass";
            String res = "";
            if (cleConducteur != -1) {
                res = String.valueOf(res) + " AND CLE_CHAUFFEUR = " + cleConducteur;
            }
            if (date != null) {
                res = String.valueOf(res) + " AND DATE_JOUR = " + BddTransport.getDateStringToSGBDR(date, false);
            }
            if (!res.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Comment(rs.getInt("CLE_LIEN_JOUR_COMMASS"), rs.getInt("CLE_CHAUFFEUR"), rs.getString("DATE_JOUR"), rs.getString("COMM_ASS"), false));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getComment()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getCommentCount(int cleConducteur, String date, String comment) {
        String sql = "";
        int result = 0;
        try {
            sql = "SELECT count(*) as nb FROM t_lien_jour_commass";
            String res = "";
            if (cleConducteur != -1) {
                res = String.valueOf(res) + " AND CLE_CHAUFFEUR = " + cleConducteur;
            }
            if (date != null) {
                res = String.valueOf(res) + " AND DATE_JOUR BETWEEN \"" + BddTransport.getDateStringToSGBDR(ConversionTime.addDay(date, "yyyy-MM-dd", -30), false) + "\"" + " AND \"" + BddTransport.getDateStringToSGBDR(date, false) + "\"";
            }
            if (!(res = String.valueOf(res) + " AND COMM_ASS = '" + BddTransport.addSlashes(comment) + "'").equals("")) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getInt("nb");
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getCommentCount()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public void addTelechargementUEV(int cleVehicule, int cleUser, String date, String nomFichier) {
        if (!this.telechargementExiste(nomFichier)) {
            String[] lib = new String[]{"CLE_TELECHARGEMENT", "CLE_VEHICULE", "CLE_USER", "DATE_TELECHARGEMENT", "NOM_FICHIER"};
            String[] val = new String[]{"GEN_T_TELECHARGEMENT_UEV.nextval", String.valueOf(cleVehicule), String.valueOf(cleUser), date, nomFichier};
            int[] type = new int[]{1111, 4, 4, 93, 12};
            this.addRecord(tableTelechargementUEV, lib, val, type);
        }
    }

    public boolean telechargementExiste(String nomFichier) {
        String sql = "";
        boolean result = false;
        try {
            sql = "SELECT count(*) FROM t_telechargement WHERE NOM_FICHIER = '" + nomFichier + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                if (rs.getInt(1) < 1) continue;
                result = true;
            }
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#telechargementExiste()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<TailleAgence> getTailleAgence() {
        String sql = "";
        Vector<TailleAgence> result = new Vector<TailleAgence>();
        try {
            sql = "SELECT t_taille_agence.CLE_TAILLE_AGENCE, t_taille_agence.DESIGNATION_TAILLE FROM t_taille_agence ORDER BY t_taille_agence.DESIGNATION_TAILLE";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new TailleAgence(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getTailleAgence()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public void delService(int cleConducteur, String dateDebut, String dateFin) {
        String sql = "";
        try {
            sql = "DELETE FROM t_service WHERE CLE_CHAUFFEUR=" + cleConducteur;
            if (dateDebut != null) {
                sql = String.valueOf(sql) + " AND DATE_DEBUT=" + BddTransport.getDateStringToSGBDR(dateDebut, true);
            }
            if (dateFin != null) {
                sql = String.valueOf(sql) + " AND DATE_FIN=" + BddTransport.getDateStringToSGBDR(dateFin, true);
            }
            Statement stm = this.getConnection().createStatement();
            stm.executeUpdate(sql);
            stm.close();
            this.fireDBChanged(new BddEvent(tableService, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#delService()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    public void delPeriodeService(int cleConducteur, String dateDebut, String dateFin) {
        String sql = "";
        try {
            sql = "DELETE FROM t_service WHERE CLE_CHAUFFEUR=" + cleConducteur + " AND DATE_DEBUT < " + BddTransport.getDateStringToSGBDR(dateFin, true) + " AND DATE_FIN > " + BddTransport.getDateStringToSGBDR(dateDebut, true);
            Statement stm = this.getConnection().createStatement();
            stm.executeUpdate(sql);
            this.fireDBChanged(new BddEvent(tableService, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#delPeriodeService()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    public void delPeriodeJour(int cleConducteur, String dateDebut, String dateFin) {
        String sql = "";
        try {
            sql = "DELETE FROM t_jour WHERE CLE_CHAUFFEUR=" + cleConducteur + " AND DATE_JOUR < " + BddTransport.getDateStringToSGBDR(dateFin, true) + " AND DATE_JOUR > " + BddTransport.getDateStringToSGBDR(dateDebut, true);
            Statement stm = this.getConnection().createStatement();
            stm.executeUpdate(sql);
            this.fireDBChanged(new BddEvent("t_jour", Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#delPeriodeJour()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    public void delPeriodeJourModifie(int cleConducteur, String dateDebut, String dateFin) {
        String sql = "";
        try {
            sql = "DELETE FROM t_jour_modifie WHERE CLE_CHAUFFEUR=" + cleConducteur + " AND DATE_JOUR < " + BddTransport.getDateStringToSGBDR(dateFin, true) + " AND DATE_JOUR > " + BddTransport.getDateStringToSGBDR(dateDebut, true);
            Statement stm = this.getConnection().createStatement();
            stm.executeUpdate(sql);
            this.fireDBChanged(new BddEvent(tableJourModifie, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#delPeriodeJourModifie()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    public void delVehicule(int cleVehicule) {
        String[] lib = new String[]{"CLE_VEHICULE"};
        String[] val = new String[]{String.valueOf(cleVehicule)};
        int[] type = new int[]{4};
        this.delRecord(tableVehicule, lib, val, type);
    }

    public void delProfil(int cleProfil) {
        String[] lib = new String[]{"CLE_PROFIL"};
        String[] val = new String[]{String.valueOf(cleProfil)};
        int[] type = new int[]{4};
        this.delRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableProfil, lib, val, type);
        this.delRecord(String.valueOf(BddTransport.getBaseDefault(true)) + tableDroit, lib, val, type);
    }

    public void delActiviteConflit(int cleConflit, int cleConducteur, String dateBDD) {
        String[] libAct = new String[]{"SUPPRESSION", "CLE_JOUR"};
        String[] valAct = new String[]{"1", String.valueOf(cleConflit)};
        int[] typeAct = new int[]{4, 4};
        String[] libActivite = new String[]{"CLE_CHAUFFEUR", "ANNEE_ACTIVITE", "SUPPRESSION"};
        String[] valActivite = new String[]{String.valueOf(cleConducteur), dateBDD, "0"};
        int[] typeActivite = new int[]{4, 91, 4};
        this.updateRecord(tableConflitAnalyse, libAct, valAct, typeAct, libActivite, valActivite, typeActivite);
        this.updateRecord(tableConflitBase, libAct, valAct, typeAct, libActivite, valActivite, typeActivite);
    }

    public void delJour(int cleConducteur, String dateBDD, String raison) {
        String cleUser = String.valueOf(ConnexionSettings.getInstance().getUserCle());
        String cleJour = this.getJourCle(cleConducteur, dateBDD);
        String[] libSuppression = new String[]{"CLE_SUPPRESSION", "CLE_JOUR", "DATE_SUPPRESSION", "COMMENTAIRE", "CLE_USER"};
        String[] valSuppression = new String[]{"GEN_T_SUPPRESSION.nextval", cleJour, ConversionTime.dateToString(new java.util.Date(), "yyyy-MM-dd"), raison, cleUser};
        int[] typeSuppression = new int[]{1111, 4, 91, 12, 4};
        this.addRecord(tableSuppression, libSuppression, valSuppression, typeSuppression);
        String[] lib = new String[]{"SUPPRESSION"};
        String[] val = new String[]{"1"};
        int[] type = new int[]{4};
        String[] libJour = new String[]{"CLE_CHAUFFEUR", "DATE_JOUR"};
        String[] valJour = new String[]{String.valueOf(cleConducteur), dateBDD};
        int[] typeJour = new int[]{4, 91};
        this.updateRecord("t_jour", lib, val, type, libJour, valJour, typeJour);
        String[] libm = new String[]{"SUPPRESSION", "CURRENT_VALUE"};
        String[] valm = new String[]{"1", "0"};
        int[] typem = new int[]{4, 4};
        this.updateRecord(tableJourModifie, libm, valm, typem, libJour, valJour, typeJour);
        String[] libComm = new String[]{"CLE_CHAUFFEUR", "DATE_JOUR"};
        String[] valActivite = new String[]{String.valueOf(cleConducteur), dateBDD, "0"};
        int[] typeActivite = new int[]{4, 91, 4};
        this.delRecord("t_lien_jour_frais", libComm, valActivite, typeActivite);
        this.delRecord(tableLienJourCommass, libComm, valActivite, typeActivite);
    }

    public void delJour(int cleConducteur, String dateBDD) {
        String[] value = new String[]{String.valueOf(cleConducteur), dateBDD};
        int[] type = new int[]{4, 91};
        String[] libJour = new String[]{"CLE_CHAUFFEUR", "DATE_JOUR"};
        this.delRecord("t_jour", libJour, value, type);
        this.delRecord(tableJourModifie, libJour, value, type);
        DriverExpenses.deleteExpenses(cleConducteur, dateBDD, null, 0);
        this.delRecord(tableLienJourCommass, libJour, value, type);
    }

    public void restaureJour(String cleJour) {
        String[] lib = new String[]{"SUPPRESSION"};
        String[] val = new String[]{"0"};
        int[] type = new int[]{4};
        String[] libJour = new String[]{"CLE"};
        String[] valJour = new String[]{cleJour};
        int[] typeJour = new int[]{4};
        this.updateRecord("t_jour", lib, val, type, libJour, valJour, typeJour);
    }

    public void delTourneeJ(String cleTournee) {
        String[] lib = new String[]{"CLE_LIEN_JOUR_TOURNEE"};
        String[] val = new String[]{cleTournee};
        int[] type = new int[]{4};
        this.delRecord(tableLienJourTournee, lib, val, type);
    }

    public void delComment(int cleConducteur, String dateJour) {
        String[] lib = new String[]{"CLE_CHAUFFEUR", "DATE_JOUR"};
        String[] val = new String[]{String.valueOf(cleConducteur), dateJour};
        int[] type = new int[]{4, 91};
        this.delRecord(tableLienJourCommass, lib, val, type);
    }

    private void delRecord(String table, String[] lib, String[] val, int[] type) {
        String sql = "";
        try {
            String vals = "";
            int i = 0;
            while (i < lib.length) {
                vals = String.valueOf(vals) + " AND " + lib[i] + "=" + this.getString(val[i], type[i]);
                ++i;
            }
            sql = "DELETE FROM " + table + " WHERE " + vals.substring(5);
            Statement stm = this.getConnection().createStatement();
            stm.executeUpdate(sql);
            stm.close();
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 1, new java.util.Date(), sql).insert();
            this.fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#delRecord()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    public boolean isActiviteExiste(int cleConducteur, String date) {
        ResultSet rs;
        Statement stm;
        String sql;
        block4: {
            sql = "";
            sql = "SELECT CLE_CHAUFFEUR FROM t_jour WHERE CLE_CHAUFFEUR =" + cleConducteur + " AND DATE_JOUR= " + BddTransport.getDateStringToSGBDR(date, false) + " AND SUPPRESSION=0";
            stm = this.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            if (!rs.next()) break block4;
            return true;
        }
        try {
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#isActiviteExiste()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return false;
    }

    public boolean isTelecharge(int cle_vehic, String date_min, String date_max) {
        ResultSet rs;
        Statement stm;
        String sql;
        block4: {
            sql = "";
            sql = "SELECT CLE_UEV FROM t_uev WHERE CLE_VEHICULE =" + cle_vehic + " AND DATE_MIN= " + BddTransport.getDateStringToSGBDR(date_min, true) + " AND DATE_MAX= " + BddTransport.getDateStringToSGBDR(date_max, true);
            stm = this.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            if (!rs.next()) break block4;
            return true;
        }
        try {
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#isTelecharge()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return false;
    }

    public Vector<Jour> getJour(int cleConducteur, String dateDebut, String dateFin, boolean brut, boolean supprime, boolean semainePleine) throws DayException {
        String sql = "";
        Vector<Jour> result = new Vector<Jour>();
        try {
            String res = "";
            if (dateDebut != null) {
                res = dateFin != null && !dateFin.equals("") ? String.valueOf(res) + " AND jour.DATE_JOUR BETWEEN " + BddTransport.getDateStringToSGBDR(dateDebut, false) + " AND " + BddTransport.getDateStringToSGBDR(dateFin, false) : String.valueOf(res) + " AND jour.DATE_JOUR =" + BddTransport.getDateStringToSGBDR(dateDebut, false);
            }
            if (cleConducteur != 0) {
                res = String.valueOf(res) + " AND jour.CLE_CHAUFFEUR = " + cleConducteur;
            }
            res = String.valueOf(res) + " AND SUPPRESSION=" + (supprime ? "1" : "0");
            sql = "SELECT jour.CLE," + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "jour") + ", CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT," + " AUTRE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION,COMM_ASS, CLE_USER, ACTIVITIES, MANUAL_INPUT, SOURCE_NAME" + " FROM " + "t_jour" + " jour" + " LEFT JOIN " + tableLienJourCommass + " comm on jour.date_jour=comm.date_jour and jour.cle_chauffeur=comm.cle_chauffeur";
            if (res.length() != 0) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            if (!brut) {
                sql = String.valueOf(sql) + " AND MODIFICATION = 0 UNION ALL SELECT jour.CLE, " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "jour") + ", CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT," + " AUTRE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION,COMM_ASS, CLE_USER, ACTIVITIES, MANUAL_INPUT, SOURCE_NAME" + " FROM " + tableJourModifie + " jour" + " LEFT JOIN " + tableLienJourCommass + " comm on jour.date_jour=comm.date_jour and jour.cle_chauffeur=comm.cle_chauffeur" + " WHERE CURRENT_VALUE = 1";
                if (res.length() != 0) {
                    sql = String.valueOf(sql) + res;
                }
            }
            sql = String.valueOf(sql) + " ORDER BY DATE_JOUR";
            Transport.ps.startOperation();
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate jour", "#BddTransport.getJour() => %s# sql = " + sql, 1);
            GregorianCalendar cal = new GregorianCalendar();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            cal.setTime(dateFormat.parse(dateDebut));
            boolean set = false;
            Transport.ps.startOperation();
            while (rs.next()) {
                if (!set && semainePleine) {
                    cal.setTime(dateFormat.parse(ConversionTime.getFirstDayOfPreviousWeek(dateFormat.parse(rs.getString("DATE_JOUR").substring(0, 10)), dateFormat, 1)));
                    set = true;
                }
                while (!rs.getString("DATE_JOUR").substring(0, 10).equals(dateFormat.format(cal.getTime()))) {
                    if (dateFormat.parse(rs.getString("DATE_JOUR").substring(0, 10)).before(cal.getTime())) {
                        TimsLogger.warn("getJour() " + rs.getString("DATE_JOUR") + " before " + cal.getTime());
                        throw new DayException();
                    }
                    result.add(new Jour(0, cleConducteur, dateFormat.format(cal.getTime()), 0, 0, 0, 1440, 0, 0, 0, 0, 0, 0, 0, 0, 0, false, null, null, 0, null, false));
                    cal.add(5, 1);
                }
                Jour toAdd = new Jour(rs.getInt("CLE"), cleConducteur, rs.getString("DATE_JOUR").substring(0, 10), rs.getInt("CONDUITE"), rs.getInt("TRAVAIL"), rs.getInt("DISPO"), rs.getInt("REPOS"), rs.getInt("DOUBLE_EQUIP"), rs.getInt("AUTRE"), rs.getInt("EVENEMENT"), rs.getInt("CUMUL_T_C_D_DE"), rs.getInt("HEURE_DEBUT"), rs.getInt("HEURE_FIN"), rs.getInt("HEURE_NUIT"), rs.getInt("DISTANCE"), rs.getInt("MODIFICATION"), rs.getBoolean("SUPPRESSION"), null, rs.getString("COMM_ASS"), rs.getInt("CLE_USER"), rs.getString("SOURCE_NAME"), rs.getInt("MANUAL_INPUT") == 1);
                Blob blobActivities = rs.getBlob("ACTIVITIES");
                if (blobActivities == null) {
                    TimsLogger.error("#BddTransprot.getDay# No condensed activities on " + toAdd.getDate());
                } else {
                    toAdd.setActivity(ActiviteConducteur.fromCondensed(blobActivities.getBytes(1L, (int)blobActivities.length()), toAdd));
                }
                result.add(toAdd);
                cal.add(5, 1);
            }
            if (dateFin != null) {
                while (!cal.getTime().after(dateFormat.parse(dateFin))) {
                    result.add(new Jour(0, cleConducteur, dateFormat.format(cal.getTime()), 0, 0, 0, 1440, 0, 0, 0, 0, 0, 0, 0, 0, 0, false, null, null, 0, null, false));
                    cal.add(5, 1);
                }
            }
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Tri des donn\u00e9es requ\u00eate jour");
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (DayException ex) {
            throw ex;
        }
        catch (Exception ex) {
            TimsLogger.error("#getJour()# " + ex.getMessage() + " Erreur sql = " + sql);
            ex.printStackTrace();
        }
        return result;
    }

    public Vector<Jour> getJourArchive(int cleConducteur, String dateDebut, String dateFin, boolean brute) {
        String sql = "";
        Vector<Jour> result = new Vector<Jour>();
        try {
            String res = "";
            if (dateDebut != null) {
                res = dateFin != null && !dateFin.equals("") ? String.valueOf(res) + " AND jour.DATE_JOUR BETWEEN " + BddTransport.getDateStringToSGBDR(dateDebut, false) + " AND " + BddTransport.getDateStringToSGBDR(dateFin, false) : String.valueOf(res) + " AND jour.DATE_JOUR =" + BddTransport.getDateStringToSGBDR(dateDebut, false);
            }
            if (cleConducteur != 0) {
                res = String.valueOf(res) + " AND jour.CLE_CHAUFFEUR = " + cleConducteur;
            }
            String table = tableJourModifie;
            if (brute) {
                table = "t_jour";
            }
            sql = "SELECT jour.CLE," + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "jour") + ", CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT," + " AUTRE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION,COMM_ASS, CLE_USER, MANUAL_INPUT, SOURCE_NAME" + " FROM " + table + " jour" + " LEFT JOIN " + tableLienJourCommass + " comm on jour.date_jour=comm.date_jour and jour.cle_chauffeur=comm.cle_chauffeur";
            if (res.length() != 0) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY DATE_JOUR";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Jour(rs.getInt("CLE"), cleConducteur, rs.getString("DATE_JOUR").substring(0, 10), rs.getInt("CONDUITE"), rs.getInt("TRAVAIL"), rs.getInt("DISPO"), rs.getInt("REPOS"), rs.getInt("DOUBLE_EQUIP"), rs.getInt("AUTRE"), rs.getInt("EVENEMENT"), rs.getInt("CUMUL_T_C_D_DE"), rs.getInt("HEURE_DEBUT"), rs.getInt("HEURE_FIN"), rs.getInt("HEURE_NUIT"), rs.getInt("DISTANCE"), rs.getInt("MODIFICATION"), rs.getBoolean("SUPPRESSION"), null, rs.getString("COMM_ASS"), rs.getInt("CLE_USER"), rs.getString("SOURCE_NAME"), rs.getInt("MANUAL_INPUT") == 1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getJourArchive()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<VehicleUsed>[] getPriseVehiculeSemaine(int cleConducteur, java.util.Date dateJour) {
        result = new Vector[7];
        i = 0;
        while (i < 7) {
            result[i] = new Vector<E>();
            ++i;
        }
        calendrier = new GregorianCalendar();
        dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        calendrier.setTime(dateJour);
        dateBDDDebut = dateFormat.format(calendrier.getTime());
        calendrier.add(5, 6);
        dateBDDFin = dateFormat.format(calendrier.getTime());
        tmp = VehicleUsed.loadListDriver(cleConducteur, 0, dateBDDDebut, dateBDDFin);
        if (tmp.size() == 0) {
            return result;
        }
        calendrier.setTime(dateJour);
        dateBDD = dateFormat.format(calendrier.getTime());
        y = 0;
        x = 0;
        ** GOTO lbl29
        {
            result[x].add(tmp.get(y));
            ++y;
            do {
                if (y < tmp.size() && ConversionTime.dateToStringDb(tmp.get(y).getDateDebut()).startsWith(dateBDD)) continue block1;
                calendrier.add(5, 1);
                dateBDD = dateFormat.format(calendrier.getTime());
                ++x;
lbl29:
                // 2 sources

            } while (x < 7);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<Place>[] getPlaceSemaine(int cleConducteur, java.util.Date dateJour) {
        result = new Vector[7];
        i = 0;
        while (i < 7) {
            result[i] = new Vector<E>();
            ++i;
        }
        calendrier = new GregorianCalendar();
        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        calendrier.setTime(dateJour);
        dateBDDDebut = dateFormat.format(calendrier.getTime());
        calendrier.add(5, 7);
        dateBDDFin = dateFormat.format(calendrier.getTime());
        tmp = Place.load(cleConducteur, dateBDDDebut, dateBDDFin);
        if (tmp.size() == 0) {
            return result;
        }
        calendrier.setTime(dateJour);
        calendrier.add(5, 1);
        y = 0;
        x = 0;
        ** GOTO lbl28
        {
            result[x].add(tmp.get(y));
            ++y;
            do {
                if (y < tmp.size() && tmp.get(y).getDateTime().before(calendrier.getTime())) continue block1;
                calendrier.add(5, 1);
                ++x;
lbl28:
                // 2 sources

            } while (x < 7);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<SpecificCondition>[] getSpecificConditionSemaine(int cleConducteur, java.util.Date dateJour) {
        result = new Vector[7];
        i = 0;
        while (i < 7) {
            result[i] = new Vector<E>();
            ++i;
        }
        calendrier = new GregorianCalendar();
        calendrier.setTime(dateJour);
        calendrier.add(5, 7);
        tmp = SpecificCondition.loadList(cleConducteur, dateJour, calendrier.getTime());
        if (tmp.size() == 0) {
            return result;
        }
        calendrier.setTime(dateJour);
        calendrier.add(5, 1);
        y = 0;
        x = 0;
        ** GOTO lbl25
        {
            result[x].add(tmp.get(y));
            ++y;
            do {
                if (y < tmp.size() && tmp.get(y).getSpecificTimestamp().before(calendrier.getTime())) continue block1;
                calendrier.add(5, 1);
                ++x;
lbl25:
                // 2 sources

            } while (x < 7);
        }
        return result;
    }

    public int isJourConflit(String jour, int cleAgence, int cleCond) {
        int retour = 0;
        String sql = "";
        try {
            sql = "SELECT TRAITE FROM t_conflit JOIN t_conducteur ON t_conflit.CLE_CHAUFFEUR=t_conducteur.CLE_CHAUFFEUR WHERE DATE_CONFLIT=" + BddTransport.getDateStringToSGBDR(jour, false);
            if (cleAgence != 0) {
                sql = String.valueOf(sql) + " AND t_conducteur.CLE_AGENCE=" + cleAgence;
            }
            if (cleCond != 0) {
                sql = String.valueOf(sql) + " AND t_conducteur.CLE_CHAUFFEUR=" + cleCond;
            }
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                retour = 2;
                if (rs.getInt(1) != 0) continue;
                retour = 1;
                break;
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#isJourConflit()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return retour;
    }

    public boolean isBaseExiste(String nomBase) {
        boolean existe = false;
        String sql = "";
        try {
            sql = "SELECT CLE_SOCIETE FROM " + BddTransport.getBaseDefault(true) + tableSociete + " WHERE BASE_NAME='" + nomBase + "'";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            if (rs.next()) {
                existe = true;
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#isBaseExiste()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return existe;
    }

    public Vector<ActiviteConducteur> getActivDetailConflit(int cleConducteur, java.util.Date dateJour, String table, boolean traite) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String sql = "";
        Vector<ActiviteConducteur> result = new Vector<ActiviteConducteur>();
        try {
            sql = "SELECT CLE_ACTIVITE,  CLE_CHAUFFEUR,  CLE_JOUR, " + table + ".CLE_TYPE_ACTIV, " + BddTransport.getDateSGBDRToString("ANNEE_ACTIVITE", false, "") + ", " + " HEURE_DEBUT," + " HEURE_FIN," + " DUREE_EN_MINUTE," + " ETAT_CARTE," + " SOURCE," + " NOM_SOURCE," + " CLE_DISQUE," + tableTypeActivite + ".DESIGNATION, " + " COULEUR," + " ETAT_CONDUITE," + " LECTEUR" + " FROM " + table + "," + tableTypeActivite + " WHERE " + table + ".CLE_CHAUFFEUR =" + cleConducteur;
            if (dateJour != null) {
                sql = String.valueOf(sql) + " AND " + table + ".ANNEE_ACTIVITE=" + BddTransport.getDateStringToSGBDR(dateFormat.format(dateJour), false);
            }
            sql = String.valueOf(sql) + " AND " + table + ".CLE_TYPE_ACTIV=" + tableTypeActivite + ".ID" + " AND " + table + ".SUPPRESSION=" + (traite ? "1" : "0") + " ORDER BY HEURE_DEBUT,HEURE_FIN";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new ActiviteConducteur(rs.getInt("CLE_ACTIVITE"), rs.getInt("CLE_CHAUFFEUR"), rs.getInt("CLE_JOUR"), rs.getInt("CLE_TYPE_ACTIV"), rs.getString("DESIGNATION"), rs.getString("COULEUR"), rs.getInt("HEURE_DEBUT"), rs.getInt("HEURE_FIN"), rs.getInt("DUREE_EN_MINUTE"), rs.getString("ANNEE_ACTIVITE").substring(0, 10), rs.getString("SOURCE"), rs.getString("NOM_SOURCE"), rs.getString("ETAT_CARTE"), rs.getString("ETAT_CONDUITE"), rs.getString("LECTEUR"), rs.getInt("CLE_DISQUE"), 0, 0));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getActivDetailConflit()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public void addConflit(String dateBDD, int cleChauffeur, int kmBase, int kmAnalyse, int cleUser) {
        String[] lib = new String[]{"CLE_CONFLIT", "CLE_CHAUFFEUR", "DATE_CONFLIT", "KM_BASE", "KM_ANALYSE", "CLE_USER"};
        String[] val = new String[]{"GEN_T_CONFLIT.nextval", String.valueOf(cleChauffeur), dateBDD, String.valueOf(kmBase), String.valueOf(kmAnalyse), String.valueOf(cleUser)};
        int[] type = new int[]{1111, 4, 91, 12, 12, 4};
        this.addRecord(tableConflit, lib, val, type);
    }

    private boolean addRecord(String table, String[] lib, String[] val, int[] type) {
        boolean retour;
        block9: {
            retour = false;
            Statement stm = null;
            String sql = "";
            try {
                String libs = "";
                String vals = "";
                int start = 1;
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    start = 0;
                }
                while (start < lib.length) {
                    libs = String.valueOf(libs) + ", " + lib[start];
                    vals = String.valueOf(vals) + ", " + this.getString(val[start], type[start]);
                    ++start;
                }
                sql = "INSERT INTO " + table + " ( " + libs.substring(2) + " ) VALUES ( " + vals.substring(2) + " ) ";
                stm = this.getConnection().createStatement();
                stm.executeUpdate(sql);
                this.fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                this.showTimeout();
                this.closeStatement(stm);
                break block9;
            }
            catch (Exception ex) {
                try {
                    TimsLogger.error("#addRecord()# " + ex.getMessage() + " - Erreur sql = " + sql);
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.closeStatement(stm);
                }
            }
            this.closeStatement(stm);
        }
        return retour;
    }

    public void updateKm(int km, String date, int cleConducteur, int modification, String table) {
        String[] lib = new String[]{"DISTANCE"};
        String[] val = new String[]{String.valueOf(km)};
        int[] type = new int[]{4};
        String[] lib_ = new String[]{"DATE_JOUR", "CLE_CHAUFFEUR", "SUPPRESSION", "MODIFICATION"};
        String[] val_ = new String[]{date, String.valueOf(cleConducteur), "0", String.valueOf(modification)};
        int[] type_ = new int[]{91, 4, 4, 4};
        this.updateRecord(table, lib, val, type, lib_, val_, type_);
    }

    private void updateRecord(String table, String[] lib, String[] val, int[] type, String[] lib_, String[] val_, int[] type_) {
        String sql = "";
        try {
            String libs = "";
            String cond = "";
            int i = 0;
            while (i < lib.length) {
                libs = String.valueOf(libs) + ", " + lib[i] + "= " + this.getString(val[i], type[i]);
                ++i;
            }
            i = 0;
            while (i < lib_.length) {
                cond = String.valueOf(cond) + "AND " + lib_[i] + " = " + this.getString(val_[i], type_[i]) + " ";
                ++i;
            }
            sql = "UPDATE " + table + " SET" + libs.substring(1) + " WHERE" + cond.substring(3);
            Statement stm = this.getConnection().createStatement();
            stm.executeUpdate(sql);
            stm.close();
            this.fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#updateRecord()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    public Connection getConnection() {
        if (this.connection == null) {
            TimsLogger.debug("BddTransport.getConnection() : create new connection");
            this.lastConnectionTime = System.currentTimeMillis();
            this.connection = this.loadConnection(null, null);
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                this.setCaseInsensitive(this.connection);
            }
        }
        if (System.currentTimeMillis() - this.lastConnectionTime > 600000L) {
            TimsLogger.info("BddTransport.getConnection() : 10 minutes passed, renew connexion");
            try {
                this.connection.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.loadConnection(null, null);
            String version = this.getDBVersion();
            if (!version.equals(Transport.res.getResourceString("databaseVersion"))) {
                TimsLogger.warn("Nous ne sommes plus sur une version " + Transport.res.getResourceString("databaseVersion") + " mais sur une version " + version);
                if (Transport.apiMode == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("connexion.master.error"), LanguageTranslator.getString("connexion.error"), 0);
                            System.exit(0);
                        }
                    });
                }
            }
        }
        this.lastConnectionTime = System.currentTimeMillis();
        return this.connection;
    }

    public void reloadConnection(String user, String pwd) {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.connection = null;
        this.loadConnection(user, pwd);
    }

    private Connection loadConnection(String user, String pwd) {
        while (this.loadingConnexion) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.loadingConnexion = true;
        TimsLogger.debug("#BddTransport.getConnection()# on entre dans loadConnection");
        try {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                TimsLogger.info("load oracle");
                Class.forName("oracle.jdbc.OracleDriver");
            } else {
                Class.forName("com.mysql.jdbc.Driver").newInstance();
            }
        }
        catch (Exception e) {
            TimsLogger.error(" Establish driver error  : " + e);
            return null;
        }
        try {
            String port;
            String URL2 = "";
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                URL2 = String.valueOf(URL2) + "jdbc:oracle:thin:@";
                String string = port = System.getProperty("PORT") == null ? "1521" : System.getProperty("PORT");
                if (System.getProperty("URL") != null || System.getProperty("BASE") != null) {
                    URL2 = String.valueOf(URL2) + (System.getProperty("BASE") == null ? System.getProperty("URL") : System.getProperty("BASE"));
                    URL2 = String.valueOf(URL2) + ":" + port;
                    URL2 = String.valueOf(URL2) + ":" + (System.getProperty("INSTANCE") != null ? System.getProperty("INSTANCE") : "TIMS");
                } else {
                    URL2 = String.valueOf(URL2) + "localhost:" + port + ":" + (System.getProperty("INSTANCE") != null ? System.getProperty("INSTANCE") : "TIMS");
                }
            } else {
                URL2 = String.valueOf(URL2) + "jdbc:mysql://";
                String string = port = System.getProperty("PORT") == null ? "3309" : System.getProperty("PORT");
                if (System.getProperty("URL") != null || System.getProperty("BASE") != null) {
                    URL2 = String.valueOf(URL2) + (System.getProperty("BASE") == null ? System.getProperty("URL") : System.getProperty("BASE"));
                    URL2 = String.valueOf(URL2) + ":" + port;
                } else {
                    URL2 = String.valueOf(URL2) + "localhost:" + port;
                }
                URL2 = String.valueOf(URL2) + "/" + (this.societeCourante != null ? this.societeCourante.getNomBase() : BddTransport.getBaseDefault(false)) + "?autoReconnect=true&zeroDateTimeBehavior=convertToNull&useSSL=false";
            }
            ProgressBarIndetermine pb = null;
            if (Transport.apiMode == 0) {
                pb = new ProgressBarIndetermine(null, "Connexion \u00e0 la base de donn\u00e9es");
                pb.setVisible(true);
            }
            TimsLogger.debug("#BddTransport.loadConection# url de connexion = " + URL2);
            if (user == null) {
                user = res.getResourceString("user");
                pwd = res.getResourceString("pass");
                if (System.getProperty("USER") != null) {
                    user = System.getProperty("USER");
                }
                if (System.getProperty("PASSWORD") != null) {
                    pwd = System.getProperty("PASSWORD");
                }
                if (this.societeCourante != null && System.getProperty("URL") != null && Transport.apiMode == 0) {
                    String baseUser = this.societeCourante.getNomBase().length() > 12 ? this.societeCourante.getNomBase().substring(0, 12).toLowerCase() : this.societeCourante.getNomBase().toLowerCase();
                    user = String.valueOf(baseUser) + "_utl";
                    pwd = Fonctions.decryptPassword(this.societeCourante.getUserDBPwd(), Fonctions.getDecryptKey());
                }
            } else {
                TimsLogger.debug("#BddTransport.loadConnection# Force connection with " + user);
            }
            this.connection = DriverManager.getConnection(URL2, user, pwd);
            if (pb != null) {
                pb.dispose();
            }
            if (this.connection == null) {
                JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("connexion.database.error"), LanguageTranslator.getString("connexion.error"), 2);
                System.exit(0);
            }
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("connexion.database.error"), LanguageTranslator.getString("connexion.error"), 2);
            TimsLogger.error("unable to connect with " + user);
            ex.printStackTrace();
            System.exit(0);
        }
        this.loadingConnexion = false;
        return this.connection;
    }

    private String getDBVersion() {
        String sql = "";
        String toReturn = "";
        try {
            sql = "SELECT eval FROM " + BddTransport.getBaseDefault(true) + "configuration" + " WHERE value = 'database_version'";
            Statement stm = this.connection.createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                toReturn = rs.getString("eval");
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getVersion()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return toReturn;
    }

    public void setCaseInsensitive(Connection connection) {
        String sql = "";
        try {
            sql = "ALTER session SET nls_sort=binary_ci";
            Statement stm = connection.createStatement();
            stm.executeUpdate(sql);
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#setCaseInsensitive()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    public Vector<Integer> getSeuilConduiteContinue() {
        Vector<Integer> result = new Vector<Integer>();
        String sql = "";
        try {
            sql = "SELECT SEUIL FROM t_tbl_infractions WHERE TYPE_REGLE=1";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getSeuilConduiteContinue()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Integer> getSeuilConduiteContinueVoyageur() {
        Vector<Integer> result = new Vector<Integer>();
        String sql = "";
        try {
            sql = "SELECT SEUIL FROM t_tbl_infractions WHERE TYPE_REGLE=1";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getSeuilConduiteContinueVoyageur()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Integer> getSeuilConduiteJournaliere() {
        Vector<Integer> result = new Vector<Integer>();
        String sql = "";
        try {
            sql = "SELECT SEUIL FROM t_tbl_infractions WHERE TYPE_REGLE=2";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getSeuilConduiteJournaliere()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Integer> getSeuilTEJournalier() {
        Vector<Integer> result = new Vector<Integer>();
        String sql = "";
        try {
            sql = "SELECT SEUIL FROM t_tbl_infractions WHERE TYPE_REGLE=9";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getSeuilTEJournalier()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Integer> getSeuilTEContinu() {
        Vector<Integer> result = new Vector<Integer>();
        String sql = "";
        try {
            sql = "SELECT SEUIL FROM t_tbl_infractions WHERE TYPE_REGLE=13";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getSeuilTEContinu()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Integer> getSeuilMinCard() {
        Vector<Integer> result = new Vector<Integer>();
        String sql = "";
        try {
            sql = "SELECT SEUIL FROM t_tbl_infractions WHERE TYPE_REGLE=13";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getSeuilTEContinu()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Integer> getSeuilTEHebdomadaire() {
        Vector<Integer> result = new Vector<Integer>();
        String sql = "";
        try {
            sql = "SELECT SEUIL FROM t_tbl_infractions WHERE TYPE_REGLE=8";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getSeuilTEHebdomadaire()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Integer> getSeuilConduiteHebdomadaire() {
        Vector<Integer> result = new Vector<Integer>();
        String sql = "";
        try {
            sql = "SELECT SEUIL FROM t_tbl_infractions WHERE TYPE_REGLE=3";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getSeuilConduiteHebdomadaire()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Integer> getSeuilReposJournalier() {
        Vector<Integer> result = new Vector<Integer>();
        String sql = "";
        try {
            sql = "SELECT SEUIL FROM t_tbl_infractions WHERE TYPE_REGLE IN (4,6)";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getSeuilReposJournalier()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Integer> getSeuilReposJournalierDE() {
        Vector<Integer> result = new Vector<Integer>();
        String sql = "";
        try {
            sql = "SELECT SEUIL FROM t_tbl_infractions WHERE TYPE_REGLE = 5";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getSeuilReposJournalierDE()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<Integer> getSeuilReposHebdomadaire() {
        Vector<Integer> result = new Vector<Integer>();
        String sql = "";
        try {
            sql = "SELECT SEUIL FROM t_tbl_infractions WHERE TYPE_REGLE = 7";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getSeuilReposHebdomadaire()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getMax(String table, String id) {
        int result = 0;
        String sql = "";
        try {
            sql = "SELECT max(" + id + ") FROM " + table;
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#BddTransport.getMax()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getCount(String table, String id) {
        int result = 0;
        String sql = "";
        try {
            sql = "SELECT count(" + id + ") FROM " + table;
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#BddTransport.getCount()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public boolean executeCmd(String cmd) {
        boolean toReturn = false;
        TimsLogger.debug("execute " + cmd);
        Statement stm = null;
        try {
            try {
                stm = this.getConnection().createStatement();
                stm.executeUpdate(cmd);
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                this.showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("Data truncated for column") || ex.getMessage().contains("Can't DROP") && ex.getMessage().contains("check that column/key exists") || ex.getMessage().contains("DUPLICATE COLUMN")) {
                    TimsLogger.warn("exception non pertinente " + cmd);
                    toReturn = true;
                } else {
                    TimsLogger.error(cmd);
                }
                TimsLogger.error("#executeCmd()# " + ex.getMessage());
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean queryAndPrint(String cmd) {
        boolean toReturn = false;
        int fieldsCount = cmd.split(",").length;
        TimsLogger.debug("queryAndPrint# " + cmd + " (" + fieldsCount + " colonnes)");
        int totalLine = 0;
        Statement stm = null;
        try {
            try {
                stm = this.getConnection().createStatement();
                ResultSet rs = stm.executeQuery(cmd);
                while (rs.next()) {
                    String toShow = "";
                    int x = 1;
                    while (x <= fieldsCount) {
                        toShow = String.valueOf(toShow) + rs.getObject(x) + ",";
                        ++x;
                    }
                    TimsLogger.debug(toShow);
                    ++totalLine;
                }
                TimsLogger.debug(String.valueOf(totalLine) + " lines");
                rs.close();
                stm.close();
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                this.showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (Exception ex) {
                TimsLogger.error("#queryAndPrint# " + ex.getMessage());
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public String getTableDetails(String table, String catalog) {
        String line = "";
        try {
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                DatabaseMetaData dmd = this.getConnection().getMetaData();
                this.getConnection().setCatalog(this.societeCourante.getNomBase());
                ResultSet resultat = dmd.getColumns(catalog != null ? catalog : this.getConnection().getCatalog(), null, table, "%");
                if (resultat.next()) {
                    line = String.valueOf(line) + table + ";";
                    do {
                        Object val = resultat.getObject(4);
                        line = String.valueOf(line) + val + ";";
                    } while (resultat.next());
                }
            }
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                try {
                    String sql = "select COLUMN_NAME from ALL_TAB_COLUMNS where TABLE_NAME = '" + table.toUpperCase() + "'";
                    Statement stm = this.getConnection().createStatement();
                    ResultSet rs = stm.executeQuery(sql);
                    if (rs.next()) {
                        line = String.valueOf(line) + table + ";";
                        do {
                            line = String.valueOf(line) + rs.getString(1) + ";";
                        } while (rs.next());
                    }
                    rs.close();
                    stm.close();
                }
                catch (CommunicationsException ex) {
                    ex.printStackTrace();
                    this.showTimeout();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return line;
    }

    public Vector<String> getTableListe() {
        Vector<String> list = new Vector<String>();
        try {
            TimsLogger.debug(this.societeCourante.getNomBase());
            DatabaseMetaData metaData = this.getConnection().getMetaData();
            ResultSet resultSetTable = metaData.getTables(this.societeCourante.getNomBase(), null, null, null);
            while (resultSetTable.next()) {
                String tableName = resultSetTable.getString("TABLE_NAME");
                list.add(tableName);
            }
            resultSetTable.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public Vector<String> getTimsTableListe() {
        Vector<String> list = new Vector<String>();
        try {
            TimsLogger.debug(this.societeCourante.getNomBase());
            DatabaseMetaData metaData = this.getConnection().getMetaData();
            ResultSet resultSetTable = metaData.getTables(BddTransport.getBaseDefault(false), null, null, null);
            while (resultSetTable.next()) {
                String tableName = resultSetTable.getString("TABLE_NAME");
                list.add(tableName);
            }
            resultSetTable.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public static String addRestriction(String tableAgence, String tableCond) {
        String sql = "";
        if (conn.isUserRestreintAgence() && !conn.getUserSociete().equals("0") && tableAgence != null && tableAgence != "") {
            String agenceRestreinte = "";
            int i = 0;
            while (i < conn.getUserCleA().size()) {
                agenceRestreinte = String.valueOf(agenceRestreinte) + "," + conn.getUserCleA().get(i);
                ++i;
            }
            sql = String.valueOf(sql) + tableAgence + ".CLE_AGENCE IN (" + agenceRestreinte.substring(1) + ("1".equals(System.getProperty("show_unknown", "0")) ? ",0" : "") + ")";
        }
        if (conn.isUserRestreintConducteur() && conn.getUserCleC() != 0 && tableCond != null && tableCond != "") {
            if (sql != "") {
                sql = String.valueOf(sql) + " AND ";
            }
            sql = String.valueOf(sql) + tableCond + ".CLE_CHAUFFEUR='" + conn.getUserCleC() + "'";
        }
        return sql;
    }

    public static String addNewRestriction(String tableAgence, boolean newAgencyIdString, String tableCond, boolean newDriverIdString) {
        String driverString = "CLE_CHAUFFEUR";
        if (newDriverIdString) {
            driverString = "DRIVER_ID";
        }
        String agenceString = "CLE_AGENCE";
        if (newAgencyIdString) {
            agenceString = "AGENCY_ID";
        }
        String sql = "";
        if (conn.isUserRestreintAgence() && !conn.getUserSociete().equals("0") && tableAgence != null && tableAgence != "") {
            String agenceRestreinte = "";
            int i = 0;
            while (i < conn.getUserCleA().size()) {
                agenceRestreinte = String.valueOf(agenceRestreinte) + "," + conn.getUserCleA().get(i);
                ++i;
            }
            sql = String.valueOf(sql) + tableAgence + "." + agenceString + " IN (" + agenceRestreinte.substring(1) + ")";
        }
        if (conn.isUserRestreintConducteur() && conn.getUserCleC() != 0 && tableCond != null && tableCond != "") {
            if (sql != "") {
                sql = String.valueOf(sql) + " AND ";
            }
            sql = String.valueOf(sql) + tableCond + "." + driverString + " ='" + conn.getUserCleC() + "'";
        }
        return sql;
    }

    public void changeDB(Societe toChange, boolean refresh) {
        if (this.societeCourante != null && this.societeCourante.getCleSociete() == toChange.getCleSociete()) {
            TimsLogger.debug("#BddTransport.changeDB# Le syst\u00e8me est d\u00e9j\u00e0 sur cette soci\u00e9t\u00e9");
            return;
        }
        TimsLogger.info("#BddTransport.changeDB# Changement de soci\u00e9t\u00e9 " + (toChange == null ? "null" : toChange.getNomSociete()) + (refresh ? "(refresh on)" : "(refresh off)"));
        String sql = "";
        try {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                TimsLogger.info("#BddTransport.changeDB# oracle, on ne change pas ! ");
            } else {
                this.societeCourante = toChange;
                if (System.getProperty("URL") != null && Transport.apiMode == 0) {
                    this.reloadConnection(null, null);
                }
                if (this.societeCourante == null) {
                    TimsLogger.warn("#BddTransport.changeDB# on veut changer pour se mettre sur la base TIMS ??");
                    return;
                }
                sql = "USE " + this.societeCourante.getNomBase();
                Statement stm = this.getConnection().createStatement();
                stm.executeUpdate(sql);
                stm.close();
            }
            TimsLogger.debug("#BddTransport.changeDB# r\u00e9initialisation des listes et chargement configuration de la base");
            Region.setList(null);
            Agence.setList(null);
            JourType.setList(null);
            TypeContrat.setList(null);
            ExpensesType.setList(null);
            TypeActivite.setList(null);
            PayPeriod.setList(null);
            Conducteur.setList(null);
            OffenceType.setList(null);
            OffencePart.setList(null);
            OffenceThreshold.setList(null);
            EmployeeObligationType.setList(null);
            Garage.setList(null);
            RoundType.setList(null);
            InterventionType.setList(null);
            Vehicule.setList(null);
            System.gc();
            Configuration.loadList(this.societeCourante.getNomBase(), true);
            if (refresh) {
                this.fireDBChanged(new BddEvent(tableSociete, Constants.ACTION_TYPE.UPDATE));
            }
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#changeDB()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    public void changeDB(String nomSociete, boolean refresh) {
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            TimsLogger.info("#BddTransport.changeDB# oracle, on ne change pas ! ");
        } else {
            this.changeDB(Societe.loadList(nomSociete).get(0), refresh);
        }
    }

    public Societe getCompany() {
        if (this.societeCourante == null) {
            Vector<Societe> companies = Societe.loadList(null);
            if (companies.size() != 0) {
                this.societeCourante = companies.get(0);
            } else {
                TimsLogger.warn("#BddTransport.getCompany# Pas de soci\u00e9t\u00e9 disponible, on cr\u00e9e une soci\u00e9t\u00e9 factice");
                this.societeCourante = new Societe(res.getResourceString("nomSociete"), System.getProperty("INSTANCE") != null ? System.getProperty("INSTANCE") : "tims");
            }
        }
        return this.societeCourante;
    }

    public boolean creeDB(String nomBase) {
        boolean toReturn = false;
        String sql = "";
        try {
            sql = "CREATE DATABASE " + nomBase;
            Statement stm = this.getConnection().createStatement();
            stm.executeUpdate(sql);
            sql = "USE " + nomBase;
            stm.executeUpdate(sql);
            stm.close();
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#creeDB()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return toReturn;
    }

    public void supprimeDB(String db) {
        String sql = "";
        try {
            sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + tableSociete + " WHERE NOM_BASE='" + db + "'";
            Statement stm = this.getConnection().createStatement();
            stm.executeUpdate(sql);
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#supprimeDB()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }

    private String getString(String val, int type) {
        if (type == 91) {
            return BddTransport.getDateStringToSGBDR(val, false);
        }
        if (type == 93) {
            return BddTransport.getDateStringToSGBDR(val, true);
        }
        if (type == 12) {
            return "'" + BddTransport.addSlashes(val) + "'";
        }
        if (type == 1111) {
            return val;
        }
        if (type == 16) {
            return val == "true" ? "1" : "0";
        }
        if (val.equals("")) {
            return "0";
        }
        return val;
    }

    public static String getDateStringToSGBDR(String date, boolean withHeure) {
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            return "'" + (withHeure ? date : date.substring(0, 10)) + "'";
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            String format = "yyyy-mm-dd";
            if (withHeure) {
                return "TO_TIMESTAMP('" + (date.length() == 10 ? String.valueOf(date) + " 00:00:00" : date.substring(0, 19)) + "','" + format + " hh24:mi:ss')";
            }
            return "TO_DATE('" + date.substring(0, 10) + "','" + format + "')";
        }
        return date;
    }

    public static String getDateTruncation(String date) {
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            return "DATE(" + date + ")";
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            return "TRUNC(" + date + ")";
        }
        return date;
    }

    public static String addDayToDate(String date, int nbJour) {
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            return "ADDDATE(" + date + ", INTERVAL " + nbJour + " DAY) ";
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            return String.valueOf(date) + "+" + nbJour;
        }
        return "";
    }

    public static String getDateSGBDRToString(String nomColonne, boolean withHeure, String table) {
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            if (table == null || table.equals("")) {
                return nomColonne;
            }
            return String.valueOf(table) + "." + nomColonne;
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            String format = "yyyy-mm-dd";
            if (withHeure) {
                format = String.valueOf(format) + " hh24:mi:ss";
            }
            if (table == null || table.equals("")) {
                return "to_char(" + nomColonne + ",'" + format + "') as " + nomColonne;
            }
            return "to_char(" + table + "." + nomColonne + ",'" + format + "') as " + nomColonne;
        }
        return nomColonne;
    }

    public static String getCurrentDate() {
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            return "curdate()";
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            return "sysdate";
        }
        return "curdate()";
    }

    public static String getDateDiff(String op1, String op2) {
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            return "DATEDIFF(" + op1 + "," + op2 + ")";
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            return "trunc(to_number(substr((" + op1 + "-" + op2 + "),1,instr(" + op1 + "-" + op2 + ",' '))))";
        }
        return "SGBDR NOT SUPPORTED";
    }

    public static String getNBJour(String jour) {
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            return jour;
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            return jour;
        }
        return "SGBDR NOT SUPPORTED";
    }

    public static String getBaseDefault(boolean point) {
        String defaultDb = "tims";
        if (System.getProperty("INSTANCE") != null) {
            defaultDb = System.getProperty("INSTANCE");
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            return "";
        }
        return String.valueOf(defaultDb) + (point ? "." : "");
    }

    public static String getChampDate() {
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            return "DATE";
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            return "\"DATE\"";
        }
        return "DATE";
    }

    public static String getYearField() {
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            return "YEAR";
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            return "\"YEAR\"";
        }
        return "YEAR";
    }

    public boolean tryToexecute(String sql) {
        boolean success = true;
        Statement stm = null;
        try {
            try {
                stm = this.getConnection().createStatement();
                stm.executeQuery(sql);
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                this.showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (Exception ex) {
                TimsLogger.error("#tryToexecute()# " + ex.getMessage() + " - Erreur sql = " + sql);
                success = false;
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return success;
    }

    public Vector<String[]> getOtherActivity() {
        Vector<String[]> result = new Vector<String[]>();
        String sql = "";
        try {
            sql = "SELECT DISTINCT CLE_CHAUFFEUR, ANNEE_ACTIVITE FROM T_ACTIVITE WHERE MODIFICATION = 0 AND CLE_TYPE_ACTIV IN (6,9) UNION SELECT DISTINCT CLE_CHAUFFEUR, ANNEE_ACTIVITE FROM T_ACTIVITE_MODIFIE WHERE CLE_TYPE_ACTIV IN (6,9) ORDER BY CLE_CHAUFFEUR, ANNEE_ACTIVITE";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                String[] a = new String[]{rs.getString("CLE_CHAUFFEUR"), rs.getString("annee_activite")};
                result.add(a);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getOtherActivity()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public Vector<String[]> getNoMidnightAct() {
        Vector<String[]> result = new Vector<String[]>();
        String sql = "";
        try {
            sql = "select nb, cle_chauffeur, annee_activite from (select count(cle_chauffeur) as nb, cle_chauffeur, annee_activite from (SELECT DISTINCT annee_activite, cle_chauffeur from t_activite where annee_activite > \"2008-05-01\" and suppression = 0 union all SELECT DISTINCT date_jour as annee_activite, cle_chauffeur from t_jour where date_jour > \"2008-05-01\" and suppression = 0) T group by cle_chauffeur, annee_activite) U where nb=1";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                String[] a = new String[]{rs.getString("CLE_CHAUFFEUR"), rs.getString("annee_activite"), "0"};
                result.add(a);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getNoMidnightAct()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
        return result;
    }

    public int getActiveConnections() {
        int result = 0;
        String sql = "";
        try {
            sql = "show processlist";
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                ++result;
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
            return -1;
        }
        catch (Exception ex) {
            TimsLogger.error("#getActiveConnections()# " + ex.getMessage() + " - Erreur sql = " + sql);
            return -1;
        }
        return result;
    }

    public Vector<Jour> getJourNew(int driverId, java.util.Date begin, java.util.Date end, int onlyBrut, boolean onlyDeleted) {
        return this.getJourNew(driverId, ConversionTime.dateToString(begin, "yyyy-MM-dd"), ConversionTime.dateToString(end, "yyyy-MM-dd"), onlyBrut, onlyDeleted);
    }

    public Vector<Jour> getJourByInsertion(int driverId, String begin, int onlyBrut, boolean onlyDeleted) {
        String sql = "";
        Vector<Jour> result = new Vector<Jour>();
        try {
            String res = "";
            if (begin != null) {
                res = String.valueOf(res) + " AND jour.DATE_INSERTION > " + BddTransport.getDateStringToSGBDR(begin, false);
            }
            if (driverId != 0) {
                res = String.valueOf(res) + " AND jour.CLE_CHAUFFEUR = " + driverId;
            }
            res = String.valueOf(res) + " AND SUPPRESSION=" + (onlyDeleted ? "1" : "0");
            if (onlyBrut == 2) {
                res = String.valueOf(res) + " AND MODIFICATION > 0";
            }
            sql = "SELECT jour.CLE,jour.CLE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "jour") + ", CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT," + " AUTRE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION, CLE_USER, ACTIVITIES, MANUAL_INPUT, SOURCE_NAME" + " FROM " + "t_jour" + " jour " + (res.length() != 0 ? "WHERE " + res.substring(5) : "");
            if (onlyBrut == 1) {
                sql = String.valueOf(sql) + " AND MODIFICATION = 0 UNION ALL SELECT jour.CLE, jour.CLE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "jour") + ", CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT," + " AUTRE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION, CLE_USER, ACTIVITIES, MANUAL_INPUT, SOURCE_NAME" + " FROM " + tableJourModifie + " jour" + " WHERE CURRENT_VALUE = 1" + (res.length() != 0 ? " AND " + res.substring(5) : "");
            }
            sql = String.valueOf(sql) + " ORDER BY CLE_CHAUFFEUR, DATE_JOUR";
            TimsLogger.debug(sql);
            Statement stm = this.connection.createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Jour toAdd = new Jour(rs.getInt("CLE"), rs.getInt("CLE_CHAUFFEUR"), rs.getString("DATE_JOUR").substring(0, 10), rs.getInt("CONDUITE"), rs.getInt("TRAVAIL"), rs.getInt("DISPO"), rs.getInt("REPOS"), rs.getInt("DOUBLE_EQUIP"), rs.getInt("AUTRE"), rs.getInt("EVENEMENT"), rs.getInt("CUMUL_T_C_D_DE"), rs.getInt("HEURE_DEBUT"), rs.getInt("HEURE_FIN"), rs.getInt("HEURE_NUIT"), rs.getInt("DISTANCE"), rs.getInt("MODIFICATION"), rs.getBoolean("SUPPRESSION"), null, "", rs.getInt("CLE_USER"), rs.getString("SOURCE_NAME"), rs.getInt("MANUAL_INPUT") == 1);
                Blob act = rs.getBlob("ACTIVITIES");
                if (act != null) {
                    toAdd.setActivity(ActiviteConducteur.fromCondensed(act.getBytes(1L, (int)act.length()), toAdd));
                }
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getJour()# " + ex.getMessage() + " - sql = " + sql);
        }
        return result;
    }

    public Vector<Jour> getJourNew(int driverId, String begin, String end, int onlyBrut, boolean onlyDeleted) {
        String sql = "";
        Vector<Jour> result = new Vector<Jour>();
        try {
            String res = "";
            if (begin != null) {
                res = end != null && !end.equals("") ? String.valueOf(res) + " AND jour.DATE_JOUR BETWEEN " + BddTransport.getDateStringToSGBDR(begin, false) + " AND " + BddTransport.getDateStringToSGBDR(end, false) : String.valueOf(res) + " AND jour.DATE_JOUR =" + BddTransport.getDateStringToSGBDR(begin, false);
            }
            if (driverId != 0) {
                res = String.valueOf(res) + " AND jour.CLE_CHAUFFEUR = " + driverId;
            }
            res = String.valueOf(res) + " AND SUPPRESSION=" + (onlyDeleted ? "1" : "0");
            if (onlyBrut == 2) {
                res = String.valueOf(res) + " AND MODIFICATION > 0";
            }
            sql = "SELECT jour.CLE,jour.CLE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "jour") + ", CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT," + " AUTRE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION, CLE_USER, ACTIVITIES, MANUAL_INPUT, SOURCE_NAME" + " FROM " + "t_jour" + " jour " + (res.length() != 0 ? "WHERE " + res.substring(5) : "");
            if (onlyBrut == 1) {
                sql = String.valueOf(sql) + " AND MODIFICATION = 0 UNION ALL SELECT jour.CLE, jour.CLE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "jour") + ", CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT," + " AUTRE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION, CLE_USER, ACTIVITIES, MANUAL_INPUT, SOURCE_NAME" + " FROM " + tableJourModifie + " jour" + " WHERE CURRENT_VALUE = 1" + (res.length() != 0 ? " AND " + res.substring(5) : "");
            }
            sql = String.valueOf(sql) + " ORDER BY DATE_JOUR";
            Statement stm = this.connection.createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Jour toAdd = new Jour(rs.getInt("CLE"), rs.getInt("CLE_CHAUFFEUR"), rs.getString("DATE_JOUR").substring(0, 10), rs.getInt("CONDUITE"), rs.getInt("TRAVAIL"), rs.getInt("DISPO"), rs.getInt("REPOS"), rs.getInt("DOUBLE_EQUIP"), rs.getInt("AUTRE"), rs.getInt("EVENEMENT"), rs.getInt("CUMUL_T_C_D_DE"), rs.getInt("HEURE_DEBUT"), rs.getInt("HEURE_FIN"), rs.getInt("HEURE_NUIT"), rs.getInt("DISTANCE"), rs.getInt("MODIFICATION"), rs.getBoolean("SUPPRESSION"), null, "", rs.getInt("CLE_USER"), rs.getString("SOURCE_NAME"), rs.getInt("MANUAL_INPUT") == 1);
                Blob act = rs.getBlob("ACTIVITIES");
                if (act != null) {
                    toAdd.setActivity(ActiviteConducteur.fromCondensed(act.getBytes(1L, (int)act.length()), toAdd));
                }
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getJour()# " + ex.getMessage() + " - sql = " + sql);
        }
        return result;
    }

    public Vector<Jour> getJourDebug(int driverId, String begin, String end) {
        String sql = "";
        Vector<Jour> result = new Vector<Jour>();
        try {
            String res = "";
            if (driverId != 0) {
                res = String.valueOf(res) + " AND jour.CLE_CHAUFFEUR = " + driverId;
            }
            sql = "SELECT jour.CLE,jour.CLE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "jour") + ", CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT," + " AUTRE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION, CLE_USER, ACTIVITIES, MANUAL_INPUT, SOURCE_NAME" + " FROM " + tableJourModifie + " jour " + " WHERE CURRENT_VALUE = 1" + (res.length() != 0 ? " AND DATE_INSERTION > \"2019-03-17\" AND " + res.substring(5) : "");
            sql = String.valueOf(sql) + " ORDER BY CLE_CHAUFFEUR, DATE_JOUR";
            Statement stm = this.connection.createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Jour toAdd = new Jour(rs.getInt("CLE"), rs.getInt("CLE_CHAUFFEUR"), rs.getString("DATE_JOUR").substring(0, 10), rs.getInt("CONDUITE"), rs.getInt("TRAVAIL"), rs.getInt("DISPO"), rs.getInt("REPOS"), rs.getInt("DOUBLE_EQUIP"), rs.getInt("AUTRE"), rs.getInt("EVENEMENT"), rs.getInt("CUMUL_T_C_D_DE"), rs.getInt("HEURE_DEBUT"), rs.getInt("HEURE_FIN"), rs.getInt("HEURE_NUIT"), rs.getInt("DISTANCE"), rs.getInt("MODIFICATION"), rs.getBoolean("SUPPRESSION"), null, "", rs.getInt("CLE_USER"), rs.getString("SOURCE_NAME"), rs.getInt("MANUAL_INPUT") == 1);
                Blob act = rs.getBlob("ACTIVITIES");
                if (act != null) {
                    toAdd.setActivity(ActiviteConducteur.fromCondensed(act.getBytes(1L, (int)act.length()), toAdd));
                }
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getJour()# " + ex.getMessage() + " - sql = " + sql);
        }
        return result;
    }

    public int countJour() {
        int count = 0;
        String sql = "";
        try {
            sql = "SELECT count(*) as nb FROM t_jour";
            sql = String.valueOf(sql) + " ORDER BY DATE_JOUR";
            Statement stm = this.connection.createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                count = rs.getInt("nb");
            }
            rs.close();
            stm.close();
            TimsLogger.debug(sql);
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getJour()# " + ex.getMessage() + " - sql = " + sql);
        }
        return count;
    }

    public Vector<ActiviteConducteur> getManualInput(int driverId, java.util.Date begin, java.util.Date end, boolean onlyBrut, boolean onlyDeleted) {
        String sBegin = ConversionTime.dateToString(begin, "yyyy-MM-dd");
        String sEnd = ConversionTime.dateToString(end, "yyyy-MM-dd");
        String sql = "";
        Vector<ActiviteConducteur> result = new Vector<ActiviteConducteur>();
        try {
            String res = "";
            if (begin != null) {
                res = end != null && !end.equals("") ? String.valueOf(res) + " AND jour.DATE_JOUR BETWEEN " + BddTransport.getDateStringToSGBDR(sBegin, false) + " AND " + BddTransport.getDateStringToSGBDR(sEnd, false) : String.valueOf(res) + " AND jour.DATE_JOUR =" + BddTransport.getDateStringToSGBDR(sBegin, false);
            }
            if (driverId != 0) {
                res = String.valueOf(res) + " AND jour.CLE_CHAUFFEUR = " + driverId;
            }
            res = String.valueOf(res) + " AND SUPPRESSION=" + (onlyDeleted ? "1" : "0");
            sql = "SELECT jour.CLE,jour.CLE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "jour") + ", CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT," + " AUTRE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION, CLE_USER, ACTIVITIES, MANUAL_INPUT, SOURCE_NAME" + " FROM " + "t_jour" + " jour " + (res.length() != 0 ? "WHERE " + res.substring(5) : "");
            if (!onlyBrut) {
                sql = String.valueOf(sql) + " AND MODIFICATION = 0 UNION ALL SELECT jour.CLE, jour.CLE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "jour") + ", CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT," + " AUTRE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION, CLE_USER, ACTIVITIES, MANUAL_INPUT, SOURCE_NAME" + " FROM " + tableJourModifie + " jour" + " WHERE CURRENT_VALUE = 1" + (res.length() != 0 ? " AND " + res.substring(5) : "");
            }
            sql = String.valueOf(sql) + " ORDER BY DATE_JOUR";
            Statement stm = this.connection.createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Jour toAdd = new Jour(rs.getInt("CLE"), rs.getInt("CLE_CHAUFFEUR"), rs.getString("DATE_JOUR").substring(0, 10), rs.getInt("CONDUITE"), rs.getInt("TRAVAIL"), rs.getInt("DISPO"), rs.getInt("REPOS"), rs.getInt("DOUBLE_EQUIP"), rs.getInt("AUTRE"), rs.getInt("EVENEMENT"), rs.getInt("CUMUL_T_C_D_DE"), rs.getInt("HEURE_DEBUT"), rs.getInt("HEURE_FIN"), rs.getInt("HEURE_NUIT"), rs.getInt("DISTANCE"), rs.getInt("MODIFICATION"), rs.getBoolean("SUPPRESSION"), null, "", rs.getInt("CLE_USER"), rs.getString("SOURCE_NAME"), rs.getInt("MANUAL_INPUT") == 1);
                Blob act = rs.getBlob("ACTIVITIES");
                if (act != null) {
                    toAdd.setActivity(ActiviteConducteur.fromCondensed(act.getBytes(1L, (int)act.length()), toAdd));
                }
                for (ActiviteConducteur one : toAdd.getActivity()) {
                    if (!one.isManualInput() || one.isRest()) continue;
                    result.add(one);
                }
            }
            rs.close();
            stm.close();
            TimsLogger.debug(sql);
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getJour()# " + ex.getMessage() + " - sql = " + sql);
        }
        return result;
    }

    public Vector<ActiviteConducteur> getNightActivity(int driverId, java.util.Date begin, java.util.Date end, boolean onlyBrut, boolean onlyDeleted) {
        String sBegin = ConversionTime.dateToString(begin, "yyyy-MM-dd");
        String sEnd = ConversionTime.dateToString(end, "yyyy-MM-dd");
        String sql = "";
        Vector<ActiviteConducteur> result = new Vector<ActiviteConducteur>();
        try {
            String res = " AND HEURE_NUIT!=0";
            if (begin != null) {
                res = end != null && !end.equals("") ? String.valueOf(res) + " AND jour.DATE_JOUR BETWEEN " + BddTransport.getDateStringToSGBDR(sBegin, false) + " AND " + BddTransport.getDateStringToSGBDR(sEnd, false) : String.valueOf(res) + " AND jour.DATE_JOUR =" + BddTransport.getDateStringToSGBDR(sBegin, false);
            }
            if (driverId != 0) {
                res = String.valueOf(res) + " AND jour.CLE_CHAUFFEUR = " + driverId;
            }
            res = String.valueOf(res) + " AND SUPPRESSION=" + (onlyDeleted ? "1" : "0");
            sql = "SELECT jour.CLE,jour.CLE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "jour") + ", CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT," + " AUTRE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION, CLE_USER, ACTIVITIES, SOURCE_NAME, MANUAL_INPUT" + " FROM " + "t_jour" + " jour " + (res.length() != 0 ? "WHERE " + res.substring(5) : "");
            if (!onlyBrut) {
                sql = String.valueOf(sql) + " AND MODIFICATION = 0 UNION ALL SELECT jour.CLE, jour.CLE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "jour") + ", CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT," + " AUTRE, CUMUL_T_C_D_DE, HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION, CLE_USER, ACTIVITIES, SOURCE_NAME, MANUAL_INPUT" + " FROM " + tableJourModifie + " jour" + " WHERE CURRENT_VALUE = 1" + (res.length() != 0 ? " AND " + res.substring(5) : "");
            }
            sql = String.valueOf(sql) + " ORDER BY DATE_JOUR";
            Statement stm = this.connection.createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Jour toAdd = new Jour(rs.getInt("CLE"), rs.getInt("CLE_CHAUFFEUR"), rs.getString("DATE_JOUR").substring(0, 10), rs.getInt("CONDUITE"), rs.getInt("TRAVAIL"), rs.getInt("DISPO"), rs.getInt("REPOS"), rs.getInt("DOUBLE_EQUIP"), rs.getInt("AUTRE"), rs.getInt("EVENEMENT"), rs.getInt("CUMUL_T_C_D_DE"), rs.getInt("HEURE_DEBUT"), rs.getInt("HEURE_FIN"), rs.getInt("HEURE_NUIT"), rs.getInt("DISTANCE"), rs.getInt("MODIFICATION"), rs.getBoolean("SUPPRESSION"), null, "", rs.getInt("CLE_USER"), rs.getString("SOURCE_NAME"), rs.getInt("MANUAL_INPUT") == 1);
                Blob act = rs.getBlob("ACTIVITIES");
                if (act != null) {
                    toAdd.setActivity(ActiviteConducteur.fromCondensed(act.getBytes(1L, (int)act.length()), toAdd));
                }
                for (ActiviteConducteur one : toAdd.getActivity()) {
                    if (Fonctions.getTempsNuit(one) == 0 || one.isRest()) continue;
                    result.add(one);
                }
            }
            rs.close();
            stm.close();
            TimsLogger.debug(sql);
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getJour()# " + ex.getMessage() + " - sql = " + sql);
        }
        return result;
    }

    public static String getQuote() {
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            return "\"";
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            return "'";
        }
        return "\"";
    }

    public static String getClearedImmat(String field) {
        if (field == null || field.equals("")) {
            field = "N_IMMATRICULATION";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            return "replace(replace(" + field + ",'-',''),' ','')";
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            return "replace(replace(" + field + ",'-'),' ')";
        }
        return "\"";
    }

    public java.util.Date getDate() {
        Timestamp result = null;
        String sql = "";
        try {
            sql = "SELECT current_timestamp " + (System.getProperty("SGBDR", "mysql").equals("mysql") ? "" : "FROM DUAL");
            Statement stm = this.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result = rs.getTimestamp("current_timestamp");
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            this.showTimeout();
            return null;
        }
        catch (Exception ex) {
            TimsLogger.error("#getTime()# " + ex.getMessage() + " - Erreur sql = " + sql);
            return null;
        }
        return result;
    }

    public static void migration() {
        String tableToMigrate = null;
        String directory = null;
        try {
            if (tableToMigrate == null) {
                JFileChooser choix = new JFileChooser(System.getProperty("user.home"));
                choix.setFileSelectionMode(0);
                choix.setDialogTitle("Selectionner le fichier avec les tables \u00e0 r\u00e9cup\u00e9rer");
                choix.setApproveButtonText("Verifier");
                if (choix.showOpenDialog(MainFrameTransport.getInstance()) != 0) {
                    return;
                }
                tableToMigrate = choix.getSelectedFile().getAbsolutePath();
                directory = choix.getSelectedFile().getParent();
            }
            TimsLogger.debug("TIMS - free : " + Runtime.getRuntime().freeMemory());
            System.gc();
            PrintWriter errorWriter = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(directory) + "\\MIGRATION - ERROR.txt")));
            PrintWriter logWriter = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(directory) + "\\TIMS - LOG.txt")));
            FileReader reader = null;
            BufferedReader br = null;
            String ligne = null;
            boolean fileExist = true;
            if (!new File(tableToMigrate).exists()) {
                errorWriter.println("TimsStructure.txt not found");
                logWriter.println("TimsStructure.txt not found");
                fileExist = false;
            }
            if (fileExist) {
                reader = new FileReader(tableToMigrate);
                br = new BufferedReader(reader);
                ligne = "";
                ligne = br.readLine();
                Statement stm = BddTransport.getInstance().getConnection().createStatement();
                ResultSet rs = null;
                while (ligne != null) {
                    int lineNb = 0;
                    String[] table = ligne.split(";");
                    logWriter.println("migration started for " + table[0]);
                    TimsLogger.warn("migration started for " + table[0]);
                    try {
                        String sql = "SELECT * FROM " + table[0];
                        rs = stm.executeQuery(sql);
                        while (rs.next()) {
                            ++lineNb;
                        }
                    }
                    catch (CommunicationsException ex) {
                        errorWriter.println("An error occured for " + table[0] + "(" + ex.getMessage() + ")");
                        ex.printStackTrace();
                        BddTransport.getInstance().showTimeout();
                    }
                    catch (Exception ex) {
                        errorWriter.println("An error occured for " + table[0] + "(" + ex.getMessage() + ")");
                        TimsLogger.error(ex.getMessage());
                    }
                    logWriter.println("migration end for " + table[0] + " : " + lineNb + " migrated");
                    TimsLogger.warn("migration end for " + table[0] + " : " + lineNb + " migrated");
                    ligne = br.readLine();
                    errorWriter.flush();
                    logWriter.flush();
                }
                rs.close();
                stm.close();
                reader.close();
                br.close();
                reader = null;
                br = null;
            }
            errorWriter.close();
            logWriter.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("MainFrameTransport.migration(  )  : " + ex);
            ex.printStackTrace();
            return;
        }
    }
}

