/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.AccidentAction;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Injured;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Repairing;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class Accident
extends MainElement {
    public static final String table = "ACCIDENT";
    private static Vector<Accident> list = null;
    public static String[] TYPE_WORDING = new String[]{LanguageTranslator.getString("accident.knownThirdParty"), LanguageTranslator.getString("accident.unknownThirdParty"), LanguageTranslator.getString("accident.noThirdParty")};
    public static String[] RESPONSABILITY_WORDING = new String[]{LanguageTranslator.getString("accident.0"), LanguageTranslator.getString("accident.50"), LanguageTranslator.getString("accident.100")};
    private int id = 0;
    private String identificationNumber = null;
    private String insuranceNumber = null;
    private int agencyId = 0;
    private int driverId = 0;
    private int vehicleId = 0;
    private Date day = null;
    private String place = null;
    private int type = 0;
    private boolean injury = false;
    private boolean steal = false;
    private String description = null;
    private boolean bigDamages = false;
    private int responsability = 0;
    private boolean inTraffic = false;
    private String insuranceType = "";
    private String conventionType = "";
    private String insuranceCode = "";
    private int garageId = 0;
    private Date garageIn = null;
    private Date garageOut = null;
    private boolean towing = false;
    private float rcCost = 0.0f;
    private float rcExcess = 0.0f;
    private float insuranceRecourse = 0.0f;
    private float companyRecourse = 0.0f;
    private float damageExcess = 0.0f;
    private float VAT = 0.0f;
    private float dilapidation = 0.0f;
    private float selfInsurance = 0.0f;
    private float expertCost = 0.0f;
    private float fixingCost = 0.0f;
    private float companyFixingCost = 0.0f;
    private float locationDebt = 0.0f;
    private float companyLocationDebt = 0.0f;
    private float guarding = 0.0f;
    private float totalCost = 0.0f;
    private float totalInsurance = 0.0f;
    private boolean opened = false;
    private Vector<Injured> injuried = null;
    private Vector<Repairing> repairing = null;
    private Vector<AccidentAction> accidentAction = null;

    public boolean equals(Object o) {
        return o instanceof Accident && this.identificationNumber.equals(((Accident)o).getIdentificationNumber());
    }

    public String toString() {
        return this.getIdentificationNumber();
    }

    public boolean loadByIdentificationNumber(String identificationNumber) {
        String sql = "SELECT " + Accident.getAllFields() + " FROM " + table + " WHERE IDENTIFICATION_NUMBER='" + identificationNumber + "'";
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + Accident.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = Accident.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#Accident.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#Accident.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.identificationNumber = rs.getString("IDENTIFICATION_NUMBER");
                    this.insuranceNumber = rs.getString("INSURANCE_NUMBER");
                    this.agencyId = rs.getInt("AGENCY_ID");
                    this.driverId = rs.getInt("DRIVER_ID");
                    this.vehicleId = rs.getInt("VEHICLE_ID");
                    this.day = rs.getDate("DAY");
                    this.place = rs.getString("PLACE");
                    this.type = rs.getInt("TYPE");
                    this.injury = rs.getInt("INJURY") == 1;
                    this.steal = rs.getInt("STEAL") == 1;
                    this.description = rs.getString("DESCRIPTION");
                    this.bigDamages = rs.getInt("BIG_DAMAGES") == 1;
                    this.responsability = rs.getInt("RESPONSABILITY");
                    this.garageId = rs.getInt("GARAGE_ID");
                    this.garageIn = rs.getDate("GARAGE_IN");
                    this.garageOut = rs.getDate("GARAGE_OUT");
                    this.towing = rs.getInt("TOWING") == 1;
                    this.rcCost = rs.getFloat("RC_COST");
                    this.rcExcess = rs.getFloat("RC_EXCESS");
                    this.insuranceRecourse = rs.getFloat("INSURANCE_RECOURSE");
                    this.companyRecourse = rs.getFloat("COMPANY_RECOURSE");
                    this.damageExcess = rs.getFloat("DAMAGE_EXCESS");
                    this.VAT = rs.getFloat("VAT");
                    this.dilapidation = rs.getFloat("DILAPIDATION");
                    this.selfInsurance = rs.getFloat("SELF_INSURANCE");
                    this.expertCost = rs.getFloat("EXPERT_COST");
                    this.fixingCost = rs.getFloat("FIXING_COST");
                    this.companyFixingCost = rs.getFloat("COMPANY_FIXING_COST");
                    this.locationDebt = rs.getFloat("LOCATION_DEBT");
                    this.companyLocationDebt = rs.getFloat("COMPANY_LOCATION_DEBT");
                    this.guarding = rs.getFloat("GUARDING");
                    this.guarding = rs.getFloat("GUARDING");
                    this.totalCost = rs.getFloat("TOTAL_COST");
                    this.totalInsurance = rs.getFloat("TOTAL_INSURANCE");
                    this.opened = rs.getInt("OPENED") == 1;
                    this.inTraffic = rs.getInt("IN_TRAFFIC") == 1;
                    this.insuranceType = rs.getString("INSURANCE_TYPE");
                    this.conventionType = rs.getString("CONVENTION_TYPE");
                    this.insuranceCode = rs.getString("INSURANCE_CODE");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("#Accident.genericLoad() # sql = " + sql + " => " + ex.getMessage());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#Accident.insert()");
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO ACCIDENT (" + Accident.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    this.statement = Accident.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO ACCIDENT (" + Accident.getAllFields().substring(Accident.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    this.statement = Accident.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.identificationNumber, 12);
                this.statement.setObject(2, (Object)this.insuranceNumber, 12);
                this.statement.setObject(3, (Object)this.agencyId, 4);
                this.statement.setObject(4, (Object)this.driverId, 4);
                this.statement.setObject(5, (Object)this.vehicleId, 4);
                this.statement.setTimestamp(6, this.day == null ? null : new Timestamp(this.day.getTime()));
                this.statement.setObject(7, (Object)this.place, 12);
                this.statement.setObject(8, (Object)this.type, 4);
                this.statement.setObject(9, (Object)(this.injury ? 1 : 0), 4);
                this.statement.setObject(10, (Object)(this.steal ? 1 : 0), 4);
                this.statement.setObject(11, (Object)this.description, 12);
                this.statement.setObject(12, (Object)(this.bigDamages ? 1 : 0), 4);
                this.statement.setObject(13, (Object)this.responsability, 4);
                this.statement.setObject(14, (Object)this.garageId, 4);
                this.statement.setTimestamp(15, this.garageIn == null ? null : new Timestamp(this.garageIn.getTime()));
                this.statement.setTimestamp(16, this.garageOut == null ? null : new Timestamp(this.garageOut.getTime()));
                this.statement.setObject(17, (Object)(this.towing ? 1 : 0), 4);
                this.statement.setObject(18, (Object)Float.valueOf(this.rcCost), 6);
                this.statement.setObject(19, (Object)Float.valueOf(this.rcExcess), 6);
                this.statement.setObject(20, (Object)Float.valueOf(this.insuranceRecourse), 6);
                this.statement.setObject(21, (Object)Float.valueOf(this.companyRecourse), 6);
                this.statement.setObject(22, (Object)Float.valueOf(this.damageExcess), 6);
                this.statement.setObject(23, (Object)Float.valueOf(this.VAT), 6);
                this.statement.setObject(24, (Object)Float.valueOf(this.dilapidation), 6);
                this.statement.setObject(25, (Object)Float.valueOf(this.selfInsurance), 6);
                this.statement.setObject(26, (Object)Float.valueOf(this.expertCost), 6);
                this.statement.setObject(27, (Object)Float.valueOf(this.fixingCost), 6);
                this.statement.setObject(28, (Object)Float.valueOf(this.companyFixingCost), 6);
                this.statement.setObject(29, (Object)Float.valueOf(this.locationDebt), 6);
                this.statement.setObject(30, (Object)Float.valueOf(this.companyLocationDebt), 6);
                this.statement.setObject(31, (Object)Float.valueOf(this.guarding), 6);
                this.statement.setObject(32, (Object)Float.valueOf(this.totalCost), 6);
                this.statement.setObject(33, (Object)Float.valueOf(this.totalInsurance), 6);
                this.statement.setObject(34, (Object)(this.opened ? 1 : 0), 4);
                this.statement.setObject(35, (Object)(this.inTraffic ? 1 : 0), 4);
                this.statement.setObject(36, (Object)this.insuranceType, 12);
                this.statement.setObject(37, (Object)this.conventionType, 12);
                this.statement.setObject(38, (Object)this.insuranceCode, 12);
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    ResultSet rs = this.statement.getGeneratedKeys();
                    if (!rs.next()) {
                        TimsLogger.info("#Accident.insert# no auto generated key availaible");
                    } else {
                        TimsLogger.debug("#Accident.insert# auto generated key value = " + rs.getInt(1));
                        this.id = rs.getInt(1);
                    }
                    rs.close();
                }
                if (this.id == 0) {
                    if (this.loadId()) {
                        TimsLogger.debug("#Accident.insert# generated key value = " + this.id);
                    } else {
                        TimsLogger.info("#Accident.insert# no generated key availaible");
                    }
                }
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID) AS ID FROM ACCIDENT WHERE IDENTIFICATION_NUMBER = ?";
        PreparedStatement statement = null;
        try {
            try {
                statement = Accident.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.identificationNumber, 12);
                rs = statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("#Accident.loadId()#  sql = " + sql + " => " + ex.getMessage());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE ACCIDENT SET  IDENTIFICATION_NUMBER=? , INSURANCE_NUMBER=? , AGENCY_ID=? , DRIVER_ID=? , VEHICLE_ID=? , DAY=? , PLACE=? , TYPE=? , INJURY=? , STEAL=? , DESCRIPTION=? , BIG_DAMAGES=? , RESPONSABILITY=? , GARAGE_ID=? , GARAGE_IN=? , GARAGE_OUT=? , TOWING=? , RC_COST=? , RC_EXCESS=? , INSURANCE_RECOURSE=? , COMPANY_RECOURSE=? , DAMAGE_EXCESS=? , VAT=? , DILAPIDATION=? , SELF_INSURANCE=? , EXPERT_COST=? , FIXING_COST=? , COMPANY_FIXING_COST=? , LOCATION_DEBT=? , COMPANY_LOCATION_DEBT=? , GUARDING=? , TOTAL_COST=? , TOTAL_INSURANCE=? , OPENED=? , IN_TRAFFIC=? , INSURANCE_TYPE=? , CONVENTION_TYPE=? , INSURANCE_CODE=?  WHERE ID=?";
        try {
            try {
                this.statement = Accident.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.identificationNumber, 12);
                this.statement.setObject(2, (Object)this.insuranceNumber, 12);
                this.statement.setObject(3, (Object)this.agencyId, 4);
                this.statement.setObject(4, (Object)this.driverId, 4);
                this.statement.setObject(5, (Object)this.vehicleId, 4);
                this.statement.setTimestamp(6, this.day == null ? null : new Timestamp(this.day.getTime()));
                this.statement.setObject(7, (Object)this.place, 12);
                this.statement.setObject(8, (Object)this.type, 4);
                this.statement.setObject(9, (Object)(this.injury ? 1 : 0), 4);
                this.statement.setObject(10, (Object)(this.steal ? 1 : 0), 4);
                this.statement.setObject(11, (Object)this.description, 12);
                this.statement.setObject(12, (Object)(this.bigDamages ? 1 : 0), 4);
                this.statement.setObject(13, (Object)this.responsability, 4);
                this.statement.setObject(14, (Object)this.garageId, 4);
                this.statement.setTimestamp(15, this.garageIn == null ? null : new Timestamp(this.garageIn.getTime()));
                this.statement.setTimestamp(16, this.garageOut == null ? null : new Timestamp(this.garageOut.getTime()));
                this.statement.setObject(17, (Object)(this.towing ? 1 : 0), 4);
                this.statement.setObject(18, (Object)Float.valueOf(this.rcCost), 6);
                this.statement.setObject(19, (Object)Float.valueOf(this.rcExcess), 6);
                this.statement.setObject(20, (Object)Float.valueOf(this.insuranceRecourse), 6);
                this.statement.setObject(21, (Object)Float.valueOf(this.companyRecourse), 6);
                this.statement.setObject(22, (Object)Float.valueOf(this.damageExcess), 6);
                this.statement.setObject(23, (Object)Float.valueOf(this.VAT), 6);
                this.statement.setObject(24, (Object)Float.valueOf(this.dilapidation), 6);
                this.statement.setObject(25, (Object)Float.valueOf(this.selfInsurance), 6);
                this.statement.setObject(26, (Object)Float.valueOf(this.expertCost), 6);
                this.statement.setObject(27, (Object)Float.valueOf(this.fixingCost), 6);
                this.statement.setObject(28, (Object)Float.valueOf(this.companyFixingCost), 6);
                this.statement.setObject(29, (Object)Float.valueOf(this.locationDebt), 6);
                this.statement.setObject(30, (Object)Float.valueOf(this.companyLocationDebt), 6);
                this.statement.setObject(31, (Object)Float.valueOf(this.guarding), 6);
                this.statement.setObject(32, (Object)Float.valueOf(this.totalCost), 6);
                this.statement.setObject(33, (Object)Float.valueOf(this.totalInsurance), 6);
                this.statement.setObject(34, (Object)(this.opened ? 1 : 0), 4);
                this.statement.setObject(35, (Object)(this.inTraffic ? 1 : 0), 4);
                this.statement.setObject(36, (Object)this.insuranceType, 12);
                this.statement.setObject(37, (Object)this.conventionType, 12);
                this.statement.setObject(38, (Object)this.insuranceCode, 12);
                this.statement.setObject(39, (Object)this.id, 4);
                this.statement.executeUpdate();
                toReturn = true;
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean compareAndUpdate(String identificationNumber, String insuranceNumber, int agencyId, int driverId, int vehicleId, Date day, String place, int type, boolean injury, boolean steal, String description, boolean bigDamages, int responsability, int garageId, Date garageIn, Date garageOut, boolean towing, float rcCost, float rcExcess, float insuranceRecourse, float companyRecourse, float damageExcess, float VAT, float dilapidation, float selfInsurance, float expertCost, float fixingCost, float companyFixingCost, float locationDebt, float companyLocationDebt, float guarding, float totalCost, float totalInsurance, boolean opened, boolean inTraffic, String insuranceType, String conventionType, String insuranceCode, Vector<Injured> injuried) {
        String tracer = String.valueOf(LanguageTranslator.getString("accident")) + " n\u00b0 " + this.id + "\n";
        if (Fonctions.fieldChange(identificationNumber, this.identificationNumber)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.identification") + " '" + this.identificationNumber + "' => '" + identificationNumber + "'\n";
            this.setIdentificationNumber(identificationNumber);
        }
        if (Fonctions.fieldChange(insuranceNumber, this.insuranceNumber)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.insuranceNumber") + " '" + this.insuranceNumber + "' => '" + insuranceNumber + "'\n";
            this.setInsuranceNumber(insuranceNumber);
        }
        if (this.agencyId != agencyId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.agency") + " '" + this.agencyId + "' => '" + agencyId + "'\n";
            this.setAgencyId(agencyId);
        }
        if (this.driverId != driverId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.driver") + " '" + this.driverId + "' => '" + driverId + "'\n";
            this.setDriverId(driverId);
        }
        if (this.vehicleId != vehicleId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.vehicle") + " '" + this.vehicleId + "' => '" + vehicleId + "'\n";
            this.setVehicleId(vehicleId);
        }
        if (Fonctions.fieldChange(this.day, day)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.date") + " '" + this.day + "' => '" + day + "'\n";
            this.setDay(day);
        }
        if (Fonctions.fieldChange(this.place, place)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.place") + " '" + this.place + "' => '" + place + "'\n";
            this.setPlace(place);
        }
        if (this.type != type) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.type") + " '" + this.type + "' => '" + type + "'\n";
            this.setType(type);
        }
        if (this.injury != injury) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.injuried") + " '" + this.injury + "' => '" + injury + "'\n";
            this.setInjury(injury);
        }
        if (this.steal != steal) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.steal") + " '" + this.steal + "' => '" + steal + "'\n";
            this.setSteal(steal);
        }
        if (Fonctions.fieldChange(this.description, description)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.description") + " '" + this.description + "' => '" + description + "'\n";
            this.setDescription(description);
        }
        if (this.bigDamages != bigDamages) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.vehicle") + " '" + this.bigDamages + "' => '" + bigDamages + "'\n";
            this.setBigDamages(bigDamages);
        }
        if (this.responsability != responsability) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.responsability") + " '" + this.responsability + "' => '" + responsability + "'\n";
            this.setResponsability(responsability);
        }
        if (this.garageId != garageId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.garage") + " '" + this.garageId + "' => '" + garageId + "'\n";
            this.setGarageId(garageId);
        }
        if (Fonctions.fieldChange(this.garageIn, garageIn)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.date") + " '" + this.garageIn + "' => '" + garageIn + "'\n";
            this.setGarageIn(garageIn);
        }
        if (Fonctions.fieldChange(this.towing, towing)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.towing") + " '" + this.towing + "' => '" + towing + "'\n";
            this.setTowing(towing);
        }
        if (this.rcCost != rcCost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.rcCost") + " '" + this.rcCost + "' => '" + rcCost + "'\n";
            this.setRcCost(rcCost);
        }
        if (this.rcExcess != rcExcess) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.rcExcess") + " '" + this.rcExcess + "' => '" + rcExcess + "'\n";
            this.setRcExcess(rcExcess);
        }
        if (this.insuranceRecourse != insuranceRecourse) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.insuranceRecourse") + " '" + this.insuranceRecourse + "' => '" + insuranceRecourse + "'\n";
            this.setInsuranceRecourse(insuranceRecourse);
        }
        if (this.companyRecourse != companyRecourse) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.companyRecourse") + " '" + this.companyRecourse + "' => '" + companyRecourse + "'\n";
            this.setCompanyRecourse(companyRecourse);
        }
        if (this.damageExcess != damageExcess) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.damageExcess") + " '" + this.damageExcess + "' => '" + damageExcess + "'\n";
            this.setDamageExcess(damageExcess);
        }
        if (this.VAT != VAT) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.VAT") + " '" + this.VAT + "' => '" + VAT + "'\n";
            this.setVAT(VAT);
        }
        if (this.dilapidation != dilapidation) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.dilapidation") + " '" + this.dilapidation + "' => '" + dilapidation + "'\n";
            this.setDilapidation(dilapidation);
        }
        if (this.selfInsurance != selfInsurance) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.selfInsurance") + " '" + this.selfInsurance + "' => '" + selfInsurance + "'\n";
            this.setSelfInsurance(selfInsurance);
        }
        if (this.expertCost != expertCost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.expertCost") + " '" + this.expertCost + "' => '" + expertCost + "'\n";
            this.setExpertCost(expertCost);
        }
        if (this.fixingCost != fixingCost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.fixingCost") + " '" + this.fixingCost + "' => '" + fixingCost + "'\n";
            this.setFixingCost(fixingCost);
        }
        if (this.companyFixingCost != companyFixingCost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.companyFixingCost") + " '" + this.companyFixingCost + "' => '" + companyFixingCost + "'\n";
            this.setCompanyFixingCost(companyFixingCost);
        }
        if (this.locationDebt != locationDebt) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.locationDebt") + " '" + this.locationDebt + "' => '" + locationDebt + "'\n";
            this.setLocationDebt(locationDebt);
        }
        if (this.companyLocationDebt != companyLocationDebt) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.companyLocationDebt") + " '" + this.companyLocationDebt + "' => '" + companyLocationDebt + "'\n";
            this.setCompanyLocationDebt(companyLocationDebt);
        }
        if (this.guarding != guarding) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.guarding") + " '" + this.guarding + "' => '" + guarding + "'\n";
            this.setGuarding(guarding);
        }
        if (this.totalCost != totalCost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.totalCost") + " '" + this.totalCost + "' => '" + totalCost + "'\n";
            this.setTotalCost(totalCost);
        }
        if (this.totalInsurance != totalInsurance) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.totalInsurance") + " '" + this.totalInsurance + "' => '" + totalInsurance + "'\n";
            this.setTotalInsurance(totalInsurance);
        }
        if (this.opened != opened) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.opened") + " '" + this.opened + "' => '" + opened + "'\n";
            this.setOpened(opened);
        }
        if (this.inTraffic != inTraffic) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.inTraffic") + " '" + this.inTraffic + "' => '" + inTraffic + "'\n";
            this.setInTraffic(inTraffic);
        }
        if (Fonctions.fieldChange(insuranceType, this.insuranceType)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.insuranceType") + " '" + this.insuranceType + "' => '" + insuranceType + "'\n";
            this.setInsuranceType(insuranceType);
        }
        if (Fonctions.fieldChange(conventionType, this.conventionType)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.conventionType") + " '" + this.conventionType + "' => '" + conventionType + "'\n";
            this.setConventionType(conventionType);
        }
        if (Fonctions.fieldChange(insuranceCode, this.insuranceCode)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident.insuranceCode") + " '" + this.insuranceCode + "' => '" + insuranceCode + "'\n";
            this.setInsuranceCode(insuranceCode);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("accident")) + " n\u00b0 " + this.id + "\n")) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#Accident.loadId()#  no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM ACCIDENT WHERE ID=?";
        try {
            this.statement = Accident.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public String getInsuranceNumber() {
        return this.insuranceNumber;
    }

    public void setInsuranceNumber(String insuranceNumber) {
        this.insuranceNumber = insuranceNumber;
    }

    public int getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(int agencyId) {
        this.agencyId = agencyId;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int vehicleId) {
        this.vehicleId = vehicleId;
    }

    public Date getDay() {
        return this.day;
    }

    public void setDay(Date day) {
        this.day = day;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean getInjury() {
        return this.injury;
    }

    public void setInjury(boolean injury) {
        this.injury = injury;
    }

    public boolean getSteal() {
        return this.steal;
    }

    public void setSteal(boolean steal) {
        this.steal = steal;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isBigDamages() {
        return this.bigDamages;
    }

    public void setBigDamages(boolean bigDamages) {
        this.bigDamages = bigDamages;
    }

    public int getResponsability() {
        return this.responsability;
    }

    public void setResponsability(int responsability) {
        this.responsability = responsability;
    }

    public boolean isInTraffic() {
        return this.inTraffic;
    }

    public void setInTraffic(boolean inTraffic) {
        this.inTraffic = inTraffic;
    }

    public String getInsuranceType() {
        return this.insuranceType;
    }

    public void setInsuranceType(String insuranceType) {
        this.insuranceType = insuranceType;
    }

    public String getConventionType() {
        return this.conventionType;
    }

    public void setConventionType(String conventionType) {
        this.conventionType = conventionType;
    }

    public String getInsuranceCode() {
        return this.insuranceCode;
    }

    public void setInsuranceCode(String insuranceCode) {
        this.insuranceCode = insuranceCode;
    }

    public int getGarageId() {
        return this.garageId;
    }

    public void setGarageId(int garageId) {
        this.garageId = garageId;
    }

    public Date getGarageIn() {
        return this.garageIn;
    }

    public void setGarageIn(Date garageEntry) {
        this.garageIn = garageEntry;
    }

    public Date getGarageOut() {
        return this.garageOut;
    }

    public void setGarageOut(Date garageOut) {
        this.garageOut = garageOut;
    }

    public boolean isTowing() {
        return this.towing;
    }

    public void setTowing(boolean towing) {
        this.towing = towing;
    }

    public float getRcCost() {
        return this.rcCost;
    }

    public void setRcCost(float rcCost) {
        this.rcCost = rcCost;
    }

    public float getRcExcess() {
        return this.rcExcess;
    }

    public void setRcExcess(float rcExcess) {
        this.rcExcess = rcExcess;
    }

    public float getInsuranceRecourse() {
        return this.insuranceRecourse;
    }

    public void setInsuranceRecourse(float insuranceRecourse) {
        this.insuranceRecourse = insuranceRecourse;
    }

    public float getCompanyRecourse() {
        return this.companyRecourse;
    }

    public void setCompanyRecourse(float companyRecourse) {
        this.companyRecourse = companyRecourse;
    }

    public float getDamageExcess() {
        return this.damageExcess;
    }

    public void setDamageExcess(float damageExcess) {
        this.damageExcess = damageExcess;
    }

    public float getVAT() {
        return this.VAT;
    }

    public void setVAT(float vAT) {
        this.VAT = vAT;
    }

    public float getDilapidation() {
        return this.dilapidation;
    }

    public void setDilapidation(float dilapidation) {
        this.dilapidation = dilapidation;
    }

    public float getSelfInsurance() {
        return this.selfInsurance;
    }

    public void setSelfInsurance(float selfInsurance) {
        this.selfInsurance = selfInsurance;
    }

    public float getExpertCost() {
        return this.expertCost;
    }

    public void setExpertCost(float expertCost) {
        this.expertCost = expertCost;
    }

    public float getFixingCost() {
        return this.fixingCost;
    }

    public void setFixingCost(float fixingCost) {
        this.fixingCost = fixingCost;
    }

    public float getCompanyFixingCost() {
        return this.companyFixingCost;
    }

    public void setCompanyFixingCost(float companyFixingCost) {
        this.companyFixingCost = companyFixingCost;
    }

    public float getLocationDebt() {
        return this.locationDebt;
    }

    public void setLocationDebt(float locationDebt) {
        this.locationDebt = locationDebt;
    }

    public float getCompanyLocationDebt() {
        return this.companyLocationDebt;
    }

    public void setCompanyLocationDebt(float companyLocationDebt) {
        this.companyLocationDebt = companyLocationDebt;
    }

    public float getGuarding() {
        return this.guarding;
    }

    public void setGuarding(float guarding) {
        this.guarding = guarding;
    }

    public float getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(float totalCost) {
        this.totalCost = totalCost;
    }

    public float getTotalInsurance() {
        return this.totalInsurance;
    }

    public void setTotalInsurance(float totalInsurance) {
        this.totalInsurance = totalInsurance;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public Vector<Injured> getInjuried() {
        if (this.injuried == null) {
            this.injuried = Injured.loadList(this.id);
        }
        return this.injuried;
    }

    public void setInjuried(Vector<Injured> injuried) {
        this.injuried = injuried;
    }

    public Vector<Repairing> getRepairing() {
        if (this.repairing == null) {
            this.repairing = Repairing.loadList(this.id);
        }
        return this.repairing;
    }

    public void setRepairing(Vector<Repairing> repairing) {
        this.repairing = repairing;
    }

    public Vector<AccidentAction> getAccidentAction() {
        if (this.accidentAction == null) {
            this.accidentAction = AccidentAction.loadList(this.id);
        }
        return this.accidentAction;
    }

    public void setAccidentAction(Vector<AccidentAction> accidentAction) {
        this.accidentAction = accidentAction;
    }

    private static String getAllFields() {
        return "ID, IDENTIFICATION_NUMBER, INSURANCE_NUMBER, AGENCY_ID, DRIVER_ID, VEHICLE_ID, DAY, PLACE, TYPE, INJURY, STEAL, DESCRIPTION, BIG_DAMAGES, RESPONSABILITY, GARAGE_ID, GARAGE_IN, GARAGE_OUT, TOWING, RC_COST, RC_EXCESS, INSURANCE_RECOURSE, COMPANY_RECOURSE, DAMAGE_EXCESS, VAT, DILAPIDATION, SELF_INSURANCE, EXPERT_COST, FIXING_COST, COMPANY_FIXING_COST, LOCATION_DEBT, COMPANY_LOCATION_DEBT, GUARDING, TOTAL_COST, TOTAL_INSURANCE, OPENED, IN_TRAFFIC, INSURANCE_TYPE, CONVENTION_TYPE, INSURANCE_CODE";
    }

    public static Vector<Accident> loadList(Agence agence, Date begin, Date end) {
        String filters = "";
        if (agence != null) {
            filters = " AND AGENCY_ID = " + agence.getCleAgence();
        }
        if (begin != null) {
            filters = end != null ? String.valueOf(filters) + " AND DAY BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(end, "yyyy-MM-dd"), false) : String.valueOf(filters) + " AND DAY =" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false);
        }
        return Accident.loadList(filters.equals("") ? filters : " WHERE " + filters.substring(5));
    }

    public static Vector<Accident> loadList(Conducteur driver, Vehicule vehicle) {
        String restrict;
        String restriction = "";
        if (driver != null) {
            restriction = String.valueOf(restriction) + " AND DRIVER_ID = " + driver.getCleConducteur();
        }
        if (vehicle != null) {
            restriction = String.valueOf(restriction) + " AND VEHICLE_ID = " + vehicle.getCleVehicule();
        }
        if ((restrict = BddTransport.addNewRestriction(null, true, table, true)) != "") {
            restriction = String.valueOf(restriction) + " AND " + restrict;
        }
        if (!restriction.equals("")) {
            restriction = " WHERE " + restriction.substring(5);
        }
        return Accident.loadList(restriction);
    }

    public static Vector<Accident> loadList(String filters) {
        Vector<Accident> liste = new Vector<Accident>();
        String sql = "SELECT " + Accident.getAllFields() + " FROM " + table;
        sql = String.valueOf(sql) + filters;
        sql = String.valueOf(sql) + " ORDER BY DAY";
        try {
            ResultSet rs = null;
            Statement stm = Accident.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                Accident tmp = new Accident();
                TimsLogger.debug("#Accident.genericLoad# Found id " + rs.getInt("ID"));
                tmp.id = rs.getInt("ID");
                tmp.identificationNumber = rs.getString("IDENTIFICATION_NUMBER");
                tmp.insuranceNumber = rs.getString("INSURANCE_NUMBER");
                tmp.agencyId = rs.getInt("AGENCY_ID");
                tmp.driverId = rs.getInt("DRIVER_ID");
                tmp.vehicleId = rs.getInt("VEHICLE_ID");
                tmp.day = rs.getTimestamp("DAY");
                tmp.place = rs.getString("PLACE");
                tmp.type = rs.getInt("TYPE");
                tmp.injury = rs.getInt("INJURY") == 1;
                tmp.steal = rs.getInt("STEAL") == 1;
                tmp.description = rs.getString("DESCRIPTION");
                tmp.bigDamages = rs.getInt("BIG_DAMAGES") == 1;
                tmp.responsability = rs.getInt("RESPONSABILITY");
                tmp.garageId = rs.getInt("GARAGE_ID");
                tmp.garageIn = rs.getTimestamp("GARAGE_IN");
                tmp.garageOut = rs.getTimestamp("GARAGE_OUT");
                tmp.towing = rs.getInt("TOWING") == 1;
                tmp.rcCost = rs.getFloat("RC_COST");
                tmp.rcExcess = rs.getFloat("RC_EXCESS");
                tmp.insuranceRecourse = rs.getFloat("INSURANCE_RECOURSE");
                tmp.companyRecourse = rs.getFloat("COMPANY_RECOURSE");
                tmp.damageExcess = rs.getFloat("DAMAGE_EXCESS");
                tmp.VAT = rs.getFloat("VAT");
                tmp.dilapidation = rs.getFloat("DILAPIDATION");
                tmp.selfInsurance = rs.getFloat("SELF_INSURANCE");
                tmp.expertCost = rs.getFloat("EXPERT_COST");
                tmp.fixingCost = rs.getFloat("FIXING_COST");
                tmp.companyFixingCost = rs.getFloat("COMPANY_FIXING_COST");
                tmp.locationDebt = rs.getFloat("LOCATION_DEBT");
                tmp.companyLocationDebt = rs.getFloat("COMPANY_LOCATION_DEBT");
                tmp.guarding = rs.getFloat("GUARDING");
                tmp.totalCost = rs.getFloat("TOTAL_COST");
                tmp.totalInsurance = rs.getFloat("TOTAL_INSURANCE");
                tmp.opened = rs.getInt("OPENED") == 1;
                tmp.inTraffic = rs.getInt("IN_TRAFFIC") == 1;
                tmp.insuranceType = rs.getString("INSURANCE_TYPE");
                tmp.conventionType = rs.getString("CONVENTION_TYPE");
                tmp.insuranceCode = rs.getString("INSURANCE_CODE");
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.debug("#loadList()# sql = " + sql + " => " + ex.getMessage());
        }
        return liste;
    }

    public static Vector<Accident> getList() {
        if (list == null) {
            list = Accident.loadList(null, null);
        }
        return list;
    }

    public static void setList(Vector<Accident> list) {
        Accident.list = list;
    }

    public static Accident getAccident(int id) throws DBObjectNotFoundException {
        for (Accident tmp : Accident.getList()) {
            if (tmp.getId() != id) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("Accident");
    }
}

