/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class AccidentAction
extends MainElement {
    public static final String table = "ACCIDENT_ACTION";
    private static Vector<AccidentAction> list = null;
    private int id = 0;
    private int userId = 0;
    private Date insertionDate = null;
    private int accidentId = 0;
    private String purpose = null;

    public AccidentAction() {
    }

    public AccidentAction(int id, int userId, Date day, int accidentId, String purpose) {
        this.id = id;
        this.userId = userId;
        this.insertionDate = day;
        this.accidentId = accidentId;
        this.purpose = purpose;
    }

    public boolean equals(Object o) {
        return o instanceof AccidentAction && this.accidentId == ((AccidentAction)o).getAccidentId() && this.insertionDate.equals(((AccidentAction)o).getInsertionDate()) && this.purpose.equals(((AccidentAction)o).getPurpose());
    }

    public Object clone() {
        return new AccidentAction(this.id, this.userId, this.insertionDate, this.accidentId, this.purpose);
    }

    public String toString() {
        return this.getPurpose();
    }

    public boolean loadByPurpose(String purpose) {
        String sql = "SELECT " + AccidentAction.getAllFields() + " FROM " + table + " WHERE PURPOSE='" + BddTransport.addSlashes(purpose) + "'";
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + AccidentAction.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = AccidentAction.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    TimsLogger.debug("#AccidentAction.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.userId = rs.getInt("USER_ID");
                    this.insertionDate = rs.getDate("INSERTION_DATE");
                    this.accidentId = rs.getInt("ACCIDENT_ID");
                    this.purpose = rs.getString("PURPOSE");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("#genericLoad# sql " + sql + " => " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#AccidentAction.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO ACCIDENT_ACTION (" + AccidentAction.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO ACCIDENT_ACTION (" + AccidentAction.getAllFields().substring(AccidentAction.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?)";
        }
        try {
            this.statement = AccidentAction.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.userId, 4);
            this.statement.setTimestamp(2, new Timestamp(this.insertionDate.getTime()));
            this.statement.setObject(3, (Object)this.accidentId, 4);
            this.statement.setObject(4, (Object)this.purpose, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE ACCIDENT_ACTION SET  USER_ID=? , INSERTION_DATE=? , ACCIDENT_ID=? , PURPOSE=? WHERE ID=?";
        try {
            this.statement = AccidentAction.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.userId, 4);
            this.statement.setDate(2, new java.sql.Date(this.insertionDate.getTime()));
            this.statement.setObject(3, (Object)this.accidentId, 4);
            this.statement.setObject(4, (Object)this.purpose, 12);
            this.statement.setObject(5, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean compareAndUpdate(int userId, Date day, int accidentId, String purpose) {
        String tracer = String.valueOf(LanguageTranslator.getString("accident.action")) + " n\u00b0 " + this.id + " (" + this.getPurpose() + ") \n";
        if (this.userId != userId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.user") + " '" + this.userId + "' => '" + userId + "'\n";
            this.setUserId(userId);
        }
        if (Fonctions.fieldChange(day, this.insertionDate)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.day") + " '" + this.insertionDate + "' => '" + day + "'\n";
            this.setInsertionDate(day);
        }
        if (this.accidentId != accidentId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident") + " '" + this.accidentId + "' => '" + accidentId + "'\n";
            this.setAccidentId(accidentId);
        }
        if (Fonctions.fieldChange(purpose, this.purpose)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.purpose") + " '" + this.purpose + "' => '" + purpose + "'\n";
            this.setPurpose(purpose);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("accident.action")) + " n\u00b0 " + this.id + " (" + this.getPurpose() + ") \n")) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#AccidentAction# no changes");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM ACCIDENT_ACTION WHERE ID=?";
        try {
            try {
                this.statement = AccidentAction.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                toReturn = true;
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), String.valueOf(LanguageTranslator.getString("accident.action")) + " n\u00b0 " + this.id).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getInsertionDate() {
        return this.insertionDate;
    }

    public void setInsertionDate(Date day) {
        this.insertionDate = day;
    }

    public int getAccidentId() {
        return this.accidentId;
    }

    public void setAccidentId(int accidentId) {
        this.accidentId = accidentId;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int garageId) {
        this.userId = garageId;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    private static String getAllFields() {
        return "ID, USER_ID, INSERTION_DATE, ACCIDENT_ID, PURPOSE";
    }

    public static Vector<AccidentAction> loadList(int accidentId) {
        Vector<AccidentAction> liste = new Vector<AccidentAction>();
        String sql = "SELECT " + AccidentAction.getAllFields() + " FROM " + table;
        if (accidentId != 0) {
            sql = String.valueOf(sql) + " WHERE ACCIDENT_ID =" + accidentId;
        }
        sql = String.valueOf(sql) + " ORDER BY INSERTION_DATE";
        try {
            ResultSet rs = null;
            Statement stm = AccidentAction.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                AccidentAction tmp = new AccidentAction(rs.getInt("ID"), rs.getInt("USER_ID"), rs.getDate("INSERTION_DATE"), rs.getInt("ACCIDENT_ID"), rs.getString("PURPOSE"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#loadList()#  sql = " + sql + " => " + ex);
        }
        return liste;
    }

    public static Vector<AccidentAction> getList() {
        if (list == null) {
            list = AccidentAction.loadList(0);
        }
        return list;
    }

    public static void setList(Vector<AccidentAction> list) {
        AccidentAction.list = list;
    }

    public static AccidentAction get(int idType) throws DBObjectNotFoundException {
        for (AccidentAction tmp : AccidentAction.getList()) {
            if (tmp.getId() != idType) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("AccidentAction");
    }
}

