/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Activite;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.exception.ActivityTypeNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class ActiviteConducteur
extends Activite {
    public static final int ACTIVITY = 102;
    public static final int UPDATED_ACTIVITY = 103;
    public static final int CONFLICT_ACTIVITY_BASE = 114;
    public static final int CONFLICT_ACTIVITY_ANALYZE = 115;
    private int cleConducteur = 0;
    private String typeSource = null;
    private String nomSource = null;
    private int cleDisque;
    private int cleAgence;
    private String dateJour;
    private float avgDistance = 0.0f;
    private String table;

    public ActiviteConducteur(String table) {
        this.table = table;
    }

    public ActiviteConducteur(ActiviteConducteur toClone) {
        this.cleActivite = toClone.cleActivite;
        this.cleConducteur = toClone.cleConducteur;
        this.cleAgence = toClone.cleAgence;
        this.cleType = toClone.cleType;
        this.description = toClone.description;
        this.couleur = toClone.couleur;
        this.heureDebut = toClone.heureDebut;
        this.heureFin = toClone.heureFin;
        this.duree = toClone.duree;
        this.dateJour = toClone.dateJour;
        this.etatCarte = toClone.etatCarte;
        this.etatConduite = toClone.etatConduite;
        this.lecteur = toClone.lecteur;
        this.typeSource = toClone.typeSource;
        this.nomSource = toClone.nomSource;
        this.cleDisque = toClone.cleDisque;
        this.modification = toClone.modification;
        this.suppression = toClone.suppression;
    }

    public ActiviteConducteur(int cleActivite, int cleConducteur, int cleAgence, int cleType, String description, String couleur, int heureDebut, int heureFin, int duree, String dateJour, String typeSource, String nomSource, String etatCarte, String etatConduite, String lecteur, int cleDisque, int modification, int suppression) {
        this.cleActivite = cleActivite;
        this.cleConducteur = cleConducteur;
        this.cleAgence = cleAgence;
        this.cleType = cleType;
        this.description = description;
        this.couleur = couleur;
        this.heureDebut = heureDebut;
        this.heureFin = heureFin;
        this.duree = duree;
        this.dateJour = dateJour == "" ? "" : dateJour.substring(0, 10);
        this.etatCarte = etatCarte;
        this.etatConduite = etatConduite;
        this.lecteur = lecteur;
        this.typeSource = typeSource;
        this.nomSource = nomSource;
        this.cleDisque = cleDisque;
        this.modification = modification;
        this.suppression = suppression;
    }

    public ActiviteConducteur(int cleConducteur, int cleAgence, int cleType, String description, int heureDebut, int heureFin, int duree, String dateJour, String typeSource, String nomSource, String etatCarte, String etatConduite, String lecteur, int cleDisque) {
        this.cleConducteur = cleConducteur;
        this.cleAgence = cleAgence;
        this.cleType = cleType;
        this.description = description;
        this.heureDebut = heureDebut;
        this.heureFin = heureFin;
        this.duree = duree;
        this.dateJour = dateJour;
        this.etatCarte = etatCarte;
        this.etatConduite = etatConduite;
        this.lecteur = lecteur;
        this.typeSource = typeSource;
        this.nomSource = nomSource;
        this.cleDisque = cleDisque;
    }

    public ActiviteConducteur(byte[] one, String source, String date, int driverId, int deleted, int updated) {
        this.dateJour = date;
        this.cleConducteur = driverId;
        this.modification = updated;
        this.suppression = deleted;
        this.loadCondensedRepresentation(one);
    }

    public void setActivite(int cleConducteur, int cleAgence, int cleType, String description, int heureDebut, int heureFin, int duree, String dateJour, String typeSource, String nomSource, String etatCarte, String etatConduite, String lecteur, int cleDisque) {
        this.cleConducteur = cleConducteur;
        this.cleAgence = cleAgence;
        this.cleType = cleType;
        this.description = description;
        this.heureDebut = heureDebut;
        this.heureFin = heureFin;
        this.duree = duree;
        this.dateJour = dateJour;
        this.etatCarte = etatCarte;
        this.etatConduite = etatConduite;
        this.lecteur = lecteur;
        this.typeSource = typeSource;
        this.nomSource = nomSource;
        this.cleDisque = cleDisque;
    }

    public boolean equals(Object o) {
        return o instanceof ActiviteConducteur && ((ActiviteConducteur)o).getDate().equals(this.getDate()) && ((ActiviteConducteur)o).getHeureDebut() == this.getHeureDebut() && ((ActiviteConducteur)o).getHeureFin() == this.getHeureFin() && ((ActiviteConducteur)o).getCleType() == this.getCleType() && ((ActiviteConducteur)o).getCleConducteur() == this.getCleConducteur();
    }

    public void affiche() {
        TimsLogger.debug("#ActiviteConducteur.affiche# " + this.dateJour + " " + this.cleType + " " + ConversionTime.heureIntToString(this.heureDebut, "h") + " - " + ConversionTime.heureIntToString(this.heureFin, "h") + " (" + this.duree + ") : modif:" + this.modification + (Transport.debug >= 1 ? " src:" + this.typeSource + "-lect:" + this.lecteur + "-carte:" + this.etatCarte + "-conduite:" + this.etatConduite : ""));
    }

    public int getCleConducteur() {
        return this.cleConducteur;
    }

    public void setCleConducteur(int cleConducteur) {
        this.cleConducteur = cleConducteur;
    }

    public int getCleDisque() {
        return this.cleDisque;
    }

    public void setCleDisque(int cleDisque) {
        this.cleDisque = cleDisque;
    }

    public String getDateJour() {
        return this.dateJour;
    }

    public java.util.Date getDate() {
        return ConversionTime.stringToDate(this.dateJour, "yyyy-MM-dd");
    }

    public void setDateJour(String dateJour) {
        this.dateJour = dateJour;
    }

    public String getNomSource() {
        return this.nomSource;
    }

    public void setNomSource(String nomSource) {
        this.nomSource = nomSource;
    }

    public String getTypeSource() {
        return this.typeSource;
    }

    public void setTypeSource(String typeSource) {
        this.typeSource = typeSource;
    }

    public float getAvgDistance() {
        return this.avgDistance;
    }

    public void setAvgDistance(float avgDistance) {
        this.avgDistance = avgDistance;
    }

    public String getTable() {
        return this.table;
    }

    public boolean insert() {
        if (this.table == null || this.table.equals("")) {
            return false;
        }
        return this.insert(this.table);
    }

    public byte[] getCondensedRepresentation() {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        String activite = Integer.toBinaryString(this.heureDebut + (int)Math.pow(2.0, 11.0)).substring(1);
        activite = String.valueOf(activite) + Integer.toBinaryString(this.heureFin + (int)Math.pow(2.0, 11.0)).substring(1);
        activite = String.valueOf(activite) + Integer.toBinaryString(this.cleType + (int)Math.pow(2.0, 5.0)).substring(1);
        activite = this.typeSource == null ? String.valueOf(activite) + "11" : (LanguageTranslator.getString("generics.disc").equals(this.typeSource) ? String.valueOf(activite) + "00" : ("CAP".equals(this.typeSource) ? String.valueOf(activite) + "01" : (LanguageTranslator.getString("generics.card").equals(this.typeSource) ? String.valueOf(activite) + "01" : (LanguageTranslator.getString("generics.graphic").equals(this.typeSource) ? String.valueOf(activite) + "10" : String.valueOf(activite) + "11"))));
        activite = String.valueOf(activite) + ("CONVOYEUR".equals(this.lecteur) ? "1" : "0");
        activite = String.valueOf(activite) + ("SEUL".equals(this.etatConduite) || "INCONNU".equals(this.etatConduite) ? "0" : "1");
        activite = String.valueOf(activite) + ("INSEREE".equals(this.etatCarte) ? "0" : "1");
        int x = 0;
        while (x < 4) {
            tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
            ++x;
        }
        TimsLogger.debug(String.valueOf(Fonctions.parseHexAscii(tmp.toByteArray(), 0, -1)) + " => " + Fonctions.parseBinaryAscii(tmp.toByteArray(), 0, -1) + " : ");
        return tmp.toByteArray();
    }

    public boolean loadCondensedRepresentation(byte[] buffer) {
        String tmp = "";
        int x = 0;
        while (x < 4) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (buffer[x] < 0 ? buffer[x] + 256 : buffer[x])).substring(1);
            ++x;
        }
        this.heureDebut = Integer.parseInt(tmp.substring(0, 11), 2);
        this.heureFin = Integer.parseInt(tmp.substring(11, 22), 2);
        this.duree = this.heureFin - this.heureDebut;
        this.cleType = Integer.parseInt(tmp.substring(22, 27), 2);
        int source = Integer.parseInt(tmp.substring(27, 29), 2);
        if (source == 0) {
            this.typeSource = LanguageTranslator.getString("generics.disc");
        } else if (source == 1) {
            this.typeSource = LanguageTranslator.getString("generics.card");
        } else if (source == 2) {
            this.typeSource = LanguageTranslator.getString("generics.graphic");
        } else if (source == 3) {
            this.typeSource = LanguageTranslator.getString("generics.auto");
        }
        if (source == 1) {
            this.lecteur = tmp.substring(29, 30).equals("0") ? "CONDUCTEUR" : "CONVOYEUR";
            int eConduite = Integer.parseInt(tmp.substring(30, 31));
            int eCarte = Integer.parseInt(tmp.substring(31, 32));
            this.etatConduite = eCarte == 0 ? (eConduite == 1 ? "EQUIPAGE" : "SEUL") : (eConduite == 1 ? "S. MAN" : "INCONNU");
            this.etatCarte = eCarte == 0 ? "INSEREE" : "NON INSEREE";
        }
        return true;
    }

    public boolean insert(String tableToInsert) {
        boolean toReturn;
        block18: {
            toReturn = false;
            this.table = tableToInsert;
            try {
                this.statement = this.getPreparedStatement();
                this.statement.setObject(1, (Object)this.cleConducteur, 4);
                this.statement.setObject(2, (Object)this.cleType, 4);
                this.statement.setObject(3, (Object)this.heureDebut, 4);
                this.statement.setObject(4, (Object)this.heureFin, 4);
                this.statement.setObject(5, (Object)this.duree, 4);
                this.statement.setObject(6, (Object)this.etatCarte, 12);
                this.statement.setObject(7, (Object)this.typeSource, 12);
                this.statement.setDate(8, Date.valueOf(this.dateJour));
                this.statement.setObject(9, (Object)this.etatConduite, 12);
                this.statement.setObject(10, (Object)this.lecteur, 12);
                this.statement.setObject(11, (Object)this.cleDisque, 4);
                this.statement.setObject(12, (Object)this.nomSource, 12);
                this.statement.setObject(13, (Object)this.modification, 4);
                this.statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(this.table, Constants.ACTION_TYPE.CREATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    break block18;
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
                break block18;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    break block18;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (this.statement != null) {
                            this.statement.close();
                        }
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        TimsLogger.debug("add activity " + this.cleType + " on " + this.dateJour + " (return " + toReturn + ")");
        return toReturn;
    }

    public PreparedStatement getPreparedStatement() {
        if (this.statement == null) {
            String sql = "";
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO " + this.table + " (CLE_ACTIVITE,CLE_CHAUFFEUR,CLE_TYPE_ACTIV,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE," + "ETAT_CARTE,SOURCE,ANNEE_ACTIVITE,ETAT_CONDUITE,LECTEUR,CLE_DISQUE,NOM_SOURCE,MODIFICATION) " + "VALUES (GEN_" + this.table.toUpperCase() + ".nextval,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO " + this.table + " (CLE_CHAUFFEUR,CLE_TYPE_ACTIV,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE," + "ETAT_CARTE,SOURCE,ANNEE_ACTIVITE,ETAT_CONDUITE,LECTEUR,CLE_DISQUE,NOM_SOURCE,MODIFICATION) " + "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }
            try {
                this.statement = ActiviteConducteur.getConnection().prepareStatement(sql);
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
            }
            catch (Exception ex) {
                TimsLogger.error("#ActiviteConducteur.getPreparedStatement# erreur ");
            }
        }
        return this.statement;
    }

    public void closeStatement() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (Exception ex) {
            TimsLogger.error("#ActiviteConducteur.closeStatement# erreur");
        }
    }

    public void update(String table) {
        String sql = "UPDATE " + table + " SET " + "CLE_CHAUFFEUR=? ," + "CLE_TYPE_ACTIV=? ," + "HEURE_DEBUT=? ," + "HEURE_FIN=? ," + "DUREE_EN_MINUTE=? ," + "ETAT_CARTE=? ," + "SOURCE=? ," + "ANNEE_ACTIVITE=? ," + "ETAT_CONDUITE=? ," + "LECTEUR=? ," + "CLE_DISQUE=? ," + "NOM_SOURCE=? ," + "MODIFICATION=? " + "WHERE CLE_ACTIVITE=?";
        try {
            try {
                this.statement = ActiviteConducteur.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleConducteur, 4);
                this.statement.setObject(2, (Object)this.cleType, 4);
                this.statement.setObject(3, (Object)this.heureDebut, 4);
                this.statement.setObject(4, (Object)this.heureFin, 4);
                this.statement.setObject(5, (Object)this.duree, 4);
                this.statement.setObject(6, (Object)this.etatCarte, 12);
                this.statement.setObject(7, (Object)this.typeSource, 12);
                this.statement.setDate(8, Date.valueOf(this.dateJour));
                this.statement.setObject(9, (Object)this.etatConduite, 12);
                this.statement.setObject(10, (Object)this.lecteur, 12);
                this.statement.setObject(11, (Object)this.cleDisque, 4);
                this.statement.setObject(12, (Object)this.nomSource, 12);
                this.statement.setObject(13, (Object)this.modification, 4);
                this.statement.setObject(14, (Object)this.cleActivite, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateModification(String table) {
        String sql = "UPDATE " + table + " SET " + "MODIFICATION=1 " + "WHERE CLE_ACTIVITE=?";
        try {
            this.statement = ActiviteConducteur.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.cleActivite, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(String table) {
        String sql = "DELETE FROM " + table + " WHERE CLE_ACTIVITE=?";
        try {
            try {
                this.statement = ActiviteConducteur.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleActivite, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean isRest() {
        try {
            return TypeActivite.getActivityType(this.cleType).getPaidPercentage() == 0;
        }
        catch (ActivityTypeNotFoundException e) {
            TimsLogger.warn("Activity key " + this.cleType + " not found");
            return true;
        }
    }

    public byte[] write(OutputStream out, int offset) {
        this.affiche();
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = ConversionTime.dateStringToBinary(this.dateJour);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.heureDebut + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.heureFin + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.modification + (int)Math.pow(2.0, 4.0)).substring(1);
            activite = String.valueOf(activite) + this.suppression;
            activite = String.valueOf(activite) + (this.lecteur.equals("CONDUCTEUR") ? "0" : "1");
            activite = String.valueOf(activite) + (this.etatConduite.equals("SEUL") ? "0" : "1");
            activite = String.valueOf(activite) + (this.etatCarte.equals("INSEREE") ? "0" : "1");
            activite = this.cleType < 7 ? String.valueOf(activite) + Integer.toBinaryString(this.cleType + (int)Math.pow(2.0, 3.0)).substring(1) : String.valueOf(activite) + "000";
            activite = this.typeSource.equals(LanguageTranslator.getString("generics.disc")) ? String.valueOf(activite) + "00" : (this.typeSource.equals(LanguageTranslator.getString("generics.card")) ? String.valueOf(activite) + "01" : (this.typeSource.equals(LanguageTranslator.getString("generics.graphic")) ? String.valueOf(activite) + "10" : String.valueOf(activite) + "11"));
            int x = 0;
            while (x < 6) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            if (this.nomSource != null) {
                tmp.write(this.nomSource.getBytes());
            } else {
                tmp.write(0);
            }
            TimsLogger.debug("#ActiviteConducteur.write# toByteArray() " + new String(tmp.toByteArray()));
            out.write((byte)offset);
            out.write((byte)(tmp.toByteArray().length / 255 + 1));
            out.write((byte)tmp.toByteArray().length);
            out.write(tmp.toByteArray());
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#ActiviteConducteur.write# error " + ex.getMessage());
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 6) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            TimsLogger.debug("#ImportConducteur.readActivity#" + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x]) + " => " + tmp.substring(x * 8));
            ++x;
        }
        this.dateJour = ConversionTime.binaryToDateString(tmp);
        this.heureDebut = Integer.parseInt(tmp.substring(13, 24), 2);
        this.heureFin = Integer.parseInt(tmp.substring(24, 35), 2);
        this.duree = this.heureFin - this.heureDebut;
        this.modification = Integer.parseInt(tmp.substring(35, 39), 2);
        this.suppression = Integer.parseInt(tmp.substring(39, 40), 2);
        this.lecteur = tmp.substring(40, 41).equals("0") ? "CONDUCTEUR" : "CONVOYEUR";
        this.etatConduite = tmp.substring(41, 42).equals("0") ? "SEUL" : "EQUIPAGE";
        this.etatCarte = tmp.substring(42, 43).equals("0") ? "INSEREE" : "NON INSEREE";
        this.cleType = Integer.parseInt(tmp.substring(43, 46), 2) == 0 ? 8 : Integer.parseInt(tmp.substring(43, 46), 2);
        this.typeSource = String.valueOf(Integer.parseInt(tmp.substring(46, 48), 2));
        if (new String(fileBuffer).length() > 6) {
            this.nomSource = new String(fileBuffer).substring(6);
        }
    }

    public static byte[] toCondensed(Vector<ActiviteConducteur> tmp) {
        byte[] toReturn = new byte[tmp.size() * 4];
        int offset = 0;
        for (ActiviteConducteur activite : tmp) {
            byte[] activity = activite.getCondensedRepresentation();
            System.arraycopy(activity, 0, toReturn, offset, 4);
            offset += 4;
        }
        return toReturn;
    }

    public static Vector<ActiviteConducteur> fromCondensed(byte[] tmp, Jour from) {
        Vector<ActiviteConducteur> toReturn = new Vector<ActiviteConducteur>();
        float distancePerKm = from.getDriving() == 0 ? 0 : from.getKm() / from.getDriving();
        int x = 0;
        while (x < tmp.length) {
            byte[] one = new byte[4];
            System.arraycopy(tmp, x, one, 0, 4);
            ActiviteConducteur toAdd = new ActiviteConducteur(one, "", from.getDate(), from.getDriverId(), from.isDelete() ? 1 : 0, from.getUpdate());
            if (toAdd.getCleType() == 1) {
                float avgActDistance = distancePerKm / 60.0f * (float)toAdd.getDuree();
                toAdd.setAvgDistance(avgActDistance);
            }
            toReturn.add(toAdd);
            x += 4;
        }
        return toReturn;
    }

    public static Vector<ActiviteConducteur> fromCondensed(byte[] tmp, java.util.Date date, int driverId) {
        return ActiviteConducteur.fromCondensed(tmp, ConversionTime.dateToStringDb(date), driverId, false, 0, 0.0f);
    }

    public static Vector<ActiviteConducteur> fromCondensed(byte[] tmp, String date, int driverId, boolean deleted, int updated, float distancePerKm) {
        Vector<ActiviteConducteur> toReturn = new Vector<ActiviteConducteur>();
        int x = 0;
        while (x < tmp.length) {
            byte[] one = new byte[4];
            System.arraycopy(tmp, x, one, 0, 4);
            ActiviteConducteur toAdd = new ActiviteConducteur(one, "", date, driverId, deleted ? 1 : 0, updated);
            if (toAdd.getCleType() == 1) {
                float avgActDistance = distancePerKm * (float)toAdd.getDuree();
                toAdd.setAvgDistance(avgActDistance);
            }
            toReturn.add(toAdd);
            x += 4;
        }
        return toReturn;
    }

    public boolean isManualInput() {
        return "S. MAN".equals(this.getEtatConduite());
    }
}

