/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class ActivityDetail
extends MainElement {
    public static final String table = "ACTIVITY_DETAIL";
    private int id = 0;
    private Date begin = null;
    private Date end = null;
    private int driverId = 0;
    private int vehicleId = 0;
    private String vehicleRegistration = "";
    private int activityId = 0;
    private float avgKm = 0.0f;

    public ActivityDetail() {
    }

    public ActivityDetail(int id, Date begin, Date end, int driverId, int vehicleId, String vehicle, int activityId, float avgKm) {
        this.id = id;
        this.begin = begin;
        this.end = end;
        this.driverId = driverId;
        this.vehicleId = vehicleId;
        this.vehicleRegistration = vehicle;
        this.activityId = activityId;
        this.avgKm = avgKm;
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#ActivityDetail.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO ACTIVITY_DETAIL (" + ActivityDetail.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO ACTIVITY_DETAIL (" + ActivityDetail.getAllFields().substring(ActivityDetail.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?)";
        }
        try {
            this.statement = ActivityDetail.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.begin, 12);
            this.statement.setObject(2, (Object)this.end, 12);
            this.statement.setObject(3, (Object)this.driverId, 4);
            this.statement.setObject(4, (Object)this.vehicleId, 4);
            this.statement.setObject(5, (Object)this.activityId, 4);
            this.statement.setObject(6, (Object)Float.valueOf(this.avgKm), 6);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public String getSqlString() {
        return String.valueOf(ConversionTime.dateToString(this.getBegin(), "yyyy-MM-dd HH:mm:ss")) + "\t" + ConversionTime.dateToString(this.getEnd(), "yyyy-MM-dd HH:mm:ss") + "\t" + this.getActivityId() + "\t" + this.getDriverId() + "\t" + this.getVehicleId() + "\t" + this.getVehicleRegistration() + "\t" + this.getAvgKm();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getBegin() {
        return this.begin;
    }

    public void setBegin(Date begin) {
        this.begin = begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public String getVehicleRegistration() {
        return this.vehicleRegistration;
    }

    public void setVehicleRegistration(String vehicleRegistration) {
        this.vehicleRegistration = vehicleRegistration;
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int vehicleId) {
        this.vehicleId = vehicleId;
    }

    public int getActivityId() {
        return this.activityId;
    }

    public void setActivityId(int activityId) {
        this.activityId = activityId;
    }

    public float getAvgKm() {
        return this.avgKm;
    }

    public void setAvgKm(int avgKm) {
        this.avgKm = avgKm;
    }

    private static String getAllFields() {
        return "ID, BEGIN, END, ACTIVITY_ID, DRIVER_ID, VEHICLE_ID, VEHICLE_REGISTRATION, AVG_KM";
    }

    public void delete() {
        String sql = "DELETE FROM ACTIVITY_DETAIL WHERE ID=?";
        try {
            this.statement = ActivityDetail.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Vector<ActivityDetail> loadList(boolean archive) {
        Vector<ActivityDetail> liste = new Vector<ActivityDetail>();
        String sql = "SELECT " + ActivityDetail.getAllFields() + " FROM " + table + " WHERE ARCHIVED = " + (archive ? "1" : "0") + " ORDER BY NAME";
        try {
            ResultSet rs = null;
            Statement stm = ActivityDetail.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                ActivityDetail tmp = new ActivityDetail(rs.getInt("ID"), rs.getDate("BEGIN"), rs.getDate("END"), rs.getInt("DRIVER_ID"), rs.getInt("VEHICLE_ID"), rs.getString("VEHICLE_REGISTRATION"), rs.getInt("ACTIVITY_ID"), rs.getFloat("AVG_KM"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("ActionType.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static void deleteAll(int cleConducteur, String sBegin, String sEnd) {
        String sql = "";
        try {
            sql = "DELETE FROM ACTIVITY_DETAIL WHERE DRIVER_ID =" + cleConducteur + " AND BEGIN >= " + BddTransport.getDateStringToSGBDR(sBegin, true) + " AND END <= " + BddTransport.getDateStringToSGBDR(sEnd, true);
            Statement stm = ActivityDetail.getConnection().createStatement();
            stm.executeUpdate(sql);
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#ActivityDetail.delete()# " + ex.getMessage() + " - Erreur sql = " + sql);
        }
    }
}

