/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class AutomaticWarning
extends MainElement {
    public static String table = "automatic_warning";
    public static final int DAILY = 0;
    public static final int WEEKLY = 1;
    public static final int MONTHLY = 2;
    public static final int YEARLY = 3;
    public static String[] LIBELLE = new String[]{LanguageTranslator.getString("frequency.daily"), LanguageTranslator.getString("frequency.weekly"), LanguageTranslator.getString("frequency.monthly"), LanguageTranslator.getString("frequency.yearly")};
    private int id = 0;
    private String name = null;
    private String calculationClass = "NONE";
    private int frequency = 0;
    private int executionDate = 1;

    public AutomaticWarning(int cle, String name, String calculationClass, int frequency, int executionDate) {
        this.id = cle;
        this.name = name;
        this.calculationClass = calculationClass;
        this.frequency = frequency;
        this.executionDate = executionDate;
    }

    public boolean equals(Object obj) {
        return obj instanceof AutomaticWarning && this.id == ((AutomaticWarning)obj).getId() && this.name.equals(((AutomaticWarning)obj).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#EmployeeObligationType.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + table + " (" + AutomaticWarning.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + table + " (" + AutomaticWarning.getAllFields().substring(AutomaticWarning.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?)";
        }
        try {
            this.statement = AutomaticWarning.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.calculationClass, 12);
            this.statement.setObject(3, (Object)this.frequency, 4);
            this.statement.setObject(4, (Object)this.executionDate, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE " + table + " SET " + " NAME=? ," + " CALCULATION_CLASS=? ," + " FREQUENCY=?," + " EXECUTION_DATE=?" + " WHERE ID=?";
        try {
            this.statement = AutomaticWarning.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.calculationClass, 12);
            this.statement.setObject(3, (Object)this.frequency, 4);
            this.statement.setObject(4, (Object)this.frequency, 4);
            this.statement.setObject(5, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean compareAndUpdate(String name, String calculationClass, int frequency, int executionDate) {
        String tracer = String.valueOf(LanguageTranslator.getString("automatic")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n";
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (Fonctions.fieldChange(calculationClass, this.calculationClass)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.class") + " '" + this.calculationClass + "' => '" + calculationClass + "'\n";
            this.setCalculationClass(name);
        }
        if (frequency != this.frequency) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.frequency") + " '" + this.frequency + "' => '" + frequency + "'\n";
            this.setFrequency(frequency);
        }
        if (executionDate != this.executionDate) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.executionDate") + " '" + this.executionDate + "' => '" + executionDate + "'\n";
            this.setExecutionDate(executionDate);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("automatic")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n")) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#Automaticwarning# no changes");
        return true;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCalculationClass() {
        return this.calculationClass;
    }

    public void setCalculationClass(String calculationClass) {
        this.calculationClass = calculationClass;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(int executionDate) {
        this.executionDate = executionDate;
    }

    public void print() {
        TimsLogger.info("#AutomaticWarning.print# id = " + this.id + ", name = " + this.name + ", calculationClass = " + this.calculationClass);
    }

    private static String getAllFields() {
        return "ID, NAME, CALCULATION_CLASS, FREQUENCY, EXECUTION_DATE";
    }

    public static Vector<AutomaticWarning> loadList(int companyId) {
        Vector<AutomaticWarning> list = new Vector<AutomaticWarning>();
        String sql = "SELECT " + AutomaticWarning.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table;
        if (companyId != 0) {
            sql = String.valueOf(sql) + " WHERE ID IN (SELECT ID_WARNING FROM " + BddTransport.getBaseDefault(true) + "COMPANY_WARNING_ACTIVATION" + " WHERE ID_COMPANY = " + companyId + ")";
        }
        try {
            ResultSet rs = null;
            Statement stm = AutomaticWarning.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                AutomaticWarning tmp = new AutomaticWarning(rs.getInt("ID"), rs.getString("NAME"), rs.getString("CALCULATION_CLASS"), rs.getInt("FREQUENCY"), rs.getInt("EXECUTION_DATE"));
                list.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#loadList() # sql = " + sql + " => " + ex.getMessage());
        }
        return list;
    }

    public static Vector<AutomaticWarning> loadUserList(int userId) {
        Vector<AutomaticWarning> list = new Vector<AutomaticWarning>();
        String sql = "SELECT " + AutomaticWarning.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table;
        if (userId != 0) {
            sql = String.valueOf(sql) + " WHERE ID IN (SELECT ID_WARNING FROM " + BddTransport.getBaseDefault(true) + "USER_WARNING_ACTIVATION" + " WHERE ID_USER = " + userId + ")";
        }
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = AutomaticWarning.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                AutomaticWarning tmp = new AutomaticWarning(rs.getInt("ID"), rs.getString("NAME"), rs.getString("CALCULATION_CLASS"), rs.getInt("FREQUENCY"), rs.getInt("EXECUTION_DATE"));
                list.add(tmp);
            }
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate automatic warning user ", "#AutomaticWarning.loadUserList() => %s# sql = " + sql, 1);
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#loadUserList() # sql = " + sql + " => " + ex.getMessage());
        }
        return list;
    }

    public static String getFrequencyWording(int id) {
        return LIBELLE[id];
    }

    public static int getFrequencyWording(String word) {
        if (word.equals(LanguageTranslator.getString("frequency.daily"))) {
            return 0;
        }
        if (word.equals(LanguageTranslator.getString("frequency.weekly"))) {
            return 1;
        }
        if (word.equals(LanguageTranslator.getString("frequency.monthly"))) {
            return 2;
        }
        if (word.equals(LanguageTranslator.getString("frequency.yearly"))) {
            return 3;
        }
        return 0;
    }
}

