/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class CompanyAction
extends MainElement {
    public static final String table = String.valueOf(BddTransport.getBaseDefault(true)) + "COMPANY_ACTION";
    private static Vector<CompanyAction> list = null;
    private int id = 0;
    private int companyId = 0;
    private Date date = null;
    private int stateId = 0;
    private int managerId = 0;
    private int productId = 0;
    private int actionTypeId = 0;
    private int priorityId = 0;
    private int contactId = 0;
    private String problem = null;
    private String solve = null;
    private int lengthTel = 0;
    private int lengthInterv = 0;
    private float cost = 0.0f;

    public CompanyAction() {
    }

    public CompanyAction(int id, int companyId, Date date, int state, int manager, int product, int action, int priority, int contact, String problem, String solve, int lengthTel, int lengthInterv, float cost) {
        this.id = id;
        this.companyId = companyId;
        this.date = date;
        this.stateId = state;
        this.managerId = manager;
        this.productId = product;
        this.actionTypeId = action;
        this.priorityId = priority;
        this.contactId = contact;
        this.problem = problem;
        this.solve = solve;
        this.lengthTel = lengthTel;
        this.lengthInterv = lengthInterv;
        this.cost = cost;
    }

    public String toString() {
        return String.valueOf(this.getId()) + " " + this.getDate();
    }

    public boolean loadByCompany(int companyId) {
        String sql = "SELECT " + CompanyAction.getAllFields() + " FROM " + table + " WHERE COMPANY_ID=" + companyId;
        return this.genericLoad(sql);
    }

    public boolean loadById(int id) {
        String sql = "SELECT " + CompanyAction.getAllFields() + " FROM " + table + " WHERE ID=" + id;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = CompanyAction.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#CompanyAction.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#Garage.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.companyId = rs.getInt("COMPANY_ID");
                    this.date = rs.getDate("ACTION_DATE");
                    this.stateId = rs.getInt("STATE_ID");
                    this.managerId = rs.getInt("MANAGER_ID");
                    this.productId = rs.getInt("PRODUCT_ID");
                    this.actionTypeId = rs.getInt("ACTION_TYPE_ID");
                    this.priorityId = rs.getInt("PRIORITY_ID");
                    this.contactId = rs.getInt("CONTACT_ID");
                    this.problem = rs.getString("PROBLEM");
                    this.solve = rs.getString("SOLVE");
                    this.lengthTel = rs.getInt("LENGTH_TEL");
                    this.lengthInterv = rs.getInt("LENGTH_INTERV");
                    this.cost = rs.getFloat("COST");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#CompanyAction.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#CompanyAction.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + table + " (" + CompanyAction.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + table + " (" + CompanyAction.getAllFields().substring(CompanyAction.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = CompanyAction.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.companyId, 4);
                this.statement.setTimestamp(2, new Timestamp(this.date.getTime()));
                this.statement.setObject(3, (Object)this.stateId, 4);
                this.statement.setObject(4, (Object)this.managerId, 4);
                this.statement.setObject(5, (Object)this.productId, 4);
                this.statement.setObject(6, (Object)this.actionTypeId, 4);
                this.statement.setObject(7, (Object)this.priorityId, 4);
                this.statement.setObject(8, (Object)this.contactId, 4);
                this.statement.setObject(9, (Object)this.problem, 12);
                this.statement.setObject(10, (Object)this.solve, 12);
                this.statement.setObject(11, (Object)this.lengthTel, 4);
                this.statement.setObject(12, (Object)this.lengthInterv, 4);
                this.statement.setObject(13, (Object)Float.valueOf(this.cost), 6);
                this.statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE " + table + " SET " + " COMPANY_ID=? ," + " ACTION_DATE=? ," + " STATE_ID=? ," + " MANAGER_ID=? ," + " PRODUCT_ID=? ," + " ACTION_TYPE_ID=? ," + " PRIORITY_ID=? ," + " CONTACT_ID=? ," + " PROBLEM=?, " + " SOLVE=?, " + " LENGTH_TEL=? ," + " LENGTH_INTERV=? ," + " COST=? " + " WHERE ID=?";
        try {
            this.statement = CompanyAction.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.companyId, 4);
            this.statement.setTimestamp(2, new Timestamp(this.date.getTime()));
            this.statement.setObject(3, (Object)this.stateId, 4);
            this.statement.setObject(4, (Object)this.managerId, 4);
            this.statement.setObject(5, (Object)this.productId, 4);
            this.statement.setObject(6, (Object)this.actionTypeId, 4);
            this.statement.setObject(7, (Object)this.priorityId, 4);
            this.statement.setObject(8, (Object)this.contactId, 4);
            this.statement.setObject(9, (Object)this.problem, 12);
            this.statement.setObject(10, (Object)this.solve, 12);
            this.statement.setObject(11, (Object)this.lengthTel, 4);
            this.statement.setObject(12, (Object)this.lengthInterv, 4);
            this.statement.setObject(13, (Object)Float.valueOf(this.cost), 6);
            this.statement.setObject(14, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean compareAndUpdate(int companyId, Date date, int stateId, int managerId, int productId, int actionTypeId, int priorityId, int contactId, String problem, String solve, int lengthTel, int lengthInterv, float cost) {
        String idS;
        String tracer = idS = String.valueOf(LanguageTranslator.getString("generics.companyAction")) + " n\u00b0 " + this.id + " (" + this.getDate() + "," + this.getCompanyId() + ") \n";
        if (this.companyId != companyId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.company") + " '" + this.companyId + "' => '" + companyId + "'\n";
            this.setCompanyId(companyId);
        }
        if (Fonctions.fieldChange(date, this.date)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.date") + " '" + this.date + "' => '" + date + "'\n";
            this.setDate(date);
        }
        if (this.stateId != stateId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.state") + " '" + this.stateId + "' => '" + stateId + "'\n";
            this.setStateId(stateId);
        }
        if (this.managerId != managerId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.manager") + " '" + this.managerId + "' => '" + managerId + "'\n";
            this.setManagerId(managerId);
        }
        if (this.productId != productId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.product") + " '" + this.productId + "' => '" + productId + "'\n";
            this.setProductId(productId);
        }
        if (this.actionTypeId != actionTypeId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.action") + " '" + this.actionTypeId + "' => '" + actionTypeId + "'\n";
            this.setActionTypeId(actionTypeId);
        }
        if (this.priorityId != priorityId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.priority") + " '" + this.priorityId + "' => '" + priorityId + "'\n";
            this.setPriorityId(priorityId);
        }
        if (this.contactId != contactId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.contact") + " '" + this.contactId + "' => '" + contactId + "'\n";
            this.setContactId(contactId);
        }
        if (Fonctions.fieldChange(problem, this.problem)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.problem") + " '" + this.problem + "' => '" + problem + "'\n";
            this.setProblem(problem);
        }
        if (Fonctions.fieldChange(solve, this.solve)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.solve") + " '" + this.solve + "' => '" + solve + "'\n";
            this.setSolve(solve);
        }
        if (this.lengthTel != lengthTel) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.lengthTel") + " '" + this.lengthTel + "' => '" + lengthTel + "'\n";
            this.setLengthTel(lengthTel);
        }
        if (this.lengthInterv != lengthInterv) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.lengthInterv") + " '" + this.lengthInterv + "' => '" + lengthInterv + "'\n";
            this.setLengthInterv(lengthInterv);
        }
        if (this.cost != cost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.cost") + " '" + this.cost + "' => '" + cost + "'\n";
            this.setCost(cost);
        }
        if (!tracer.equals(idS)) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#CompanyAction# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM " + table + " WHERE ID=?";
        try {
            this.statement = CompanyAction.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(int companyId) {
        this.companyId = companyId;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getStateId() {
        return this.stateId;
    }

    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    public int getManagerId() {
        return this.managerId;
    }

    public void setManagerId(int managerId) {
        this.managerId = managerId;
    }

    public int getProductId() {
        return this.productId;
    }

    public void setProductId(int productId) {
        this.productId = productId;
    }

    public int getActionTypeId() {
        return this.actionTypeId;
    }

    public void setActionTypeId(int actionTypeId) {
        this.actionTypeId = actionTypeId;
    }

    public int getPriorityId() {
        return this.priorityId;
    }

    public void setPriorityId(int priorityId) {
        this.priorityId = priorityId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public void setContactId(int contactId) {
        this.contactId = contactId;
    }

    public String getProblem() {
        return this.problem;
    }

    public void setProblem(String problem) {
        this.problem = problem;
    }

    public String getSolve() {
        return this.solve;
    }

    public void setSolve(String solve) {
        this.solve = solve;
    }

    public int getLengthTel() {
        return this.lengthTel;
    }

    public void setLengthTel(int lengthTel) {
        this.lengthTel = lengthTel;
    }

    public int getLengthInterv() {
        return this.lengthInterv;
    }

    public void setLengthInterv(int lengthInterv) {
        this.lengthInterv = lengthInterv;
    }

    public float getCost() {
        return this.cost;
    }

    public void setCost(float cost) {
        this.cost = cost;
    }

    private static String getAllFields() {
        return "ID, COMPANY_ID, ACTION_DATE, STATE_ID, MANAGER_ID, PRODUCT_ID, ACTION_TYPE_ID, PRIORITY_ID, CONTACT_ID, PROBLEM, SOLVE, LENGTH_TEL, LENGTH_INTERV, COST";
    }

    public static Vector<CompanyAction> loadList(int companyId, int managerId, int actionTypeId, int stateId, int productId, int contactId, int priorityId, Date begin, Date end) {
        Vector<CompanyAction> liste = new Vector<CompanyAction>();
        String sql = "SELECT " + CompanyAction.getAllFields() + " FROM " + table;
        String restrictions = "";
        if (companyId != 0 && companyId != -1) {
            restrictions = String.valueOf(restrictions) + " AND COMPANY_ID = " + companyId;
        }
        if (managerId != 0 && managerId != -1) {
            restrictions = String.valueOf(restrictions) + " AND MANAGER_ID = " + managerId;
        }
        if (actionTypeId != 0 && actionTypeId != -1) {
            restrictions = String.valueOf(restrictions) + " AND ACTION_TYPE_ID = " + actionTypeId;
        }
        if (stateId != 0 && stateId != -1) {
            restrictions = String.valueOf(restrictions) + " AND STATE_ID = " + stateId;
        }
        if (productId != 0 && productId != -1) {
            restrictions = String.valueOf(restrictions) + " AND PRODUCT_ID = " + productId;
        }
        if (contactId != 0 && contactId != -1) {
            restrictions = String.valueOf(restrictions) + " AND CONTACT_ID = " + contactId;
        }
        if (priorityId != 0 && priorityId != -1) {
            restrictions = String.valueOf(restrictions) + " AND PRIORITY_ID = " + priorityId;
        }
        if (begin != null) {
            restrictions = end == null ? String.valueOf(restrictions) + " AND DATE(ACTION_DATE) = '" + ConversionTime.dateToString(begin, "yyyy-MM-dd") + "'" : String.valueOf(restrictions) + " AND ACTION_DATE BETWEEN '" + ConversionTime.dateToString(begin, "yyyy-MM-dd") + "' AND '" + ConversionTime.dateToString(end, "yyyy-MM-dd") + "'";
        }
        if (!restrictions.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + restrictions.substring(5);
            TimsLogger.debug("sql += " + sql);
        }
        sql = String.valueOf(sql) + " ORDER BY ACTION_DATE";
        try {
            ResultSet rs = null;
            Statement stm = CompanyAction.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                CompanyAction tmp = new CompanyAction(rs.getInt("ID"), rs.getInt("COMPANY_ID"), rs.getTimestamp("ACTION_DATE"), rs.getInt("STATE_ID"), rs.getInt("MANAGER_ID"), rs.getInt("PRODUCT_ID"), rs.getInt("ACTION_TYPE_ID"), rs.getInt("PRIORITY_ID"), rs.getInt("CONTACT_ID"), rs.getString("PROBLEM"), rs.getString("SOLVE"), rs.getInt("LENGTH_TEL"), rs.getInt("LENGTH_INTERV"), rs.getFloat("COST"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("CompanyAction.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<CompanyAction> loadList(String companyRegex, int managerId, int actionTypeId, int stateId, int productId, int contactId, int priorityId, Date begin, Date end) {
        Vector<CompanyAction> liste = new Vector<CompanyAction>();
        String sql = "SELECT " + CompanyAction.getAllFields() + " FROM " + table;
        String restrictions = "";
        if (companyRegex != null && !companyRegex.equals("")) {
            restrictions = String.valueOf(restrictions) + " AND COMPANY_ID IN (SELECT ID FROM " + BddTransport.getBaseDefault(true) + "ICONTACT_COMPANY WHERE NAME LIKE \"%" + companyRegex + "%\")";
        }
        if (managerId != 0 && managerId != -1) {
            restrictions = String.valueOf(restrictions) + " AND MANAGER_ID = " + managerId;
        }
        if (actionTypeId != 0 && actionTypeId != -1) {
            restrictions = String.valueOf(restrictions) + " AND ACTION_TYPE_ID = " + actionTypeId;
        }
        if (stateId != 0 && stateId != -1) {
            restrictions = String.valueOf(restrictions) + " AND STATE_ID = " + stateId;
        }
        if (productId != 0 && productId != -1) {
            restrictions = String.valueOf(restrictions) + " AND PRODUCT_ID = " + productId;
        }
        if (contactId != 0 && contactId != -1) {
            restrictions = String.valueOf(restrictions) + " AND CONTACT_ID = " + contactId;
        }
        if (priorityId != 0 && priorityId != -1) {
            restrictions = String.valueOf(restrictions) + " AND PRIORITY_ID = " + priorityId;
        }
        if (begin != null) {
            restrictions = end == null ? String.valueOf(restrictions) + " AND DATE(ACTION_DATE) = '" + ConversionTime.dateToString(begin, "yyyy-MM-dd") + "'" : String.valueOf(restrictions) + " AND ACTION_DATE BETWEEN '" + ConversionTime.dateToString(begin, "yyyy-MM-dd") + "' AND '" + ConversionTime.dateToString(end, "yyyy-MM-dd") + "'";
        }
        if (!restrictions.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + restrictions.substring(5);
            TimsLogger.debug("sql += " + sql);
        }
        sql = String.valueOf(sql) + " ORDER BY ACTION_DATE";
        try {
            ResultSet rs = null;
            Statement stm = CompanyAction.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                CompanyAction tmp = new CompanyAction(rs.getInt("ID"), rs.getInt("COMPANY_ID"), rs.getTimestamp("ACTION_DATE"), rs.getInt("STATE_ID"), rs.getInt("MANAGER_ID"), rs.getInt("PRODUCT_ID"), rs.getInt("ACTION_TYPE_ID"), rs.getInt("PRIORITY_ID"), rs.getInt("CONTACT_ID"), rs.getString("PROBLEM"), rs.getString("SOLVE"), rs.getInt("LENGTH_TEL"), rs.getInt("LENGTH_INTERV"), rs.getFloat("COST"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("CompanyAction.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }
}

