/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ElementArbre;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.MultiBoxItem;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.exception.DriverNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;

public class Conducteur
extends MainElement
implements ElementArbre,
MultiBoxItem {
    public static final String table = "t_conducteur";
    public static final int PHOTO_HEIGHT = 100;
    public static final int PHOTO_WIDTH = 100;
    public static final int OFFSET = 101;
    public static final int STATUS_ORANGE = 15;
    public static final int STATUS_ROUGE = 25;
    public static final int TYPE_INCONNU = 0;
    public static final int TYPE_GR = 1;
    public static final int TYPE_ZC = 2;
    public static final int TYPE_ME = 3;
    public static final int UNKOWN = 0;
    public static final int DISTRIBUTION = 1;
    public static final int TRACTION = 2;
    public static final int LOCATION = 3;
    public static Vector<Conducteur> fullList = null;
    private int cleConducteur = 0;
    private int cleAgence = 0;
    private int cleTypeContrat = 0;
    private String nom = null;
    private String prenom = null;
    private int cleTypePersonnel = 0;
    private int cleTypeConducteur = 0;
    private int nightDay = 0;
    private String matricule = null;
    private String key = null;
    private float taux = 0.0f;
    private String dateNaissance = null;
    private String lieuNaissance = null;
    private String numeroImport = null;
    private String numeroCarte = null;
    private int memberState = 0;
    private int replacement = 0;
    private int renewal = 0;
    private boolean renewalPending = false;
    private String adresse = null;
    private String codePostal = null;
    private String ville = null;
    private float latitude = 0.0f;
    private float longitude = 0.0f;
    private String tel1 = null;
    private String tel2 = null;
    private String tel3 = null;
    private String email = null;
    private String dateEntree = null;
    private String dateSortie = null;
    private String dateVisite = null;
    private String dateDebutValiditeCarte = ConversionTime.dateFromFranceToBDD("", false);
    private String dateFinValiditeCarte = ConversionTime.dateFromFranceToBDD("", false);
    private int prime = 0;
    private String numSecuriteSociale = null;
    private int calendarId = 0;
    private boolean nightWorker = false;
    private String fimoFco = null;
    private String quaCardNumber = null;
    private String dernierCalculBrut = null;
    private String dernierCalculModifie = null;
    private String dernierChangement = null;
    private String dernierTelechargement = null;
    private String lastExport = null;
    private int externalId = 0;
    private int analyticCodeId = 0;
    private float targetConsumption = 0.0f;
    private int payPeriodType = 0;
    private String numeroPermis;
    private String dateVisitePermis;
    private String BDelivery = null;
    private String CDelivery = null;
    private String CEDelivery = null;
    private String DDelivery = null;
    private String DEDelivery = null;
    private String adr = null;
    private String caces = null;
    private int ioCounter = 0;
    private int daySinceLastDownload = 0;
    private int archive = 0;
    private boolean expensesAllowance = false;

    public Conducteur() {
    }

    public Conducteur(int cleConducteur) {
        this.loadById(cleConducteur);
    }

    public Conducteur(int cleConducteur, String nomConducteur, String prenomConducteur) {
        this.cleConducteur = cleConducteur;
        this.nom = nomConducteur;
        this.prenom = prenomConducteur;
    }

    public Conducteur(int cleConducteur, String nomConducteur, String prenomConducteur, String dernierCalculBrut, String dernierCalculModifie, int cleTypeConducteur) {
        this.cleConducteur = cleConducteur;
        this.dernierCalculBrut = dernierCalculBrut;
        this.dernierCalculModifie = dernierCalculModifie;
        this.cleTypeConducteur = cleTypeConducteur;
        this.nom = nomConducteur;
        this.prenom = prenomConducteur;
    }

    public Conducteur(int cleConducteur, String nom, String prenom, String dernierChangement) {
        this.cleConducteur = cleConducteur;
        this.nom = nom;
        this.prenom = prenom;
        this.dernierChangement = dernierChangement;
    }

    public Conducteur(int cleConducteur, int cleAgence, String nom, String prenom, String dernierChangement) {
        this.cleConducteur = cleConducteur;
        this.cleAgence = cleConducteur;
        this.nom = nom;
        this.prenom = prenom;
        this.dernierChangement = dernierChangement;
    }

    public Conducteur(int cleConducteur, int cleAgence, String nom, String prenom, String numeroImport, String numeroCarte, String dateSortie, String dernierCalculBrut, String dernierCalculModifie) {
        this.cleConducteur = cleConducteur;
        this.cleAgence = cleAgence;
        this.nom = nom;
        this.prenom = prenom;
        this.numeroImport = numeroImport;
        this.numeroCarte = numeroCarte;
        this.dateSortie = dateSortie;
        this.dernierCalculBrut = dernierCalculBrut;
        this.dernierCalculModifie = dernierCalculModifie;
    }

    public Conducteur(String nom, String prenom) {
        this.loadByName(nom, prenom);
    }

    public Conducteur(int cle, String nom, String prenom, String dernierTelechargement, boolean archive, String matricule) {
        this.cleConducteur = cle;
        this.archive = archive ? 1 : 0;
        this.nom = nom;
        this.prenom = prenom;
        this.matricule = matricule;
        this.dernierTelechargement = dernierTelechargement;
    }

    public String toString() {
        return String.valueOf(this.nom) + "   " + this.prenom + (this.matricule != null && !this.matricule.equals("") ? " - " + this.matricule : "");
    }

    @Override
    public String getLibelle() {
        return String.valueOf(this.nom) + "   " + this.prenom + (this.matricule != null && !this.matricule.equals("") ? " - " + this.matricule : "");
    }

    @Override
    public int getStatus() {
        if (this.archive == 1) {
            return 5;
        }
        if (this.dernierTelechargement != null && !this.dernierTelechargement.startsWith("1970-01-01") && !this.dernierTelechargement.equals("")) {
            String day = ConversionTime.dateToString(new java.util.Date(), "yyyy-MM-dd");
            int numberOfDaySinceLastDownload = ConversionTime.getNbJourBetween(this.dernierTelechargement, day, "yyyy-MM-dd");
            if (numberOfDaySinceLastDownload > Integer.parseInt(System.getProperty("driver.orange.threshold", String.valueOf(15)))) {
                if (numberOfDaySinceLastDownload > Integer.parseInt(System.getProperty("driver.red.threshold", String.valueOf(25)))) {
                    return 2;
                }
                return 1;
            }
            return 0;
        }
        return 4;
    }

    @Override
    public boolean isArchive() {
        return this.archive == 1;
    }

    @Override
    public int getId() {
        return this.getCleConducteur();
    }

    @Override
    public int getCle() {
        return this.getCleConducteur();
    }

    @Override
    public String getCode() {
        return this.getMatricule();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Conducteur && ((Conducteur)object).getNom().equals(this.nom) && ((Conducteur)object).getPrenom().equals(this.prenom) && ((Conducteur)object).getCle() == this.cleConducteur;
    }

    public int hashCode() {
        int hash = 2;
        hash = 31 * hash + (this.nom != null ? this.nom.hashCode() : 0);
        hash = 31 * hash + (this.prenom != null ? this.prenom.hashCode() : 0);
        return hash;
    }

    /*
     * Loose catch block
     */
    public boolean insert() {
        boolean retour = false;
        String sql = "";
        TimsLogger.debug("#Conducteur.insert()");
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO t_conducteur (CLE_CHAUFFEUR, TAUX_HORAIRE, DATE_NAISSANCE, LIEU_NAISSANCE,  CLE_AGENCE, CLE_TYPE_PAYE, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, MATRICULE_CHAUFFEUR, NUM_CARTE_CHAUFFEUR, MEMBER_STATE, REPLACEMENT, RENEWAL, NUM_IMPORT_CHAUFFEUR, ADRESSE, CODE_POSTAL, VILLE, LATITUDE, LONGITUDE, TEL1, TEL2, TEL3, EMAIL, DATE_ENTREE_SOCIETE, DATE_DERNIERE_VISITE_MEDICALE, TYPE_CONDUCTEUR, NUM_SECURITE_SOCIALE, CLE_TYPE_CHAUFFEUR, CALENDAR_ID, LOGO, DATE_DEBUT_VALIDITE_CARTE, DATE_EXPIRATION_CARTE, DATE_DERNIER_CHANGEMENT, DATE_DERNIER_TELECHARGEMENT, DATE_SORTIE, FIMO_FCO, QUALIFICATION_CARD_NUMBER, TRAVAIL_NUIT, DALLAS_KEY_ID, NIGHT_DAY, NUMERO_PERMIS, DATE_DELIVRANCE_PERMIS, DATE_VISITE_PERMIS, B_DELIVERY, C_DELIVERY, CE_DELIVERY, D_DELIVERY, DE_DELIVERY, ADR, CACES, LAST_EXPORT, TRAGEO_ID, ANALYTIC_CODE_ID, RENEWAL_PENDING, CONSUMPTION_TARGET, PAY_PERIOD_TYPE, EXPENSES_ALLOWANCE)  VALUES (GEN_T_CONDUCTEUR.nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    this.statement = Conducteur.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO t_conducteur (TAUX_HORAIRE, DATE_NAISSANCE, LIEU_NAISSANCE, CLE_AGENCE, CLE_TYPE_PAYE, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, MATRICULE_CHAUFFEUR, NUM_CARTE_CHAUFFEUR, MEMBER_STATE, REPLACEMENT, RENEWAL,  NUM_IMPORT_CHAUFFEUR, ADRESSE, CODE_POSTAL, VILLE, LATITUDE, LONGITUDE, TEL1, TEL2, TEL3, EMAIL, DATE_ENTREE_SOCIETE, DATE_DERNIERE_VISITE_MEDICALE, TYPE_CONDUCTEUR, NUM_SECURITE_SOCIALE, CLE_TYPE_CHAUFFEUR, CALENDAR_ID, LOGO, DATE_DEBUT_VALIDITE_CARTE, DATE_EXPIRATION_CARTE, DATE_DERNIER_CHANGEMENT, DATE_DERNIER_TELECHARGEMENT, DATE_SORTIE, FIMO_FCO, QUALIFICATION_CARD_NUMBER, TRAVAIL_NUIT, DALLAS_KEY_ID, NIGHT_DAY, NUMERO_PERMIS,  DATE_VISITE_PERMIS, B_DELIVERY, C_DELIVERY, CE_DELIVERY, D_DELIVERY, DE_DELIVERY, ADR, CACES, LAST_EXPORT, TRAGEO_ID,  ANALYTIC_CODE_ID, RENEWAL_PENDING, CONSUMPTION_TARGET, PAY_PERIOD_TYPE, EXPENSES_ALLOWANCE)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    this.statement = Conducteur.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)Float.valueOf(this.taux), 6);
                this.statement.setDate(2, Date.valueOf(Conducteur.getDateToSGBD(this.dateNaissance)));
                this.statement.setObject(3, (Object)this.lieuNaissance, 12);
                this.statement.setObject(4, (Object)this.cleAgence, 4);
                this.statement.setObject(5, (Object)this.cleTypeContrat, 4);
                this.statement.setObject(6, (Object)this.nom, 12);
                this.statement.setObject(7, (Object)this.prenom, 12);
                this.statement.setObject(8, (Object)this.matricule, 12);
                this.statement.setObject(9, (Object)this.numeroCarte, 12);
                this.statement.setObject(10, (Object)this.memberState, 4);
                this.statement.setObject(11, (Object)this.replacement, 4);
                this.statement.setObject(12, (Object)this.renewal, 4);
                this.statement.setObject(13, (Object)this.numeroImport, 12);
                this.statement.setObject(14, (Object)this.adresse, 12);
                this.statement.setObject(15, (Object)this.codePostal, 12);
                this.statement.setObject(16, (Object)this.ville, 12);
                this.statement.setObject(17, (Object)Float.valueOf(this.latitude), 6);
                this.statement.setObject(18, (Object)Float.valueOf(this.longitude), 6);
                this.statement.setObject(19, (Object)this.tel1, 12);
                this.statement.setObject(20, (Object)this.tel2, 12);
                this.statement.setObject(21, (Object)this.tel3, 12);
                this.statement.setObject(22, (Object)this.email, 12);
                this.statement.setDate(23, Date.valueOf(Conducteur.getDateToSGBD(this.dateEntree)));
                this.statement.setDate(24, Date.valueOf(Conducteur.getDateToSGBD(this.dateVisite)));
                this.statement.setObject(25, (Object)this.cleTypeConducteur, 4);
                this.statement.setObject(26, (Object)this.numSecuriteSociale, 12);
                this.statement.setObject(27, (Object)this.cleTypePersonnel, 4);
                this.statement.setObject(28, (Object)this.calendarId, 4);
                this.statement.setObject(29, (Object)"", 12);
                this.statement.setDate(30, Date.valueOf(Conducteur.getDateToSGBD(this.dateDebutValiditeCarte)));
                this.statement.setDate(31, Date.valueOf(Conducteur.getDateToSGBD(this.dateFinValiditeCarte)));
                this.statement.setTimestamp(32, Timestamp.valueOf(Conducteur.getTimestampToSGBD(this.dernierChangement)));
                this.statement.setTimestamp(33, Timestamp.valueOf(Conducteur.getTimestampToSGBD(this.dernierTelechargement)));
                this.statement.setDate(34, Date.valueOf(Conducteur.getDateToSGBD(this.dateSortie)));
                this.statement.setDate(35, Date.valueOf(Conducteur.getDateToSGBD(this.fimoFco)));
                this.statement.setObject(36, (Object)this.quaCardNumber, 12);
                this.statement.setObject(37, (Object)(this.nightWorker ? 1 : 0), 4);
                this.statement.setObject(38, (Object)this.key, 12);
                this.statement.setObject(39, (Object)this.nightDay, 4);
                this.statement.setObject(40, (Object)this.numeroPermis, 12);
                this.statement.setDate(41, Date.valueOf(Conducteur.getDateToSGBD(this.dateVisitePermis)));
                this.statement.setDate(42, Date.valueOf(Conducteur.getDateToSGBD(this.BDelivery)));
                this.statement.setDate(43, Date.valueOf(Conducteur.getDateToSGBD(this.CDelivery)));
                this.statement.setDate(44, Date.valueOf(Conducteur.getDateToSGBD(this.CEDelivery)));
                this.statement.setDate(45, Date.valueOf(Conducteur.getDateToSGBD(this.DDelivery)));
                this.statement.setDate(46, Date.valueOf(Conducteur.getDateToSGBD(this.DEDelivery)));
                this.statement.setDate(47, Date.valueOf(Conducteur.getDateToSGBD(this.adr)));
                this.statement.setDate(48, Date.valueOf(Conducteur.getDateToSGBD(this.caces)));
                this.statement.setTimestamp(49, Timestamp.valueOf(Conducteur.getTimestampToSGBD(this.lastExport)));
                this.statement.setObject(50, (Object)this.externalId, 4);
                this.statement.setObject(51, (Object)this.analyticCodeId, 4);
                this.statement.setObject(52, (Object)(this.renewalPending ? 1 : 0), 4);
                this.statement.setObject(53, (Object)Float.valueOf(this.targetConsumption), 6);
                this.statement.setObject(54, (Object)this.payPeriodType, 4);
                this.statement.setObject(55, (Object)(this.expensesAllowance ? 1 : 0), 4);
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    try {
                        ResultSet rs = this.statement.getGeneratedKeys();
                        if (!rs.next()) {
                            TimsLogger.warn("#Conducteur.insert# no auto generated key availaible");
                        } else {
                            TimsLogger.debug("#Conducteur.insert# auto generated key value = " + rs.getInt(1));
                            this.cleConducteur = rs.getInt(1);
                        }
                        rs.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (this.cleConducteur == 0) {
                    if (this.loadId()) {
                        TimsLogger.debug("#Conducteur.insert# generated key value = " + this.cleConducteur);
                    } else {
                        TimsLogger.warn("#Conducteur.insert# no generated key availaible");
                    }
                }
                if (!FileManager.createDirectory(this.getDataDirName())) {
                    TimsLogger.error("#Conducteur.insert# impossible de cr\u00e9er le repertoire");
                }
                if (this.numeroCarte != null && !this.numeroCarte.equals("")) {
                    VehicleUsed.updateConducteur(this.numeroCarte, this.cleConducteur);
                }
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new java.util.Date(), this.affiche()).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(CLE_CHAUFFEUR) AS CLE_CHAUFFEUR FROM t_conducteur WHERE NOM_CONDUCTEUR = ? AND PRENOM_CONDUCTEUR = ? AND ARCHIVAGE=0";
        PreparedStatement statement = null;
        try {
            try {
                statement = Conducteur.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.nom, 12);
                statement.setObject(2, (Object)this.prenom, 12);
                rs = statement.executeQuery();
                while (rs.next()) {
                    this.cleConducteur = rs.getInt("CLE_CHAUFFEUR");
                    TimsLogger.debug("#Conducteur.loadId# id found " + rs.getInt("CLE_CHAUFFEUR"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("#Conducteur.loadId()#  sql = " + sql);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean update() {
        String sql = "UPDATE t_conducteur SET  TAUX_HORAIRE=? , DATE_NAISSANCE=? , CLE_AGENCE=? , CLE_TYPE_PAYE=? , CALENDAR_ID=? , NOM_CONDUCTEUR=? , PRENOM_CONDUCTEUR=? , MATRICULE_CHAUFFEUR=? , NUM_CARTE_CHAUFFEUR=? , MEMBER_STATE=? , REPLACEMENT=? , RENEWAL=? , NUM_IMPORT_CHAUFFEUR=? , ADRESSE=? , CODE_POSTAL=? , VILLE=? , LATITUDE = ?, LONGITUDE = ?, TEL1=? , TEL2=? , DATE_ENTREE_SOCIETE=? , DATE_DERNIERE_VISITE_MEDICALE=? , TYPE_CONDUCTEUR=? , NUM_SECURITE_SOCIALE=? , CLE_TYPE_CHAUFFEUR=? , LOGO=? , DATE_DEBUT_VALIDITE_CARTE=? , DATE_EXPIRATION_CARTE=? , DATE_SORTIE=? , IO_COUNTER=? , DATE_DERNIER_CHANGEMENT=? , DATE_DERNIER_TELECHARGEMENT=? , ARCHIVAGE=? , TRAVAIL_NUIT =?, FIMO_FCO =?, QUALIFICATION_CARD_NUMBER =?, DALLAS_KEY_ID =?,  NIGHT_DAY =?,  NUMERO_PERMIS =?,  DATE_VISITE_PERMIS =?,  B_DELIVERY =?,  C_DELIVERY =?,  CE_DELIVERY =?,  D_DELIVERY =?,  DE_DELIVERY =?,  ADR =?,  CACES =?,  LAST_EXPORT =?,  TRAGEO_ID =?,  ANALYTIC_CODE_ID =?,  RENEWAL_PENDING =?,  CONSUMPTION_TARGET =?,  PAY_PERIOD_TYPE =?,  EXPENSES_ALLOWANCE =?,  LIEU_NAISSANCE=? , TEL3=? , EMAIL=?  WHERE CLE_CHAUFFEUR=?";
        try {
            this.statement = Conducteur.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)Float.valueOf(this.taux), 6);
            this.statement.setDate(2, Date.valueOf(Conducteur.getDateToSGBD(this.dateNaissance)));
            this.statement.setObject(3, (Object)this.cleAgence, 4);
            this.statement.setObject(4, (Object)this.cleTypeContrat, 4);
            this.statement.setObject(5, (Object)this.calendarId, 4);
            this.statement.setObject(6, (Object)this.nom, 12);
            this.statement.setObject(7, (Object)this.prenom, 12);
            this.statement.setObject(8, (Object)this.matricule, 12);
            this.statement.setObject(9, (Object)this.numeroCarte, 12);
            this.statement.setObject(10, (Object)this.memberState, 4);
            this.statement.setObject(11, (Object)this.replacement, 4);
            this.statement.setObject(12, (Object)this.renewal, 4);
            this.statement.setObject(13, (Object)this.numeroImport, 12);
            this.statement.setObject(14, (Object)this.adresse, 12);
            this.statement.setObject(15, (Object)this.codePostal, 12);
            this.statement.setObject(16, (Object)this.ville, 12);
            this.statement.setObject(17, (Object)Float.valueOf(this.latitude), 6);
            this.statement.setObject(18, (Object)Float.valueOf(this.longitude), 6);
            this.statement.setObject(19, (Object)this.tel1, 12);
            this.statement.setObject(20, (Object)this.tel2, 12);
            this.statement.setDate(21, Date.valueOf(Conducteur.getDateToSGBD(this.dateEntree)));
            this.statement.setDate(22, Date.valueOf(Conducteur.getDateToSGBD(this.dateVisite)));
            this.statement.setObject(23, (Object)this.cleTypeConducteur, 4);
            this.statement.setObject(24, (Object)this.numSecuriteSociale, 12);
            this.statement.setObject(25, (Object)this.cleTypePersonnel, 4);
            this.statement.setObject(26, (Object)"", 12);
            this.statement.setDate(27, Date.valueOf(Conducteur.getDateToSGBD(this.dateDebutValiditeCarte)));
            this.statement.setDate(28, Date.valueOf(Conducteur.getDateToSGBD(this.dateFinValiditeCarte)));
            this.statement.setDate(29, Date.valueOf(Conducteur.getDateToSGBD(this.dateSortie)));
            this.statement.setObject(30, (Object)this.ioCounter, 4);
            this.statement.setTimestamp(31, Timestamp.valueOf(Conducteur.getTimestampToSGBD(this.dernierChangement)));
            this.statement.setTimestamp(32, Timestamp.valueOf(Conducteur.getTimestampToSGBD(this.dernierTelechargement)));
            this.statement.setObject(33, (Object)this.archive, 4);
            this.statement.setObject(34, (Object)(this.nightWorker ? 1 : 0), 4);
            this.statement.setDate(35, Date.valueOf(Conducteur.getDateToSGBD(this.fimoFco)));
            this.statement.setObject(36, (Object)this.quaCardNumber, 12);
            this.statement.setObject(37, (Object)this.key, 12);
            this.statement.setObject(38, (Object)this.nightDay, 4);
            this.statement.setObject(39, (Object)this.numeroPermis, 12);
            this.statement.setDate(40, Date.valueOf(Conducteur.getDateToSGBD(this.dateVisitePermis)));
            this.statement.setDate(41, Date.valueOf(Conducteur.getDateToSGBD(this.BDelivery)));
            this.statement.setDate(42, Date.valueOf(Conducteur.getDateToSGBD(this.CDelivery)));
            this.statement.setDate(43, Date.valueOf(Conducteur.getDateToSGBD(this.CEDelivery)));
            this.statement.setDate(44, Date.valueOf(Conducteur.getDateToSGBD(this.DDelivery)));
            this.statement.setDate(45, Date.valueOf(Conducteur.getDateToSGBD(this.DEDelivery)));
            this.statement.setDate(46, Date.valueOf(Conducteur.getDateToSGBD(this.adr)));
            this.statement.setDate(47, Date.valueOf(Conducteur.getDateToSGBD(this.caces)));
            this.statement.setTimestamp(48, Timestamp.valueOf(Conducteur.getTimestampToSGBD(this.lastExport)));
            this.statement.setObject(49, (Object)this.externalId, 4);
            this.statement.setObject(50, (Object)this.analyticCodeId, 4);
            this.statement.setObject(51, (Object)(this.renewalPending ? 1 : 0), 4);
            this.statement.setObject(52, (Object)Float.valueOf(this.targetConsumption), 6);
            this.statement.setObject(53, (Object)this.payPeriodType, 6);
            this.statement.setObject(54, (Object)(this.expensesAllowance ? 1 : 0), 4);
            this.statement.setObject(55, (Object)this.lieuNaissance, 12);
            this.statement.setObject(56, (Object)this.tel3, 12);
            this.statement.setObject(57, (Object)this.email, 12);
            this.statement.setObject(58, (Object)this.cleConducteur, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("update()#  sql = " + sql);
            ex.printStackTrace();
        }
        return false;
    }

    public boolean compareAndUpdate(String name, String firstName, String matricule, String importNumber, String cardNumber, int memberState, int replacement, int renewal, int ioCounter, String birth, String birthPlace, int agency, int contract, int calendar, int personnel, int driver, String address, String cp, String city, String phone, String mobile, String tel3, String email, String begin, String end, String medical, String delivery, String expiration, String socialNumber, float rate, boolean nightWorker, String fimoFco, String quaCardNumber, String key, int nightDay, String numeroPermis, String dateVisitePermis, String BDelivery, String CDelivery, String CEDelivery, String DDelivery, String DEDelivery, String adr, String caces, int externalId, int analyticCodeId, boolean renewalPending, int payPeriodType, boolean expensesAllowance) {
        String fromRename = null;
        boolean renewCoordinates = false;
        String tracer = String.valueOf(LanguageTranslator.getString("generics.driver")) + " n\u00b0 " + this.cleConducteur + " (" + this.getNom() + " " + this.getPrenom() + ") \n";
        if (Fonctions.fieldChange(this.nom, name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.lastName") + " '" + this.nom + "' => '" + name + "'\n";
            if (fromRename == null) {
                fromRename = this.getDataDirName();
            }
            this.setNom(name);
        }
        if (Fonctions.fieldChange(this.prenom, firstName)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.firstName") + " '" + this.prenom + "' => '" + firstName + "'\n";
            if (fromRename == null) {
                fromRename = this.getDataDirName();
            }
            this.setPrenom(firstName);
        }
        if (Fonctions.fieldChange(this.matricule, matricule)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.registration") + " '" + this.matricule + "' => '" + matricule + "'\n";
            this.setMatricule(matricule);
        }
        if (Fonctions.fieldChange(this.key, key)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.key") + " '" + this.key + "' => '" + key + "'\n";
            this.setKey(key);
        }
        if (Fonctions.fieldChange(this.numeroImport, importNumber)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.numeroImport + "' => '" + importNumber + "'\n";
            this.setNumeroImport(importNumber);
        }
        if (Fonctions.fieldChange(this.numeroCarte, cardNumber)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.cardNumber") + " '" + this.numeroCarte + "' => '" + cardNumber + "'\n";
            if (fromRename == null) {
                fromRename = this.getDataDirName();
            }
            this.setNumeroCarte(cardNumber);
        }
        if (memberState != this.memberState) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.memberState") + " '" + this.memberState + "' => '" + memberState + "'\n";
            this.setMemberState(memberState);
        }
        if (replacement != this.replacement) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.replacement") + " '" + this.replacement + "' => '" + replacement + "'\n";
            this.setReplacement(replacement);
        }
        if (renewal != this.renewal) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.renewal") + " '" + this.renewal + "' => '" + renewal + "'\n";
            this.setRenewal(renewal);
        }
        if (ioCounter != this.ioCounter) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.ioCounter") + " '" + this.ioCounter + "' => '" + ioCounter + "'\n";
            this.setIoCounter(ioCounter);
        }
        if (!Conducteur.getDateFromSGBD(birth).equals(this.dateNaissance)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.birthday") + " '" + this.dateNaissance + "' => '" + Conducteur.getDateFromSGBD(birth) + "'\n";
            this.setDateNaissance(Conducteur.getDateFromSGBD(birth));
        }
        if (Fonctions.fieldChange(this.lieuNaissance, birthPlace)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.birth.place") + " '" + this.lieuNaissance + "' => '" + birthPlace + "'\n";
            this.setLieuNaissance(birthPlace);
        }
        if (agency != this.cleAgence) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.agency") + " '" + this.cleAgence + "' => '" + agency + "'\n";
            if (fromRename == null) {
                fromRename = this.getDataDirName();
            }
            this.setCleAgence(agency);
        }
        if (contract != this.cleTypeContrat) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.pay.title") + " '" + this.cleTypeContrat + "' => '" + contract + "'\n";
            this.setCleTypeContrat(contract);
        }
        if (calendar != this.calendarId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.calendar") + " '" + this.calendarId + "' => '" + calendar + "'\n";
            this.setCalendarId(calendar);
        }
        if (personnel != this.cleTypePersonnel) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.type.title") + " '" + this.cleTypePersonnel + "' => '" + personnel + "'\n";
            this.setCleTypePersonnel(personnel);
        }
        if (driver != this.cleTypeConducteur) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.title") + " '" + this.cleTypeConducteur + "' => '" + driver + "'\n";
            this.setCleTypeConducteur(driver);
        }
        if (Fonctions.fieldChange(this.adresse, address)) {
            renewCoordinates = true;
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.address") + " '" + this.adresse + "' => '" + address + "'\n";
            this.setAdresse(address);
        }
        if (Fonctions.fieldChange(this.codePostal, cp)) {
            renewCoordinates = true;
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.cp") + " '" + this.codePostal + "' => '" + cp + "'\n";
            this.setCodePostal(cp);
        }
        if (Fonctions.fieldChange(this.ville, city)) {
            renewCoordinates = true;
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.city") + " '" + this.ville + "' => '" + city + "'\n";
            this.setVille(city);
        }
        if (Fonctions.fieldChange(this.tel1, phone)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.phone") + " '" + this.tel1 + "' => '" + phone + "'\n";
            this.setTel1(phone);
        }
        if (Fonctions.fieldChange(this.tel2, mobile)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.mobile") + " '" + this.tel2 + "' => '" + mobile + "'\n";
            this.setTel2(mobile);
        }
        if (Fonctions.fieldChange(this.tel3, tel3)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.personal.phone") + " '" + this.tel3 + "' => '" + tel3 + "'\n";
            this.setTel3(tel3);
        }
        if (Fonctions.fieldChange(this.email, email)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("geerics.email") + " '" + this.email + "' => '" + email + "'\n";
            this.setEmail(email);
        }
        if (!Conducteur.getDateFromSGBD(begin).equals(this.dateEntree)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.enterDate") + " '" + this.dateEntree + "' => '" + Conducteur.getDateFromSGBD(begin) + "'\n";
            this.setDateEntree(Conducteur.getDateFromSGBD(begin));
        }
        if (!Conducteur.getDateFromSGBD(end).equals(this.dateSortie)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.exitDate") + " '" + this.dateSortie + "' => '" + Conducteur.getDateFromSGBD(end) + "'\n";
            this.setDateSortie(Conducteur.getDateFromSGBD(end));
            if (!Conducteur.getDateFromSGBD(end).equals("")) {
                this.setArchive(ConversionTime.stringToDate(end, "yyyy-MM-dd").before(new java.util.Date()) ? 1 : 0);
            } else {
                this.setArchive(0);
            }
        }
        if (!Conducteur.getDateFromSGBD(medical).equals(this.dateVisite)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.medicalExam") + " '" + this.dateVisite + "' => '" + Conducteur.getDateFromSGBD(medical) + "'\n";
            this.setDateVisite(Conducteur.getDateFromSGBD(medical));
        }
        if (!Conducteur.getDateFromSGBD(delivery).equals(this.dateDebutValiditeCarte)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.delivery") + " '" + this.dateDebutValiditeCarte + "' => '" + Conducteur.getDateFromSGBD(delivery) + "'\n";
            this.setDateDebutValiditeCarte(Conducteur.getDateFromSGBD(delivery));
        }
        if (!Conducteur.getDateFromSGBD(expiration).equals(this.dateFinValiditeCarte)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.expiry") + " '" + this.dateFinValiditeCarte + "' => '" + Conducteur.getDateFromSGBD(expiration) + "'\n";
            this.setDateFinValiditeCarte(Conducteur.getDateFromSGBD(expiration));
        }
        if (renewalPending != this.renewalPending) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.renewalPending") + " '" + this.renewalPending + "' => '" + renewalPending + "'\n";
            this.setRenewalPending(renewalPending);
        }
        if (Fonctions.fieldChange(this.numSecuriteSociale, socialNumber)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.ss") + " '" + this.numSecuriteSociale + "' => '" + socialNumber + "'\n";
            this.setNumSecuriteSociale(socialNumber);
        }
        if (rate != this.taux) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.rate") + " '" + this.taux + "' => '" + rate + "'\n";
            this.setTaux(rate);
        }
        if (nightWorker != this.nightWorker) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.night") + " '" + this.nightWorker + "' => '" + nightWorker + "'\n";
            this.setNightWorker(nightWorker);
        }
        if (nightDay != this.nightDay) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.nightDay") + " '" + this.nightDay + "' => '" + nightDay + "'\n";
            this.setNightDay(nightDay);
        }
        if (!Conducteur.getDateFromSGBD(fimoFco).equals(this.fimoFco)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.fcos") + " '" + this.fimoFco + "' => '" + fimoFco + "'\n";
            this.setFimoFco(fimoFco);
        }
        if (Fonctions.fieldChange(this.quaCardNumber, quaCardNumber)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.quaCardNumber") + " '" + this.quaCardNumber + "' => '" + quaCardNumber + "'\n";
            this.setQuaCardNumber(quaCardNumber);
        }
        if (Fonctions.fieldChange(this.numeroPermis, numeroPermis)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.licence.number") + " '" + this.numeroPermis + "' => '" + numeroPermis + "'\n";
            this.setNumeroPermis(numeroPermis);
        }
        if (!Conducteur.getDateFromSGBD(dateVisitePermis).equals(this.dateVisitePermis)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.licenceMedicalExam") + " '" + this.dateVisitePermis + "' => '" + dateVisitePermis + "'\n";
            this.setDateVisitePermis(dateVisitePermis);
        }
        if (!Conducteur.getDateFromSGBD(adr).equals(this.adr)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.adr") + " '" + this.adr + "' => '" + adr + "'\n";
            this.setAdr(adr);
        }
        if (!Conducteur.getDateFromSGBD(caces).equals(this.caces)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.caces") + " '" + this.caces + "' => '" + caces + "'\n";
            this.setCaces(caces);
        }
        if (Fonctions.fieldChange(BDelivery, this.BDelivery)) {
            tracer = String.valueOf(tracer) + "B '" + this.BDelivery + "' => '" + BDelivery + "'\n";
            this.setBDelivery(BDelivery);
        }
        if (Fonctions.fieldChange(CDelivery, this.CDelivery)) {
            tracer = String.valueOf(tracer) + "C '" + this.CDelivery + "' => '" + CDelivery + "'\n";
            this.setCDelivery(CDelivery);
        }
        if (Fonctions.fieldChange(CEDelivery, this.CEDelivery)) {
            tracer = String.valueOf(tracer) + "CE '" + this.CEDelivery + "' => '" + CEDelivery + "'\n";
            this.setCEDelivery(CEDelivery);
        }
        if (Fonctions.fieldChange(DDelivery, this.DDelivery)) {
            tracer = String.valueOf(tracer) + "D '" + this.DDelivery + "' => '" + DDelivery + "'\n";
            this.setDDelivery(DDelivery);
        }
        if (Fonctions.fieldChange(DEDelivery, this.DEDelivery)) {
            tracer = String.valueOf(tracer) + "DE '" + this.DEDelivery + "' => '" + DEDelivery + "'\n";
            this.setDEDelivery(DEDelivery);
        }
        if (externalId != this.externalId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.externalId") + " '" + this.externalId + "' => '" + externalId + "'\n";
            this.setExternalId(externalId);
        }
        if (analyticCodeId != this.analyticCodeId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.analyticCodeId") + " '" + this.analyticCodeId + "' => '" + analyticCodeId + "'\n";
            this.setAnalyticCodeId(analyticCodeId);
        }
        if (payPeriodType != this.payPeriodType) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.payPeriodType") + " '" + this.payPeriodType + "' => '" + payPeriodType + "'\n";
            this.setPayPeriodType(payPeriodType);
        }
        if (expensesAllowance != this.expensesAllowance) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.expensesAllowance") + " '" + this.expensesAllowance + "' => '" + expensesAllowance + "'\n";
            this.setExpensesAllowance(expensesAllowance);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.driver")) + " n\u00b0 " + this.cleConducteur + " (" + this.getNom() + " " + this.getPrenom() + ") \n")) {
            if (fromRename != null && !FileManager.moveDirectory(fromRename, this.getDataDirName())) {
                TimsLogger.error("#Conducteur.compareAndUpdate# erreur renommage repertoire " + fromRename + " to " + this.getDataDirName());
            }
            if (renewCoordinates) {
                try {
                    String fullAddress = String.valueOf(this.getAdresse()) + " " + this.getCodePostal() + " " + this.getVille();
                    float[] position = Fonctions.getCoordinates(fullAddress);
                    if (position != null) {
                        this.setLongitude(position[0]);
                        this.setLatitude(position[1]);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TimsLogger.error("#DCC.add# erreur getPosition");
                }
            }
            TimsLogger.debug("#Conducteur.compareAndUpdate# changes : " + tracer);
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
            return this.update();
        }
        TimsLogger.debug("#Conducteur.compareAndUpdate# no changes");
        return true;
    }

    public boolean compareAndUpdateConsumption(float target) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.driver")) + " n\u00b0 " + this.cleConducteur + " (" + this.getNom() + " " + this.getPrenom() + ") \n";
        if (target != this.targetConsumption) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("consumption.target") + " : '" + this.targetConsumption + "' => '" + target + "'\n";
            this.setTargetConsumption(target);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.driver")) + " n\u00b0 " + this.cleConducteur + " (" + this.getNom() + " " + this.getPrenom() + ") \n")) {
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
            return this.update();
        }
        TimsLogger.debug("#Conducteur.compareAndUpdate# no changes");
        return true;
    }

    public boolean compareAndUpdateLastImport(String lastImport) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.driver")) + " n\u00b0 " + this.cleConducteur + " (" + this.getNom() + " " + this.getPrenom() + ") \n";
        if (Fonctions.fieldChange(this.dernierChangement, lastImport)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.lastCardChange") + " : '" + this.dernierChangement + "' => '" + lastImport + "'\n";
            this.setDernierChangement(lastImport);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.driver")) + " n\u00b0 " + this.cleConducteur + " (" + this.getNom() + " " + this.getPrenom() + ") \n")) {
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
            return this.update();
        }
        TimsLogger.debug("#Conducteur.compareAndUpdateLastImport# no changes");
        return true;
    }

    public boolean updateLicense(String licenseNumber) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.driver")) + " n\u00b0 " + this.cleConducteur + " (" + this.getNom() + " " + this.getPrenom() + ") \n";
        if (Fonctions.fieldChange(this.numeroPermis, licenseNumber)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.licence.number") + " '" + this.numeroPermis + "' => '" + licenseNumber + "'\n";
            this.setNumeroPermis(licenseNumber);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.driver")) + " n\u00b0 " + this.cleConducteur + " (" + this.getNom() + " " + this.getPrenom() + ") \n")) {
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
            return this.update();
        }
        TimsLogger.debug("#Conducteur.compareAndUpdate# no changes");
        return true;
    }

    public boolean updateCard(String numeroCarte, int memberState, int replacement, int renewal, int ioCounter, String dateNaissance, String delivrance, String expiration) {
        String fromRename = null;
        String tracer = String.valueOf(LanguageTranslator.getString("generics.driver")) + " n\u00b0 " + this.cleConducteur + " (" + this.getNom() + " " + this.getPrenom() + ") \n";
        if (Fonctions.fieldChange(this.numeroCarte, numeroCarte)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.cardNumber") + " '" + this.numeroCarte + "' => '" + numeroCarte + "'\n";
            if (fromRename == null) {
                fromRename = this.getDataDirName();
            }
            this.setNumeroCarte(numeroCarte);
        }
        if (memberState != this.memberState) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.memberState") + " '" + this.memberState + "' => '" + memberState + "'\n";
            this.setMemberState(memberState);
        }
        if (replacement != this.replacement) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.replacement") + " '" + this.replacement + "' => '" + replacement + "'\n";
            this.setReplacement(replacement);
        }
        if (renewal != this.renewal) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.renewal") + " '" + this.renewal + "' => '" + renewal + "'\n";
            this.setRenewal(renewal);
        }
        if (ioCounter != this.ioCounter) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.ioCounter") + " '" + this.ioCounter + "' => '" + ioCounter + "'\n";
            this.setIoCounter(ioCounter);
        }
        if (!Conducteur.getDateFromSGBD(dateNaissance).equals(this.dateNaissance)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.birthday") + " '" + this.dateNaissance + "' => '" + Conducteur.getDateFromSGBD(dateNaissance) + "'\n";
            this.setDateNaissance(Conducteur.getDateFromSGBD(dateNaissance));
        }
        if (!Conducteur.getDateFromSGBD(delivrance).equals(this.dateDebutValiditeCarte)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.delivery") + " '" + this.dateDebutValiditeCarte + "' => '" + Conducteur.getDateFromSGBD(delivrance) + "'\n";
            this.setDateDebutValiditeCarte(Conducteur.getDateFromSGBD(delivrance));
        }
        if (!Conducteur.getDateFromSGBD(expiration).equals(this.dateFinValiditeCarte)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.expiry") + " '" + this.dateFinValiditeCarte + "' => '" + Conducteur.getDateFromSGBD(expiration) + "'\n";
            this.setDateFinValiditeCarte(Conducteur.getDateFromSGBD(expiration));
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.driver")) + " n\u00b0 " + this.cleConducteur + " (" + this.getNom() + " " + this.getPrenom() + ") \n")) {
            if (fromRename != null && !FileManager.moveDirectory(fromRename, this.getDataDirName())) {
                TimsLogger.error("#Conducteur.compareAndUpdate# erreur renommage repertoire " + fromRename + " to " + this.getDataDirName());
            }
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
            return this.update();
        }
        TimsLogger.debug("#Conducteur.compareAndUpdate# no changes");
        return true;
    }

    public boolean loadByCard(String numeroCarte, int cardIssuingMemberState, int archive) {
        TimsLogger.debug("#Conducteur.loadByCard()# load numeroCarte = " + numeroCarte + ", cardIssuingMemberState = " + cardIssuingMemberState);
        String sql = "SELECT " + Conducteur.getAllFields() + " FROM " + table + " WHERE NUM_CARTE_CHAUFFEUR LIKE '" + numeroCarte.substring(0, 14) + "%'" + (cardIssuingMemberState != -1 ? " AND MEMBER_STATE = " + cardIssuingMemberState : "") + " AND ARCHIVAGE=" + (archive == -1 ? (Comparable<Boolean>)Boolean.valueOf(MainFrameTransport.archivage) : (Comparable<Boolean>)Integer.valueOf(archive));
        return this.genericLoad(sql);
    }

    public boolean loadById(int driverId) {
        String sql = "SELECT " + Conducteur.getAllFields() + " FROM " + table + " WHERE CLE_CHAUFFEUR=" + driverId;
        return this.genericLoad(sql);
    }

    public boolean loadByCode(String code) {
        String sql = "SELECT " + Conducteur.getAllFields() + " FROM " + table + " WHERE MATRICULE_CHAUFFEUR='" + code + "'" + " AND ARCHIVAGE=" + (MainFrameTransport.archivage ? "1" : "0");
        return this.genericLoad(sql);
    }

    public boolean genericLoad(ResultSet rs) throws SQLException {
        this.cleConducteur = rs.getInt("CLE_CHAUFFEUR");
        this.externalId = rs.getInt("TRAGEO_ID");
        this.cleAgence = rs.getInt("CLE_AGENCE");
        this.nom = rs.getString("NOM_CONDUCTEUR");
        this.prenom = rs.getString("PRENOM_CONDUCTEUR");
        this.taux = rs.getFloat("TAUX_HORAIRE");
        this.dateNaissance = Conducteur.getDateFromSGBD(rs.getString("DATE_NAISSANCE"));
        this.lieuNaissance = rs.getString("LIEU_NAISSANCE");
        this.cleTypeContrat = rs.getInt("CLE_TYPE_PAYE");
        this.calendarId = rs.getInt("CALENDAR_ID");
        this.matricule = rs.getString("MATRICULE_CHAUFFEUR");
        this.key = rs.getString("DALLAS_KEY_ID");
        this.numeroCarte = rs.getString("NUM_CARTE_CHAUFFEUR");
        this.memberState = rs.getInt("MEMBER_STATE");
        this.replacement = rs.getInt("REPLACEMENT");
        this.renewal = rs.getInt("RENEWAL");
        this.numeroImport = rs.getString("NUM_IMPORT_CHAUFFEUR");
        this.adresse = rs.getString("ADRESSE");
        this.codePostal = rs.getString("CODE_POSTAL");
        this.ville = rs.getString("VILLE");
        this.tel1 = rs.getString("TEL1");
        this.tel2 = rs.getString("TEL2");
        this.tel3 = rs.getString("TEL3");
        this.email = rs.getString("EMAIL");
        this.dateEntree = Conducteur.getDateFromSGBD(rs.getString("DATE_ENTREE_SOCIETE"));
        this.dateVisite = Conducteur.getDateFromSGBD(rs.getString("DATE_DERNIERE_VISITE_MEDICALE"));
        this.cleTypeConducteur = rs.getInt("TYPE_CONDUCTEUR");
        this.numSecuriteSociale = rs.getString("NUM_SECURITE_SOCIALE");
        this.cleTypePersonnel = rs.getInt("CLE_TYPE_CHAUFFEUR");
        this.dateDebutValiditeCarte = Conducteur.getDateFromSGBD(rs.getString("DATE_DEBUT_VALIDITE_CARTE"));
        this.dateFinValiditeCarte = Conducteur.getDateFromSGBD(rs.getString("DATE_EXPIRATION_CARTE"));
        this.dateSortie = Conducteur.getDateFromSGBD(rs.getString("DATE_SORTIE"));
        this.dernierChangement = Conducteur.getDateFromSGBD(rs.getString("DATE_DERNIER_CHANGEMENT"));
        this.dernierTelechargement = Conducteur.getDateFromSGBD(rs.getString("DATE_DERNIER_TELECHARGEMENT"));
        this.dernierCalculBrut = Conducteur.getDateFromSGBD(rs.getString("DATE_CALCUL_BRUT"));
        this.dernierCalculModifie = Conducteur.getDateFromSGBD(rs.getString("DATE_CALCUL_MODIFIE"));
        this.ioCounter = rs.getInt("IO_COUNTER");
        this.nightWorker = rs.getBoolean("TRAVAIL_NUIT");
        this.fimoFco = Conducteur.getDateFromSGBD(rs.getString("FIMO_FCO"));
        this.quaCardNumber = rs.getString("QUALIFICATION_CARD_NUMBER");
        this.nightDay = rs.getInt("NIGHT_DAY");
        this.numeroPermis = rs.getString("NUMERO_PERMIS");
        this.dateVisitePermis = Conducteur.getDateFromSGBD(rs.getString("DATE_VISITE_PERMIS"));
        this.BDelivery = Conducteur.getDateFromSGBD(rs.getString("B_DELIVERY"));
        this.CDelivery = Conducteur.getDateFromSGBD(rs.getString("C_DELIVERY"));
        this.CEDelivery = Conducteur.getDateFromSGBD(rs.getString("CE_DELIVERY"));
        this.DDelivery = Conducteur.getDateFromSGBD(rs.getString("D_DELIVERY"));
        this.DEDelivery = Conducteur.getDateFromSGBD(rs.getString("DE_DELIVERY"));
        this.archive = rs.getInt("ARCHIVAGE");
        this.analyticCodeId = rs.getInt("ANALYTIC_CODE_ID");
        this.renewalPending = rs.getBoolean("RENEWAL_PENDING");
        this.targetConsumption = rs.getFloat("CONSUMPTION_TARGET");
        this.payPeriodType = rs.getInt("PAY_PERIOD_TYPE");
        this.expensesAllowance = rs.getBoolean("EXPENSES_ALLOWANCE");
        this.adr = Conducteur.getDateFromSGBD(rs.getString("ADR"));
        this.caces = Conducteur.getDateFromSGBD(rs.getString("CACES"));
        this.lastExport = Conducteur.getDateFromSGBD(rs.getString("LAST_EXPORT"));
        this.latitude = rs.getFloat("LATITUDE");
        this.longitude = rs.getFloat("LONGITUDE");
        return true;
    }

    public boolean genericLoad(String sql) {
        boolean retour = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = Conducteur.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    retour = this.genericLoad(rs);
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("genericLoad()#  sql = " + sql + " (" + ex.getMessage() + ")");
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean loadByExternalId(int externalId) {
        String sql = "SELECT " + Conducteur.getAllFields() + " FROM " + table + " WHERE TRAGEO_ID=" + externalId;
        return this.genericLoad(sql);
    }

    public boolean loadByKey(String key) {
        String sql = "SELECT " + Conducteur.getAllFields() + " FROM " + table + " WHERE DALLAS_KEY_ID='" + key + "'" + " AND ARCHIVAGE=" + (MainFrameTransport.archivage ? "1" : "0");
        return this.genericLoad(sql);
    }

    public boolean loadByName(String nom, String prenom) {
        String sql = "SELECT " + Conducteur.getAllFields() + " FROM " + table + " WHERE NOM_CONDUCTEUR='" + BddTransport.addSlashes(nom) + "' AND PRENOM_CONDUCTEUR LIKE '" + BddTransport.addSlashes(prenom.split(" ")[0]) + "%'";
        return this.genericLoad(sql);
    }

    public boolean delete() {
        boolean retour = false;
        String sql = "DELETE FROM t_conducteur WHERE CLE_CHAUFFEUR=?";
        try {
            try {
                this.statement = Conducteur.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleConducteur, 4);
                this.statement.executeUpdate();
                this.statement.close();
                FileManager.moveDirectory(this.getDataDirName(), String.valueOf(this.getDataDirName(false)) + " - DELETED");
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 1, new java.util.Date(), this.affiche()).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public String getLastWorkedDay() {
        block21: {
            String string;
            ResultSet rs = null;
            String sql = "SELECT max(DATE_JOUR) as last FROM t_jour WHERE CLE_CHAUFFEUR=?";
            try {
                this.statement = Conducteur.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleConducteur, 4);
                rs = this.statement.executeQuery();
                if (!rs.next()) break block21;
                if (rs.getString("last") == null) {
                    String string2 = ConversionTime.dateToString(new java.util.Date(), "yyyy-MM-dd");
                    return string2;
                }
                string = rs.getString("last");
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                break block21;
            }
            catch (SQLException ex) {
                TimsLogger.error("#Conducteur.getLastWorkedDay()#  sql = " + sql);
                break block21;
            }
            finally {
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            return string;
        }
        return ConversionTime.dateToString(new java.util.Date(), "yyyy-mm-dd");
    }

    public String affiche() {
        String toReturn = "d\u00e9tail conducteur (cle = " + this.cleConducteur + ")\t";
        toReturn = String.valueOf(toReturn) + "nom : " + this.nom + " " + this.prenom + " \t";
        toReturn = String.valueOf(toReturn) + "n\u00b0 carte : " + this.numeroCarte + " (" + this.replacement + ", " + this.renewal + ") \t";
        toReturn = String.valueOf(toReturn) + "matricule : " + this.matricule + " \r\n";
        return toReturn;
    }

    public String getAdresse() {
        return this.adresse;
    }

    public void setAdresse(String adresse) {
        this.adresse = adresse;
    }

    public int getCleAgence() {
        return this.cleAgence;
    }

    public void setCleAgence(int cleAgence) {
        this.cleAgence = cleAgence;
    }

    public int getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(int cleCalendrierInterv) {
        this.calendarId = cleCalendrierInterv;
    }

    public int getCleConducteur() {
        return this.cleConducteur;
    }

    public void setCleConducteur(int cleConducteur) {
        this.cleConducteur = cleConducteur;
    }

    public int getCleTypeConducteur() {
        return this.cleTypeConducteur;
    }

    public void setCleTypeConducteur(int cleTypeConducteur) {
        this.cleTypeConducteur = cleTypeConducteur;
    }

    public int getCleTypeContrat() {
        return this.cleTypeContrat;
    }

    public void setCleTypeContrat(int cleTypePaye) {
        this.cleTypeContrat = cleTypePaye;
    }

    public int getCleTypePersonnel() {
        return this.cleTypePersonnel;
    }

    public void setCleTypePersonnel(int cleTypePersonnel) {
        this.cleTypePersonnel = cleTypePersonnel;
    }

    public String getCodePostal() {
        return this.codePostal;
    }

    public void setCodePostal(String codePostal) {
        this.codePostal = codePostal;
    }

    public String getDateDebutValiditeCarte() {
        return this.dateDebutValiditeCarte;
    }

    public void setDateDebutValiditeCarte(String dateDebutValiditeCarte) {
        this.dateDebutValiditeCarte = dateDebutValiditeCarte;
    }

    public String getDateEntree() {
        return this.dateEntree;
    }

    public void setDateEntree(String dateEntree) {
        this.dateEntree = dateEntree;
    }

    public String getDateFinValiditeCarte() {
        return this.dateFinValiditeCarte;
    }

    public void setDateFinValiditeCarte(String dateFinValiditeCarte) {
        this.dateFinValiditeCarte = dateFinValiditeCarte;
    }

    public String getDateNaissance() {
        return this.dateNaissance;
    }

    public void setDateNaissance(String dateNaissance) {
        this.dateNaissance = dateNaissance;
    }

    public String getDateSortie() {
        return this.dateSortie;
    }

    public void setDateSortie(String dateSortie) {
        this.dateSortie = dateSortie;
    }

    public String getDateVisite() {
        return this.dateVisite;
    }

    public void setDateVisite(String dateVisite) {
        this.dateVisite = dateVisite;
    }

    public String getDernierCalculBrut() {
        return this.dernierCalculBrut;
    }

    public void setDernierCalculBrut(String dernierCalculBrut) {
        this.dernierCalculBrut = dernierCalculBrut;
    }

    public String getDernierCalculModifie() {
        return this.dernierCalculModifie;
    }

    public void setDernierCalculModifie(String dernierCalculModifie) {
        this.dernierCalculModifie = dernierCalculModifie;
    }

    public String getDernierChangement() {
        return this.dernierChangement;
    }

    public void setDernierChangement(String dernierChangement) {
        this.dernierChangement = dernierChangement;
    }

    public int getIoCounter() {
        return this.ioCounter;
    }

    public void setIoCounter(int ioCounter) {
        this.ioCounter = ioCounter;
    }

    public String getMatricule() {
        return this.matricule;
    }

    public void setMatricule(String matricule) {
        this.matricule = matricule;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getNumeroCarte() {
        return this.numeroCarte;
    }

    public void setNumeroCarte(String numeroCarte) {
        this.numeroCarte = numeroCarte;
    }

    public int getMemberState() {
        return this.memberState;
    }

    public void setMemberState(int memberState) {
        this.memberState = memberState;
    }

    public int getReplacement() {
        return this.replacement;
    }

    public void setReplacement(int replacement) {
        this.replacement = replacement;
    }

    public int getRenewal() {
        return this.renewal;
    }

    public void setRenewal(int renewal) {
        this.renewal = renewal;
    }

    public String getNumeroImport() {
        return this.numeroImport;
    }

    public void setNumeroImport(String numeroImport) {
        this.numeroImport = numeroImport;
    }

    public String getNumSecuriteSociale() {
        return this.numSecuriteSociale;
    }

    public void setNumSecuriteSociale(String numSecuriteSociale) {
        this.numSecuriteSociale = numSecuriteSociale;
    }

    public String getPrenom() {
        return this.prenom;
    }

    public void setPrenom(String prenom) {
        this.prenom = prenom;
    }

    public int getPrime() {
        return this.prime;
    }

    public void setPrime(int prime) {
        this.prime = prime;
    }

    public float getTaux() {
        return this.taux;
    }

    public void setTaux(int taux) {
        this.taux = taux;
    }

    public String getTel1() {
        return this.tel1;
    }

    public void setTel1(String tel1) {
        this.tel1 = tel1;
    }

    public String getTel2() {
        return this.tel2;
    }

    public void setTel2(String tel2) {
        this.tel2 = tel2;
    }

    public String getVille() {
        return this.ville;
    }

    public void setVille(String ville) {
        this.ville = ville;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public void setLatitude(float latitude) {
        this.latitude = latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public void setLongitude(float longitude) {
        this.longitude = longitude;
    }

    public String getDernierTelechargement() {
        return this.dernierTelechargement;
    }

    public void setDernierTelechargement(String dernierTelechargement) {
        this.dernierTelechargement = dernierTelechargement;
    }

    public boolean isNightWorker() {
        return this.nightWorker;
    }

    public void setNightWorker(boolean nightWorker) {
        this.nightWorker = nightWorker;
    }

    public void setTaux(float taux) {
        this.taux = taux;
    }

    public String getFimoFco() {
        return this.fimoFco;
    }

    public void setFimoFco(String fimo) {
        this.fimoFco = fimo;
    }

    public String getQuaCardNumber() {
        return this.quaCardNumber;
    }

    public void setQuaCardNumber(String quaCardNumber) {
        this.quaCardNumber = quaCardNumber;
    }

    public int getArchive() {
        return this.archive;
    }

    public void setArchive(int archive) {
        this.archive = archive;
    }

    public int getDaySinceLastDownload() {
        return this.daySinceLastDownload;
    }

    public void setDaySinceLastDownload(int daySinceLastDownload) {
        this.daySinceLastDownload = daySinceLastDownload;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getNightDay() {
        return this.nightDay;
    }

    public void setNightDay(int nightDay) {
        this.nightDay = nightDay;
    }

    public String getNumeroPermis() {
        return this.numeroPermis;
    }

    public void setNumeroPermis(String numeroPermis) {
        this.numeroPermis = numeroPermis;
    }

    public String getDateVisitePermis() {
        return this.dateVisitePermis;
    }

    public void setDateVisitePermis(String dateVisitePermis) {
        this.dateVisitePermis = dateVisitePermis;
    }

    public String getBDelivery() {
        return this.BDelivery;
    }

    public void setBDelivery(String bDelivery) {
        this.BDelivery = bDelivery;
    }

    public String getCDelivery() {
        return this.CDelivery;
    }

    public void setCDelivery(String cDelivery) {
        this.CDelivery = cDelivery;
    }

    public String getCEDelivery() {
        return this.CEDelivery;
    }

    public void setCEDelivery(String cEDelivery) {
        this.CEDelivery = cEDelivery;
    }

    public String getDDelivery() {
        return this.DDelivery;
    }

    public void setDDelivery(String dDelivery) {
        this.DDelivery = dDelivery;
    }

    public String getDEDelivery() {
        return this.DEDelivery;
    }

    public void setDEDelivery(String dEDelivery) {
        this.DEDelivery = dEDelivery;
    }

    public String getAdr() {
        return this.adr;
    }

    public void setAdr(String adr) {
        this.adr = adr;
    }

    public String getCaces() {
        return this.caces;
    }

    public void setCaces(String caces) {
        this.caces = caces;
    }

    public String getLastExport() {
        return this.lastExport;
    }

    public void setLastExport(String lastExport) {
        this.lastExport = lastExport;
    }

    public int getExternalId() {
        return this.externalId;
    }

    public void setExternalId(int externalId) {
        this.externalId = externalId;
    }

    public int getAnalyticCodeId() {
        return this.analyticCodeId;
    }

    public void setAnalyticCodeId(int analyticCodeId) {
        this.analyticCodeId = analyticCodeId;
    }

    public boolean isRenewalPending() {
        return this.renewalPending;
    }

    public void setRenewalPending(boolean renewalPending) {
        this.renewalPending = renewalPending;
    }

    public float getTargetConsumption() {
        return this.targetConsumption;
    }

    public void setTargetConsumption(float targetConsumption) {
        this.targetConsumption = targetConsumption;
    }

    public int getPayPeriodType() {
        return this.payPeriodType;
    }

    public void setPayPeriodType(int payPeriodType) {
        this.payPeriodType = payPeriodType;
    }

    public boolean isExpensesAllowance() {
        return this.expensesAllowance;
    }

    public void setExpensesAllowance(boolean expensesAllowance) {
        this.expensesAllowance = expensesAllowance;
    }

    public String getLieuNaissance() {
        return this.lieuNaissance;
    }

    public void setLieuNaissance(String lieuNaissance) {
        this.lieuNaissance = lieuNaissance;
    }

    public String getTel3() {
        return this.tel3;
    }

    public void setTel3(String tel3) {
        this.tel3 = tel3;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDataDirName() {
        return this.getDataDirName(true);
    }

    public String getDataDirName(boolean withLastSeparator) {
        String separator = "/";
        if (System.getProperty("URL") == null) {
            separator = "\\";
        }
        return String.valueOf(BddTransport.getInstance().getCompany().getNomBase()) + separator + String.valueOf(this.cleAgence) + separator + this.nom + " " + this.prenom + " - " + this.cleConducteur + (this.numeroCarte != null && !this.numeroCarte.equals("") ? " - " + this.numeroCarte.substring(0, 16) : "") + (withLastSeparator ? separator : "");
    }

    public byte[] write(OutputStream out) {
        this.affiche();
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            tmp.write((byte)this.nom.length());
            tmp.write(this.nom.getBytes());
            tmp.write((byte)this.prenom.length());
            tmp.write(this.prenom.getBytes());
            tmp.write((byte)this.matricule.length());
            tmp.write(this.matricule.getBytes());
            tmp.write(Conducteur.getDateToSGBD(this.dateNaissance).getBytes());
            if (this.numeroImport != null) {
                tmp.write((byte)this.numeroImport.length());
                tmp.write(this.numeroImport.getBytes());
            } else {
                tmp.write(0);
            }
            if (this.numeroCarte != null) {
                tmp.write((byte)this.numeroCarte.length());
                tmp.write(this.numeroCarte.getBytes());
            } else {
                tmp.write(0);
            }
            if (this.adresse != null) {
                tmp.write((byte)this.adresse.length());
                tmp.write(this.adresse.getBytes());
            } else {
                tmp.write(0);
            }
            if (this.codePostal != null) {
                tmp.write((byte)this.codePostal.length());
                tmp.write(this.codePostal.getBytes());
            } else {
                tmp.write(0);
            }
            if (this.ville != null) {
                tmp.write((byte)this.ville.length());
                tmp.write(this.ville.getBytes());
            } else {
                tmp.write(0);
            }
            if (this.tel1 != null) {
                tmp.write((byte)this.tel1.length());
                tmp.write(this.tel1.getBytes());
            } else {
                tmp.write(0);
            }
            if (this.tel2 != null) {
                tmp.write((byte)this.tel2.length());
                tmp.write(this.tel2.getBytes());
            } else {
                tmp.write(0);
            }
            tmp.write(Conducteur.getDateToSGBD(this.dateEntree).getBytes());
            tmp.write(Conducteur.getDateToSGBD(this.dateSortie).getBytes());
            tmp.write(Conducteur.getDateToSGBD(this.dateVisite).getBytes());
            tmp.write(Conducteur.getDateToSGBD(this.dateDebutValiditeCarte).getBytes());
            tmp.write(Conducteur.getDateToSGBD(this.dateFinValiditeCarte).getBytes());
            if (this.numSecuriteSociale != null) {
                tmp.write((byte)this.numSecuriteSociale.length());
                tmp.write(this.numSecuriteSociale.getBytes());
            } else {
                tmp.write(0);
            }
            tmp.write(Conducteur.getDateToSGBD(this.dernierCalculBrut).getBytes());
            tmp.write(Conducteur.getDateToSGBD(this.dernierCalculModifie).getBytes());
            tmp.write(Conducteur.getTimestampToSGBD(this.dernierChangement).getBytes());
            tmp.write(Conducteur.getTimestampToSGBD(this.dernierTelechargement).getBytes());
            tmp.write((byte)this.ioCounter);
            out.write(101);
            out.write((byte)(tmp.size() / 255 + 1));
            out.write((byte)tmp.size());
            tmp.writeTo(out);
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#Conducteur.write()# " + ex.getMessage());
            return null;
        }
    }

    public void read(byte[] obj, int offset) {
        if (obj[offset] != 101) {
            TimsLogger.error("Conducteur.read()# erreur offset" + offset);
            return;
        }
        int length = obj[++offset];
        int dataLength = Fonctions.bytesToInt(obj, ++offset, length);
        offset += length;
        length = obj[offset];
        this.nom = new String(obj).substring(++offset, offset + length);
        length = obj[offset += length] < 0 ? obj[offset] + 256 : obj[offset];
        this.prenom = new String(obj).substring(++offset, offset + length);
        length = obj[offset += length] < 0 ? obj[offset] + 256 : obj[offset];
        this.matricule = new String(obj).substring(++offset, offset + length);
        this.dateNaissance = Conducteur.getDateFromSGBD(new String(obj).substring(offset += length, offset + 10));
        length = obj[offset += 10] < 0 ? obj[offset] + 256 : obj[offset];
        this.numeroImport = new String(obj).substring(++offset, offset + length);
        length = obj[offset += length] < 0 ? obj[offset] + 256 : obj[offset];
        this.numeroCarte = new String(obj).substring(++offset, offset + length);
        length = obj[offset += length] < 0 ? obj[offset] + 256 : obj[offset];
        this.adresse = new String(obj).substring(++offset, offset + length);
        length = obj[offset += length] < 0 ? obj[offset] + 256 : obj[offset];
        this.codePostal = new String(obj).substring(++offset, offset + length);
        length = obj[offset += length] < 0 ? obj[offset] + 256 : obj[offset];
        this.ville = new String(obj).substring(++offset, offset + length);
        length = obj[offset += length] < 0 ? obj[offset] + 256 : obj[offset];
        this.tel1 = new String(obj).substring(++offset, offset + length);
        length = obj[offset += length] < 0 ? obj[offset] + 256 : obj[offset];
        this.tel2 = new String(obj).substring(++offset, offset + length);
        this.dateEntree = Conducteur.getDateFromSGBD(new String(obj).substring(offset += length, offset + 10));
        this.dateSortie = Conducteur.getDateFromSGBD(new String(obj).substring(offset += 10, offset + 10));
        this.dateVisite = Conducteur.getDateFromSGBD(new String(obj).substring(offset += 10, offset + 10));
        this.dateDebutValiditeCarte = Conducteur.getDateFromSGBD(new String(obj).substring(offset += 10, offset + 10));
        this.dateFinValiditeCarte = Conducteur.getDateFromSGBD(new String(obj).substring(offset += 10, offset + 10));
        length = obj[offset += 10] < 0 ? obj[offset] + 256 : obj[offset];
        this.numSecuriteSociale = new String(obj).substring(++offset, offset + length);
        this.dernierCalculBrut = Conducteur.getDateFromSGBD(new String(obj).substring(offset += length, offset + 10));
        this.dernierCalculModifie = Conducteur.getDateFromSGBD(new String(obj).substring(offset += 10, offset + 10));
        this.dernierChangement = Conducteur.getDateFromSGBD(new String(obj).substring(offset += 10, offset + 21));
        this.dernierTelechargement = Conducteur.getDateFromSGBD(new String(obj).substring(offset += 21, offset + 21));
        this.ioCounter = obj[offset += 21];
        this.affiche();
    }

    private static String getAllFields() {
        return "CLE_CHAUFFEUR, CLE_AGENCE, TAUX_HORAIRE, CLE_TYPE_PAYE, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, MATRICULE_CHAUFFEUR, NUM_CARTE_CHAUFFEUR, MEMBER_STATE, REPLACEMENT, RENEWAL, NUM_IMPORT_CHAUFFEUR, ADRESSE, CODE_POSTAL, VILLE, LATITUDE, LONGITUDE, TEL1, TEL2, TEL3, EMAIL, LIEU_NAISSANCE, TYPE_CONDUCTEUR, NUM_SECURITE_SOCIALE, CLE_TYPE_CHAUFFEUR, CALENDAR_ID, LOGO, ARCHIVAGE, " + BddTransport.getDateSGBDRToString("DATE_ENTREE_SOCIETE", false, "") + ", " + BddTransport.getDateSGBDRToString("DATE_SORTIE", false, "") + ", " + BddTransport.getDateSGBDRToString("DATE_EXPIRATION_CARTE", false, "") + ", " + BddTransport.getDateSGBDRToString("DATE_DEBUT_VALIDITE_CARTE", false, "") + ", " + BddTransport.getDateSGBDRToString("DATE_CALCUL_BRUT", false, "") + ", " + BddTransport.getDateSGBDRToString("DATE_CALCUL_MODIFIE", false, "") + ", " + BddTransport.getDateSGBDRToString("DATE_NAISSANCE", false, "") + ", " + BddTransport.getDateSGBDRToString("DATE_DERNIERE_VISITE_MEDICALE", false, "") + ", " + BddTransport.getDateSGBDRToString("ADR", false, "") + ", " + BddTransport.getDateSGBDRToString("CACES", false, "") + ", " + BddTransport.getDateSGBDRToString("LAST_EXPORT", false, "") + ", " + BddTransport.getDateSGBDRToString("DATE_DERNIER_CHANGEMENT", true, "") + ", " + BddTransport.getDateSGBDRToString("DATE_DERNIER_TELECHARGEMENT", true, "") + ", " + BddTransport.getDateSGBDRToString("FIMO_FCO", false, table) + ", " + BddTransport.getDateSGBDRToString("DATE_VISITE_PERMIS", false, table) + ", " + BddTransport.getDateSGBDRToString("B_DELIVERY", false, table) + ", " + BddTransport.getDateSGBDRToString("C_DELIVERY", false, table) + ", " + BddTransport.getDateSGBDRToString("CE_DELIVERY", false, table) + ", " + BddTransport.getDateSGBDRToString("D_DELIVERY", false, table) + ", " + BddTransport.getDateSGBDRToString("DE_DELIVERY", false, table) + ", " + "IO_COUNTER, TRAVAIL_NUIT, QUALIFICATION_CARD_NUMBER, DALLAS_KEY_ID, NIGHT_DAY, NUMERO_PERMIS, TRAGEO_ID, " + "ANALYTIC_CODE_ID, RENEWAL_PENDING, CONSUMPTION_TARGET, PAY_PERIOD_TYPE, EXPENSES_ALLOWANCE";
    }

    public static Vector<Conducteur> loadList(Integer ... integer) {
        return Conducteur.loadList(null, integer);
    }

    public static Vector<Conducteur> loadList(String filter, Integer ... agencyId) {
        Vector<Conducteur> result = new Vector<Conducteur>();
        String sql = "SELECT " + Conducteur.getAllFields() + " FROM " + table;
        try {
            String userRestrict;
            String restriction = " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            String agencies = "";
            if (agencyId.length != 0 && agencyId[0] != 0) {
                Integer[] integerArray = agencyId;
                int n = agencyId.length;
                int n2 = 0;
                while (n2 < n) {
                    int cle = integerArray[n2];
                    if (cle != 0) {
                        agencies = String.valueOf(agencies) + "," + cle;
                    }
                    ++n2;
                }
            }
            if (!agencies.equals("")) {
                restriction = String.valueOf(restriction) + " AND CLE_AGENCE IN (" + agencies.substring(1) + ")";
            }
            if (filter != null) {
                restriction = System.getProperty("SGBDR", "mysql").equals("oracle") ? String.valueOf(restriction) + " AND (UPPER(NOM_CONDUCTEUR) LIKE UPPER(" + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + ")" + " OR UPPER(PRENOM_CONDUCTEUR) LIKE UPPER(" + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + ")" + " OR MATRICULE_CHAUFFEUR LIKE " + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + " OR NUM_CARTE_CHAUFFEUR LIKE " + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + ")" : String.valueOf(restriction) + " AND (NOM_CONDUCTEUR LIKE " + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + " OR PRENOM_CONDUCTEUR LIKE " + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + " OR MATRICULE_CHAUFFEUR LIKE " + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + " OR NUM_CARTE_CHAUFFEUR LIKE " + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + ")";
            }
            if ((userRestrict = BddTransport.addRestriction(table, table)) != "") {
                restriction = String.valueOf(restriction) + " AND " + userRestrict;
            }
            if (!restriction.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, CLE_CHAUFFEUR";
            Transport.ps.startOperation();
            Statement stm = Conducteur.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Conducteur.loadList", "#Conducteur.loadList# %s " + sql, 1);
            while (rs.next()) {
                Conducteur tmp = new Conducteur();
                tmp.genericLoad(rs);
                result.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("loadList()# ex " + ex.getMessage() + ", sql = " + sql);
        }
        if (agencyId.length == 0 && filter == null) {
            fullList = result;
        }
        return result;
    }

    public static Vector<Conducteur> loadListWithArchive(Integer ... agencyId) {
        return Conducteur.loadListWithArchive(null, agencyId);
    }

    public static Vector<Conducteur> loadListWithArchive(String filter, Integer ... agencyId) {
        Vector<Conducteur> result = new Vector<Conducteur>();
        String sql = "SELECT " + Conducteur.getAllFields() + " FROM " + table;
        try {
            String userRestrict;
            String restriction = "";
            String agencies = "";
            if (agencyId.length != 0 && agencyId[0] != 0) {
                Integer[] integerArray = agencyId;
                int n = agencyId.length;
                int n2 = 0;
                while (n2 < n) {
                    int cle = integerArray[n2];
                    if (cle != 0) {
                        agencies = String.valueOf(agencies) + "," + cle;
                    }
                    ++n2;
                }
            }
            if (!agencies.equals("")) {
                restriction = String.valueOf(restriction) + " AND CLE_AGENCE IN (" + agencies.substring(1) + ")";
            }
            if (filter != null) {
                restriction = System.getProperty("SGBDR", "mysql").equals("oracle") ? String.valueOf(restriction) + " AND (UPPER(NOM_CONDUCTEUR) LIKE UPPER(" + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + ")" + " OR UPPER(PRENOM_CONDUCTEUR) LIKE UPPER(" + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + ")" + " OR MATRICULE_CHAUFFEUR LIKE " + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + " OR NUM_CARTE_CHAUFFEUR LIKE " + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + ")" : String.valueOf(restriction) + " AND (NOM_CONDUCTEUR LIKE " + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + " OR PRENOM_CONDUCTEUR LIKE " + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + " OR MATRICULE_CHAUFFEUR LIKE " + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + " OR NUM_CARTE_CHAUFFEUR LIKE " + BddTransport.getQuote() + "%" + filter + "%" + BddTransport.getQuote() + ")";
            }
            if ((userRestrict = BddTransport.addRestriction(table, table)) != "") {
                restriction = String.valueOf(restriction) + " AND " + userRestrict;
            }
            if (!restriction.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, CLE_CHAUFFEUR";
            Transport.ps.startOperation();
            Statement stm = Conducteur.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Conducteur.loadList", "#Conducteur.loadList# %s " + sql, 1);
            while (rs.next()) {
                Conducteur tmp = new Conducteur();
                tmp.genericLoad(rs);
                result.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#Conducteur.loadList()# sql = " + sql);
        }
        return result;
    }

    public static void setList(Vector<Conducteur> fullList) {
        Conducteur.fullList = fullList;
    }

    public static Vector<Conducteur> getList() {
        if (fullList == null) {
            fullList = Conducteur.loadList(new Integer[0]);
        }
        return fullList;
    }

    public static Conducteur getDriver(Vector<Conducteur> driverList, int driverId) throws DriverNotFoundException {
        if (driverList == null) {
            driverList = Conducteur.getList();
        }
        for (Conducteur tmp : driverList) {
            if (tmp.getCleConducteur() != driverId) continue;
            return tmp;
        }
        throw new DriverNotFoundException();
    }

    public static Conducteur getDriverByExternalId(Vector<Conducteur> driverList, int externalId) throws DriverNotFoundException {
        if (driverList == null) {
            driverList = Conducteur.getList();
        }
        for (Conducteur tmp : driverList) {
            if (tmp.getExternalId() != externalId) continue;
            return tmp;
        }
        throw new DriverNotFoundException();
    }

    public static Conducteur getDriverByKey(Vector<Conducteur> driverList, String key) throws DriverNotFoundException {
        if (driverList == null) {
            driverList = Conducteur.getList();
        }
        for (Conducteur tmp : driverList) {
            if (tmp.getKey() == null || !tmp.getKey().equals(key)) continue;
            return tmp;
        }
        throw new DriverNotFoundException();
    }

    public static Conducteur getDriver(Vector<Conducteur> driverList, String cardNumber, int memberState) throws DriverNotFoundException, Exception {
        if (driverList == null) {
            driverList = Conducteur.getList();
        }
        for (Conducteur tmp : driverList) {
            if (tmp.getNumeroCarte() == null || tmp.getNumeroCarte().length() < 14 || !tmp.getNumeroCarte().substring(0, 14).equals(cardNumber.substring(0, 14)) || memberState != -1 && memberState != tmp.getMemberState()) continue;
            return tmp;
        }
        throw new DriverNotFoundException();
    }

    public static Conducteur getDriver(Vector<Conducteur> driverList, String registrationNumber) throws DriverNotFoundException, Exception {
        if (driverList == null) {
            driverList = Conducteur.getList();
        }
        for (Conducteur tmp : driverList) {
            if (!registrationNumber.equals(tmp.getMatricule())) continue;
            return tmp;
        }
        throw new DriverNotFoundException();
    }

    public static Vector<Conducteur> getExpiredCard() {
        Vector<Conducteur> liste = new Vector<Conducteur>();
        String sql = "SELECT CLE_CHAUFFEUR, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, RENEWAL_PENDING, DATE_EXPIRATION_CARTE FROM t_conducteur WHERE " + BddTransport.getDateDiff("DATE_EXPIRATION_CARTE", BddTransport.getCurrentDate()) + " < (SELECT eval FROM " + BddTransport.getBaseDefault(true) + "configuration WHERE value = 'card_expiration_warning')" + " AND ARCHIVAGE = 0";
        String restriction = BddTransport.addRestriction(table, table);
        if (restriction != "") {
            sql = String.valueOf(sql) + " AND " + restriction;
        }
        sql = String.valueOf(sql) + " ORDER BY NOM_CONDUCTEUR";
        ResultSet rs = null;
        try {
            Transport.ps.startOperation();
            Statement stm = Conducteur.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate conducteur", "#conducteur.getExpiredCard() => %s# sql = " + sql, 1);
            while (rs.next()) {
                if (rs.getString("DATE_EXPIRATION_CARTE").equals("1970-01-01")) continue;
                Conducteur toAdd = new Conducteur(rs.getInt("CLE_CHAUFFEUR"), rs.getString("NOM_CONDUCTEUR"), rs.getString("PRENOM_CONDUCTEUR"));
                toAdd.setDateFinValiditeCarte(rs.getString("DATE_EXPIRATION_CARTE"));
                toAdd.setRenewalPending(rs.getBoolean("RENEWAL_PENDING"));
                liste.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            TimsLogger.error("#Conducteur.getExpiredCard()# sql = " + sql);
        }
        return liste;
    }

    public static Vector<Conducteur> getExpiredFimoFco() {
        Vector<Conducteur> liste = new Vector<Conducteur>();
        String sql = "SELECT CLE_CHAUFFEUR, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, FIMO FROM t_conducteur WHERE " + BddTransport.getDateDiff("FIMO", BddTransport.getCurrentDate()) + " < (SELECT eval FROM " + BddTransport.getBaseDefault(true) + "configuration WHERE value = \"fimo_expiration_warning\")" + " AND ARCHIVAGE = 0";
        String restriction = BddTransport.addRestriction(table, table);
        if (restriction != "") {
            sql = String.valueOf(sql) + " AND " + restriction;
        }
        sql = String.valueOf(sql) + " ORDER BY NOM_CONDUCTEUR";
        ResultSet rs = null;
        try {
            Transport.ps.startOperation();
            Statement stm = Conducteur.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate conducteur", "#conducteur.getExpiredFimoFco() => %s# sql = " + sql, 1);
            while (rs.next()) {
                if (rs.getString("FIMO").equals("1970-01-01")) continue;
                Conducteur toAdd = new Conducteur(rs.getInt("CLE_CHAUFFEUR"), rs.getString("NOM_CONDUCTEUR"), rs.getString("PRENOM_CONDUCTEUR"));
                toAdd.setFimoFco(rs.getString("FIMO"));
                liste.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            TimsLogger.error("#Conducteur.getExpiredFimo()# sql = " + sql);
        }
        return liste;
    }

    public static Vector<Conducteur> getDownloadBefore(String date) {
        Vector<Conducteur> result = new Vector<Conducteur>();
        String sql = "";
        try {
            sql = "SELECT CLE_AGENCE, CLE_CHAUFFEUR, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, " + BddTransport.getDateSGBDRToString("DATE_DERNIER_TELECHARGEMENT", false, "") + " FROM " + table + " WHERE DATE_DERNIER_TELECHARGEMENT < " + BddTransport.getDateStringToSGBDR(date, false) + " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            String restriction = BddTransport.addRestriction(table, table);
            if (restriction != "") {
                sql = String.valueOf(sql) + " AND " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY CLE_AGENCE, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR";
            Statement stm = Conducteur.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Conducteur toAdd = new Conducteur(rs.getInt("CLE_CHAUFFEUR"), rs.getString("NOM_CONDUCTEUR"), rs.getString("PRENOM_CONDUCTEUR"), rs.getString("DATE_DERNIER_TELECHARGEMENT"));
                toAdd.setCleAgence(rs.getInt("CLE_AGENCE"));
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getDownloadBefore()# sql = " + sql);
        }
        return result;
    }

    public static String getDriverLibelle(int driverId) {
        try {
            Conducteur toReturn = Conducteur.getDriver(null, driverId);
            return toReturn.getLibelle();
        }
        catch (Exception ex) {
            TimsLogger.warn(ex.getMessage());
            return LanguageTranslator.getString("generics.unknown");
        }
    }

    public static boolean cardNumberExists(String cardNumber) {
        boolean toReturn = false;
        Conducteur check = new Conducteur();
        check.loadByCard(cardNumber, -1, 0);
        if (check.getCleConducteur() != 0) {
            toReturn = true;
        }
        return toReturn;
    }

    public static Vector<String> getDriverCardNumberList(String baseName) {
        String sql = "";
        Vector<String> result = new Vector<String>();
        try {
            sql = "SELECT NUM_CARTE_CHAUFFEUR FROM " + baseName + "." + table + " WHERE ARCHIVAGE = 0";
            Statement stm = Conducteur.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                if (rs.getString("NUM_CARTE_CHAUFFEUR") == null || rs.getString("NUM_CARTE_CHAUFFEUR").length() < 14) continue;
                result.add(rs.getString("NUM_CARTE_CHAUFFEUR").substring(0, 14));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Conducteur.getDriverCardNumberList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }
}

