/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.SQLException;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class Conflit
extends MainElement {
    public static final String table = "t_conflit";
    public static final int OFFSET = 129;
    private int cle = 0;
    private int cleConducteur = 0;
    private int cleUser = 0;
    private int cleTraitant = 0;
    private String nomConducteur = "";
    private String prenomConducteur = "";
    private String agence = "";
    private String dateConflit = "";
    private String dateCreation = "";
    private String dateProcession = "";
    private boolean traite = false;
    private int kmAnalyse = 0;
    private int kmBase = 0;

    public Conflit() {
    }

    public Conflit(int cle, int cleConducteur, int cleUser, int cleTraitant, String nomConducteur, String prenomConducteur, String agence, String dateConflit, String dateCreation, String dateProcession, int kmAnalyse, int kmBase, boolean traite) {
        this.cle = cle;
        this.cleUser = cleUser;
        this.cleConducteur = cleConducteur;
        this.nomConducteur = nomConducteur;
        this.cleTraitant = cleTraitant;
        this.prenomConducteur = prenomConducteur;
        this.agence = agence;
        this.dateConflit = dateConflit;
        this.dateCreation = dateCreation;
        this.dateProcession = dateProcession;
        this.traite = traite;
        this.kmAnalyse = kmAnalyse;
        this.kmBase = kmBase;
    }

    public String getAgence() {
        return this.agence;
    }

    public void setAgence(String agence) {
        this.agence = agence;
    }

    public int getCle() {
        return this.cle;
    }

    public void setCle(int cle) {
        this.cle = cle;
    }

    public int getCleConducteur() {
        return this.cleConducteur;
    }

    public void setCleConducteur(int cleConducteur) {
        this.cleConducteur = cleConducteur;
    }

    public String getDateConflit() {
        return this.dateConflit;
    }

    public void setDateConflit(String dateConflit) {
        this.dateConflit = dateConflit;
    }

    public String getNomConducteur() {
        return this.nomConducteur;
    }

    public void setNomConducteur(String nomConducteur) {
        this.nomConducteur = nomConducteur;
    }

    public String getPrenomConducteur() {
        return this.prenomConducteur;
    }

    public void setPrenomConducteur(String prenomConducteur) {
        this.prenomConducteur = prenomConducteur;
    }

    public boolean isTraite() {
        return this.traite;
    }

    public void setTraite(boolean traite) {
        this.traite = traite;
    }

    public int getKmAnalyse() {
        return this.kmAnalyse;
    }

    public void setKmAnalyse(int kmAnalyse) {
        this.kmAnalyse = kmAnalyse;
    }

    public int getKmBase() {
        return this.kmBase;
    }

    public void setKmBase(int kmBase) {
        this.kmBase = kmBase;
    }

    public int getCleTraitant() {
        return this.cleTraitant;
    }

    public void setCleTraitant(int cleTraitant) {
        this.cleTraitant = cleTraitant;
    }

    public String getDateCreation() {
        return this.dateCreation;
    }

    public void setDateCreation(String dateCreation) {
        this.dateCreation = dateCreation;
    }

    public String getDateProcession() {
        return this.dateProcession;
    }

    public void setDateProcession(String dateProcession) {
        this.dateProcession = dateProcession;
    }

    public boolean insert() {
        String sql = "";
        TimsLogger.debug("#Conflit.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO t_conflit (CLE_CONFLIT,CLE_CHAUFFEUR, DATE_CONFLIT, KM_BASE, KM_ANALYSE,CLE_USER, CLE_TRAITANT,TRAITE,DATE_CREATION,DATE_PROCESSION) VALUES (GEN_T_CONFLIT.nextval,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO t_conflit (CLE_CHAUFFEUR, DATE_CONFLIT, KM_BASE, KM_ANALYSE,CLE_USER, CLE_TRAITANT,TRAITE,DATE_CREATION,DATE_PROCESSION) VALUES (?,?,?,?,?,?,?,?,?)";
        }
        try {
            this.statement = Conflit.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.cleConducteur, 4);
            this.statement.setDate(2, Date.valueOf(this.dateConflit));
            this.statement.setObject(3, (Object)this.kmBase, 4);
            this.statement.setObject(4, (Object)this.kmAnalyse, 4);
            this.statement.setObject(5, (Object)this.cleUser, 4);
            this.statement.setObject(6, (Object)this.cleTraitant, 4);
            this.statement.setObject(7, (Object)(this.traite ? 1 : 0), 4);
            this.statement.setDate(8, Date.valueOf(this.dateCreation));
            this.statement.setDate(9, Date.valueOf(this.dateProcession));
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public byte[] write(OutputStream out) {
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = ConversionTime.dateStringToBinary(this.dateConflit);
            activite = String.valueOf(activite) + ConversionTime.dateStringToBinary(this.dateCreation);
            activite = String.valueOf(activite) + ConversionTime.dateStringToBinary(this.dateProcession);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.kmAnalyse + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.kmBase + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + (this.traite ? "100" : "000");
            activite = String.valueOf(activite) + Integer.toBinaryString(this.cleUser + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.cleTraitant + (int)Math.pow(2.0, 11.0)).substring(1);
            int x = 0;
            while (x < 10) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            out.write(-127);
            out.write((byte)(tmp.size() / 255 + 1));
            out.write((byte)tmp.size());
            tmp.writeTo(out);
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("write()# error => " + ex.getMessage());
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 10) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            TimsLogger.debug("#Conflit.read#" + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x]) + " => " + tmp.substring(x * 8));
            ++x;
        }
        this.dateConflit = ConversionTime.binaryToDateString(tmp);
        this.dateCreation = ConversionTime.binaryToDateString(tmp.substring(13));
        this.dateProcession = ConversionTime.binaryToDateString(tmp.substring(26));
        this.kmAnalyse = Integer.parseInt(tmp.substring(39, 50), 2);
        this.kmBase = Integer.parseInt(tmp.substring(50, 61), 2);
        this.traite = tmp.substring(61, 62).equals("1");
        this.cleUser = Integer.parseInt(tmp.substring(64, 72), 2);
        this.cleTraitant = Integer.parseInt(tmp.substring(72, 80), 2);
    }
}

