/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class ConsumptionEval
extends MainElement {
    public static final String table = "CONSUMPTION_EVAL";
    private static Vector<ConsumptionEval> list = null;
    private int id = 0;
    private String name = "";
    private int percentage = 0;
    private int color = 0;

    public ConsumptionEval() {
    }

    public ConsumptionEval(int id, String name, int percentage, int color) {
        this.id = id;
        this.name = name;
        this.percentage = percentage;
        this.color = color;
    }

    public boolean equals(Object o) {
        return o instanceof ConsumptionEval && this.name == ((ConsumptionEval)o).getName();
    }

    public Object clone() {
        return new ConsumptionEval(this.id, this.name, this.percentage, this.color);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + ConsumptionEval.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = ConsumptionEval.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.percentage = rs.getInt("PERCENTAGE");
                    this.color = rs.getInt("COLOR");
                    this.name = rs.getString("NAME");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("genericLoad()# sql = " + sql + " => " + ex.getMessage());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO CONSUMPTION_EVAL (" + ConsumptionEval.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO CONSUMPTION_EVAL (" + ConsumptionEval.getAllFields().substring(ConsumptionEval.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?)";
        }
        try {
            this.statement = ConsumptionEval.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.percentage, 4);
            this.statement.setObject(3, (Object)this.color, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("insert()# sql = " + sql + " => " + ex.getMessage());
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE CONSUMPTION_EVAL SET  NAME=? , PERCENTAGE=? , COLOR=?  WHERE ID=?";
        try {
            this.statement = ConsumptionEval.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.percentage, 4);
            this.statement.setObject(3, (Object)this.color, 4);
            this.statement.setObject(4, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("updateValue()# sql = " + sql + " => " + ex.getMessage());
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getPercentage() {
        return this.percentage;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int vehicleId) {
        this.color = vehicleId;
    }

    public void setPercentage(int driverId) {
        this.percentage = driverId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private static String getAllFields() {
        return "ID, NAME, PERCENTAGE, COLOR";
    }

    public boolean compareAndUpdate(String name, int percentage, int color) {
        String tracer = String.valueOf(LanguageTranslator.getString("consumption.evaluation")) + " n\u00b0 " + this.id + "\n";
        if (percentage != this.percentage) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.percentage") + " '" + this.percentage + "' => '" + percentage + "'\n";
            this.setPercentage(percentage);
        }
        if (color != this.color) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.color") + " '" + this.color + "' => '" + color + "'\n";
            this.setColor(color);
        }
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.name") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("consumption.evaluation")) + " n\u00b0 " + this.id + "\n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("compareAndUpdate# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM CONSUMPTION_EVAL WHERE ID=?";
        try {
            this.statement = ConsumptionEval.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Vector<ConsumptionEval> loadList(String filters) {
        Vector<ConsumptionEval> liste = new Vector<ConsumptionEval>();
        String sql = "SELECT " + ConsumptionEval.getAllFields() + " FROM " + table + (filters != null && !filters.equals("") ? " WHERE " + filters.substring(4) : "") + " ORDER BY PERCENTAGE";
        try {
            ResultSet rs = null;
            Statement stm = ConsumptionEval.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                ConsumptionEval tmp = new ConsumptionEval(rs.getInt("ID"), rs.getString("NAME"), rs.getInt("PERCENTAGE"), rs.getInt("COLOR"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("loadList()# sql = " + sql + " => " + ex.getMessage());
        }
        return liste;
    }

    public static Vector<ConsumptionEval> getList() {
        if (list == null) {
            list = ConsumptionEval.loadList(null);
        }
        return list;
    }

    public static ConsumptionEval get(Vector<ConsumptionEval> ceList, int ceId) throws DBObjectNotFoundException {
        if (ceList == null) {
            ceList = ConsumptionEval.getList();
        }
        for (ConsumptionEval tmp : ceList) {
            if (tmp.getId() != ceId) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("ConsumptionEval");
    }

    public static boolean get(Object object, int consumptionEvalId) {
        return false;
    }

    public static void setList(Vector<ConsumptionEval> list) {
        ConsumptionEval.list = list;
    }
}

