/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.CustomReportGroup;
import fr.pgh.data.bdd.CustomReportParameter;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transport.report.generator.TimeConverter;
import transport.report.generator.TimeConverterFactory;

public class CustomReport
extends MainElement {
    public static final String table = "CUSTOM_REPORT";
    public static final String DEFAULT_NAME = LanguageTranslator.getString("report.custom");
    public static final int SERVICE = 1;
    public static final int EXPENSE = 2;
    public static final int OFFENCE = 3;
    public static final int GENERIC = 0;
    private int id = 0;
    private String name = null;
    private int type = 0;
    private TimeConverter timeConverter = null;
    private Vector<CustomReportColumn> column = null;
    private Vector<CustomReportGroup> groups = null;
    private HashMap<String, Object> properties = null;

    public CustomReport(int id, String name, int type, Vector<CustomReportColumn> column, Vector<CustomReportGroup> groups, HashMap<String, Object> properties) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.column = column;
        this.groups = groups;
        this.properties = properties;
    }

    public CustomReport(int id, String name, int type, Vector<CustomReportColumn> column, HashMap<String, Object> properties) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.column = column;
        this.properties = properties;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TimeConverter getTimeConverter() {
        if (this.timeConverter == null) {
            int type = this.getProperties().get("RESOLUTION") == null ? 1 : Integer.parseInt(this.getProperties().get("RESOLUTION").toString());
            TimsLogger.info("#CustomReport.getTimeConverter# Report " + this.name + " has a " + type + " timeConverter");
            this.timeConverter = TimeConverterFactory.getTimeConverter(type);
        }
        return this.timeConverter;
    }

    public void setTimeConverter(TimeConverter timeConverter) {
        this.timeConverter = timeConverter;
    }

    public Vector<CustomReportColumn> getColumn() {
        if (this.column == null) {
            this.column = CustomReportColumn.loadList(this.getId());
            TimsLogger.info("#CustomReport.getColumn# Report " + this.name + " has " + this.column.size() + " columns");
        }
        return this.column;
    }

    public void setColumn(Vector<CustomReportColumn> column) {
        this.column = column;
    }

    public void setGroups(Vector<CustomReportGroup> groups) {
        this.groups = groups;
    }

    public Vector<CustomReportGroup> getGroups() {
        if (this.groups == null) {
            this.groups = CustomReportGroup.loadList(this.getId());
            TimsLogger.info("#CustomReport.getGroup# Report " + this.name + " has " + this.groups.size() + " groups");
        }
        return this.groups;
    }

    public HashMap<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = this.getId() != 0 ? CustomReportParameter.loadList(this.getId()) : new HashMap();
            TimsLogger.info("#CustomReport.getProperties# Report " + this.name + " has " + this.properties.size() + " properties");
        }
        return this.properties;
    }

    public void setProperties(HashMap<String, Object> properties) {
        this.properties = properties;
    }

    public boolean updateProperty(String propertyName, Object propertyValue) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(propertyName, propertyValue);
        return true;
    }

    public boolean update() {
        Transport.bdd.startTransaction();
        if (this.id != 0) {
            if (!this.delete()) {
                Transport.bdd.rollback();
                return false;
            }
            this.id = 0;
        }
        if (!this.insert()) {
            Transport.bdd.rollback();
            return false;
        }
        Transport.bdd.commit();
        return true;
    }

    public boolean updateValues() {
        boolean toReturn = true;
        String sql = "UPDATE CUSTOM_REPORT SET NAME=?,TYPE=? WHERE ID=?";
        try {
            this.statement = CustomReport.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.type, 4);
            this.statement.setObject(3, (Object)this.id, 4);
            this.statement.executeUpdate();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
            toReturn = false;
        }
        catch (SQLException e) {
            e.printStackTrace();
            toReturn = false;
        }
        return toReturn;
    }

    public boolean insert() {
        String sql;
        boolean toReturn;
        block18: {
            BddTransport.getInstance().startTransaction();
            toReturn = true;
            sql = "";
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO CUSTOM_REPORT (ID, NAME, TYPE) VALUES (GEN_CUSTOM_REPORT.nextval,?,?)";
                this.statement = CustomReport.getConnection().prepareStatement(sql);
                break block18;
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO CUSTOM_REPORT (NAME, TYPE) VALUES (?,?)";
                this.statement = CustomReport.getConnection().prepareStatement(sql, 1);
                break block18;
            }
            TimsLogger.error("#CustomReport.insert# database type unrecognized");
            return false;
        }
        try {
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.type, 4);
            this.statement.executeUpdate();
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                ResultSet resultSet = this.statement.getGeneratedKeys();
                if (!resultSet.next()) {
                    TimsLogger.warn("#CustomReport.insert# no auto generated key availaible");
                } else {
                    TimsLogger.debug("#CustomReport.insert# auto generated key value = " + resultSet.getInt(1));
                    this.id = resultSet.getInt(1);
                }
                resultSet.close();
            }
            if (this.id == 0) {
                if (this.loadId()) {
                    TimsLogger.debug("#CustomReport.insert# generated key value = " + this.id);
                } else {
                    TimsLogger.warn("#CustomReport.insert# no generated key availaible");
                }
            }
            for (CustomReportColumn customReportColumn : this.getColumn()) {
                customReportColumn.setCustomReportId(this.id);
                if (customReportColumn.insert()) continue;
                toReturn = false;
                break;
            }
            if (toReturn) {
                for (Map.Entry entry : this.getProperties().entrySet()) {
                    CustomReportParameter toAdd;
                    if (entry.getValue() == null || entry.getValue().toString().equals("") || ((String)entry.getKey()).equals("AGENCIES") || ((String)entry.getKey()).equals("DRIVERS") || ((String)entry.getKey()).equals("BEGIN") || ((String)entry.getKey()).equals("END") || ((String)entry.getKey()).equals(table) || (toAdd = new CustomReportParameter(0, this.id, (String)entry.getKey(), entry.getValue().toString(), null)).insert()) continue;
                    toReturn = false;
                }
            }
            if (toReturn) {
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
        }
        catch (CommunicationsException communicationsException) {
            BddTransport.getInstance().showTimeout();
            toReturn = false;
        }
        catch (SQLException sQLException) {
            TimsLogger.error("insert()# sql = " + sql + " => " + sQLException.getMessage());
            toReturn = false;
        }
        if (toReturn) {
            BddTransport.getInstance().commit();
        } else {
            BddTransport.getInstance().rollback();
        }
        return toReturn;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID) AS ID FROM CUSTOM_REPORT WHERE NAME = ?";
        try {
            try {
                this.statement = CustomReport.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.name, 12);
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    TimsLogger.info("#CustomReport.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("loadId()# sql = " + sql + " => " + ex.getMessage());
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean delete() {
        BddTransport.getInstance().startTransaction();
        boolean toReturn = false;
        String sql = "DELETE FROM CUSTOM_REPORT WHERE ID=?";
        try {
            this.statement = CustomReport.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            for (CustomReportColumn toAdd : this.getColumn()) {
                if (toAdd.delete()) continue;
                toReturn = false;
                break;
            }
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (toReturn) {
            BddTransport.getInstance().commit();
        } else {
            BddTransport.getInstance().rollback();
        }
        return toReturn;
    }

    public static Vector<CustomReport> loadList(int type) {
        Vector<CustomReport> result = new Vector<CustomReport>();
        String sql = "";
        try {
            sql = "SELECT ID, NAME, TYPE FROM CUSTOM_REPORT";
            if (type != 0) {
                sql = String.valueOf(sql) + " WHERE TYPE = " + type;
            }
            TimsLogger.debug(sql);
            Statement stm = CustomReport.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                CustomReport tmp = new CustomReport(rs.getInt("ID"), rs.getString("NAME"), rs.getInt("TYPE"), null, null);
                result.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("loadId()# sql = " + sql + " => " + ex.getMessage());
        }
        return result;
    }
}

