/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class CustomReportColumn
extends MainElement {
    public static final String table = "CUSTOM_REPORT_COLUMN";
    public static final String DEFAULT_DATE_FORMAT = "dd/MM/yyyy HH:mm";
    public static final String[] DATE_FORMAT = new String[]{"dd/MM/yyyy HH:mm", "dd/MM/yyyy"};
    public static final String[] INTEGER_FORMAT = new String[]{"heure", "nombre"};
    private int id = 0;
    private int customReportId = 0;
    private String name = null;
    private String visibleName = null;
    private String type = null;
    private String expression = null;
    private int width = 0;
    private int position = 0;
    private boolean totalRequired = false;

    public CustomReportColumn(int id, int reportId, String name, String visibleName, String type, String expression, int width, int position, boolean totalRequired) {
        this.id = id;
        this.customReportId = reportId;
        this.name = name;
        this.visibleName = visibleName;
        this.type = type;
        this.expression = expression;
        this.width = width;
        this.position = position;
        this.totalRequired = totalRequired;
    }

    public CustomReportColumn(int id, int reportId, String name, String visibleName, String type, String expression, int width, int position) {
        this(id, reportId, name, visibleName, type, expression, width, position, false);
    }

    public String toString() {
        return "[" + this.visibleName + " (" + this.name + ") " + this.type + "]";
    }

    public CustomReportColumn(int id, int reportId, String name, String type, String expression, int width, int position) {
        this(id, reportId, name, name, type, expression, width, position, false);
    }

    public CustomReportColumn(int id, int reportId, String name, String type, String expression, int width, int position, boolean totalRequired) {
        this(id, reportId, name, name, type, expression, width, position, totalRequired);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getCustomReportId() {
        return this.customReportId;
    }

    public void setCustomReportId(int reportId) {
        this.customReportId = reportId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVisibleName() {
        return this.visibleName;
    }

    public void setVisibleName(String visibleName) {
        this.visibleName = visibleName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isTotalRequired() {
        return this.totalRequired;
    }

    public void setTotalRequired(boolean totalRequired) {
        this.totalRequired = totalRequired;
    }

    public boolean insert() {
        boolean toReturn = true;
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO CUSTOM_REPORT_COLUMN (ID, CUSTOM_REPORT_ID, NAME, VISIBLE_NAME, TYPE, EXPRESSION, WIDTH, POSITION) VALUES (GEN_CUSTOM_REPORT_COLUMN.nextval,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO CUSTOM_REPORT_COLUMN (CUSTOM_REPORT_ID, NAME, VISIBLE_NAME, TYPE, EXPRESSION, WIDTH, POSITION) VALUES (?,?,?,?,?,?,?)";
        }
        try {
            this.statement = CustomReportColumn.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.customReportId, 4);
            this.statement.setObject(2, (Object)this.name, 12);
            this.statement.setObject(3, (Object)this.visibleName, 12);
            this.statement.setObject(4, (Object)this.type, 12);
            this.statement.setObject(5, (Object)this.expression, 12);
            this.statement.setObject(6, (Object)this.width, 4);
            this.statement.setObject(7, (Object)this.position, 4);
            this.statement.executeUpdate();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
        }
        catch (CommunicationsException ex) {
            toReturn = false;
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            toReturn = false;
            TimsLogger.error("insert()# sql = " + sql + " => " + ex.getMessage());
        }
        return toReturn;
    }

    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM CUSTOM_REPORT_COLUMN WHERE ID=?";
        try {
            try {
                this.statement = CustomReportColumn.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public static Vector<CustomReportColumn> loadList(int columnReportId) {
        Vector<CustomReportColumn> result = new Vector<CustomReportColumn>();
        String sql = "";
        try {
            sql = "SELECT ID, CUSTOM_REPORT_ID, TYPE, NAME, VISIBLE_NAME, EXPRESSION, WIDTH, POSITION FROM CUSTOM_REPORT_COLUMN";
            if (columnReportId != 0) {
                sql = String.valueOf(sql) + " WHERE CUSTOM_REPORT_ID = " + columnReportId;
            }
            sql = String.valueOf(sql) + " ORDER BY POSITION";
            TimsLogger.debug(sql);
            Statement stm = CustomReportColumn.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                CustomReportColumn tmp = new CustomReportColumn(rs.getInt("ID"), rs.getInt("CUSTOM_REPORT_ID"), rs.getString("NAME"), rs.getString("VISIBLE_NAME"), rs.getString("TYPE"), rs.getString("EXPRESSION"), rs.getInt("WIDTH"), rs.getInt("POSITION"));
                result.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("loadList()# sql = " + sql + " => " + ex.getMessage());
        }
        return result;
    }
}

