/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class DCMissingDriverActivity
extends MainElement
implements Cloneable {
    public static final String table = "DC_MISSING_DRIVER_ACTIVITY";
    private int id = 0;
    private int driverId = 0;
    private int dataControlId = 0;
    private Date begin = null;
    private Date end = null;

    public DCMissingDriverActivity() {
    }

    public DCMissingDriverActivity clone() throws CloneNotSupportedException {
        return (DCMissingDriverActivity)super.clone();
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public int getDataControlId() {
        return this.dataControlId;
    }

    public void setDataControlId(int dataControlId) {
        this.dataControlId = dataControlId;
    }

    public Date getBegin() {
        return this.begin;
    }

    public void setBegin(Date begin) {
        this.begin = begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public String toString() {
        return "DCMissingDriverActivities id " + this.id + " : {driverId = " + this.driverId + "} {begin = " + this.begin + "} {end = " + this.end + "}";
    }

    public DCMissingDriverActivity(int id, int dataControlId, int driverId, Date begin, Date end) {
        this.id = id;
        this.dataControlId = dataControlId;
        this.driverId = driverId;
        this.begin = begin;
        this.end = end;
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = DCMissingDriverActivity.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#DCMissingDriverActivities.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#DCMissingDriverActivities.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.driverId = rs.getInt("DRIVER_ID");
                    this.dataControlId = rs.getInt("DATA_CONTROL_ID");
                    this.begin = rs.getDate("BEGIN");
                    this.end = rs.getDate("END");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#DCMissingDriverActivities.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#DCMissingDriverActivities.insert()#");
        try {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO DC_MISSING_DRIVER_ACTIVITY (" + DCMissingDriverActivity.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?)";
                this.statement = DCMissingDriverActivity.getConnection().prepareStatement(sql);
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO DC_MISSING_DRIVER_ACTIVITY (" + DCMissingDriverActivity.getAllFields().substring(DCMissingDriverActivity.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?)";
                this.statement = DCMissingDriverActivity.getConnection().prepareStatement(sql, 1);
            }
            this.statement.setObject(1, (Object)this.dataControlId, 4);
            this.statement.setObject(2, (Object)this.driverId, 4);
            this.statement.setTimestamp(3, new Timestamp(this.begin.getTime()));
            this.statement.setTimestamp(4, new Timestamp(this.end.getTime()));
            this.statement.executeUpdate();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    private static String getAllFields() {
        return "ID, DATA_CONTROL_ID, DRIVER_ID, BEGIN, END";
    }

    public static ArrayList<DCMissingDriverActivity> loadList(int dataControlId) {
        ArrayList<DCMissingDriverActivity> liste = new ArrayList<DCMissingDriverActivity>();
        String sql = "SELECT " + DCMissingDriverActivity.getAllFields() + " FROM " + table;
        if (dataControlId != 0) {
            sql = String.valueOf(sql) + " WHERE DATA_CONTROL_ID =" + dataControlId;
        }
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = DCMissingDriverActivity.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate liste import activit\u00e9", "#DCMissingDriverActivities.loadLastList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                DCMissingDriverActivity tmp = new DCMissingDriverActivity(rs.getInt("ID"), rs.getInt("DATA_CONTROL_ID"), rs.getInt("DRIVER_ID"), new Date(rs.getTimestamp("BEGIN").getTime()), new Date(rs.getTimestamp("END").getTime()));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("DCMissingDriverActivities.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }
}

