/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class DCVehicleOffenceAlert
extends MainElement
implements Cloneable {
    public static final String table = "DC_VEHICLE_OFFENCE_ALERT";
    private int id = 0;
    private int vehicleId = 0;
    private int dataControlId = 0;
    private Date offenceDate = null;
    private int offenceId = 0;

    public DCVehicleOffenceAlert() {
    }

    public DCVehicleOffenceAlert clone() throws CloneNotSupportedException {
        return (DCVehicleOffenceAlert)super.clone();
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int vehicleId) {
        this.vehicleId = vehicleId;
    }

    public int getDataControlId() {
        return this.dataControlId;
    }

    public void setDataControlId(int dataControlId) {
        this.dataControlId = dataControlId;
    }

    public Date getOffenceDate() {
        return this.offenceDate;
    }

    public void setOffenceDate(Date offenceDate) {
        this.offenceDate = offenceDate;
    }

    public int getOffenceId() {
        return this.offenceId;
    }

    public void setOffenceId(int offenceId) {
        this.offenceId = offenceId;
    }

    public String toString() {
        return "DCVehicleOffenceAlert id " + this.id + " : {vehicleId = " + this.vehicleId + "} {offenceDate = " + this.offenceDate + "} {offenceId = " + this.offenceId + "}";
    }

    public DCVehicleOffenceAlert(int id, int dataControlId, int vehicleId, Date offenceDate, int offenceId) {
        this.id = id;
        this.dataControlId = dataControlId;
        this.vehicleId = vehicleId;
        this.offenceDate = offenceDate;
        this.offenceId = offenceId;
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = DCVehicleOffenceAlert.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#DCVehicleOffenceAlert.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#DCVehicleOffenceAlert.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.vehicleId = rs.getInt("VEHICLE_ID");
                    this.dataControlId = rs.getInt("DATA_CONTROL_ID");
                    this.offenceDate = rs.getDate("OFFENCE_DATE");
                    this.offenceId = rs.getInt("OFFENCE_ID");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#DCVehicleOffenceAlert.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#DCVehicleOffenceAlert.insert()#");
        try {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO DC_VEHICLE_OFFENCE_ALERT (" + DCVehicleOffenceAlert.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?)";
                this.statement = DCVehicleOffenceAlert.getConnection().prepareStatement(sql);
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO DC_VEHICLE_OFFENCE_ALERT (" + DCVehicleOffenceAlert.getAllFields().substring(DCVehicleOffenceAlert.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?)";
                this.statement = DCVehicleOffenceAlert.getConnection().prepareStatement(sql, 1);
            }
            this.statement.setObject(1, (Object)this.dataControlId, 4);
            this.statement.setObject(2, (Object)this.vehicleId, 4);
            this.statement.setTimestamp(3, new Timestamp(this.offenceDate.getTime()));
            this.statement.setObject(2, (Object)this.offenceId, 4);
            this.statement.executeUpdate();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    private static String getAllFields() {
        return "ID, DATA_CONTROL_ID, VEHICLE_ID, OFFENCE_DATE, OFFENCE_ID";
    }

    public static ArrayList<DCVehicleOffenceAlert> loadList(int dataControlId) {
        ArrayList<DCVehicleOffenceAlert> liste = new ArrayList<DCVehicleOffenceAlert>();
        String sql = "SELECT " + DCVehicleOffenceAlert.getAllFields() + " FROM " + table;
        if (dataControlId != 0) {
            sql = String.valueOf(sql) + " WHERE DATA_CONTROL_ID =" + dataControlId;
        }
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = DCVehicleOffenceAlert.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate liste import activit\u00e9", "#DCMissingVuActivity.loadLastList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                DCVehicleOffenceAlert tmp = new DCVehicleOffenceAlert(rs.getInt("ID"), rs.getInt("DATA_CONTROL_ID"), rs.getInt("VEHICLE_ID"), new Date(rs.getTimestamp("OFFENCE_DATE").getTime()), rs.getInt("OFFENCE_ID"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("DCDriverOffenceAlert.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }
}

