/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.CardDownload;
import fr.pgh.data.bdd.DCMissingDriverActivity;
import fr.pgh.data.bdd.DCMissingVuActivity;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.data.bdd.UevDownload;
import fr.pgh.data.bdd.UevOffence;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class DataRetriever
extends MainElement {
    public static String table = "data_retriever";
    public static ArrayList<DataRetriever> list = null;
    private int id = 0;
    private String name = null;
    private Date analyzeDate = null;
    private Date begin = null;
    private Date end = null;
    private ArrayList<Agence> agencies = null;
    private ArrayList<CardDownload> cardFiles = null;
    private ArrayList<UevDownload> vuFiles = null;
    private ArrayList<DCMissingVuActivity> vuMissingActivities = null;
    private ArrayList<DCMissingDriverActivity> driverMissingActivities = null;
    private ArrayList<Offence> driverOffences = null;
    private ArrayList<UevOffence> vehicleOffences = null;
    private int type = 0;

    public DataRetriever(int id, String name, Date begin, Date end, ArrayList<Agence> agencies) {
        this.id = id;
        this.name = name;
        this.begin = begin;
        this.end = end;
        this.agencies = agencies;
    }

    public boolean equals(Object obj) {
        return obj instanceof DataRetriever && this.id == ((DataRetriever)obj).getId() && this.name.equals(((DataRetriever)obj).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#" + DataRetriever.class.getName() + ".insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + table + " (" + DataRetriever.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + table + " (" + DataRetriever.getAllFields().substring(DataRetriever.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?)";
        }
        try {
            this.statement = DataRetriever.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.type, 4);
            this.statement.setObject(3, (Object)this.type, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE " + table + " SET " + " NAME=? ," + " TYPE=?" + " WHERE ID=?";
        try {
            this.statement = DataRetriever.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.type, 4);
            this.statement.setObject(3, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean compareAndUpdate(String name, int type) {
        String tracer = String.valueOf(LanguageTranslator.getString("data.control")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n";
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (type != this.type) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.type") + " '" + this.type + "' => '" + type + "'\n";
            this.setType(type);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("automatic")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n")) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#" + DataRetriever.class.getName() + "# no changes");
        return true;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Date getBegin() {
        return this.begin;
    }

    public void setBegin(Date begin) {
        this.begin = begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public ArrayList<Agence> getAgencies() {
        return this.agencies;
    }

    public void setAgencies(ArrayList<Agence> agencies) {
        this.agencies = agencies;
    }

    public ArrayList<CardDownload> getCardFiles() {
        return this.cardFiles;
    }

    public void setCardFiles(ArrayList<CardDownload> cardFiles) {
        this.cardFiles = cardFiles;
    }

    public ArrayList<UevDownload> getVuFiles() {
        return this.vuFiles;
    }

    public void setVuFiles(ArrayList<UevDownload> vuFiles) {
        this.vuFiles = vuFiles;
    }

    public ArrayList<DCMissingVuActivity> getVuMissingActivities() {
        return this.vuMissingActivities;
    }

    public void setVuMissingActivities(ArrayList<DCMissingVuActivity> vuMissingActivities) {
        this.vuMissingActivities = vuMissingActivities;
    }

    public ArrayList<DCMissingDriverActivity> getDriverMissingActivities() {
        return this.driverMissingActivities;
    }

    public void setDriverMissingActivities(ArrayList<DCMissingDriverActivity> driverMissingActivities) {
        this.driverMissingActivities = driverMissingActivities;
    }

    public ArrayList<Offence> getDriverOffences() {
        return this.driverOffences;
    }

    public void setDriverOffences(ArrayList<Offence> driverOffences) {
        this.driverOffences = driverOffences;
    }

    public ArrayList<UevOffence> getVehicleOffences() {
        return this.vehicleOffences;
    }

    public void setVehicleOffences(ArrayList<UevOffence> vehicleOffences) {
        this.vehicleOffences = vehicleOffences;
    }

    public void print() {
        TimsLogger.info("#" + DataRetriever.class.getName() + ".print# id = " + this.id + ", name = " + this.name);
    }

    private static String getAllFields() {
        return "ID, NAME, BEGIN, END";
    }

    public static ArrayList<DataRetriever> getList() {
        if (list == null) {
            list = new ArrayList();
            String sql = "SELECT * FROM " + table;
            Statement stm = null;
            ResultSet rs = null;
            try {
                try {
                    stm = DataRetriever.getConnection().createStatement();
                    rs = stm.executeQuery(sql);
                    while (rs.next()) {
                        list.add(new DataRetriever(rs.getInt("ID"), rs.getString("NAME"), rs.getDate("BEGIN"), rs.getDate("END"), null));
                    }
                }
                catch (CommunicationsException ex) {
                    BddTransport.getInstance().showTimeout();
                    try {
                        if (stm != null) {
                            stm.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    try {
                        if (stm != null) {
                            stm.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return list;
    }

    public static DataRetriever find(ArrayList<DataRetriever> list, int taskId) throws DBObjectNotFoundException {
        if (list == null) {
            list = DataRetriever.getList();
        }
        for (DataRetriever tmp : list) {
            if (tmp.getId() != taskId) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException(DataRetriever.class.getName());
    }
}

