/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.MainElement;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;
import transpo.system.util.ProcessType;

public class DriverDayAnomaly
extends MainElement
implements Cloneable {
    public static final String table = "IMPORT_ACTIVITY_ANOMALY";
    private int id = 0;
    private int importActivityId = 0;
    private int driverId = 0;
    private Date anomalyDay = null;
    private Vector<ActiviteConducteur> initial = null;
    private int initialDayType = 0;
    private Vector<ActiviteConducteur> imported = null;
    private int importedDayType = 0;
    private int overrun = 0;
    private ProcessType process = ProcessType.MERGE;

    public DriverDayAnomaly() {
    }

    public DriverDayAnomaly clone() throws CloneNotSupportedException {
        return (DriverDayAnomaly)super.clone();
    }

    public String toString() {
        return "DriverDayAnomaly id " + this.id + " : {importId = " + this.importActivityId + "} {driverId = " + this.driverId + "} {day = " + this.anomalyDay + "} {overrun = " + this.overrun + "} {process = " + (Object)((Object)this.process) + "}";
    }

    public DriverDayAnomaly(int id, int importId, int driverId, Date anomalyDay, int overrun, Vector<ActiviteConducteur> initial, Vector<ActiviteConducteur> imported, ProcessType process) {
        this.id = id;
        this.importActivityId = importId;
        this.driverId = driverId;
        this.anomalyDay = anomalyDay;
        this.overrun = overrun;
        this.initial = initial;
        this.imported = imported;
        this.process = process;
    }

    public DriverDayAnomaly(int id, int importId, int driverId, Date anomalyDay, int overrun, int initial, Vector<ActiviteConducteur> imported, ProcessType process) {
        this.id = id;
        this.importActivityId = importId;
        this.driverId = driverId;
        this.anomalyDay = anomalyDay;
        this.overrun = overrun;
        this.initialDayType = initial;
        this.imported = imported;
        this.process = process;
    }

    public DriverDayAnomaly(int id, int importId, int driverId, Date anomalyDay, int overrun, Vector<ActiviteConducteur> initial, int imported, ProcessType process) {
        this.id = id;
        this.importActivityId = importId;
        this.driverId = driverId;
        this.anomalyDay = anomalyDay;
        this.overrun = overrun;
        this.initial = initial;
        this.importedDayType = imported;
        this.process = process;
    }

    public DriverDayAnomaly(int id, int importId, int driverId, Date anomalyDay, int overrun, int initial, int imported, ProcessType process) {
        this.id = id;
        this.importActivityId = importId;
        this.driverId = driverId;
        this.anomalyDay = anomalyDay;
        this.overrun = overrun;
        this.initialDayType = initial;
        this.importedDayType = imported;
        this.process = process;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getImportActivityId() {
        return this.importActivityId;
    }

    public void setImportActivityId(int importId) {
        this.importActivityId = importId;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public Date getAnomalyDay() {
        return this.anomalyDay;
    }

    public void setAnomalyDay(Date anomalyDay) {
        this.anomalyDay = anomalyDay;
    }

    public Vector<ActiviteConducteur> getInitial() {
        return this.initial;
    }

    public void setInitial(Vector<ActiviteConducteur> initial) {
        this.initial = initial;
    }

    public Vector<ActiviteConducteur> getImported() {
        return this.imported;
    }

    public void setImported(Vector<ActiviteConducteur> imported) {
        this.imported = imported;
    }

    public int getOverrun() {
        return this.overrun;
    }

    public void setOverrun(int overrun) {
        this.overrun = overrun;
    }

    public ProcessType getProcess() {
        return this.process;
    }

    public void setProcess(ProcessType process) {
        this.process = process;
    }

    public int getInitialDayType() {
        return this.initialDayType;
    }

    public void setInitialDayType(int initialDayType) {
        this.initialDayType = initialDayType;
    }

    public int getImportedDayType() {
        return this.importedDayType;
    }

    public void setImportedDayType(int importedDayType) {
        this.importedDayType = importedDayType;
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#DriverDayAnomaly.insert()#");
        try {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO IMPORT_ACTIVITY_ANOMALY (" + DriverDayAnomaly.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?,?,?,?)";
                this.statement = DriverDayAnomaly.getConnection().prepareStatement(sql);
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO IMPORT_ACTIVITY_ANOMALY (" + DriverDayAnomaly.getAllFields().substring(DriverDayAnomaly.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?)";
                this.statement = DriverDayAnomaly.getConnection().prepareStatement(sql, 1);
            }
            this.statement.setObject(1, (Object)this.importActivityId, 4);
            this.statement.setObject(2, (Object)this.driverId, 4);
            this.statement.setDate(3, new java.sql.Date(this.anomalyDay.getTime()));
            this.statement.setObject(4, (Object)(this.initial == null ? null : ActiviteConducteur.toCondensed(this.initial)), 2004);
            this.statement.setObject(5, (Object)this.initialDayType, 4);
            this.statement.setObject(6, (Object)(this.imported == null ? null : ActiviteConducteur.toCondensed(this.imported)), 2004);
            this.statement.setObject(7, (Object)this.importedDayType, 4);
            this.statement.setObject(8, (Object)this.overrun, 4);
            this.statement.setObject(9, (Object)this.process.getId(), 4);
            this.statement.executeUpdate();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private static String getAllFields() {
        return "ID, IMPORT_ACTIVITY_ID, DRIVER_ID, ANOMALY_DAY, INITIAL, INITIAL_DAY_TYPE, IMPORTED, IMPORTED_DAY_TYPE, OVERRUN, PROCESS_TYPE";
    }

    public static ArrayList<DriverDayAnomaly> loadList(int importActivityId) {
        ArrayList<DriverDayAnomaly> liste = new ArrayList<DriverDayAnomaly>();
        String sql = "SELECT " + DriverDayAnomaly.getAllFields() + " FROM " + table;
        if (importActivityId != 0) {
            sql = String.valueOf(sql) + " WHERE IMPORT_ACTIVITY_ID =" + importActivityId;
        }
        try {
            ResultSet rs = null;
            Statement stm = DriverDayAnomaly.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                DriverDayAnomaly tmp = new DriverDayAnomaly(rs.getInt("ID"), rs.getInt("IMPORT_ACTIVITY_ID"), rs.getInt("DRIVER_ID"), new Date(rs.getDate("ANOMALY_DAY").getTime()), rs.getInt("OVERRUN"), null, null, ProcessType.getProcessType(rs.getInt("PROCESS_TYPE")));
                Blob blobActivities = rs.getBlob("INITIAL");
                if (blobActivities == null) {
                    TimsLogger.debug("#DriverDayAnomaly.loadList# No initial condensed activities on");
                } else {
                    tmp.setInitial(ActiviteConducteur.fromCondensed(blobActivities.getBytes(1L, (int)blobActivities.length()), tmp.getAnomalyDay(), tmp.getDriverId()));
                }
                blobActivities = rs.getBlob("IMPORTED");
                if (blobActivities == null) {
                    TimsLogger.debug("#DriverDayAnomaly.loadList# No imported condensed activities on");
                } else {
                    tmp.setImported(ActiviteConducteur.fromCondensed(blobActivities.getBytes(1L, (int)blobActivities.length()), tmp.getAnomalyDay(), tmp.getDriverId()));
                }
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("DriverDayAnomaly.loadLastList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }
}

