/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class DriverError
extends MainElement {
    public static final String table = "driver_error";
    public static final int CARD_EXPIRED = 1;
    public static final int CARD_REPLACED = 2;
    private int id = 0;
    private int driverId = 0;
    private Date errorBegin = null;
    private Date errorEnd = null;
    private int type = 0;
    private String detail = null;
    private Date printed = null;
    private int user = 0;
    private Date processed = null;

    public DriverError() {
    }

    public DriverError(int id, int driverId, Date errorBegin, Date errorEnd, int type, String detail) {
        this.id = id;
        this.driverId = driverId;
        this.errorBegin = errorBegin;
        this.errorEnd = errorEnd;
        this.type = type;
        this.detail = detail;
        this.printed = new Date();
        this.user = ConnexionSettings.getInstance().getUserCle();
        this.processed = null;
    }

    public DriverError(int id, int driverId, Date errorBegin, Date errorEnd, int type, String detail, Date printed, int user, Date processed) {
        this.id = id;
        this.driverId = driverId;
        this.errorBegin = errorBegin;
        this.errorEnd = errorEnd;
        this.type = type;
        this.detail = detail;
        this.printed = printed;
        this.user = user;
        this.processed = processed;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public Date getErrorBegin() {
        return this.errorBegin;
    }

    public void setErrorBegin(Date errorBegin) {
        this.errorBegin = errorBegin;
    }

    public Date getErrorEnd() {
        return this.errorEnd;
    }

    public void setErrorEnd(Date errorEnd) {
        this.errorEnd = errorEnd;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Date getPrinted() {
        return this.printed;
    }

    public void setPrinted(Date printed) {
        this.printed = printed;
    }

    public int getUser() {
        return this.user;
    }

    public void setUser(int user) {
        this.user = user;
    }

    public Date getProcessed() {
        return this.processed;
    }

    public void setProcessed(Date processed) {
        this.processed = processed;
    }

    public void print() {
        TimsLogger.info("#VuError.affiche# du " + this.errorBegin + " au " + this.errorEnd + ". Erreur de " + this.type + ". D\u00e9tail : " + this.detail + ")");
    }

    public boolean insert() {
        String sql = "";
        TimsLogger.debug("#VuError.insert()");
        this.print();
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO driver_error (" + DriverError.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO driver_error (" + DriverError.getAllFields().substring(DriverError.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?)";
        }
        try {
            this.statement = DriverError.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setTimestamp(2, new Timestamp(this.errorBegin.getTime()));
            this.statement.setTimestamp(3, this.errorEnd == null ? null : new Timestamp(this.errorEnd.getTime()));
            this.statement.setObject(4, (Object)this.type, 4);
            this.statement.setObject(5, (Object)this.detail, 12);
            this.statement.setTimestamp(6, new Timestamp(this.printed.getTime()));
            this.statement.setObject(7, (Object)this.user, 4);
            this.statement.setTimestamp(8, this.processed != null ? new Timestamp(this.processed.getTime()) : null);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean update() {
        String sql = "";
        TimsLogger.debug("#UevSession.update()");
        sql = "UPDATE driver_error SET  DRIVER_ID = ?, ERROR_BEGIN = ?, ERROR_END = ?, TYPE = ?, DETAIL = ?, PRINTED = ?, USER = ?, PROCESSED = ? WHERE ID = ?";
        try {
            this.statement = DriverError.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setTimestamp(2, new Timestamp(this.errorBegin.getTime()));
            this.statement.setTimestamp(3, new Timestamp(this.errorEnd.getTime()));
            this.statement.setObject(4, (Object)this.type, 4);
            this.statement.setObject(5, (Object)this.detail, 12);
            this.statement.setTimestamp(6, new Timestamp(this.printed.getTime()));
            this.statement.setObject(7, (Object)this.user, 4);
            this.statement.setTimestamp(8, new Timestamp(this.processed.getTime()));
            this.statement.setObject(9, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static String getAllFields() {
        return "ID, DRIVER_ID, ERROR_BEGIN, ERROR_END, TYPE, DETAIL, PRINTED, USER_ID, PROCESSED";
    }

    public static Vector<DriverError> getDriverError(int driverId, Date begin, Date end) {
        Vector<DriverError> result = new Vector<DriverError>();
        String sql = "";
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                sql = "SELECT " + DriverError.getAllFields() + " FROM " + table;
                String restriction = "";
                if (driverId != 0) {
                    restriction = String.valueOf(restriction) + " AND DRIVER_ID = ?";
                }
                if (begin != null) {
                    restriction = String.valueOf(restriction) + " AND ERROR_BEGIN >= ?";
                }
                if (end != null) {
                    restriction = String.valueOf(restriction) + " AND ERROR_END <= ?";
                }
                if (!restriction.equals("")) {
                    sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
                }
                sql = String.valueOf(sql) + " ORDER BY DRIVER_ID, ERROR_BEGIN";
                stm = DriverError.getConnection().prepareStatement(sql);
                int idx = 1;
                if (driverId != 0) {
                    stm.setObject(idx, driverId, 4);
                    ++idx;
                }
                if (begin != null) {
                    stm.setTimestamp(idx, new Timestamp(begin.getTime()));
                    ++idx;
                }
                if (end != null) {
                    stm.setTimestamp(idx, new Timestamp(end.getTime()));
                    ++idx;
                }
                rs = stm.executeQuery();
                while (rs.next()) {
                    result.add(new DriverError(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getTimestamp("ERROR_BEGIN"), rs.getTimestamp("ERROR_END"), rs.getInt("TYPE"), rs.getString("DETAIL"), rs.getTimestamp("PRINTED"), rs.getInt("USER"), rs.getTimestamp("PROCESSED")));
                }
                rs.close();
                stm.close();
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                TimsLogger.warn("VuError.getVuError(  )  : " + ex);
                TimsLogger.debug("sql = " + sql);
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setProcessed(int driverId, Date begin, Date end, int type) {
        String sql = "";
        Statement stm = null;
        try {
            try {
                sql = "UPDATE driver_error SET PROCESSED = ? ";
                String restriction = "";
                if (driverId != 0) {
                    restriction = String.valueOf(restriction) + " AND DRIVER_ID = ?";
                }
                if (begin != null) {
                    restriction = String.valueOf(restriction) + " AND ERROR_BEGIN >= ?";
                }
                if (end != null) {
                    restriction = String.valueOf(restriction) + " AND ERROR_END <= ?";
                }
                if (type != -1) {
                    restriction = String.valueOf(restriction) + " AND TYPE = ?";
                }
                if (!restriction.equals("")) {
                    sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
                }
                stm = DriverError.getConnection().prepareStatement(sql);
                int idx = 1;
                stm.setObject(idx, driverId, 4);
                ++idx;
                if (begin != null) {
                    stm.setTimestamp(idx, new Timestamp(begin.getTime()));
                    ++idx;
                }
                if (end != null) {
                    stm.setTimestamp(idx, new Timestamp(end.getTime()));
                    ++idx;
                }
                if (type != -1) {
                    stm.setTimestamp(idx, new Timestamp(end.getTime()));
                    ++idx;
                }
                stm.executeUpdate();
                stm.close();
                return;
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
                if (stm == null) return;
                try {
                    stm.close();
                    return;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return;
            }
            catch (Exception ex) {
                TimsLogger.warn("VuError.getVuError(  )  : " + ex);
                TimsLogger.debug("sql = " + sql);
                if (stm == null) return;
                try {
                    stm.close();
                    return;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (stm != null) {
                try {
                    stm.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

