/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class Droit
extends MainElement {
    private int cle = 0;
    private int cleFiche = 0;
    private int cleProfil = 0;
    private String nomFiche;
    private boolean consultation;
    private boolean modification;
    private boolean ajout;
    private boolean suppression;

    public Droit(int cle, int cleProfil, int cleFiche, String fiche, boolean ecr, boolean mod, boolean sup, boolean con) {
        this.cle = cle;
        this.cleFiche = cleFiche;
        this.cleProfil = cleProfil;
        this.nomFiche = fiche;
        this.consultation = con;
        this.modification = mod;
        this.ajout = ecr;
        this.suppression = sup;
    }

    public boolean isAjout() {
        return this.ajout;
    }

    public void setAjout(boolean ajout) {
        this.ajout = ajout;
    }

    public int getCleFiche() {
        return this.cleFiche;
    }

    public void setCleFiche(int cleFiche) {
        this.cleFiche = cleFiche;
    }

    public boolean isConsultation() {
        return this.consultation;
    }

    public void setConsultation(boolean consultation) {
        this.consultation = consultation;
    }

    public boolean isModification() {
        return this.modification;
    }

    public void setModification(boolean modification) {
        this.modification = modification;
    }

    public String getNomFiche() {
        return this.nomFiche;
    }

    public void setNomFiche(String nomFiche) {
        this.nomFiche = nomFiche;
    }

    public boolean isSuppression() {
        return this.suppression;
    }

    public void setSuppression(boolean suppression) {
        this.suppression = suppression;
    }

    public int getCleProfil() {
        return this.cleProfil;
    }

    public void setCleProfil(int cleProfil) {
        this.cleProfil = cleProfil;
    }

    public boolean update() {
        if (this.cle == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean retour = false;
        try {
            try {
                PreparedStatement statement = this.getPreparedStatement();
                statement.setObject(1, (Object)this.cleProfil, 4);
                statement.setObject(2, (Object)this.cleFiche, 4);
                statement.setObject(3, (Object)(this.consultation ? 1 : 0), 4);
                statement.setObject(4, (Object)(this.modification ? 1 : 0), 4);
                statement.setObject(5, (Object)(this.ajout ? 1 : 0), 4);
                statement.setObject(6, (Object)(this.suppression ? 1 : 0), 4);
                if (statement.executeUpdate() == 1) {
                    retour = true;
                }
                statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent("t_droit", Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + "t_droit" + " SET " + " CLE_PROFIL=?, " + " CLE_FICHE=?, " + " CONSULTATION=?, " + " MODIFICATION=?, " + " ECRITURE=?, " + " SUPPRESSION=? " + " WHERE CLE_DROIT=?";
        try {
            try {
                this.statement = Droit.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleProfil, 4);
                this.statement.setObject(2, (Object)this.cleFiche, 4);
                this.statement.setObject(3, (Object)(this.consultation ? 1 : 0), 4);
                this.statement.setObject(4, (Object)(this.modification ? 1 : 0), 4);
                this.statement.setObject(5, (Object)(this.ajout ? 1 : 0), 4);
                this.statement.setObject(6, (Object)(this.suppression ? 1 : 0), 4);
                this.statement.setObject(7, (Object)this.cle, 4);
                if (this.statement.executeUpdate() == 1) {
                    retour = true;
                }
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent("t_droit", Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM t_droit WHERE CLE =?";
        try {
            this.statement = Droit.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.cle);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent("t_droit", Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public PreparedStatement getPreparedStatement() {
        if (this.statement == null) {
            String sql = "";
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO t_droit(CLE_DROIT, CLE_PROFIL, CLE_FICHE, CONSULTATION, MODIFICATION, ECRITURE, SUPPRESSION) VALUES (GEN_T_PROFIL.nextval,?,?,?,?,?,?)";
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + "t_droit" + "(CLE_PROFIL, CLE_FICHE, CONSULTATION, MODIFICATION, ECRITURE, SUPPRESSION) VALUES " + "(?,?,?,?,?,?)";
            }
            try {
                this.statement = Droit.getConnection().prepareStatement(sql);
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
            }
            catch (Exception ex) {
                TimsLogger.error("getPreparedStatement => " + ex.getMessage());
            }
        }
        return this.statement;
    }

    public static boolean updateList(Vector<Droit> toUpdate) {
        for (Droit iter : toUpdate) {
            if (iter.update()) continue;
            return false;
        }
        return true;
    }

    public static boolean createList(int profilId, Vector<Droit> toUpdate) {
        for (Droit iter : toUpdate) {
            iter.setCleProfil(profilId);
            if (iter.insert()) continue;
            return false;
        }
        return true;
    }
}

