/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class EmployeeObligationTypeGroup
extends MainElement {
    public static final String table = "EMPLOYEE_OBLIGATION_TYPE_GROUP";
    private static Vector<EmployeeObligationTypeGroup> list = null;
    private int id = 0;
    private String name = null;
    private String code = null;
    private boolean archived = false;

    public EmployeeObligationTypeGroup() {
    }

    public EmployeeObligationTypeGroup(int id, String name, String code, boolean archive) {
        this.id = id;
        this.name = name;
        this.code = code;
        this.archived = archive;
    }

    public boolean equals(Object o) {
        return o instanceof EmployeeObligationTypeGroup && this.name.equals(((EmployeeObligationTypeGroup)o).getName());
    }

    public String toString() {
        return this.getName();
    }

    public boolean loadByName(String designation) {
        String sql = "SELECT " + EmployeeObligationTypeGroup.getAllFields() + " FROM " + table + " WHERE NAME='" + BddTransport.addSlashes(designation) + "'";
        return this.genericLoad(sql);
    }

    public boolean loadByCode(String code) {
        String sql = "SELECT " + EmployeeObligationTypeGroup.getAllFields() + " FROM " + table + " WHERE CODE='" + BddTransport.addSlashes(code) + "'";
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + EmployeeObligationTypeGroup.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = EmployeeObligationTypeGroup.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#EmployeeObligationTypeGroup.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#EmployeeObligationTypeGroup.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.name = rs.getString("NAME");
                    this.code = rs.getString("CODE");
                    this.archived = rs.getBoolean("ARCHIVED");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("#EmployeeObligationTypeGroup.genericLoad() # sql = " + sql + " => " + ex.getMessage());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#EmployeeObligationTypeGroup.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO EMPLOYEE_OBLIGATION_TYPE_GROUP (" + EmployeeObligationTypeGroup.getAllFields() + ")" + " VALUES (GEN_EOTG.nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO EMPLOYEE_OBLIGATION_TYPE_GROUP (" + EmployeeObligationTypeGroup.getAllFields().substring(EmployeeObligationTypeGroup.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?)";
        }
        try {
            this.statement = EmployeeObligationTypeGroup.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.code, 12);
            this.statement.setObject(3, (Object)this.archived, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE EMPLOYEE_OBLIGATION_TYPE_GROUP SET  NAME=? , CODE=? , ARCHIVED=?  WHERE ID=?";
        try {
            this.statement = EmployeeObligationTypeGroup.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.code, 12);
            this.statement.setObject(3, (Object)this.archived, 4);
            this.statement.setObject(4, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    private static String getAllFields() {
        return "ID, NAME, CODE, ARCHIVED";
    }

    public boolean compareAndUpdate(int id, String name, String code, boolean archive) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.group")) + " n\u00b0 " + id + " (" + this.getName() + ") \n";
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (Fonctions.fieldChange(code, code)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.code + "' => '" + code + "'\n";
            this.setCode(code);
        }
        if (archive != this.archived) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.archive") + " '" + this.archived + "' => '" + archive + "'\n";
            this.setArchived(archive);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.type")) + " n\u00b0 " + id + " (" + this.getName() + ") \n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#EmployeeObligationTypeGroup# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM EMPLOYEE_OBLIGATION_TYPE_GROUP WHERE ID=?";
        try {
            this.statement = EmployeeObligationTypeGroup.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archive) {
        this.archived = archive;
    }

    public static Vector<EmployeeObligationTypeGroup> loadList(boolean archive) {
        Vector<EmployeeObligationTypeGroup> liste = new Vector<EmployeeObligationTypeGroup>();
        String sql = "SELECT " + EmployeeObligationTypeGroup.getAllFields() + " FROM " + table + " WHERE ARCHIVED = " + (archive ? "1" : "0") + " ORDER BY NAME";
        try {
            ResultSet rs = null;
            Statement stm = EmployeeObligationTypeGroup.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                EmployeeObligationTypeGroup tmp = new EmployeeObligationTypeGroup(rs.getInt("ID"), rs.getString("NAME"), rs.getString("CODE"), rs.getBoolean("ARCHIVED"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#loadList() # sql = " + sql + " => " + ex.getMessage());
        }
        return liste;
    }

    public static Vector<EmployeeObligationTypeGroup> getList() {
        if (list == null) {
            list = EmployeeObligationTypeGroup.loadList(false);
        }
        return list;
    }

    public static void setList(Vector<EmployeeObligationTypeGroup> list) {
        EmployeeObligationTypeGroup.list = list;
    }

    public static EmployeeObligationTypeGroup get(int id) throws DBObjectNotFoundException {
        for (EmployeeObligationTypeGroup tmp : EmployeeObligationTypeGroup.getList()) {
            if (tmp.getId() != id) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("EmployeeObligationTypeGroup " + id);
    }
}

