/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.DriverDayAnomaly;
import fr.pgh.data.bdd.DriverDownloadWarning;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class ImportActivity
extends MainElement
implements Cloneable {
    public static final String table = "IMPORT_ACTIVITY";
    private int id = 0;
    private Status state = Status.ANALYZED;
    private Date integrationDate = null;
    private String fileName = null;
    private int userId = 0;
    private ArrayList<DriverDownloadWarning> warnings = null;
    private ArrayList<DriverDayAnomaly> anomalies = null;

    public ImportActivity() {
    }

    public ImportActivity clone() throws CloneNotSupportedException {
        return (ImportActivity)super.clone();
    }

    public String toString() {
        return "ImportActivity id " + this.id + " : {state = " + (Object)((Object)this.state) + "} {integrationDate = " + this.integrationDate + "} {fileName = " + this.fileName + "} {userId = " + this.userId + "}";
    }

    public ImportActivity(int id, Status state, Date integrationDate, String fileName, int userId) {
        this.id = id;
        this.state = state;
        this.integrationDate = integrationDate;
        this.fileName = fileName;
        this.userId = userId;
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + ImportActivity.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = ImportActivity.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#ImportActivity.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#ImportActivity.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.state = Status.getStatus(rs.getInt("STATE"));
                    this.fileName = rs.getString("FILENAME");
                    this.integrationDate = rs.getDate("INTEGRATION_DATE");
                    this.userId = rs.getInt("USER_ID");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#ImportActivity.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#ImportActivity.insert()#");
        try {
            block15: {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO IMPORT_ACTIVITY (" + ImportActivity.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?)";
                    this.statement = ImportActivity.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO IMPORT_ACTIVITY (" + ImportActivity.getAllFields().substring(ImportActivity.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?)";
                    this.statement = ImportActivity.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.state.getId(), 4);
                this.statement.setTimestamp(2, new Timestamp(this.integrationDate.getTime()));
                this.statement.setObject(3, (Object)this.fileName, 12);
                this.statement.setObject(4, (Object)this.userId, 4);
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    try {
                        ResultSet rs = this.statement.getGeneratedKeys();
                        if (!rs.next()) {
                            TimsLogger.debug("#ImportActivity.insert# no auto generated key availaible");
                        } else {
                            TimsLogger.debug("#ImportActivity.insert# auto generated key value = " + rs.getInt(1));
                            this.id = rs.getInt(1);
                        }
                        rs.close();
                    }
                    catch (Exception ex) {
                        TimsLogger.warn("#ImportActivity.insert# unable to retrieve auto generated key");
                        if (Transport.debug < 1) break block15;
                        ex.printStackTrace();
                    }
                }
            }
            if (this.id == 0) {
                if (this.loadId()) {
                    TimsLogger.debug("#ImportActivity.insert# generated key value = " + this.id);
                } else {
                    TimsLogger.debug("#ImportActivity.insert# no generated key availaible");
                }
            }
            for (DriverDayAnomaly d : this.anomalies) {
                d.setImportActivityId(this.id);
                d.insert();
            }
            for (DriverDownloadWarning dd : this.warnings) {
                dd.setImportActivityId(this.id);
                dd.insert();
            }
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID) AS ID FROM IMPORT_ACTIVITY WHERE USER_ID = ?";
        PreparedStatement statement = null;
        try {
            try {
                statement = ImportActivity.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.userId, 4);
                rs = statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    TimsLogger.debug("#ImportActivity.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("ImportActivity.loadId()# exception sql = " + sql);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Status getState() {
        return this.state;
    }

    public void setState(Status state) {
        this.state = state;
    }

    public Date getIntegrationDate() {
        return this.integrationDate;
    }

    public void setIntegrationDate(Date integrationDate) {
        this.integrationDate = integrationDate;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public ArrayList<DriverDownloadWarning> getWarnings() {
        if (this.warnings == null) {
            this.warnings = this.id == 0 ? new ArrayList() : DriverDownloadWarning.loadList(this.id);
        }
        return this.warnings;
    }

    public void setWarnings(ArrayList<DriverDownloadWarning> warnings) {
        this.warnings = warnings;
    }

    public ArrayList<DriverDayAnomaly> getAnomalies() {
        if (this.anomalies == null) {
            this.anomalies = this.id == 0 ? new ArrayList() : DriverDayAnomaly.loadList(this.id);
        }
        return this.anomalies;
    }

    public void setAnomalies(ArrayList<DriverDayAnomaly> anomalies) {
        this.anomalies = anomalies;
    }

    private static String getAllFields() {
        return "ID, STATUS, INTEGRATION_DATE, FILENAME, USER_ID";
    }

    public static Vector<ImportActivity> loadList() {
        Vector<ImportActivity> liste = new Vector<ImportActivity>();
        String sql = "SELECT " + ImportActivity.getAllFields() + " FROM " + table;
        sql = String.valueOf(sql) + " ORDER BY INTEGRATION_DATE DESC";
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = ImportActivity.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate liste import activit\u00e9", "#EmployeeObligation.loadLastList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                ImportActivity tmp = new ImportActivity(rs.getInt("ID"), Status.getStatus(rs.getInt("STATUS")), new Date(rs.getTimestamp("INTEGRATION_DATE").getTime()), rs.getString("FILENAME"), rs.getInt("USER_ID"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("ImportActivity.loadLastList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static enum Status {
        ANALYZED(0, "Analys\u00e9"),
        INTEGRATED(1, "Integr\u00e9"),
        UNAVAILABLE(-1, "Erreur");

        private String text;
        private int id;

        public String getText() {
            return this.text;
        }

        public int getId() {
            return this.id;
        }

        private Status(int id, String text) {
            this.id = id;
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static Status getStatus(int id) {
            Status[] statusArray = Status.values();
            int n = statusArray.length;
            int n2 = 0;
            while (n2 < n) {
                Status toReturn = statusArray[n2];
                if (toReturn.getId() == id) {
                    return toReturn;
                }
                ++n2;
            }
            return null;
        }
    }
}

