/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class Intervention
extends MainElement
implements Cloneable {
    public static final String table = "INTERVENTION";
    public static final int DONE = 0;
    public static final int SCHEDULED = 1;
    public static final int CANCELLED = 2;
    public static final int SUGGESTED = 3;
    public static final int SUGGESTED_AND_LATE = 4;
    private int id = 0;
    private int typeId = 0;
    private int vehicleId = 0;
    private java.util.Date day = null;
    private int km = 0;
    private String performer = null;
    private float moCost = 0.0f;
    private float cost = 0.0f;
    private String attachment = null;
    private int state = 1;

    public Intervention() {
    }

    public Intervention clone() throws CloneNotSupportedException {
        return (Intervention)super.clone();
    }

    public String toString() {
        return "Intervention id " + this.id + " : {typeId = " + this.typeId + "} {vehicleId = " + this.vehicleId + "}" + " {day = " + this.day + "} {performer = " + this.performer + "} {moCost = " + this.moCost + "} {cost = " + this.cost + "} {state = " + this.state + "} {attachment = " + this.attachment + "}";
    }

    public Intervention(int id, int typeId, int vehicleId, java.util.Date day, int km, String performer, float moCost, float cost, int state, String attachment) {
        this.id = id;
        this.typeId = typeId;
        this.vehicleId = vehicleId;
        this.day = day;
        this.km = km;
        this.performer = performer;
        this.moCost = moCost;
        this.cost = cost;
        this.state = state;
        this.attachment = attachment;
    }

    public boolean loadByDay(java.util.Date day, int vehicleId) {
        return false;
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + Intervention.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = Intervention.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#Intervention.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#Intervention.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.typeId = rs.getInt("TYPE_ID");
                    this.vehicleId = rs.getInt("VEHICLE_ID");
                    this.day = rs.getDate("DAY");
                    this.km = rs.getInt("KM");
                    this.performer = rs.getString("PERFORMER");
                    this.moCost = rs.getInt("MO_COST");
                    this.cost = rs.getInt("COST");
                    this.state = rs.getInt("STATE");
                    this.attachment = rs.getString("ATTACHMENT");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#Intervention.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#Intervention.insert()#");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO INTERVENTION (" + Intervention.getAllFields() + ")" + " VALUES (GEN_INTERVENTION.nextval,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO INTERVENTION (" + Intervention.getAllFields().substring(Intervention.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = Intervention.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.typeId, 4);
                this.statement.setObject(2, (Object)this.vehicleId, 4);
                this.statement.setDate(3, new Date(this.day.getTime()));
                this.statement.setObject(4, (Object)this.km, 4);
                this.statement.setObject(5, (Object)this.performer, 12);
                this.statement.setObject(6, (Object)Float.valueOf(this.cost), 4);
                this.statement.setObject(7, (Object)Float.valueOf(this.moCost), 4);
                this.statement.setObject(8, (Object)this.state, 4);
                this.statement.setObject(9, (Object)this.attachment, 12);
                this.statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE INTERVENTION SET  TYPE_ID=? , VEHICLE_ID=? , DAY=? , KM=? , PERFORMER=? , MO_COST=?,  COST=?,  STATE=?,  ATTACHMENT=?  WHERE ID=?";
        try {
            this.statement = Intervention.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.typeId, 4);
            this.statement.setObject(2, (Object)this.vehicleId, 4);
            this.statement.setDate(3, new Date(this.day.getTime()));
            this.statement.setObject(4, (Object)this.km, 4);
            this.statement.setObject(5, (Object)this.performer, 12);
            this.statement.setObject(6, (Object)Float.valueOf(this.moCost), 6);
            this.statement.setObject(7, (Object)Float.valueOf(this.cost), 6);
            this.statement.setObject(8, (Object)this.state, 4);
            this.statement.setObject(9, (Object)this.attachment, 12);
            this.statement.setObject(10, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int vehicleId) {
        this.vehicleId = vehicleId;
    }

    public java.util.Date getDay() {
        return this.day;
    }

    public void setDay(java.util.Date day) {
        this.day = day;
    }

    public int getKm() {
        return this.km;
    }

    public void setKm(int km) {
        this.km = km;
    }

    public String getPerformer() {
        return this.performer;
    }

    public void setPerformer(String performer) {
        this.performer = performer;
    }

    public float getMoCost() {
        return this.moCost;
    }

    public void setMoCost(float moCost) {
        this.moCost = moCost;
    }

    public float getCost() {
        return this.cost;
    }

    public void setCost(float cost) {
        this.cost = cost;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public boolean compareAndUpdate(int typeId, int vehicleId, java.util.Date day, int km, String performer, float moCost, float cost, int state, String attachment) {
        TimsLogger.debug("#Intervention.compareAndUpdate# " + this.toString());
        String tracer = String.valueOf(LanguageTranslator.getString("generics.intervention")) + " n\u00b0 " + this.id + " (" + this.getId() + ") \n";
        if (this.id == 0) {
            this.setTypeId(typeId);
            this.setVehicleId(vehicleId);
            this.setDay(day);
            this.setKm(km);
            this.setPerformer(performer);
            this.setMoCost(moCost);
            this.setCost(cost);
            this.setState(state);
            this.setAttachment(attachment);
            tracer = String.valueOf(LanguageTranslator.getString("generics.intervention")) + "\n" + LanguageTranslator.getString("intervention.type") + " => " + this.typeId + LanguageTranslator.getString("generics.vehicle") + " => " + this.vehicleId + LanguageTranslator.getString("generics.date") + " => " + this.day;
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new java.util.Date(), tracer).insert();
            return this.insert();
        }
        if (typeId != this.typeId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("intervention.type") + " '" + this.typeId + "' => '" + typeId + "'\n";
            this.setTypeId(typeId);
        }
        if (vehicleId != this.vehicleId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.vehicle") + " '" + this.vehicleId + "' => '" + vehicleId + "'\n";
            this.setVehicleId(vehicleId);
        }
        if (Fonctions.fieldChange(day, this.day)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.date") + " '" + this.day + "' => '" + day + "'\n";
            this.setDay(day);
        }
        if (km != this.km) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.km") + " '" + this.km + "' => '" + km + "'\n";
            this.setKm(km);
        }
        if (Fonctions.fieldChange(performer, this.performer)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("intervention.performer") + " '" + this.performer + "' => '" + performer + "'\n";
            this.setPerformer(performer);
        }
        if (moCost != this.moCost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.moCost") + " '" + this.moCost + "' => '" + moCost + "'\n";
            this.setMoCost(moCost);
        }
        if (cost != this.cost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.cost") + " '" + this.cost + "' => '" + cost + "'\n";
            this.setCost(cost);
        }
        if (state != this.state) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.state") + " '" + this.state + "' => '" + state + "'\n";
            this.setState(state);
        }
        if (Fonctions.fieldChange(attachment, this.attachment)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.attachmentAcronym") + " '" + this.attachment + "' => '" + attachment + "'\n";
            this.setAttachment(attachment);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.designation")) + " n\u00b0 " + this.id + " (" + this.getId() + ") \n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#Intervention# no changes");
        return true;
    }

    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM INTERVENTION WHERE ID=?";
        try {
            try {
                this.statement = Intervention.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 1, new java.util.Date(), String.valueOf(LanguageTranslator.getString("generics.intervention")) + " n\u00b0 " + this.id + " => date " + this.getDay() + " vehicle " + this.getVehicleId() + " type " + this.getTypeId()).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public static String getStatusLibelle(int state) {
        if (state == 0) {
            return LanguageTranslator.getString("generics.done");
        }
        if (state == 1) {
            return LanguageTranslator.getString("generics.scheduled");
        }
        if (state == 2) {
            return LanguageTranslator.getString("generics.cancelled");
        }
        if (state == 3) {
            return LanguageTranslator.getString("generics.suggested");
        }
        return LanguageTranslator.getString("generics.unknown");
    }

    private static String getAllFields() {
        return "ID, TYPE_ID, VEHICLE_ID, DAY, KM, PERFORMER, COST, MO_COST, STATE, ATTACHMENT";
    }

    public static Vector<Intervention> loadList(int agencyId, int vehicleId, String begin, String end) {
        Vector<Intervention> liste = new Vector<Intervention>();
        String sql = "SELECT " + Intervention.getAllFields() + " FROM " + table;
        String restriction = "";
        if (agencyId != 0) {
            restriction = String.valueOf(restriction) + " AND VEHICLE_ID IN (SELECT CLE_VEHICULE FROM t_vehicule WHERE CLE_AGENCE = " + agencyId + ")";
        }
        if (vehicleId != 0) {
            restriction = String.valueOf(restriction) + " AND VEHICLE_ID = " + vehicleId;
        }
        if (begin != null) {
            restriction = String.valueOf(restriction) + " AND DAY >= " + BddTransport.getDateStringToSGBDR(begin, false);
        }
        if (end != null) {
            restriction = String.valueOf(restriction) + " AND DAY <= " + BddTransport.getDateStringToSGBDR(end, false);
        }
        if (!restriction.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
        }
        sql = String.valueOf(sql) + " ORDER BY VEHICLE_ID, TYPE_ID, DAY";
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = Intervention.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate intervention", "#Intervention.load() => %s# sql = " + sql, 1);
            while (rs.next()) {
                Intervention tmp = new Intervention(rs.getInt("ID"), rs.getInt("TYPE_ID"), rs.getInt("VEHICLE_ID"), new java.util.Date(rs.getDate("DAY").getTime()), rs.getInt("KM"), rs.getString("PERFORMER"), rs.getFloat("MO_COST"), rs.getFloat("COST"), rs.getInt("STATE"), rs.getString("ATTACHMENT"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Intervention.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<Intervention> loadLastList(int agencyId, int vehicleId) {
        Vector<Intervention> liste = new Vector<Intervention>();
        String sql = "SELECT " + Intervention.getAllFields() + " FROM " + table + " i" + " WHERE day = (select max(day) from " + table + " inter where inter.type_id = i.type_id and inter.vehicle_id = i.vehicle_id) ";
        String restriction = "";
        if (agencyId != 0) {
            restriction = String.valueOf(restriction) + " AND VEHICLE_ID IN (SELECT CLE_VEHICULE FROM t_vehicule WHERE CLE_AGENCE = " + agencyId + ")";
        }
        if (vehicleId != 0) {
            restriction = String.valueOf(restriction) + " AND VEHICLE_ID = " + vehicleId;
        }
        if (!restriction.equals("")) {
            sql = String.valueOf(sql) + restriction;
        }
        sql = String.valueOf(sql) + " ORDER BY TYPE_ID";
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = Intervention.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate derni\u00e8re intervention", "#Intervention.loadLastList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                Intervention tmp = new Intervention(rs.getInt("ID"), rs.getInt("TYPE_ID"), rs.getInt("VEHICLE_ID"), new java.util.Date(rs.getDate("DAY").getTime()), rs.getInt("KM"), rs.getString("PERFORMER"), rs.getFloat("MO_COST"), rs.getFloat("COST"), rs.getInt("STATE"), rs.getString("ATTACHMENT"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Intervention.loadLastList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<Intervention> loadList(String nameRegExp) {
        Vector<Intervention> liste = new Vector<Intervention>();
        String sql = "SELECT " + Intervention.getAllFields() + " FROM " + table + " WHERE ATTACHMENT LIKE \"%" + nameRegExp + "%\" AND TYPE_ID IN (SELECT ID FROM " + "EMPLOYEE_OBLIGATION_TYPE" + " WHERE ARCHIVED = 0)";
        sql = String.valueOf(sql) + " ORDER BY TYPE_ID";
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = Intervention.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate derni\u00e8re obligation", "#EmployeeObligation.loadLastList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                Intervention tmp = new Intervention(rs.getInt("ID"), rs.getInt("TYPE_ID"), rs.getInt("VEHICLE_ID"), new java.util.Date(rs.getDate("DAY").getTime()), rs.getInt("KM"), rs.getString("PERFORMER"), rs.getFloat("MO_COST"), rs.getFloat("COST"), rs.getInt("STATE"), rs.getString("ATTACHMENT"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("EmployeeObligation.loadLastList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }
}

