/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Supplies;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class InterventionType
extends MainElement {
    public static final String table = "INTERVENTION_TYPE";
    private static Vector<InterventionType> list = null;
    private int id = 0;
    private String name = null;
    private String code = null;
    private int periodExpiration = 0;
    private int kmExpiration = 0;
    private float defaultCost = 0.0f;
    private float moCost = 0.0f;
    private Vector<Supplies> supplies = null;
    private boolean archived = false;

    public InterventionType() {
    }

    public InterventionType(int id, String name, String code, int kmExpiration, int periodExpiration, float cost, float moCost, Vector<Supplies> supplies, boolean archive) {
        this.id = id;
        this.name = name;
        this.code = code;
        this.kmExpiration = kmExpiration;
        this.periodExpiration = periodExpiration;
        this.archived = archive;
        this.supplies = supplies;
        this.defaultCost = cost;
        this.moCost = moCost;
    }

    public boolean equals(Object o) {
        return o instanceof InterventionType && this.name.equals(((InterventionType)o).getName());
    }

    public String toString() {
        return this.getName();
    }

    public boolean loadByName(String designation) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(InterventionType.getAllFields()).append(" FROM ").append(table).append(" WHERE NAME='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(designation)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadByCode(String code) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(InterventionType.getAllFields()).append(" FROM ").append(table).append(" WHERE CODE='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(code)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + InterventionType.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = InterventionType.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#InterventionType.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#InterventionType.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.name = rs.getString("NAME");
                    this.code = rs.getString("CODE");
                    this.kmExpiration = rs.getInt("KM_EXPIRATION");
                    this.periodExpiration = rs.getInt("PERIOD_EXPIRATION");
                    this.defaultCost = rs.getInt("DEFAULT_COST");
                    this.moCost = rs.getInt("MO_COST");
                    this.archived = rs.getBoolean("ARCHIVED");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#InterventionType.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#InterventionType.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO INTERVENTION_TYPE (" + InterventionType.getAllFields() + ")" + " VALUES (GEN_INTERVENTION_TYPE.nextval,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO INTERVENTION_TYPE (" + InterventionType.getAllFields().substring(InterventionType.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?)";
        }
        try {
            this.statement = InterventionType.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.code, 12);
            this.statement.setObject(3, (Object)this.kmExpiration, 4);
            this.statement.setObject(4, (Object)this.periodExpiration, 4);
            this.statement.setObject(5, (Object)Float.valueOf(this.defaultCost), 4);
            this.statement.setObject(6, (Object)Float.valueOf(this.moCost), 4);
            this.statement.setObject(7, (Object)this.archived, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE INTERVENTION_TYPE SET  NAME=? , CODE=? , KM_EXPIRATION=? , PERIOD_EXPIRATION=? , DEFAULT_COST=? , MO_COST=? , ARCHIVED=?  WHERE ID=?";
        try {
            this.statement = InterventionType.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.code, 12);
            this.statement.setObject(3, (Object)this.kmExpiration, 4);
            this.statement.setObject(4, (Object)this.periodExpiration, 4);
            this.statement.setObject(5, (Object)Float.valueOf(this.defaultCost), 4);
            this.statement.setObject(6, (Object)Float.valueOf(this.moCost), 4);
            this.statement.setObject(7, (Object)this.archived, 4);
            this.statement.setObject(8, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getPeriodExpiration() {
        return this.periodExpiration;
    }

    public void setPeriodExpiration(int periodExpiration) {
        this.periodExpiration = periodExpiration;
    }

    public int getKmExpiration() {
        return this.kmExpiration;
    }

    public void setKmExpiration(int kmExpiration) {
        this.kmExpiration = kmExpiration;
    }

    public float getDefaultCost() {
        return this.defaultCost;
    }

    public void setDefaultCost(float cost) {
        this.defaultCost = cost;
    }

    public float getMoCost() {
        return this.moCost;
    }

    public void setMoCost(float moCost) {
        this.moCost = moCost;
    }

    public Vector<Supplies> getSupplies() {
        return this.supplies;
    }

    public void setSupplies(Vector<Supplies> supplies) {
        this.supplies = supplies;
    }

    private static String getAllFields() {
        return "ID, NAME, CODE, KM_EXPIRATION, PERIOD_EXPIRATION, DEFAULT_COST, MO_COST, ARCHIVED";
    }

    public boolean compareAndUpdate(int id, String name, String code, int kmExpiration, int periodExpiration, float cost, float moCost, Vector<Supplies> supplies, boolean archive) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.expenses")) + " n\u00b0 " + id + " (" + this.getName() + ") \n";
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (Fonctions.fieldChange(code, this.code)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.code + "' => '" + code + "'\n";
            this.setCode(code);
        }
        if (periodExpiration != this.periodExpiration) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("intervention.periodExpiration") + " '" + this.periodExpiration + "' => '" + periodExpiration + "'\n";
            this.setPeriodExpiration(periodExpiration);
        }
        if (kmExpiration != this.kmExpiration) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("intervention.kmExpiration") + " '" + this.kmExpiration + "' => '" + kmExpiration + "'\n";
            this.setKmExpiration(kmExpiration);
        }
        if (cost != this.defaultCost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("intervention.cost") + " '" + this.defaultCost + "' => '" + cost + "'\n";
            this.setDefaultCost(cost);
        }
        if (moCost != this.moCost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("intervention.cost") + " '" + this.moCost + "' => '" + moCost + "'\n";
            this.setMoCost(moCost);
        }
        if (archive != this.archived) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.archive") + " '" + this.archived + "' => '" + archive + "'\n";
            this.setArchived(archive);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.designation")) + " n\u00b0 " + id + " (" + this.getName() + ") \n")) {
            if (id == 0 && this.insert()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                return true;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#TypeActivite# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM INTERVENTION_TYPE WHERE ID=?";
        try {
            this.statement = InterventionType.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archive) {
        this.archived = archive;
    }

    public static Vector<InterventionType> loadList(boolean archive) {
        Vector<InterventionType> liste = new Vector<InterventionType>();
        String sql = "SELECT " + InterventionType.getAllFields() + " FROM " + table + " WHERE ARCHIVED = " + (archive ? "1" : "0") + " ORDER BY PRIORITY_ORDER, NAME";
        try {
            ResultSet rs = null;
            Statement stm = InterventionType.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                InterventionType tmp = new InterventionType(rs.getInt("ID"), rs.getString("NAME"), rs.getString("CODE"), rs.getInt("KM_EXPIRATION"), rs.getInt("PERIOD_EXPIRATION"), rs.getFloat("DEFAULT_COST"), rs.getFloat("MO_COST"), null, rs.getBoolean("ARCHIVED"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("InterventionType.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<InterventionType> getList() {
        if (list == null) {
            list = InterventionType.loadList(false);
        }
        return list;
    }

    public static void setList(Vector<InterventionType> list) {
        InterventionType.list = list;
    }

    public static InterventionType getInterventionType(int idType) throws DBObjectNotFoundException {
        for (InterventionType tmp : InterventionType.getList()) {
            if (tmp.getId() != idType) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("InterventionType");
    }

    public static InterventionType getInterventionType(String name) throws DBObjectNotFoundException {
        for (InterventionType tmp : InterventionType.getList()) {
            if (!tmp.getName().equals(name)) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("InterventionType");
    }
}

