/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.MainElement;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class Jour
extends MainElement {
    public static final String table = "t_jour";
    public static final String updateTable = "t_jour_modifie";
    public static final int OFFSET = 105;
    public static final int ORIGINAL = 0;
    public static final int CURRENT = 1;
    public static final int UPDATED = 2;
    private int dayId = 0;
    private int driverId = 0;
    private int userId = 0;
    private String date = null;
    private int driving = 0;
    private int work = 0;
    private int availability = 0;
    private int rest = 0;
    private int crew = 0;
    private int unk = 0;
    private int other = 0;
    private int service = 0;
    private int beginTime = 0;
    private int endTime = 0;
    private int night = 0;
    private int km = 0;
    private int update = 0;
    private boolean delete = false;
    private String comment = null;
    private Vector<ActiviteConducteur> activity = null;
    private String sourceName = null;
    private boolean manualInput = false;

    public Jour(int cleJour, int cleConducteur, String dateJour, int cumulConduite, int cumulTravail, int cumulDispo, int cumulRepos, int cumulDoubleEquipage, int cumulInconnu, int cumulAutre, int totalService, int debutJour, int finJour, int heureNuit, int km, int modification, boolean hasBeenDeleted, Vector<ActiviteConducteur> listeActivite, String commentaire, int userId, String sourceName, boolean manualInput) {
        this.dayId = cleJour;
        this.driverId = cleConducteur;
        this.date = dateJour;
        this.driving = cumulConduite;
        this.work = cumulTravail;
        this.availability = cumulDispo;
        this.rest = cumulRepos;
        this.crew = cumulDoubleEquipage;
        this.unk = cumulInconnu;
        this.other = cumulAutre;
        this.service = totalService;
        this.beginTime = debutJour;
        this.endTime = finJour;
        this.night = heureNuit;
        this.km = km;
        this.update = modification;
        this.delete = hasBeenDeleted;
        this.activity = listeActivite;
        this.comment = commentaire;
        this.userId = userId;
        this.sourceName = sourceName;
        this.manualInput = manualInput;
    }

    public Jour(String dateJour, int cumul, int debut, int fin) {
        this.date = dateJour;
        this.service = cumul;
        this.beginTime = debut;
        this.endTime = fin;
    }

    public Jour() {
    }

    public void setJour(int cleConducteur, String dateJour, int cumulConduite, int cumulTravail, int cumulDispo, int cumulRepos, int cumulDoubleEquipage, int cumulInconnu, int cumulAutre, int totalService, int debutJour, int finJour, int heureNuit, int km, int modification, boolean hasBeenDeleted, Vector<ActiviteConducteur> listeActivite, int cleUser, String sourceName, boolean manualInput) {
        this.driverId = cleConducteur;
        this.date = dateJour;
        this.driving = cumulConduite;
        this.work = cumulTravail;
        this.availability = cumulDispo;
        this.rest = cumulRepos;
        this.crew = cumulDoubleEquipage;
        this.unk = cumulInconnu;
        this.other = cumulAutre;
        this.service = totalService;
        this.beginTime = debutJour;
        this.endTime = finJour;
        this.night = heureNuit;
        this.km = km;
        this.update = modification;
        this.delete = hasBeenDeleted;
        this.activity = listeActivite;
        this.userId = cleUser;
        this.sourceName = sourceName;
        this.manualInput = manualInput;
    }

    public void affiche() {
        TimsLogger.debug("#Jour.affiche# " + this.driverId + " " + this.dayId + " " + this.date + " " + this.beginTime + "=>" + this.endTime + " --> C = " + this.driving + ", T = " + this.work + ", D = " + this.availability + ", DE = " + this.crew + ", R = " + this.rest + ", TOTAL = " + this.service + " (" + (this.activity == null ? "null" : Integer.valueOf(this.activity.size())) + " activities)");
    }

    public boolean insert() {
        boolean retour;
        block24: {
            retour = false;
            try {
                String table = table;
                if (this.update != 0) {
                    table = updateTable;
                }
                String sql = "";
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO " + table + "(CLE,CLE_CHAUFFEUR,DATE_JOUR,CONDUITE,TRAVAIL,DISPO,REPOS,DOUBLE_EQUIP," + "AUTRE,EVENEMENT,DISTANCE,CUMUL_T_C_D_DE,HEURE_DEBUT,HEURE_FIN,HEURE_NUIT,CLE_USER, MODIFICATION," + " SUPPRESSION,ACTIVITIES,SOURCE_NAME, MANUAL_INPUT) VALUES " + "(GEN_" + table + ".nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO " + table + "(CLE_CHAUFFEUR,DATE_JOUR,CONDUITE,TRAVAIL,DISPO,REPOS,DOUBLE_EQUIP," + "AUTRE,EVENEMENT,DISTANCE,CUMUL_T_C_D_DE,HEURE_DEBUT,HEURE_FIN,HEURE_NUIT,CLE_USER, MODIFICATION," + " SUPPRESSION,ACTIVITIES,SOURCE_NAME, MANUAL_INPUT) VALUES " + "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                }
                this.statement = Jour.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.driverId, 12);
                this.statement.setDate(2, Date.valueOf(this.date));
                this.statement.setObject(3, (Object)this.driving, 4);
                this.statement.setObject(4, (Object)this.work, 4);
                this.statement.setObject(5, (Object)this.availability, 4);
                this.statement.setObject(6, (Object)this.rest, 4);
                this.statement.setObject(7, (Object)this.crew, 4);
                this.statement.setObject(8, (Object)this.unk, 4);
                this.statement.setObject(9, (Object)this.other, 4);
                this.statement.setObject(10, (Object)this.km, 12);
                this.statement.setObject(11, (Object)this.service, 4);
                this.statement.setObject(12, (Object)this.beginTime, 12);
                this.statement.setObject(13, (Object)this.endTime, 12);
                this.statement.setObject(14, (Object)this.night, 4);
                this.statement.setObject(15, (Object)this.userId, 4);
                this.statement.setObject(16, (Object)this.update, 4);
                this.statement.setObject(17, (Object)this.delete, 4);
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    byte[] act = ActiviteConducteur.toCondensed(this.activity);
                    this.statement.setBinaryStream(18, (InputStream)new BufferedInputStream(new ByteArrayInputStream(act)), act.length);
                } else if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    this.statement.setObject(18, (Object)ActiviteConducteur.toCondensed(this.activity), 2004);
                }
                this.statement.setObject(19, (Object)this.sourceName, 12);
                this.statement.setObject(20, (Object)(this.manualInput ? "1" : "0"), 4);
                this.statement.executeUpdate();
                this.statement.close();
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    break block24;
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
                break block24;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    break block24;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (this.statement != null) {
                            this.statement.close();
                        }
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        TimsLogger.debug("#Jour.insert# insertion d'une journ\u00e9e sur le " + this.date + " (retourne " + retour + ")");
        return retour;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean update() {
        TimsLogger.debug("#Jour.update# mise \u00e0 jour d'une journ\u00e9e");
        String table = table;
        if (this.update != 0) {
            table = updateTable;
        }
        boolean toReturn = false;
        this.affiche();
        String sql = "UPDATE " + table + " SET " + "CLE_CHAUFFEUR = ?, " + "DATE_JOUR = ?, " + "CONDUITE = ?, " + "TRAVAIL = ?, " + "DISPO = ?, " + "REPOS = ?, " + "DOUBLE_EQUIP = ?, " + "AUTRE = ?, " + "EVENEMENT = ?, " + "DISTANCE = ?, " + "CUMUL_T_C_D_DE = ?, " + "HEURE_DEBUT = ?, " + "HEURE_FIN = ?, " + "HEURE_NUIT = ?, " + "CLE_USER = ?, " + "MODIFICATION = ?, " + "SUPPRESSION = ?, " + "ACTIVITIES = ?, " + "SOURCE_NAME = ?, " + "MANUAL_INPUT = ? " + "WHERE CLE=?";
        try {
            try {
                this.statement = Jour.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.driverId, 12);
                this.statement.setDate(2, Date.valueOf(this.date));
                this.statement.setObject(3, (Object)this.driving, 4);
                this.statement.setObject(4, (Object)this.work, 4);
                this.statement.setObject(5, (Object)this.availability, 4);
                this.statement.setObject(6, (Object)this.rest, 4);
                this.statement.setObject(7, (Object)this.crew, 4);
                this.statement.setObject(8, (Object)this.unk, 4);
                this.statement.setObject(9, (Object)this.other, 4);
                this.statement.setObject(10, (Object)this.km, 12);
                this.statement.setObject(11, (Object)this.service, 4);
                this.statement.setObject(12, (Object)this.beginTime, 12);
                this.statement.setObject(13, (Object)this.endTime, 12);
                this.statement.setObject(14, (Object)this.night, 4);
                this.statement.setObject(15, (Object)this.userId, 4);
                this.statement.setObject(16, (Object)this.update, 4);
                this.statement.setObject(17, (Object)this.delete, 4);
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    byte[] act = ActiviteConducteur.toCondensed(this.activity);
                    this.statement.setBinaryStream(18, (InputStream)new BufferedInputStream(new ByteArrayInputStream(act)), act.length);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    this.statement.setObject(18, (Object)ActiviteConducteur.toCondensed(this.activity), 2004);
                }
                this.statement.setObject(19, (Object)this.sourceName, 12);
                this.statement.setObject(20, (Object)(this.manualInput ? "1" : "0"), 4);
                this.statement.setObject(21, (Object)this.dayId, 4);
                TimsLogger.debug("#Jour.update# sql = " + sql);
                this.statement.executeUpdate();
                this.statement.close();
                toReturn = true;
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean loadCurrent(int driverId, String day) {
        String sql = "SELECT CLE,CLE_CHAUFFEUR,DATE_JOUR,CONDUITE,TRAVAIL,DISPO,REPOS,DOUBLE_EQUIP,AUTRE,EVENEMENT,DISTANCE,CUMUL_T_C_D_DE,HEURE_DEBUT,HEURE_FIN,HEURE_NUIT,CLE_USER, MODIFICATION, SUPPRESSION,ACTIVITIES,SOURCE_NAME FROM t_jour WHERE SUPPRESSION = 0 AND CLE_CHAUFFEUR=" + driverId + " AND DATE_JOUR=\"" + day + "\"" + " AND MODIFICATION = 0 UNION ALL " + " SELECT CLE,CLE_CHAUFFEUR,DATE_JOUR,CONDUITE,TRAVAIL,DISPO,REPOS,DOUBLE_EQUIP," + " AUTRE,EVENEMENT,DISTANCE,CUMUL_T_C_D_DE,HEURE_DEBUT,HEURE_FIN,HEURE_NUIT,CLE_USER," + " MODIFICATION, SUPPRESSION,ACTIVITIES,SOURCE_NAME,MANUAL_INPUT" + " FROM " + updateTable + " WHERE CURRENT_VALUE = 1 " + " AND DATE_JOUR=\"" + day + "\"";
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = Jour.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.dayId = rs.getInt("CLE");
                    this.driverId = rs.getInt("CLE_CHAUFFEUR");
                    this.userId = rs.getInt("CLE_USER");
                    this.date = rs.getString("DATE_JOUR");
                    this.driving = rs.getInt("CONDUITE");
                    this.work = rs.getInt("TRAVAIL");
                    this.availability = rs.getInt("DISPO");
                    this.rest = rs.getInt("REPOS");
                    this.crew = rs.getInt("DOUBLE_EQUIP");
                    this.unk = rs.getInt("AUTRE");
                    this.other = rs.getInt("AUTRE");
                    this.service = rs.getInt("CUMUL_T_C_D_DE");
                    this.beginTime = rs.getInt("HEURE_DEBUT");
                    this.endTime = rs.getInt("HEURE_FIN");
                    this.night = rs.getInt("HEURE_NUIT");
                    this.km = rs.getInt("DISTANCE");
                    this.update = rs.getInt("MODIFICATION");
                    this.sourceName = rs.getString("SOURCE_NAME");
                    this.manualInput = rs.getInt("MANUAL_INPUT") == 1;
                    Blob act = rs.getBlob("ACTIVITIES");
                    if (act != null) {
                        this.setActivity(ActiviteConducteur.fromCondensed(act.getBytes(1L, (int)act.length()), this));
                    }
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#Jour.genericLoad() # : " + ex);
                TimsLogger.warn(sql);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public String getSQLInsert() {
        return String.valueOf(this.driverId) + "\t" + this.date + "\t" + this.driving + "\t" + this.work + "\t" + this.availability + "\t" + this.rest + "\t" + this.crew + "\t" + this.unk + "\t" + "0" + "\t" + this.km + "\t" + this.service + "\t" + this.beginTime + "\t" + this.endTime + "\t" + this.night + "\t" + this.userId + "\t" + (this.manualInput ? "1" : "0") + "\t" + (this.sourceName == null ? "\\N" : this.sourceName) + "\t" + Fonctions.parseHexAscii(ActiviteConducteur.toCondensed(this.activity), 0, -1);
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int cleConducteur) {
        this.driverId = cleConducteur;
    }

    public int getDayId() {
        return this.dayId;
    }

    public void setDayId(int cleJour) {
        this.dayId = cleJour;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String commentaire) {
        this.comment = commentaire;
    }

    public int getOther() {
        return this.other;
    }

    public void setOther(int cumulAutre) {
        this.other = cumulAutre;
    }

    public int getDriving() {
        return this.driving;
    }

    public void setDriving(int cumulConduite) {
        this.driving = cumulConduite;
    }

    public int getAvailability() {
        return this.availability;
    }

    public void setAvailability(int cumulDispo) {
        this.availability = cumulDispo;
    }

    public int getCrew() {
        return this.crew;
    }

    public void setCrew(int cumulDoubleEquipage) {
        this.crew = cumulDoubleEquipage;
    }

    public int getUnk() {
        return this.unk;
    }

    public void setUnk(int cumulInconnu) {
        this.unk = cumulInconnu;
    }

    public int getRest() {
        return this.rest;
    }

    public void setRest(int cumulRepos) {
        this.rest = cumulRepos;
    }

    public int getWork() {
        return this.work;
    }

    public void setWork(int cumulTravail) {
        this.work = cumulTravail;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String dateJour) {
        this.date = dateJour;
    }

    public int getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(int debutJour) {
        this.beginTime = debutJour;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int finJour) {
        this.endTime = finJour;
    }

    public int getNight() {
        return this.night;
    }

    public void setNight(int heureNuit) {
        this.night = heureNuit;
    }

    public int getKm() {
        return this.km;
    }

    public void setKm(int km) {
        this.km = km;
    }

    public Vector<ActiviteConducteur> getActivity() {
        return this.activity;
    }

    public void setActivity(Vector<ActiviteConducteur> listeActivite) {
        this.activity = listeActivite;
    }

    public int getUpdate() {
        return this.update;
    }

    public void setUpdate(int modification) {
        this.update = modification;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean supprime) {
        this.delete = supprime;
    }

    public int getService() {
        return this.service;
    }

    public void setService(int totalService) {
        this.service = totalService;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int cleUser) {
        this.userId = cleUser;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public boolean isManualInput() {
        return this.manualInput;
    }

    public void setManualInput(boolean manualInput) {
        this.manualInput = manualInput;
    }

    public void updateTime() {
        TimsLogger.debug("#Jour.updateTime# from C:" + this.driving + " T:" + this.work + " D:" + this.availability + " R:" + this.rest + " DE:" + this.crew + " I:" + this.unk + " A:" + this.other + " TOTAL:" + this.service + " begin:" + this.beginTime + " end:" + this.endTime + " night:" + this.night);
        this.driving = 0;
        this.work = 0;
        this.availability = 0;
        this.rest = 0;
        this.crew = 0;
        this.unk = 0;
        this.other = 0;
        this.service = 0;
        this.beginTime = -1;
        this.endTime = 0;
        this.night = 0;
        for (ActiviteConducteur act : this.activity) {
            if (act.getCleType() == 1) {
                this.driving += act.getDuree();
            } else if (act.getCleType() == 2) {
                this.work += act.getDuree();
            } else if (act.getCleType() == 3) {
                this.availability += act.getDuree();
            } else if (act.getCleType() == 4) {
                this.rest += act.getDuree();
            } else if (act.getCleType() == 5) {
                this.crew += act.getDuree();
            } else if (act.getCleType() == 7) {
                this.unk += act.getDuree();
            } else {
                this.other += act.getDuree();
            }
            if (!act.isRest()) {
                if (this.beginTime == -1) {
                    this.beginTime = act.getHeureDebut();
                }
                this.service += act.getDuree();
                this.endTime = act.getHeureFin();
            }
            this.night += Fonctions.getTempsNuit(act);
        }
        TimsLogger.debug("#Jour.updateTime# to C:" + this.driving + " T:" + this.work + " D:" + this.availability + " R:" + this.rest + " DE:" + this.crew + " I:" + this.unk + " A:" + this.other + " TOTAL:" + this.service + " begin:" + this.beginTime + " end:" + this.endTime + " night:" + this.night);
    }

    public byte[] write(OutputStream out) {
        this.affiche();
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = ConversionTime.dateStringToBinary(this.date);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.beginTime + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.endTime + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.driving + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.work + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.availability + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.rest + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.crew + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.unk + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.other + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.night + (int)Math.pow(2.0, 10.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.km + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.update + (int)Math.pow(2.0, 4.0)).substring(1);
            activite = String.valueOf(activite) + (this.delete ? "1" : "0");
            activite = String.valueOf(activite) + Integer.toBinaryString(this.userId + (int)Math.pow(2.0, 14.0)).substring(1);
            int x = 0;
            while (x < 18) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            out.write(105);
            out.write((byte)(tmp.size() / 255 + 1));
            out.write((byte)tmp.size());
            tmp.writeTo(out);
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#Jour.write# " + ex);
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 18) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            ++x;
        }
        this.date = ConversionTime.binaryToDateString(tmp);
        this.beginTime = Integer.parseInt(tmp.substring(13, 24), 2);
        this.endTime = Integer.parseInt(tmp.substring(24, 35), 2);
        this.driving = Integer.parseInt(tmp.substring(35, 46), 2);
        this.work = Integer.parseInt(tmp.substring(46, 57), 2);
        this.availability = Integer.parseInt(tmp.substring(57, 68), 2);
        this.rest = Integer.parseInt(tmp.substring(68, 79), 2);
        this.crew = Integer.parseInt(tmp.substring(79, 90), 2);
        this.unk = Integer.parseInt(tmp.substring(90, 101), 2);
        this.other = Integer.parseInt(tmp.substring(101, 112), 2);
        this.service = this.driving + this.work + this.availability + this.crew;
        this.night = Integer.parseInt(tmp.substring(112, 122), 2);
        this.km = Integer.parseInt(tmp.substring(122, 133), 2);
        this.update = Integer.parseInt(tmp.substring(133, 137), 2);
        this.delete = tmp.substring(137, 138).equals("1");
        this.userId = Integer.parseInt(tmp.substring(138), 2);
    }

    private static String getAllFields() {
        return "CLE, " + BddTransport.getDateSGBDRToString("DATE_JOUR", false, "") + ", CLE_CHAUFFEUR, CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIP, EVENEMENT, AUTRE," + "CUMUL_T_C_D_DE,HEURE_DEBUT, HEURE_FIN, HEURE_NUIT, DISTANCE, MODIFICATION, SUPPRESSION, CLE_USER, DATE_INSERTION, ACTIVITIES, SOURCE_NAME, MANUAL_INPUT";
    }
}

