/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DayTypeNotFoundException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class JourType
extends MainElement {
    public static String table = "t_jour_type";
    private static Vector<JourType> list = null;
    private int cle = 0;
    private String designation;
    private String code = null;
    private int color = 0;
    private int service = 0;
    private boolean paid = false;
    private boolean generateHS = false;
    private boolean generateRC = false;
    private boolean delete = true;
    private boolean willBePaid = false;
    private boolean willGenerateHS = false;
    private boolean willGenerateRC = false;
    private int futureService = 0;
    private int export = 0;
    private boolean serviceIncluded = false;
    private boolean avgValue = false;
    private int senority = 0;
    public static final int DAY_ACCURATE = 0;
    public static final int MONTH_ACCURATE = 1;
    public static final int YEAR_ACCURATE = 2;

    public JourType(int cle, String designation, String code, int color, int service, boolean paid, boolean generateHS, boolean generateRC, boolean delete, int futureService, boolean willBePaid, boolean willGenerateHS, boolean willGenerateRC, int export, boolean includedService, boolean avgValue, int minMonthService) {
        this.cle = cle;
        this.designation = designation;
        this.code = code;
        this.color = color;
        this.service = service;
        this.paid = paid;
        this.generateHS = generateHS;
        this.generateRC = generateRC;
        this.delete = delete;
        this.futureService = futureService;
        this.willBePaid = willBePaid;
        this.willGenerateHS = willGenerateHS;
        this.willGenerateRC = willGenerateRC;
        this.export = export;
        this.serviceIncluded = includedService;
        this.avgValue = avgValue;
        this.senority = minMonthService;
    }

    public JourType() {
        this.cle = 0;
        this.designation = "";
        this.service = 0;
    }

    public JourType(int cleTypeJour) {
        this.loadById(cleTypeJour);
    }

    public JourType(String designation) {
        this.loadByName(designation);
    }

    public Object clone() {
        return new JourType(this.cle, this.designation, this.code, this.color, this.service, this.paid, this.generateHS, this.generateRC, this.delete, this.futureService, this.willBePaid, this.willGenerateHS, this.willGenerateRC, this.export, this.serviceIncluded, this.avgValue, this.senority);
    }

    private static String getAllFields() {
        return "CLE, CODE, DESIGNATION, COLOR, SERVICE, PAYE, GENERE_HS, GENERE_RC, SUPPRESSION, FUTURE_SERVICE, WILL_BE_PAID, WILL_GENERATE_HS, WILL_GENERATE_RC, EXPORT, NO_SERVICE, AVG_VALUE, SENORITY";
    }

    public boolean loadById(int id) {
        String sql = "SELECT " + JourType.getAllFields() + " FROM " + table + " WHERE CLE=" + id;
        return this.genericLoad(sql);
    }

    public boolean loadByCode(String code) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(JourType.getAllFields()).append(" FROM ").append(table).append(" WHERE CODE='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(code)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadByName(String designation) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(JourType.getAllFields()).append(" FROM ").append(table).append(" WHERE DESIGNATION='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(designation)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = JourType.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.cle = rs.getInt("CLE");
                    this.designation = rs.getString("DESIGNATION");
                    this.code = rs.getString("CODE");
                    this.color = rs.getInt("COLOR");
                    this.service = rs.getInt("SERVICE");
                    this.paid = rs.getBoolean("PAYE");
                    this.generateHS = rs.getBoolean("GENERE_HS");
                    this.generateRC = rs.getBoolean("GENERE_RC");
                    this.delete = rs.getBoolean("SUPPRESSION");
                    this.futureService = rs.getInt("FUTURE_SERVICE");
                    this.willBePaid = rs.getBoolean("WILL_BE_PAID");
                    this.willGenerateHS = rs.getBoolean("WILL_GENERATE_HS");
                    this.willGenerateRC = rs.getBoolean("WILL_GENERATE_RC");
                    this.export = rs.getInt("EXPORT");
                    this.serviceIncluded = rs.getBoolean("NO_SERVICE");
                    this.avgValue = rs.getBoolean("AVG_VALUE");
                    this.senority = rs.getInt("SENORITY");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#JourType.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.cle == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        Statement statement = null;
        try {
            try {
                String sql = "";
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO " + table + " (" + JourType.getAllFields() + ")" + " VALUES (GEN_T_JOUR_TYPE.nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    statement = JourType.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO " + table + " (" + JourType.getAllFields().substring(JourType.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    statement = JourType.getConnection().prepareStatement(sql, 1);
                }
                statement.setObject(1, this.code, 12);
                statement.setObject(2, this.designation, 12);
                statement.setObject(3, this.color, 4);
                statement.setObject(4, this.service, 4);
                statement.setObject(5, this.paid, 4);
                statement.setObject(6, this.generateHS, 4);
                statement.setObject(7, this.generateRC, 4);
                statement.setObject(8, this.delete, 4);
                statement.setObject(9, this.futureService, 4);
                statement.setObject(10, this.willBePaid ? 1 : 0, 4);
                statement.setObject(11, this.willGenerateHS ? 1 : 0, 4);
                statement.setObject(12, this.willGenerateRC ? 1 : 0, 4);
                statement.setObject(13, this.export, 4);
                statement.setObject(14, this.serviceIncluded ? 1 : 0, 4);
                statement.setObject(15, this.avgValue ? 1 : 0, 4);
                statement.setObject(16, this.senority);
                statement.executeUpdate();
                this.loadId((PreparedStatement)statement);
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                String tracer = String.valueOf(LanguageTranslator.getString("generics.day")) + " (" + this.getDesignation() + ") \n";
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean loadId(PreparedStatement fromStatement) throws SQLException {
        boolean retour = false;
        ResultSet rs = null;
        if (fromStatement != null && System.getProperty("SGBDR", "mysql").equals("mysql")) {
            rs = fromStatement.getGeneratedKeys();
            if (!rs.next()) {
                TimsLogger.debug("#JourType.loadId# no auto generated key availaible");
            } else {
                TimsLogger.debug("#JourType.loadId# auto generated key value = " + rs.getInt(1));
                this.cle = rs.getInt(1);
                retour = true;
            }
            rs.close();
        }
        if (retour) {
            return retour;
        }
        String sql = "SELECT MAX(CLE) AS CLE FROM " + table + " WHERE CODE = ?";
        try {
            try {
                this.statement = JourType.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.code, 12);
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.cle = rs.getInt("CLE");
                    TimsLogger.debug("#JourType.loadId# id found " + rs.getInt("CLE"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#JourType.loadId()#  : " + ex);
                ex.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean compareAndUpdate(String designation, String code, int color, int service, boolean paid, boolean generateHS, boolean generateRC, boolean delete, int futureService, boolean willBePaid, boolean willGenerateHS, boolean willGenerateRC, int export, boolean serviceIncluded, boolean avgValue, int senority) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.day")) + " n\u00b0 " + this.cle + " (" + this.getDesignation() + ") \n";
        if (Fonctions.fieldChange(designation, this.designation)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("dayType.designation") + " '" + this.designation + "' => '" + designation + "'\n";
            this.setDesignation(designation);
        }
        if (Fonctions.fieldChange(code, this.code)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.code + "' => '" + code + "'\n";
            this.setCode(code);
        }
        if (color != this.color) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.color") + " '" + this.color + "' => '" + color + "'\n";
            this.setColor(color);
        }
        if (service != this.service) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("dayType.defaultLength") + " '" + this.service + "' => '" + service + "'\n";
            this.setService(service);
        }
        if (paid != this.paid) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("dayType.paid") + " '" + this.paid + "' => '" + paid + "'\n";
            this.setPaid(paid);
        }
        if (generateHS != this.generateHS) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("dayType.HSGenerator") + " '" + this.generateHS + "' => '" + generateHS + "'\n";
            this.setGenerateHS(generateHS);
        }
        if (generateRC != this.generateRC) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("dayType.RCGenerator") + " '" + this.generateRC + "' => '" + generateRC + "'\n";
            this.setGenerateRC(generateRC);
        }
        if (delete != this.delete) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.delete") + " '" + this.delete + "' => '" + delete + "'\n";
            this.setDelete(delete);
        }
        if (futureService != this.futureService) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("dayType.defaultLength") + " '" + this.futureService + "' => '" + futureService + "'\n";
            this.setFutureService(futureService);
        }
        if (willBePaid != this.willBePaid) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("dayType.paid") + " '" + this.willBePaid + "' => '" + willBePaid + "'\n";
            this.setWillBePaid(willBePaid);
        }
        if (willGenerateHS != this.willGenerateHS) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("dayType.HSGenerator") + " '" + this.willGenerateHS + "' => '" + willGenerateHS + "'\n";
            this.setWillGenerateHS(willGenerateHS);
        }
        if (willGenerateRC != this.willGenerateRC) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("dayType.RCGenerator") + " '" + this.willGenerateRC + "' => '" + willGenerateRC + "'\n";
            this.setWillGenerateRC(willGenerateRC);
        }
        if (export != this.export) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.export") + " '" + this.export + "' => '" + export + "'\n";
            this.setExport(export);
        }
        if (serviceIncluded != this.serviceIncluded) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("datType.serviceIncluded") + " '" + this.serviceIncluded + "' => '" + serviceIncluded + "'\n";
            this.setServiceIncluded(serviceIncluded);
        }
        if (avgValue != this.avgValue) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("datType.avgValue") + " '" + this.avgValue + "' => '" + avgValue + "'\n";
            this.setAvgValue(avgValue);
        }
        if (senority != this.senority) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.senority") + " '" + this.senority + "' => '" + senority + "'\n";
            this.setSenority(senority);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.day")) + " n\u00b0 " + this.cle + " (" + this.getDesignation() + ") \n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#JourType# no changes");
        return true;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE " + table + " SET " + " DESIGNATION =? ," + " CODE =? ," + " COLOR =? ," + " SERVICE=? ," + " PAYE=?," + " GENERE_HS=?," + " GENERE_RC=?," + " SUPPRESSION=?, " + " FUTURE_SERVICE=?," + " WILL_BE_PAID=?," + " WILL_GENERATE_HS=?," + " WILL_GENERATE_RC=?," + " EXPORT=?," + " NO_SERVICE=?," + " AVG_VALUE=?," + " SENORITY=?" + " WHERE CLE=?";
        PreparedStatement statement = null;
        try {
            try {
                statement = JourType.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.designation, 12);
                statement.setObject(2, (Object)this.code, 12);
                statement.setObject(3, (Object)this.color, 4);
                statement.setObject(4, (Object)this.service, 4);
                statement.setObject(5, (Object)(this.paid ? 1 : 0), 4);
                statement.setObject(6, (Object)(this.generateHS ? 1 : 0), 4);
                statement.setObject(7, (Object)(this.generateRC ? 1 : 0), 4);
                statement.setObject(8, (Object)(this.delete ? 1 : 0), 4);
                statement.setObject(9, (Object)this.futureService, 4);
                statement.setObject(10, (Object)(this.willBePaid ? 1 : 0), 4);
                statement.setObject(11, (Object)(this.willGenerateHS ? 1 : 0), 4);
                statement.setObject(12, (Object)(this.willGenerateRC ? 1 : 0), 4);
                statement.setObject(13, (Object)this.export, 4);
                statement.setObject(14, (Object)(this.serviceIncluded ? 1 : 0), 4);
                statement.setObject(15, (Object)(this.avgValue ? 1 : 0), 4);
                statement.setObject(16, this.senority);
                statement.setObject(17, this.cle);
                statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM " + table + " WHERE CLE =?";
        PreparedStatement statement = null;
        try {
            try {
                statement = JourType.getConnection().prepareStatement(sql);
                statement.setObject(1, this.cle);
                statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public int getCle() {
        return this.cle;
    }

    public void setCle(int cle) {
        this.cle = cle;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public boolean isGenerateHS() {
        return this.generateHS;
    }

    public void setGenerateHS(boolean genereHS) {
        this.generateHS = genereHS;
    }

    public boolean isGenerateRC() {
        return this.generateRC;
    }

    public void setGenerateRC(boolean RCGenerator) {
        this.generateRC = RCGenerator;
    }

    public boolean isPaid() {
        return this.paid;
    }

    public void setPaid(boolean paye) {
        this.paid = paye;
    }

    public int getService() {
        return this.service;
    }

    public void setService(int service) {
        this.service = service;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getFutureService() {
        return this.futureService;
    }

    public void setFutureService(int futureService) {
        this.futureService = futureService;
    }

    public boolean isWillBePaid() {
        return this.willBePaid;
    }

    public void setWillBePaid(boolean willBePaid) {
        this.willBePaid = willBePaid;
    }

    public boolean isWillGenerateHS() {
        return this.willGenerateHS;
    }

    public void setWillGenerateHS(boolean willGenerateHS) {
        this.willGenerateHS = willGenerateHS;
    }

    public boolean isWillGenerateRC() {
        return this.willGenerateRC;
    }

    public void setWillGenerateRC(boolean willGenerateRC) {
        this.willGenerateRC = willGenerateRC;
    }

    public int getExport() {
        return this.export;
    }

    public void setExport(int export) {
        this.export = export;
    }

    public boolean isAvgValue() {
        return this.avgValue;
    }

    public void setAvgValue(boolean avgValue) {
        this.avgValue = avgValue;
    }

    public boolean isServiceIncluded() {
        return this.serviceIncluded;
    }

    public void setServiceIncluded(boolean noService) {
        this.serviceIncluded = noService;
    }

    public int getSenority() {
        return this.senority;
    }

    public void setSenority(int minMonthService) {
        this.senority = minMonthService;
    }

    public static Vector<JourType> getList() {
        if (list == null) {
            list = JourType.loadList();
        }
        return list;
    }

    public static void setList(Vector<JourType> list) {
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#JourType.setList# define a new list");
        }
        JourType.list = list;
    }

    public static JourType getDayType(int idDayType) throws DayTypeNotFoundException {
        for (JourType tmp : JourType.getList()) {
            if (tmp.getCle() != idDayType) continue;
            return tmp;
        }
        throw new DayTypeNotFoundException();
    }

    public static JourType getDayType(String code) throws DayTypeNotFoundException {
        for (JourType tmp : JourType.getList()) {
            if (!tmp.getCode().equals(code)) continue;
            return tmp;
        }
        throw new DayTypeNotFoundException();
    }

    private static Vector<JourType> loadList() {
        Vector<JourType> toReturn = new Vector<JourType>();
        ResultSet rs = null;
        String sql = "SELECT " + JourType.getAllFields() + " FROM " + table;
        TimsLogger.debug("#JourType.loadList# sql" + sql);
        try {
            Statement stm = JourType.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                toReturn.add(new JourType(rs.getInt("CLE"), rs.getString("DESIGNATION"), rs.getString("CODE"), rs.getInt("COLOR"), rs.getInt("SERVICE"), rs.getBoolean("PAYE"), rs.getBoolean("GENERE_HS"), rs.getBoolean("GENERE_RC"), rs.getBoolean("SUPPRESSION"), rs.getInt("FUTURE_SERVICE"), rs.getBoolean("WILL_BE_PAID"), rs.getBoolean("WILL_GENERATE_HS"), rs.getBoolean("WILL_GENERATE_RC"), rs.getInt("EXPORT"), rs.getBoolean("NO_SERVICE"), rs.getBoolean("AVG_VALUE"), rs.getInt("SENORITY")));
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("#JourType.loadList()# " + ex);
            TimsLogger.debug(sql);
        }
        return toReturn;
    }

    public boolean shouldPay(Conducteur driver, Date day) {
        if (this.getSenority() == 0 || driver.getDateEntree().equals("") || driver.getDateEntree().equals("1970-01-01")) {
            return true;
        }
        SimpleDateFormat year = new SimpleDateFormat("yyyy");
        int senorityAccuracy = Integer.parseInt(System.getProperty("senority.accuracy", "1"));
        Date enter = ConversionTime.stringToDate(driver.getDateEntree(), "yyyy-MM-dd");
        if (senorityAccuracy == 0) {
            int nbJour = ConversionTime.getDaysBetween(enter, day);
            TimsLogger.debug("#shouldPay# " + nbJour + " days since hiring ");
            return nbJour > this.getSenority();
        }
        if (senorityAccuracy == 1) {
            SimpleDateFormat month = new SimpleDateFormat("MM");
            SimpleDateFormat dayF = new SimpleDateFormat("dd");
            int enterMonth = Integer.parseInt(month.format(enter)) + Integer.parseInt(year.format(enter)) * 12;
            int dayMonth = Integer.parseInt(month.format(day)) + Integer.parseInt(year.format(day)) * 12;
            int totalMonth = dayMonth - enterMonth;
            if (Integer.parseInt(dayF.format(day)) > Integer.parseInt(dayF.format(enter))) {
                ++totalMonth;
            }
            TimsLogger.debug("#shouldPay# " + totalMonth + " months since hiring " + dayMonth + " - " + enterMonth + " -- senority " + this.getSenority() + " -> return " + (totalMonth > this.getSenority()));
            return totalMonth > this.getSenority();
        }
        int nbYear = Integer.parseInt(year.format(day)) - Integer.parseInt(year.format(enter));
        if (ConversionTime.add(enter, 1, nbYear).after(day)) {
            --nbYear;
        }
        return nbYear > this.getSenority();
    }
}

