/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.exception.DayTypeNotFoundException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.util.Constants;

public class LienJourConducteur
extends MainElement {
    public static final String table = "t_lien_jour_conducteur";
    public static final int NORMAL = 0;
    public static final int SEMI = 1;
    public static final int FULL = 2;
    public static int DEFAULT_LENGTH_VALUE = 480;
    public static int DEFAULT_BEGIN_VALUE = 480;
    private int cle = 0;
    private int cleConducteur = 0;
    private int cleJourType = 0;
    private int cleUser = 0;
    private int type = 0;
    private java.util.Date date = null;
    private int heureDebut = 480;
    private int duree = 0;

    public LienJourConducteur() {
    }

    public void setValues(int cle, int cleConducteur, int cleJourType, int cleUser, java.util.Date dateJour, int heureDebut, int duree, int type) {
        this.cle = cle;
        this.cleConducteur = cleConducteur;
        this.cleJourType = cleJourType;
        this.cleUser = cleUser;
        this.date = dateJour;
        this.heureDebut = heureDebut;
        this.duree = duree;
        this.type = type;
    }

    public LienJourConducteur(int cleConducteur) {
        this.cleConducteur = cleConducteur;
    }

    public boolean equals(Object obj) {
        return obj instanceof LienJourConducteur && ((LienJourConducteur)obj).getCleConducteur() == this.cleConducteur && ((LienJourConducteur)obj).getCleJourType() == this.cleJourType && ((LienJourConducteur)obj).getDateJour().equals(this.date) && ((LienJourConducteur)obj).getType() == this.type;
    }

    public PreparedStatement getPreparedStatement() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO t_lien_jour_conducteur(CLE, CLE_CHAUFFEUR, CLE_JOUR_TYPE, CLE_USER, DATE_JOUR, HEURE_DEBUT, DUREE, TYPE) VALUES (GEN_T_LIEN_JOUR_CONDUCTEUR.nextval,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO t_lien_jour_conducteur(CLE_CHAUFFEUR, CLE_JOUR_TYPE, CLE_USER, DATE_JOUR, HEURE_DEBUT, DUREE, TYPE) VALUES (?,?,?,?,?,?,?)";
        }
        try {
            this.statement = LienJourConducteur.getConnection().prepareStatement(sql);
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            System.err.println("#LienJourConducteur.getPreparedStatement# erreur");
            ex.printStackTrace();
        }
        return this.statement;
    }

    public void update() {
        this.affiche();
        if (this.cle != 0) {
            this.updateJour();
        } else {
            this.insert();
        }
    }

    public void affiche() {
        TimsLogger.info("#LJC.affiche()# cleConducteur " + this.cleConducteur + " day = " + this.date + " cle=" + this.cle);
    }

    public boolean insert() {
        boolean toReturn = false;
        PreparedStatement statement = null;
        try {
            try {
                statement = this.getPreparedStatement();
                statement.setObject(1, (Object)this.cleConducteur, 4);
                statement.setObject(2, (Object)this.cleJourType, 4);
                statement.setObject(3, (Object)this.cleUser, 4);
                statement.setDate(4, new Date(this.date.getTime()));
                statement.setObject(5, (Object)this.heureDebut, 4);
                statement.setObject(6, (Object)this.duree, 4);
                statement.setObject(7, (Object)this.type, 4);
                statement.executeUpdate();
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean delete() {
        String sql = "DELETE FROM t_lien_jour_conducteur WHERE CLE= ?";
        try {
            this.statement = LienJourConducteur.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.cle, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean updateJour() {
        String sql = "UPDATE t_lien_jour_conducteur SET  CLE_CHAUFFEUR = ? , CLE_JOUR_TYPE = ? , CLE_USER = ? , DATE_JOUR = ? , HEURE_DEBUT = ? , DUREE = ? , TYPE = ?  WHERE CLE= ?";
        try {
            this.statement = LienJourConducteur.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.cleConducteur, 4);
            this.statement.setObject(2, (Object)this.cleJourType, 4);
            this.statement.setObject(3, (Object)this.cleJourType, 4);
            this.statement.setDate(4, new Date(this.date.getTime()));
            this.statement.setObject(5, (Object)this.heureDebut, 4);
            this.statement.setObject(6, (Object)this.duree, 4);
            this.statement.setObject(7, (Object)this.type, 4);
            this.statement.setObject(8, (Object)this.cle, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean load(int cleConducteur, Timestamp dateJour) {
        block4: {
            ResultSet rs = null;
            TimsLogger.debug("#LienJourConducteur.load()#");
            String sql = "SELECT CLE, CLE_CHAUFFEUR, CLE_JOUR_TYPE, CLE_USER, DATE_JOUR, HEURE_DEBUT, DUREE, TYPE FROM t_lien_jour_conducteur WHERE CLE_CHAUFFEUR = ? AND DATE_JOUR = ?";
            this.statement = LienJourConducteur.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)cleConducteur, 12);
            this.statement.setTimestamp(2, dateJour);
            rs = this.statement.executeQuery();
            if (!rs.next()) break block4;
            this.cle = rs.getInt("CLE");
            this.cleConducteur = cleConducteur;
            this.cleJourType = rs.getInt("CLE_JOUR_TYPE");
            this.cleUser = rs.getInt("CLE_USER");
            this.date = dateJour;
            this.heureDebut = rs.getInt("HEURE_DEBUT");
            this.duree = rs.getInt("DUREE");
            this.type = rs.getInt("TYPE");
            this.statement.close();
            return true;
        }
        try {
            this.statement.close();
            return false;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getCle() {
        return this.cle;
    }

    public void setCle(int cle) {
        this.cle = cle;
    }

    public int getCleConducteur() {
        return this.cleConducteur;
    }

    public void setCleConducteur(int cleConducteur) {
        this.cleConducteur = cleConducteur;
    }

    public int getCleJourType() {
        return this.cleJourType;
    }

    public void setCleJourType(int cleJourType) {
        this.cleJourType = cleJourType;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public java.util.Date getDateJour() {
        return this.date;
    }

    public void setDateJour(java.util.Date dateJour) {
        this.date = dateJour;
    }

    public int getDuree(int contractDayLength) {
        int returnLength = 0;
        if (this.type != 0) {
            JourType dayType = this.getDayType();
            if (dayType != null && "CP".equals(dayType.getCode()) && ConversionTime.getDayOfWeek(this.getDateJour(), false) == 7) {
                return 0;
            }
            int fullDayLength = 0;
            if (contractDayLength != 0) {
                fullDayLength = contractDayLength;
            } else if (this.cleJourType != 0) {
                int n = fullDayLength = dayType != null ? dayType.getService() : 0;
            }
            if (this.type == 1) {
                returnLength = fullDayLength / 2;
            }
            if (this.type == 2) {
                returnLength = fullDayLength;
            }
        } else {
            returnLength = this.duree;
        }
        return returnLength;
    }

    public int getPrintLength(int contractDayLength) {
        int dureeToReturn = 0;
        if (this.type != 0) {
            int toReturn = 0;
            if (contractDayLength != 0) {
                toReturn = contractDayLength;
            } else if (this.cleJourType != 0) {
                JourType dayType = this.getDayType();
                int n = toReturn = dayType != null ? dayType.getService() : 420;
            }
            if (this.type == 1) {
                dureeToReturn = toReturn / 2;
            }
            if (this.type == 2) {
                dureeToReturn = toReturn;
            }
        }
        if (dureeToReturn == 0) {
            dureeToReturn = this.duree;
        }
        return dureeToReturn == 0 ? DEFAULT_LENGTH_VALUE : dureeToReturn;
    }

    public int getFutureDuree() {
        if (this.type != 0) {
            int toReturn = 0;
            try {
                JourType tmp = JourType.getDayType(this.cleJourType);
                toReturn = tmp.getFutureService();
            }
            catch (DayTypeNotFoundException ex) {
                ex.printStackTrace();
            }
            if (this.type == 1) {
                return toReturn / 2;
            }
            if (this.type == 2) {
                return toReturn;
            }
        }
        return this.duree;
    }

    public void setDuree(int duree) {
        this.duree = duree;
    }

    public int getHeureDebut() {
        return this.heureDebut;
    }

    public void setHeureDebut(int heureDebut) {
        this.heureDebut = heureDebut;
    }

    public int getHeureFin() {
        return this.getHeureDebut() + this.getDuree(0);
    }

    public int getPrintEnd() {
        return this.getHeureDebut() + this.getPrintLength(0);
    }

    public int getCleUser() {
        return this.cleUser;
    }

    public void setCleUser(int cleUser) {
        this.cleUser = cleUser;
    }

    public JourType getDayType() {
        JourType toReturn = null;
        try {
            toReturn = JourType.getDayType(this.cleJourType);
        }
        catch (DayTypeNotFoundException ex) {
            TimsLogger.warn("#LJC.getDayType()# impossible de trouver le jour type : " + this.cleJourType);
        }
        return toReturn;
    }

    public String getDesignation() {
        String toReturn = "";
        try {
            toReturn = JourType.getDayType(this.cleJourType).getDesignation();
        }
        catch (DayTypeNotFoundException ex) {
            ex.printStackTrace();
        }
        return toReturn;
    }

    public static Vector<LienJourConducteur> loadList(int agencyId, int driverId, java.util.Date begin, java.util.Date end) {
        String res = "";
        if (begin != null) {
            res = end != null ? String.valueOf(res) + " AND DATE_JOUR BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(end, "yyyy-MM-dd"), false) : String.valueOf(res) + " AND DATE_JOUR =" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false);
        }
        if (agencyId != 0 && driverId == 0) {
            res = String.valueOf(res) + " AND ljc.CLE_CHAUFFEUR IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE CLE_AGENCE = " + agencyId + ")";
        }
        if (driverId != 0) {
            res = String.valueOf(res) + " AND ljc.CLE_CHAUFFEUR = " + driverId;
        }
        return LienJourConducteur.loadList(res);
    }

    public static Vector<LienJourConducteur> loadList(Vector<Agence> agencies, Vector<Conducteur> drivers, java.util.Date begin, java.util.Date end) {
        String res = "";
        if (drivers == null || drivers.size() == 0) {
            if (agencies != null && agencies.size() != 0) {
                String agencyFilter = LienJourConducteur.buildAgencyFilters(agencies, "CLE_AGENCE");
                res = String.valueOf(res) + " AND ljc.CLE_CHAUFFEUR IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE " + agencyFilter + ")";
            }
        } else {
            res = String.valueOf(res) + " AND " + LienJourConducteur.buildDriverFilters(drivers, "ljc.CLE_CHAUFFEUR");
        }
        if (begin != null) {
            res = end != null ? String.valueOf(res) + " AND DATE_JOUR BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(end, "yyyy-MM-dd"), false) : String.valueOf(res) + " AND DATE_JOUR =" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false);
        }
        return LienJourConducteur.loadList(res);
    }

    public static Vector<LienJourConducteur> loadList(int agencyId, Vector<Conducteur> drivers, java.util.Date begin, java.util.Date end) {
        String res = "";
        if (agencyId != 0) {
            res = String.valueOf(res) + " AND ljc.CLE_CHAUFFEUR IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE CLE_AGENCE = " + agencyId + ")";
        }
        if (drivers != null && drivers.size() != 0) {
            res = String.valueOf(res) + " AND " + LienJourConducteur.buildDriverFilters(drivers, "ljc.CLE_CHAUFFEUR");
        }
        if (begin != null) {
            res = end != null ? String.valueOf(res) + " AND DATE_JOUR BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(end, "yyyy-MM-dd"), false) : String.valueOf(res) + " AND DATE_JOUR =" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false);
        }
        return LienJourConducteur.loadList(res);
    }

    public static Vector<LienJourConducteur> loadList(String filters) {
        Vector<LienJourConducteur> toReturn = new Vector<LienJourConducteur>();
        String sql = "";
        try {
            sql = "SELECT ljc.CLE_CHAUFFEUR, ljc.CLE, DATE_JOUR, CLE_JOUR_TYPE, CLE_USER, HEURE_DEBUT, HEURE_FIN, DUREE, TYPE FROM t_lien_jour_conducteur ljc JOIN t_conducteur on ljc.CLE_CHAUFFEUR=t_conducteur.CLE_CHAUFFEUR  WHERE t_conducteur.ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0") + filters + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, ljc.CLE_CHAUFFEUR, DATE_JOUR";
            Statement stm = LienJourConducteur.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                LienJourConducteur tmp = new LienJourConducteur();
                tmp.setValues(rs.getInt("CLE"), rs.getInt("CLE_CHAUFFEUR"), rs.getInt("CLE_JOUR_TYPE"), rs.getInt("CLE_USER"), rs.getDate("DATE_JOUR"), rs.getInt("HEURE_DEBUT"), rs.getInt("DUREE"), rs.getInt("TYPE"));
                toReturn.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("LienJourConducteur.loadList() : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return toReturn;
    }

    public static Vector<LienJourConducteur> find(Vector<LienJourConducteur> toSearch, int driverId, java.util.Date date) {
        Vector<LienJourConducteur> toReturn = new Vector<LienJourConducteur>();
        for (LienJourConducteur ljc : toSearch) {
            if (date != null && !ljc.getDateJour().equals(date) || ljc.getCleConducteur() != driverId) continue;
            toReturn.add(ljc);
        }
        return toReturn;
    }
}

