/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.Tracking;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class OffencePart
extends MainElement {
    public static String table = "offence_part";
    private static Vector<OffencePart> list = null;
    private int id = 0;
    private int offenceTypeId = 0;
    private String name = null;
    private Vector<OffenceThreshold> thresholds = null;
    private int memberState = 0;
    private int companyType = 0;

    public OffencePart() {
    }

    public OffencePart(int id, int offenceTypeId, String name, int memberState, int companyType, Vector<OffenceThreshold> thresholds) {
        this.id = id;
        this.offenceTypeId = offenceTypeId;
        this.name = name;
        this.thresholds = thresholds;
    }

    public Object clone() {
        return new OffencePart(this.id, this.offenceTypeId, this.name, this.memberState, this.companyType, this.thresholds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + table + " (ID, OFFENCE_TYPE_ID, NAME)" + " VALUES (GEN_OFFENCE_TYPE.nextval,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + table + " (OFFENCE_TYPE_ID, NAME) VALUES (?)";
        }
        try {
            try {
                this.statement = OffencePart.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.offenceTypeId, 4);
                this.statement.setObject(2, (Object)this.name, 12);
                this.statement.executeUpdate();
                this.statement.close();
                toReturn = true;
                String tracer = String.valueOf(LanguageTranslator.getString("generics.offencePart")) + " (" + this.getName() + ") \n";
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean update() {
        if (this.id != 0) {
            return this.updateValue();
        }
        return this.insert();
    }

    public boolean compareAndUpdate(int offenceTypeId, String name) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.offencePart")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n";
        if (offenceTypeId != this.offenceTypeId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.offenceType") + " '" + this.offenceTypeId + "' => '" + offenceTypeId + "'\n";
            this.setOffenceTypeId(offenceTypeId);
        }
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.offencePart")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#TypeActivite# no changes");
        return true;
    }

    public void affiche() {
        TimsLogger.info("#OffencePArt.print# " + this.id + ", " + this.name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean updateValue() {
        boolean toReturn = false;
        this.affiche();
        String sql = "UPDATE " + table + " SET " + " OFFENCE_TYPE_ID=?" + " NAME=?" + " WHERE ID=?";
        try {
            try {
                this.statement = OffencePart.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.offenceTypeId, 4);
                this.statement.setObject(2, (Object)this.name, 12);
                this.statement.setObject(3, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                toReturn = true;
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getOffenceTypeId() {
        return this.offenceTypeId;
    }

    public void setOffenceTypeId(int offenceTypeId) {
        this.offenceTypeId = offenceTypeId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMemberState() {
        return this.memberState;
    }

    public void setMemberState(int memberState) {
        this.memberState = memberState;
    }

    public int getCompanyType() {
        return this.companyType;
    }

    public void setCompanyType(int companyType) {
        this.companyType = companyType;
    }

    public Vector<OffenceThreshold> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Vector<OffenceThreshold> thresholds) {
        this.thresholds = thresholds;
    }

    public static Vector<OffencePart> getList() {
        if (list == null) {
            list = OffencePart.loadList();
        }
        return list;
    }

    public static void setList(Vector<OffencePart> list) {
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#OffencePart.setList# define a new list");
        }
        OffencePart.list = list;
    }

    public static OffencePart getOffencePart(int offencePartId) {
        for (OffencePart tmp : OffencePart.getList()) {
            if (tmp.getId() != offencePartId) continue;
            return tmp;
        }
        TimsLogger.warn("#OffenceType.getOffenceType# not found : " + offencePartId);
        return null;
    }

    private static Vector<OffencePart> loadList() {
        Vector<OffencePart> toReturn = new Vector<OffencePart>();
        String sql = "SELECT ID, OFFENCE_TYPE_ID, NAME FROM " + table;
        try {
            Statement stm = OffencePart.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                toReturn.add(new OffencePart(rs.getInt("ID"), rs.getInt("OFFENCE_TYPE_ID"), rs.getString("NAME"), 0, 0, OffenceThreshold.getOffencePartList(rs.getInt("ID"))));
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("#OffencePart.loadList()# " + ex);
            TimsLogger.debug(sql);
        }
        return toReturn;
    }

    public static Vector<OffencePart> getOffenceTypeList(int offenceTypeId) {
        Vector<OffencePart> toReturn = new Vector<OffencePart>();
        for (OffencePart part : OffencePart.getList()) {
            if (part.getOffenceTypeId() != offenceTypeId) continue;
            toReturn.add(part);
        }
        return toReturn;
    }
}

