/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class OldVehicleUsed
extends MainElement {
    public static final int OFFSET = 121;
    public static final String table = "t_prise_vehicule";
    public static int CARTE = 0;
    public static int SCAN = 2;
    private int cle = 0;
    private int cleConducteur = 0;
    private int cleVehicule = 0;
    private String dateDebut = null;
    private String dateFin = null;
    private int kmDebut = 0;
    private int kmFin = 0;
    private int kmEffectue = 0;
    private int source = 0;
    private String nom = null;
    private String prenom = null;
    private String numeroCarte = null;
    private String immatriculation = null;
    private int ioCounter = 0;

    public OldVehicleUsed() {
    }

    public OldVehicleUsed(int cleConducteur, String nom, String prenom, String numeroCarte, String dateDebut, String dateFin) {
        this.cleConducteur = cleConducteur;
        this.dateDebut = dateDebut;
        this.dateFin = dateFin;
        this.nom = nom;
        this.prenom = prenom;
        this.numeroCarte = numeroCarte;
    }

    public OldVehicleUsed(int cle, int cleConducteur, int cleVehicule, String dateDebut, String dateFin, int kmDebut, int kmFin, int kmEffectue, String nom, String prenom, String numeroCarte, String immatriculation, int source) {
        this.cle = cle;
        this.cleConducteur = cleConducteur;
        this.cleVehicule = cleVehicule;
        this.dateDebut = dateDebut;
        this.dateFin = dateFin;
        this.kmDebut = kmDebut;
        this.kmFin = kmFin;
        this.kmEffectue = kmEffectue;
        this.nom = nom;
        this.prenom = prenom;
        this.numeroCarte = numeroCarte;
        this.immatriculation = immatriculation;
        this.source = source;
    }

    public boolean update() {
        if (this.cle == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean retour = false;
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO t_prise_vehicule (CLE, CLE_CHAUFFEUR, CLE_VEHICULE,DATE_DEBUT, DATE_FIN, KM_DEBUT, KM_FIN, KM_EFFECTUE, NOM, PRENOM, NUMERO_CARTE, IMMATRICULATION, SOURCE) VALUES (GEN_T_LIEN_JOUR_VEHICULE.nextval,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO t_prise_vehicule (CLE_CHAUFFEUR, CLE_VEHICULE, DATE_DEBUT, DATE_FIN, KM_DEBUT, KM_FIN, KM_EFFECTUE, NOM, PRENOM, NUMERO_CARTE, IMMATRICULATION, SOURCE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = OldVehicleUsed.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleConducteur, 4);
                this.statement.setObject(2, (Object)this.cleVehicule, 4);
                this.statement.setTimestamp(3, Timestamp.valueOf(this.dateDebut));
                this.statement.setTimestamp(4, Timestamp.valueOf(this.dateFin));
                this.statement.setObject(5, (Object)this.kmDebut, 4);
                this.statement.setObject(6, (Object)this.kmFin, 4);
                this.statement.setObject(7, (Object)this.kmEffectue, 4);
                this.statement.setObject(8, (Object)this.nom, 12);
                this.statement.setObject(9, (Object)this.prenom, 12);
                this.statement.setObject(10, (Object)this.numeroCarte, 12);
                this.statement.setObject(11, (Object)this.immatriculation, 12);
                this.statement.setObject(12, (Object)this.source, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                this.affiche();
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        if (this.cle == 0) {
            TimsLogger.debug("#PriseVehicule.update()#Error# clePrise to update == 0");
            return retour;
        }
        String sql = "UPDATE t_prise_vehicule SET  CLE_CHAUFFEUR=? , CLE_VEHICULE=? , DATE_DEBUT=? , DATE_FIN=? , KM_DEBUT=? , KM_FIN=? , KM_EFFECTUE= ? , NOM= ? , PRENOM= ? , NUMERO_CARTE= ? , IMMATRICULATION= ?,  SOURCE= ?  WHERE CLE=?";
        try {
            try {
                this.statement = OldVehicleUsed.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleConducteur, 4);
                this.statement.setObject(2, (Object)this.cleVehicule, 4);
                this.statement.setTimestamp(3, Timestamp.valueOf(this.dateDebut));
                this.statement.setTimestamp(4, Timestamp.valueOf(this.dateFin));
                this.statement.setObject(5, (Object)this.kmDebut, 4);
                this.statement.setObject(6, (Object)this.kmFin, 4);
                this.statement.setObject(7, (Object)this.kmEffectue, 4);
                this.statement.setObject(8, (Object)this.nom, 12);
                this.statement.setObject(9, (Object)this.prenom, 12);
                this.statement.setObject(10, (Object)this.numeroCarte, 12);
                this.statement.setObject(11, (Object)this.immatriculation, 12);
                this.statement.setObject(12, (Object)this.source, 4);
                this.statement.setObject(13, (Object)this.cle, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean delete() {
        boolean retour = false;
        String sql = "DELETE FROM t_prise_vehicule WHERE CLE=?";
        try {
            try {
                this.statement = OldVehicleUsed.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cle, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public void affiche() {
        TimsLogger.info(String.valueOf(this.cleVehicule) + "(" + this.immatriculation + ") " + this.dateDebut + " => " + this.dateFin + " : " + this.kmDebut + " " + this.kmFin + " (ioCounter = " + this.ioCounter + ")");
    }

    public int getCle() {
        return this.cle;
    }

    public void setCle(int cle) {
        this.cle = cle;
    }

    public int getCleConducteur() {
        return this.cleConducteur;
    }

    public void setCleConducteur(int cleConducteur) {
        this.cleConducteur = cleConducteur;
    }

    public int getCleVehicule() {
        return this.cleVehicule;
    }

    public void setCleVehicule(int cleVehicule) {
        this.cleVehicule = cleVehicule;
    }

    public String getDateDebut() {
        return this.dateDebut;
    }

    public void setDateDebut(String dateDebut) {
        this.dateDebut = dateDebut;
    }

    public String getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(String dateFin) {
        this.dateFin = dateFin;
    }

    public String getImmatriculation() {
        return this.immatriculation;
    }

    public void setImmatriculation(String immatriculation) {
        this.immatriculation = immatriculation;
    }

    public int getKmDebut() {
        return this.kmDebut;
    }

    public void setKmDebut(int kmDebut) {
        this.kmDebut = kmDebut;
        this.setKmEffectue(this.getKmFin() - this.getKmDebut());
    }

    public int getKmEffectue() {
        return this.kmEffectue;
    }

    public void setKmEffectue(int kmEffectue) {
        this.kmEffectue = kmEffectue;
    }

    public int getKmFin() {
        return this.kmFin;
    }

    public void setKmFin(int kmFin) {
        this.kmFin = kmFin;
        this.setKmEffectue(this.getKmFin() - this.getKmDebut());
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getNumeroCarte() {
        return this.numeroCarte;
    }

    public void setNumeroCarte(String numeroCarte) {
        this.numeroCarte = numeroCarte;
    }

    public String getPrenom() {
        return this.prenom;
    }

    public void setPrenom(String prenom) {
        this.prenom = prenom;
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public int getIoCounter() {
        return this.ioCounter;
    }

    public void setIoCounter(int ioCounter) {
        this.ioCounter = ioCounter;
    }

    public byte[] write(OutputStream out) {
        this.affiche();
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = ConversionTime.dateStringToBinary(this.dateDebut, true);
            activite = String.valueOf(activite) + ConversionTime.dateStringToBinary(this.dateFin, true);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.kmDebut + (int)Math.pow(2.0, 21.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.kmFin + (int)Math.pow(2.0, 21.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.ioCounter + (int)Math.pow(2.0, 14.0)).substring(1);
            int x = 0;
            while (x < 13) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            tmp.write(this.source);
            tmp.write(this.immatriculation.getBytes());
            out.write(121);
            out.write((byte)(tmp.size() / 255 + 1));
            out.write((byte)tmp.size());
            tmp.writeTo(out);
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#OldVehicleUsed.write# " + ex);
            ex.printStackTrace();
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 13) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            ++x;
        }
        this.dateDebut = ConversionTime.binaryToDateString(tmp, true);
        this.dateFin = String.valueOf(this.dateFin) + ConversionTime.binaryToDateString(tmp.substring(24), true);
        this.kmDebut = Integer.parseInt(tmp.substring(48, 69), 2);
        this.kmFin = Integer.parseInt(tmp.substring(69, 90), 2);
        this.ioCounter = Integer.parseInt(tmp.substring(90, 104), 2);
        this.source = fileBuffer[14];
        this.immatriculation = new String(fileBuffer).substring(15);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Vector<OldVehicleUsed> loadList(int driverId, int vehicleId, Date begin, Date end) {
        Vector<OldVehicleUsed> toReturn = new Vector<OldVehicleUsed>();
        String sql = "SELECT * FROM t_prise_vehicule";
        String res = "";
        if (begin != null) {
            res = end != null && !end.equals("") ? String.valueOf(res) + " AND DATE_DEBUT BETWEEN ? AND ?" : String.valueOf(res) + " AND " + BddTransport.getDateTruncation("DATE_DEBUT") + " =?";
        }
        if (vehicleId != 0) {
            res = String.valueOf(res) + " AND CLE_VEHICULE = ?";
        }
        if (driverId != 0) {
            res = String.valueOf(res) + " AND CLE_CHAUFFEUR = ?";
        }
        if (!res.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + res.substring(5);
        }
        sql = String.valueOf(sql) + " ORDER BY DATE_DEBUT";
        PreparedStatement statement = null;
        try {
            try {
                statement = OldVehicleUsed.getConnection().prepareStatement(sql);
                int idx = 1;
                if (begin != null) {
                    statement.setDate(idx, new java.sql.Date(begin.getTime()));
                    ++idx;
                }
                if (end != null) {
                    statement.setDate(idx, new java.sql.Date(end.getTime()));
                    ++idx;
                }
                if (vehicleId != 0) {
                    statement.setObject(idx, (Object)vehicleId, 4);
                    ++idx;
                }
                if (driverId != 0) {
                    statement.setObject(idx, (Object)driverId, 4);
                    ++idx;
                }
                TimsLogger.debug("#OldVehicleUsed.loadList()# sql = " + sql + " returns " + toReturn.size() + " entries");
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    toReturn.add(new OldVehicleUsed(rs.getInt("CLE"), rs.getInt("CLE_CHAUFFEUR"), rs.getInt("CLE_VEHICULE"), BddTransport.getDateSGBDRToString(rs.getString("DATE_DEBUT"), true, null), BddTransport.getDateSGBDRToString(rs.getString("DATE_FIN"), true, null), rs.getInt("KM_DEBUT"), rs.getInt("KM_FIN"), rs.getInt("KM_EFFECTUE"), rs.getString("NOM"), rs.getString("PRENOM"), rs.getString("NUMERO_CARTE"), rs.getString("IMMATRICULATION"), rs.getInt("SOURCE")));
                }
                TimsLogger.debug("#OldVehicleUsed.loadList()# returns " + toReturn.size() + " entries");
                statement.close();
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (statement == null) return toReturn;
                try {
                    statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (statement == null) return toReturn;
                try {
                    statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static Vector<OldVehicleUsed> find(Vector<OldVehicleUsed> toSearch, int driverId, Date date) {
        Vector<OldVehicleUsed> toReturn = new Vector<OldVehicleUsed>();
        for (OldVehicleUsed de : toSearch) {
            if (!ConversionTime.dateTruncate(ConversionTime.stringToDate(de.getDateDebut(), "yyyy-MM-dd HH:mm:ss")).equals(date) || de.getCleConducteur() != driverId) continue;
            toReturn.add(de);
        }
        return toReturn;
    }
}

