/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.ClosePayPeriod;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.exception.PayPeriodNotFoundException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class PayPeriod
extends MainElement {
    public static final String table = "PAY_PERIOD";
    private static Vector<PayPeriod> list = null;
    private int id = 0;
    private String name = null;
    private java.util.Date begin = null;
    private java.util.Date end = null;

    public PayPeriod(int id, String name, java.util.Date begin, java.util.Date end) {
        this.id = id;
        this.name = name;
        this.begin = begin;
        this.end = end;
    }

    public boolean equals(Object object) {
        return object instanceof PayPeriod && ((PayPeriod)object).getBegin().equals(this.begin) && ((PayPeriod)object).getEnd().equals(this.end);
    }

    public int hashCode() {
        int hash = 2;
        hash = this.begin != null ? this.begin.hashCode() : 0;
        return hash += this.end != null ? this.end.hashCode() : 0;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public java.util.Date getBegin() {
        return this.begin;
    }

    public void setBegin(java.util.Date begin) {
        this.begin = begin;
    }

    public java.util.Date getEnd() {
        return this.end;
    }

    public void setEnd(java.util.Date end) {
        this.end = end;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    /*
     * Loose catch block
     */
    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO PAY_PERIOD (ID, NAME, BEGIN, END) VALUES (GEN_PAY_PERIOD.nextval,?,?,?)";
                    this.statement = PayPeriod.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO PAY_PERIOD (NAME, BEGIN, END) VALUES (?,?,?)";
                    this.statement = PayPeriod.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.name, 12);
                this.statement.setDate(2, new Date(this.begin.getTime()));
                this.statement.setDate(3, new Date(this.end.getTime()));
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    ResultSet rs = this.statement.getGeneratedKeys();
                    if (!rs.next()) {
                        TimsLogger.debug("#PayPeriod.insert# no auto generated key availaible");
                    } else {
                        TimsLogger.debug("#PayPeriod.insert# auto generated key value = " + rs.getInt(1));
                        this.id = rs.getInt(1);
                    }
                    rs.close();
                } else if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    if (this.loadId()) {
                        TimsLogger.debug("#PayPeriod.insert# generated key value = " + this.id);
                    } else {
                        TimsLogger.debug("#PayPeriod.insert# no generated key availaible");
                    }
                }
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    private boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID) as ID FROM PAY_PERIOD WHERE NAME = ?";
        try {
            try {
                this.statement = PayPeriod.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.name, 12);
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    TimsLogger.debug("#PayPeriod.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#PayPeriod.loadId()#  : " + ex);
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE PAY_PERIOD SET NAME=?, BEGIN=?, END=? WHERE ID = ?";
        try {
            try {
                this.statement = PayPeriod.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.name, 12);
                this.statement.setDate(2, new Date(this.begin.getTime()));
                this.statement.setDate(3, new Date(this.end.getTime()));
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean close(int ... agenciesId) {
        Transport.bdd.startTransaction();
        int[] nArray = agenciesId;
        int n = agenciesId.length;
        int n2 = 0;
        while (n2 < n) {
            int agencyId = nArray[n2];
            if (!new ClosePayPeriod(0, this.id, agencyId, ConnexionSettings.getInstance().getUserCle(), 1, 1, new java.util.Date(), 1).update()) {
                Transport.bdd.rollback();
                return false;
            }
            ++n2;
        }
        Transport.bdd.commit();
        return true;
    }

    public static Vector<PayPeriod> getList() {
        if (list == null) {
            list = PayPeriod.loadList(null);
        }
        return list;
    }

    public static void setList(Vector<PayPeriod> list) {
        PayPeriod.list = list;
    }

    public static PayPeriod getPayPeriod(int idPayPeriod) throws PayPeriodNotFoundException {
        for (PayPeriod tmp : PayPeriod.getList()) {
            if (tmp.getId() != idPayPeriod) continue;
            return tmp;
        }
        throw new PayPeriodNotFoundException();
    }

    public static Vector<PayPeriod> loadList(Vector<Agence> agencies) {
        Vector<PayPeriod> result = new Vector<PayPeriod>();
        String sql = "";
        try {
            String agencyRestriction = "";
            if (agencies != null) {
                for (Agence tmp : agencies) {
                    agencyRestriction = String.valueOf(agencyRestriction) + "," + tmp.getCleAgence();
                }
            }
            sql = "SELECT ID, NAME, BEGIN, END FROM PAY_PERIOD";
            String where = "";
            if (!agencyRestriction.equals("")) {
                where = String.valueOf(where) + " WHERE ID NOT IN (SELECT DISTINCT PAY_PERIOD_ID FROM CLOSE_PAY_PERIOD WHERE AGENCY_ID IN (" + agencyRestriction.substring(1) + ") AND CLOTURE = 1 AND ACTIVE = 1)";
            }
            sql = String.valueOf(sql) + where + " ORDER BY BEGIN";
            TimsLogger.debug(sql);
            Statement stm = PayPeriod.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new PayPeriod(rs.getInt("ID"), rs.getString("NAME"), rs.getDate("BEGIN"), rs.getDate("END")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("PayPeriod.loadList(  )  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static HashMap<PayPeriod, Integer> loadResumeList(Vector<Agence> agencies) {
        HashMap<PayPeriod, Integer> result = new HashMap<PayPeriod, Integer>();
        String sql = "";
        try {
            String agencyRestriction = "";
            if (agencies != null) {
                for (Agence tmp : agencies) {
                    agencyRestriction = String.valueOf(agencyRestriction) + "," + tmp.getCleAgence();
                }
            }
            sql = "SELECT PAY_PERIOD.ID, NAME, BEGIN, END, COUNT(PAY_PERIOD_ID) NB FROM PAY_PERIOD join CLOSE_PAY_PERIOD ON PAY_PERIOD.ID = PAY_PERIOD_ID WHERE CLOTURE = 1 AND ACTIVE = 1";
            if (!agencyRestriction.equals("")) {
                sql = String.valueOf(sql) + " AND AGENCY_ID IN (" + agencyRestriction.substring(1) + ")";
            }
            sql = String.valueOf(sql) + "GROUP BY PAY_PERIOD.ID, NAME, BEGIN, END UNION SELECT ID, NAME, BEGIN, END, 0 FROM PAY_PERIOD WHERE ID NOT IN ( SELECT PAY_PERIOD_ID FROM CLOSE_PAY_PERIOD WHERE CLOTURE = 1 AND ACTIVE = 1";
            if (!agencyRestriction.equals("")) {
                sql = String.valueOf(sql) + " AND AGENCY_ID IN (" + agencyRestriction.substring(1) + ")";
            }
            sql = String.valueOf(sql) + ")";
            Transport.ps.startOperation();
            Statement stm = PayPeriod.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate p\u00e9riode de paie", "#PayPeriod.loadResumeList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                PayPeriod toAdd = new PayPeriod(rs.getInt("ID"), rs.getString("NAME"), rs.getDate("BEGIN"), rs.getDate("END"));
                result.put(toAdd, rs.getInt("NB"));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("PayPeriod.loadResumeList(  )  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }
}

