/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Pays;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.util.Constants;

public class Place
extends MainElement {
    public static final String table = "place";
    public static final String[] EntryType = new String[]{"place.type0", "place.type1", "place.type2", "place.type3", "place.type4", "place.type5"};
    int cle = 0;
    int driverId = 0;
    int type = 0;
    Date dateTime = null;
    int km = 0;
    int pays = 0;
    int region = 0;

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public Place(int id, int driverId, int type, Date dateTime, int km, int pays, int region) {
        this.cle = id;
        this.driverId = driverId;
        this.type = type;
        this.dateTime = dateTime;
        this.km = km;
        this.pays = pays;
        this.region = region;
    }

    public boolean insert() {
        boolean retour = false;
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO place (ID, DRIVER_ID, TYPE, DATE_CHANGE, COUNTRY, REGION, KM) VALUES (GEN_T_LIEN_JOUR_VEHICULE.nextval,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO place (DRIVER_ID, TYPE, DATE_CHANGE, COUNTRY, REGION, KM) VALUES (?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = Place.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.driverId, 4);
                this.statement.setObject(2, (Object)this.type, 4);
                this.statement.setTimestamp(3, new Timestamp(this.dateTime.getTime()));
                this.statement.setObject(4, (Object)this.pays, 4);
                this.statement.setObject(5, (Object)this.region, 4);
                this.statement.setObject(6, (Object)this.km, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                this.affiche();
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean delete() {
        boolean retour = false;
        String sql = "DELETE FROM place WHERE ID=?";
        try {
            try {
                this.statement = Place.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cle, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public Date getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }

    public int getKm() {
        return this.km;
    }

    public void setKm(int km) {
        this.km = km;
    }

    public int getPays() {
        return this.pays;
    }

    public void setPays(int pays) {
        this.pays = pays;
    }

    public int getRegion() {
        return this.region;
    }

    public void setRegion(int region) {
        this.region = region;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getSqlString() {
        SimpleDateFormat dateFormatBddHeure = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormatBddHeure.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        return String.valueOf(this.getDriverId()) + "\t" + this.getType() + "\t" + dateFormatBddHeure.format(this.getDateTime()) + "\t" + this.getPays() + "\t" + this.getRegion() + "\t" + this.getKm();
    }

    public void affiche() {
        TimsLogger.info("driver id = " + this.driverId + "date = " + ConversionTime.dateToString(this.dateTime, "dd/MM/yyyy HH:mm") + ". pays = " + Pays.getLibellePays(this.pays) + ". km v\u00e9hicule = " + this.km);
    }

    public static Vector<Place> load(int driverId, String begin, String end) {
        Vector<Place> liste = new Vector<Place>();
        String restriction = "";
        restriction = driverId != 0 ? String.valueOf(restriction) + " AND DRIVER_ID = " + driverId : String.valueOf(restriction) + " AND DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0") + ")";
        if (begin != null && !begin.equals("")) {
            restriction = end != null && !end.equals("") ? String.valueOf(restriction) + " AND DATE_CHANGE >= " + BddTransport.getDateStringToSGBDR(begin, false) + " AND DATE_CHANGE <= " + BddTransport.getDateStringToSGBDR(end, false) : String.valueOf(restriction) + " AND " + BddTransport.getDateTruncation("DATE_CHANGE") + " = " + BddTransport.getDateStringToSGBDR(begin, false);
        }
        String sql = "SELECT ID, DRIVER_ID, TYPE, DATE_CHANGE, COUNTRY, REGION, KM FROM place";
        if (!restriction.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
        }
        sql = String.valueOf(sql) + " ORDER BY DRIVER_ID, DATE_CHANGE";
        ResultSet rs = null;
        try {
            Transport.ps.startOperation();
            Statement stm = Place.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate lieux", "#Place.load() => %s# sql = " + sql, 1);
            while (rs.next()) {
                liste.add(new Place(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getInt("TYPE"), rs.getTimestamp("DATE_CHANGE"), rs.getInt("KM"), rs.getInt("COUNTRY"), rs.getInt("REGION")));
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("Place.load()  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return liste;
    }
}

