/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Droit;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.ReportAccess;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class Profil
extends MainElement {
    int cle = 0;
    String nomProfil = null;
    boolean defaut = false;
    Vector<Droit> droit = null;
    Vector<ReportAccess> report = null;

    public Profil() {
        this.cle = 0;
        this.nomProfil = "GOD";
    }

    public Profil(int cle, String nom, boolean defaut) {
        this.cle = cle;
        this.nomProfil = nom;
        this.defaut = defaut;
        this.afficheProfil();
    }

    public int getCle() {
        return this.cle;
    }

    public void setCle(int cleProfil) {
        this.cle = cleProfil;
    }

    public String getNomProfil() {
        return this.nomProfil;
    }

    public boolean isDefault() {
        return this.defaut;
    }

    public void setDefault(boolean defaut) {
        this.defaut = defaut;
    }

    public void setNomProfil(String nomProfil) {
        this.nomProfil = nomProfil;
    }

    public Vector<Droit> getDroit() {
        return this.droit;
    }

    public void setDroit(Vector<Droit> droit) {
        this.droit = droit;
    }

    public Vector<ReportAccess> getReport() {
        return this.report;
    }

    public void setReport(Vector<ReportAccess> report) {
        this.report = report;
    }

    public void afficheProfil() {
        TimsLogger.debug("Nom : " + this.getNomProfil() + " Cle : " + this.getCle());
    }

    public boolean update() {
        if (this.cle == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean retour = false;
        if (this.defaut) {
            this.updateNoDefault();
        }
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO t_profil(CLE_PROFIL, NOM_PROFIL, DEFAUT) VALUES (GEN_T_PROFIL.nextval,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + "t_profil" + "(NOM_PROFIL, DEFAUT) VALUES " + "(?,?)";
        }
        try {
            try {
                this.statement = Profil.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.nomProfil, 12);
                this.statement.setObject(2, (Object)(this.defaut ? 1 : 0), 4);
                this.statement.executeUpdate();
                this.statement.close();
                this.loadCle();
                Droit.createList(this.cle, this.droit);
                ReportAccess.createList(this.cle, this.report);
                BddTransport.getInstance().fireDBChanged(new BddEvent("t_profil", Constants.ACTION_TYPE.CREATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        if (this.defaut) {
            this.updateNoDefault();
        }
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + "t_profil" + " SET " + " NOM_PROFIL=?, " + " DEFAUT=? " + " WHERE CLE_PROFIL=?";
        try {
            try {
                this.statement = Profil.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.nomProfil, 12);
                this.statement.setObject(2, (Object)(this.defaut ? 1 : 0), 4);
                this.statement.setObject(3, (Object)this.cle, 4);
                if (this.statement.executeUpdate() == 1) {
                    retour = true;
                }
                this.statement.close();
                Droit.updateList(this.droit);
                ReportAccess.updateList(this.report);
                BddTransport.getInstance().fireDBChanged(new BddEvent("t_profil", Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + "t_profil" + " WHERE CLE_PROFIL =?";
        try {
            this.statement = Profil.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.cle);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent("t_profil", Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean updateNoDefault() {
        boolean retour = false;
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + "t_profil" + " SET DEFAUT=0 ";
        try {
            try {
                this.statement = Profil.getConnection().prepareStatement(sql);
                this.statement.executeUpdate();
                retour = true;
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent("t_profil", Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public void loadRight() {
        if (this.droit != null && this.droit.size() != 0) {
            return;
        }
        if (this.droit == null) {
            this.droit = new Vector();
        }
        String sql = "";
        try {
            try {
                sql = "SELECT CLE_DROIT, fi.CLE_FICHE, NOM_FICHE, ECRITURE, MODIFICATION, SUPPRESSION, CONSULTATION FROM " + BddTransport.getBaseDefault(true) + "t_droit" + " dr" + " JOIN " + BddTransport.getBaseDefault(true) + "t_fiche" + " fi " + " ON dr.CLE_FICHE=fi.CLE_FICHE" + " WHERE dr.CLE_PROFIL = " + this.cle + " ORDER BY NOM_FICHE";
                Statement stm = Profil.getConnection().createStatement();
                ResultSet rs = stm.executeQuery(sql);
                while (rs.next()) {
                    this.droit.add(new Droit(rs.getInt("CLE_DROIT"), this.cle, rs.getInt("CLE_FICHE"), rs.getString("NOM_FICHE"), rs.getBoolean("ECRITURE"), rs.getBoolean("MODIFICATION"), rs.getBoolean("SUPPRESSION"), rs.getBoolean("CONSULTATION")));
                }
                rs.close();
                stm.close();
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (Exception ex) {
                TimsLogger.warn("Profil.loadRight() : " + ex);
                TimsLogger.debug("sql = " + sql);
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void loadReportAccess() {
        if (this.report != null && this.report.size() != 0) {
            return;
        }
        if (this.report == null) {
            this.report = new Vector();
        }
        String sql = "SELECT DR.CLE, CLE_PROFIL, ID, TRANSLATION_ID, CUSTOMIZED_NAME, FILE_NAME, CLASS, MINIMUM_VERSION, TYPE, ENABLE, MODULE FROM " + BddTransport.getBaseDefault(true) + "DROIT_RAPPORT" + " DR" + " join " + BddTransport.getBaseDefault(true) + Report.table + " R ON DR.CLE_RAPPORT=R.ID" + " WHERE CLE_PROFIL =" + this.cle + " ORDER BY CUSTOMIZED_NAME";
        try {
            Statement stm = Profil.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                this.report.add(new ReportAccess(rs.getInt("CLE"), rs.getInt("CLE_PROFIL"), new Report(rs.getInt("ID"), rs.getString("TRANSLATION_ID"), rs.getString("CUSTOMIZED_NAME"), rs.getString("FILE_NAME"), rs.getString("CLASS"), rs.getInt("MINIMUM_VERSION"), rs.getInt("MODULE"), rs.getInt("TYPE")), rs.getBoolean("ENABLE")));
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("Profil.loadReportAccess()  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
    }

    public void loadCle() {
        String sql = "";
        try {
            try {
                StringBuilder stringBuilder = new StringBuilder("SELECT CLE_PROFIL FROM ").append(BddTransport.getBaseDefault(true)).append("t_profil").append(" WHERE NOM_PROFIL ='");
                BddTransport.getInstance();
                sql = stringBuilder.append(BddTransport.addSlashes(this.nomProfil)).append("'").toString();
                Statement stm = Profil.getConnection().createStatement();
                ResultSet rs = stm.executeQuery(sql);
                while (rs.next()) {
                    this.cle = rs.getInt("CLE_PROFIL");
                }
                rs.close();
                stm.close();
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (Exception ex) {
                TimsLogger.warn("Profil.loadCle() : " + ex);
                TimsLogger.debug("sql = " + sql);
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Vector<Profil> list() {
        Vector<Profil> result = new Vector<Profil>();
        String sql = "";
        try {
            sql = "SELECT CLE_PROFIL, NOM_PROFIL, DEFAUT FROM " + BddTransport.getBaseDefault(true) + "t_profil" + " ORDER BY NOM_PROFIL";
            Statement stm = Profil.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new Profil(rs.getInt(1), rs.getString(2), rs.getInt("DEFAUT") == 1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Profil.getProfilList() : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static Profil findById(Vector<Profil> list, int profilId) {
        for (Profil tmp : list) {
            if (tmp.getCle() != profilId) continue;
            return tmp;
        }
        return null;
    }
}

