/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ElementArbre;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;

public class Region
extends MainElement
implements ElementArbre {
    public static final String table = "region";
    public static Vector<Region> regions = null;
    int id;
    int countryId = 0;
    String name = null;
    String code = null;

    public String toString() {
        return this.name;
    }

    public Region() {
    }

    public Region(int regionId) {
        this.load(regionId);
    }

    public Region(int regionId, String name, String code, int countryId) {
        this.id = regionId;
        this.countryId = countryId;
        this.name = name;
        this.code = code;
    }

    @Override
    public String getLibelle() {
        return String.valueOf(this.name) + (this.code != null && !this.code.equals("") ? " - " + this.code : "");
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public int getCle() {
        return this.getId();
    }

    public boolean equals(Object object) {
        boolean toReturn = object instanceof Region && ((Region)object).getLibelle() != null && this.getLibelle() != null && ((Region)object).getLibelle().equals(this.getLibelle());
        return toReturn;
    }

    public int hashCode() {
        int hash = (this.name == null ? 0 : this.name.hashCode()) + table.hashCode();
        return hash;
    }

    public boolean insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO region (ID, COUNTRY_ID, NAME, CODE) VALUES (GEN_REGION.nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO region (COUNTRY_ID, NAME, CODE) VALUES (?,?,?)";
        }
        try {
            this.statement = Region.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.countryId, 4);
            this.statement.setObject(2, (Object)this.name, 12);
            this.statement.setObject(3, (Object)this.code, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean update() {
        String sql = "UPDATE region SET COUNTRY_ID=? , NAME=? , CODE=? WHERE ID=?";
        try {
            this.statement = Region.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.countryId, 4);
            this.statement.setObject(2, (Object)this.name, 12);
            this.statement.setObject(3, (Object)this.code, 12);
            this.statement.setObject(4, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean delete() {
        String sql = "DELETE FROM region WHERE ID =?";
        try {
            this.statement = Region.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean compareAndUpdate(String name, String code, int country) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.region")) + " n\u00b0 " + this.id + "\n";
        if (!name.equals(this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("agency.name") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (!code.equals(this.code)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.cp") + " '" + this.code + "' => '" + code + "'\n";
            this.setCode(code);
        }
        if (country != this.countryId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("agency.size.title") + " '" + this.countryId + "' => '" + country + "'\n";
            this.setCountryId(country);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.agency")) + " n\u00b0 " + this.id + "\n")) {
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
            return this.update();
        }
        return true;
    }

    public boolean load(int cle) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT ID, COUNTRY_ID, NAME, CODE FROM region WHERE ID=?";
        try {
            try {
                this.statement = Region.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)cle, 4);
                rs = this.statement.executeQuery();
                if (rs.next()) {
                    this.id = cle;
                    this.countryId = rs.getInt("COUNTRY_ID");
                    this.name = rs.getString("NAME");
                    this.code = rs.getString("CODE");
                } else {
                    TimsLogger.info("#Region.load# no data for region n\u00b0" + cle);
                }
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (Exception ex) {
                block24: {
                    TimsLogger.debug("#Region.getRegion(String cle)# : " + ex);
                    if (Transport.debug < 2) break block24;
                    ex.printStackTrace();
                }
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int regionId) {
        this.id = regionId;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getCountryId() {
        return this.countryId;
    }

    public void setCountryId(int countryId) {
        this.countryId = countryId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static Vector<Region> loadList(int countryId) {
        Vector<Region> toReturn = new Vector<Region>();
        ResultSet rs = null;
        Statement stm = null;
        String sql = "SELECT ID, NAME, CODE, COUNTRY_ID FROM region";
        String restriction = BddTransport.addRestriction("t_agence", "");
        if (restriction != "") {
            restriction = " AND ID IN (SELECT REGION_ID FROM t_agence WHERE  " + restriction + ")";
        }
        if (restriction != "") {
            sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
        }
        if (countryId != 0) {
            sql = String.valueOf(sql) + " AND COUNTRY_ID = " + countryId;
        }
        sql = String.valueOf(sql) + " ORDER BY NAME";
        try {
            try {
                stm = Region.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new Region(rs.getInt("ID"), rs.getString("NAME"), rs.getString("CODE"), rs.getInt("COUNTRY_ID")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("Rate.loadList()  : " + ex);
                TimsLogger.debug(sql);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static Vector<Region> getList() {
        if (regions == null) {
            regions = Region.loadList(0);
        }
        return regions;
    }

    public static void setList(Vector<Region> regions) {
        if (Transport.apiMode == 0) {
            TimsLogger.info("#Region.setList# define a new list");
        }
        Region.regions = regions;
    }

    public static Region find(Vector<Region> regions, int regionId) {
        if (regions == null) {
            regions = Region.getList();
        }
        for (Region tmp : regions) {
            if (tmp.getId() != regionId) continue;
            return tmp;
        }
        return null;
    }
}

