/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class Repairing
extends MainElement {
    public static final String table = "REPAIRING";
    private static Vector<Repairing> list = null;
    private int id = 0;
    private Date day = null;
    private int accidentId = 0;
    private int garageId = 0;
    private String purpose = null;
    private float totalCost = 0.0f;
    private float moCost = 0.0f;

    public Repairing() {
    }

    public Repairing(int id, Date day, int accidentId, int garageId, String purpose, float totalCost, float moCost) {
        this.id = id;
        this.day = day;
        this.accidentId = accidentId;
        this.garageId = garageId;
        this.purpose = purpose;
        this.totalCost = totalCost;
        this.moCost = moCost;
    }

    public boolean equals(Object o) {
        return o instanceof Repairing && this.accidentId == ((Repairing)o).getAccidentId() && this.garageId == ((Repairing)o).getGarageId() && this.purpose.equals(((Repairing)o).getPurpose());
    }

    public String toString() {
        return this.getPurpose();
    }

    public Object clone() {
        return new Repairing(this.id, this.day, this.accidentId, this.garageId, this.purpose, this.totalCost, this.moCost);
    }

    public boolean loadByPurpose(String purpose) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(Repairing.getAllFields()).append(" FROM ").append(table).append(" WHERE PURPOSE='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(purpose)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + Repairing.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = Repairing.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#Repairing.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#Repairing.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.day = rs.getDate("DAY");
                    this.accidentId = rs.getInt("ACCIDENT_ID");
                    this.garageId = rs.getInt("GARAGE_ID");
                    this.purpose = rs.getString("PURPOSE");
                    this.totalCost = rs.getFloat("TOTAL_COST");
                    this.moCost = rs.getFloat("MO_COST");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#Repairing.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#Repairing.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO REPAIRING (" + Repairing.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO REPAIRING (" + Repairing.getAllFields().substring(Repairing.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?)";
        }
        try {
            this.statement = Repairing.getConnection().prepareStatement(sql);
            this.statement.setDate(1, this.day == null ? null : new java.sql.Date(this.day.getTime()));
            this.statement.setObject(2, (Object)this.accidentId, 4);
            this.statement.setObject(3, (Object)this.garageId, 4);
            this.statement.setObject(4, (Object)this.purpose, 12);
            this.statement.setObject(5, (Object)Float.valueOf(this.totalCost), 6);
            this.statement.setObject(6, (Object)Float.valueOf(this.moCost), 6);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE REPAIRING SET  DAY=? , ACCIDENT_ID=? , GARAGE_ID=? , PURPOSE=? , TOTAL_COST=? , MO_COST=?  WHERE ID=?";
        try {
            this.statement = Repairing.getConnection().prepareStatement(sql);
            this.statement.setDate(1, this.day == null ? null : new java.sql.Date(this.day.getTime()));
            this.statement.setObject(2, (Object)this.accidentId, 4);
            this.statement.setObject(3, (Object)this.garageId, 4);
            this.statement.setObject(4, (Object)this.purpose, 12);
            this.statement.setObject(5, (Object)Float.valueOf(this.totalCost), 6);
            this.statement.setObject(6, (Object)Float.valueOf(this.moCost), 6);
            this.statement.setObject(7, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean compareAndUpdate(Date day, int accidentId, int garageId, String purpose, float totalCost, float moCost) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.repair")) + " n\u00b0 " + this.id + " (" + this.getPurpose() + ") \n";
        if (Fonctions.fieldChange(day, this.day)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.day") + " '" + this.day + "' => '" + day + "'\n";
            this.setDay(day);
        }
        if (this.accidentId != accidentId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident") + " '" + this.accidentId + "' => '" + accidentId + "'\n";
            this.setAccidentId(accidentId);
        }
        if (this.garageId != garageId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.garage") + " '" + this.garageId + "' => '" + garageId + "'\n";
            this.setGarageId(garageId);
        }
        if (Fonctions.fieldChange(purpose, this.purpose)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.purpose") + " '" + this.purpose + "' => '" + purpose + "'\n";
            this.setPurpose(purpose);
        }
        if (this.totalCost != totalCost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.cost") + " '" + this.totalCost + "' => '" + totalCost + "'\n";
            this.setTotalCost(totalCost);
        }
        if (this.moCost != moCost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.moCost") + " '" + this.moCost + "' => '" + moCost + "'\n";
            this.setMoCost(moCost);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.repair")) + " n\u00b0 " + this.id + " (" + this.getPurpose() + ") \n")) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#Repairing# no changes");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM REPAIRING WHERE ID=?";
        try {
            try {
                this.statement = Repairing.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                toReturn = true;
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 1, new Date(), String.valueOf(LanguageTranslator.getString("generics.repairing")) + " n\u00b0 " + this.id).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDay() {
        return this.day;
    }

    public void setDay(Date day) {
        this.day = day;
    }

    public int getAccidentId() {
        return this.accidentId;
    }

    public void setAccidentId(int accidentId) {
        this.accidentId = accidentId;
    }

    public int getGarageId() {
        return this.garageId;
    }

    public void setGarageId(int garageId) {
        this.garageId = garageId;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public float getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(float totalCost) {
        this.totalCost = totalCost;
    }

    public float getMoCost() {
        return this.moCost;
    }

    public void setMoCost(float moCost) {
        this.moCost = moCost;
    }

    private static String getAllFields() {
        return "ID, DAY, ACCIDENT_ID, GARAGE_ID, PURPOSE, TOTAL_COST, MO_COST";
    }

    public static Vector<Repairing> loadList(int accidentId) {
        Vector<Repairing> liste = new Vector<Repairing>();
        String sql = "SELECT " + Repairing.getAllFields() + " FROM " + table;
        if (accidentId != 0) {
            sql = String.valueOf(sql) + " WHERE ACCIDENT_ID =" + accidentId;
        }
        sql = String.valueOf(sql) + " ORDER BY DAY";
        try {
            ResultSet rs = null;
            Statement stm = Repairing.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                Repairing tmp = new Repairing(rs.getInt("ID"), rs.getDate("DAY"), rs.getInt("ACCIDENT_ID"), rs.getInt("GARAGE_ID"), rs.getString("PURPOSE"), rs.getFloat("TOTAL_COST"), rs.getFloat("MO_COST"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Repairing.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return liste;
    }

    public static Vector<Repairing> getList() {
        if (list == null) {
            list = Repairing.loadList(0);
        }
        return list;
    }

    public static void setList(Vector<Repairing> list) {
        Repairing.list = list;
    }

    public static Repairing getObligationType(int idType) throws DBObjectNotFoundException {
        for (Repairing tmp : Repairing.getList()) {
            if (tmp.getId() != idType) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("Repairing");
    }
}

