/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Report;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class ReportAccess
extends MainElement {
    public static final String table = "DROIT_RAPPORT";
    private int cle;
    private int cleProfil;
    private Report report;
    private boolean enable;

    public int getCleProfil() {
        return this.cleProfil;
    }

    public void setCleProfil(int cleProfil) {
        this.cleProfil = cleProfil;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public ReportAccess(int cle, int cleProfil, Report report, boolean enable) {
        this.cle = cle;
        this.cleProfil = cleProfil;
        this.report = report;
        this.enable = enable;
    }

    public int getCle() {
        return this.cle;
    }

    public void setCle(int cle) {
        this.cle = cle;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean insert() {
        boolean retour = false;
        String sql = "";
        TimsLogger.debug("#ReportAccess.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (CLE, CLE_PROFIL, CLE_RAPPORT, ENABLE)" + " VALUES (GEN_DROIT_RAPPORT.nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (CLE_PROFIL, CLE_RAPPORT, ENABLE)" + " VALUES (?,?,?)";
        }
        try {
            try {
                this.statement = ReportAccess.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleProfil, 4);
                this.statement.setObject(2, (Object)this.report.getId(), 4);
                this.statement.setObject(3, (Object)this.enable, 4);
                retour = this.statement.executeUpdate() != 0;
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean update() {
        boolean retour = false;
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " ENABLE=? " + " WHERE CLE=?";
        try {
            try {
                this.statement = ReportAccess.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)(this.enable ? 1 : 0), 4);
                this.statement.setObject(2, (Object)this.cle, 4);
                if (this.statement.executeUpdate() == 1) {
                    retour = true;
                }
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public static Vector<ReportAccess> loadDefaultAccess() {
        Vector<ReportAccess> liste = new Vector<ReportAccess>();
        TimsLogger.debug("report.loadDefaultAccess");
        String sql = "SELECT DR.CLE, CLE_PROFIL, ID, TRANSLATION_ID, CUSTOMIZED_NAME, FILE_NAME, CLASS, MINIMUM_VERSION, TYPE, ENABLE, MODULE FROM " + BddTransport.getBaseDefault(true) + table + " DR join " + BddTransport.getBaseDefault(true) + Report.table + " R ON DR.CLE_RAPPORT=R.ID WHERE CLE_PROFIL = 1 ORDER BY CUSTOMIZED_NAME";
        try {
            Statement stm = ReportAccess.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                liste.add(new ReportAccess(rs.getInt("CLE"), rs.getInt("CLE_PROFIL"), new Report(rs.getInt("ID"), rs.getString("TRANSLATION_ID"), rs.getString("CUSTOMIZED_NAME"), rs.getString("FILE_NAME"), rs.getString("CLASS"), rs.getInt("MINIMUM_VERSION"), rs.getInt("MODULE"), rs.getInt("TYPE")), rs.getBoolean("ENABLE")));
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("ReportAccess.loadDefaultAccess()  : " + ex.toString());
            TimsLogger.debug("sql = " + sql);
        }
        return liste;
    }

    public static boolean updateList(Vector<ReportAccess> toUpdate) {
        for (ReportAccess iter : toUpdate) {
            TimsLogger.debug("update " + iter.cle + " " + iter.isEnable());
            if (iter.update()) continue;
            return false;
        }
        return true;
    }

    public static boolean createList(int profilId, Vector<ReportAccess> toUpdate) {
        for (ReportAccess iter : toUpdate) {
            iter.setCleProfil(profilId);
            if (iter.insert()) continue;
            return false;
        }
        return true;
    }
}

