/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.MainElement;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.util.Constants;

public class Service
extends MainElement {
    public static int OFFSET = 120;
    public static final String table = "t_service";
    private int id = 0;
    private int driverId = 0;
    private String beginDate = null;
    private String endDate = null;
    private int beginTime = 0;
    private int endTime = 0;
    private int driving = 0;
    private int work = 0;
    private int availability = 0;
    private int rest = 0;
    private int crew = 0;
    private int unk = 0;
    private int other = 0;
    private int service = 0;
    private int amplitude = 0;
    private int night = 0;
    private int nightHardness = 0;
    private int distance = 0;
    private float expense = 0.0f;
    private int cut = 0;
    private int dailyRest = 0;
    private int firstWork;
    private int lastWork;
    private int firstWorkAfterRest;
    private int secondWorkAfterRest;
    private int roundId = 0;
    private int theoricServicePoint = 0;
    private int calculatedServicePoint = 0;

    public Service() {
    }

    public Service(int cleConducteur, String dateDebut, String dateFin, int heureDebut, int heureFin, int dureeConduite, int dureeTravail, int dureeDispo, int dureeRepos, int dureeDE, int dureeInconnu, int dureeAutre, int dureeService, int cut, int reposJour, int amplitude, int heureNuit, int nightHardness, float frais, int distance, int firstWork, int lastWork, int firstWorkAfterRest, int secondWorkAfterRest, int roundId, int theoricServicePoint, int calculatedServicePoint) {
        this.driverId = cleConducteur;
        this.beginDate = String.valueOf(dateDebut.substring(0, 10)) + " " + ConversionTime.heureIntToString(heureDebut, ":") + ":00";
        this.endDate = String.valueOf(dateFin.substring(0, 10)) + " " + ConversionTime.heureIntToString(heureFin, ":") + ":00";
        this.beginTime = heureDebut;
        this.endTime = heureFin;
        this.driving = dureeConduite;
        this.work = dureeTravail;
        this.availability = dureeDispo;
        this.rest = dureeRepos;
        this.crew = dureeDE;
        this.unk = dureeInconnu;
        this.other = dureeAutre;
        this.service = dureeService;
        this.cut = cut;
        this.dailyRest = reposJour;
        this.amplitude = amplitude;
        this.night = heureNuit;
        this.nightHardness = nightHardness;
        this.expense = frais;
        this.distance = distance;
        this.firstWork = firstWork;
        this.lastWork = lastWork;
        this.firstWorkAfterRest = firstWorkAfterRest;
        this.secondWorkAfterRest = secondWorkAfterRest;
        this.roundId = roundId;
        this.theoricServicePoint = theoricServicePoint;
        this.calculatedServicePoint = calculatedServicePoint;
    }

    public String toString() {
        return "cleConducteur " + this.driverId + ConversionTime.heureIntToString(this.beginTime, "h") + " de service " + " du " + this.beginDate + " " + ConversionTime.heureIntToString(this.beginTime, "h") + " au " + this.endDate + " " + ConversionTime.heureIntToString(this.endTime, "h");
    }

    public boolean load(int driverId, String begin) {
        ResultSet rs = null;
        String sql = "";
        sql = "SELECT " + Service.getAllFields() + " FROM " + table + " WHERE CLE_CHAUFFEUR = ? AND DATE_DEBUT = ?";
        try {
            this.statement = Service.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)driverId, 4);
            this.statement.setTimestamp(2, Timestamp.valueOf(begin));
            rs = this.statement.executeQuery();
            if (rs.next()) {
                this.id = rs.getInt("CLE_SERVICE");
                this.driverId = rs.getInt("CLE_CHAUFFEUR");
                this.beginTime = rs.getInt("HEURE_DEBUT");
                this.endTime = rs.getInt("HEURE_FIN");
                this.beginDate = Service.getDateFromSGBD(rs.getString("DATE_DEBUT"));
                this.endDate = Service.getDateFromSGBD(rs.getString("DATE_FIN"));
                this.driving = rs.getInt("CONDUITE");
                this.work = rs.getInt("TRAVAIL");
                this.availability = rs.getInt("DISPO");
                this.rest = rs.getInt("REPOS");
                this.crew = rs.getInt("DOUBLE_EQUIPAGE");
                this.unk = rs.getInt("INCONNU");
                this.other = rs.getInt("EVENEMENT");
                this.service = rs.getInt("SERVICE");
                this.dailyRest = rs.getInt("REPOS_JOURNALIER");
                this.amplitude = rs.getInt("AMPLITUDE");
                this.night = rs.getInt("HEURE_NUIT");
                this.nightHardness = rs.getInt("NUIT_PENIBILITE");
                this.expense = rs.getInt("FRAIS");
                this.distance = rs.getInt("DISTANCE");
                this.firstWork = rs.getInt("FIRST_WORK");
                this.lastWork = rs.getInt("LAST_WORK");
                this.firstWorkAfterRest = rs.getInt("FIRST_WORK_AFTER_REST");
                this.secondWorkAfterRest = rs.getInt("SECOND_WORK_AFTER_REST");
                return true;
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    public boolean exists() {
        ResultSet rs = null;
        String sql = "";
        sql = "SELECT * FROM t_service WHERE CLE_CHAUFFEUR = ? AND (DATE_DEBUT = ? OR DATE_FIN = ?)";
        try {
            this.statement = Service.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setTimestamp(2, Timestamp.valueOf(this.beginDate));
            this.statement.setTimestamp(3, Timestamp.valueOf(this.endDate));
            rs = this.statement.executeQuery();
            if (rs.next()) {
                this.statement.close();
                rs.close();
                return true;
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    public String getInsertString() {
        return String.valueOf(this.getDriverId()) + "\t" + this.getBeginDate() + "\t" + this.getEndDate() + "\t" + this.getBeginTime() + "\t" + this.getEndTime() + "\t" + this.getDriving() + "\t" + this.getWork() + "\t" + this.getAvailability() + "\t" + this.getRest() + "\t" + this.getCrew() + "\t" + this.getUnk() + "\t" + this.getOther() + "\t" + this.getService() + "\t" + this.getCut() + "\t" + this.getDailyRest() + "\t" + this.getAmplitude() + "\t" + this.getNight() + "\t" + this.getNightHardness() + "\t" + this.getExpense() + "\t" + this.getDistance() + "\t" + this.getFirstWork() + "\t" + this.getLastWork() + "\t" + this.getFirstWorkAfterRest() + "\t" + this.getSecondWorkAfterRest() + "\t" + this.getRoundId() + "\t" + this.getTheoricServicePoint() + "\t" + this.getCalculatedServicePoint();
    }

    public void insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO t_service (CLE_SERVICE, CLE_CHAUFFEUR, DATE_DEBUT, DATE_FIN, HEURE_DEBUT, HEURE_FIN, CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIPAGE, INCONNU, EVENEMENT, SERVICE, COUPURE, REPOS_JOURNALIER, AMPLITUDE, HEURE_NUIT, NUIT_PENIBILITE, FRAIS, DISTANCE, FIRST_WORK, LAST_WORK, FIRST_WORK_AFTER_REST, SECOND_WORK_AFTER_REST,ROUND_ID, THEORIC_SERVICE_POINT, CALCULATED_SERVICE_POINT) VALUES (GEN_T_SERVICE.nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO t_service (CLE_CHAUFFEUR, DATE_DEBUT, DATE_FIN, HEURE_DEBUT, HEURE_FIN, CONDUITE, TRAVAIL, DISPO, REPOS, DOUBLE_EQUIPAGE, INCONNU, EVENEMENT, SERVICE, COUPURE, REPOS_JOURNALIER, AMPLITUDE, HEURE_NUIT, NUIT_PENIBILITE, FRAIS, DISTANCE, FIRST_WORK, LAST_WORK, FIRST_WORK_AFTER_REST, SECOND_WORK_AFTER_REST,ROUND_ID, THEORIC_SERVICE_POINT, CALCULATED_SERVICE_POINT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = Service.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.driverId, 4);
                this.statement.setTimestamp(2, Timestamp.valueOf(this.beginDate));
                this.statement.setTimestamp(3, Timestamp.valueOf(this.endDate));
                this.statement.setObject(4, (Object)this.beginTime, 4);
                this.statement.setObject(5, (Object)this.endTime, 4);
                this.statement.setObject(6, (Object)this.driving, 4);
                this.statement.setObject(7, (Object)this.work, 4);
                this.statement.setObject(8, (Object)this.availability, 4);
                this.statement.setObject(9, (Object)this.rest, 4);
                this.statement.setObject(10, (Object)this.crew, 4);
                this.statement.setObject(11, (Object)this.unk, 4);
                this.statement.setObject(12, (Object)this.other, 4);
                this.statement.setObject(13, (Object)this.service, 4);
                this.statement.setObject(14, (Object)this.cut, 4);
                this.statement.setObject(15, (Object)this.dailyRest, 4);
                this.statement.setObject(16, (Object)this.amplitude, 4);
                this.statement.setObject(17, (Object)this.night, 4);
                this.statement.setObject(18, (Object)this.nightHardness, 4);
                this.statement.setObject(19, (Object)Float.valueOf(this.expense), 6);
                this.statement.setObject(20, (Object)this.distance, 4);
                this.statement.setObject(21, (Object)this.firstWork, 4);
                this.statement.setObject(22, (Object)this.lastWork, 4);
                this.statement.setObject(23, (Object)this.firstWorkAfterRest, 4);
                this.statement.setObject(24, (Object)this.secondWorkAfterRest, 4);
                this.statement.setObject(25, (Object)this.roundId, 4);
                this.statement.setObject(26, (Object)this.theoricServicePoint, 4);
                this.statement.setObject(27, (Object)this.calculatedServicePoint, 4);
                this.statement.executeUpdate();
                this.statement.close();
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean update() {
        TimsLogger.debug("#Service.update# ");
        this.affiche();
        if (this.id == 0) {
            return false;
        }
        String sql = "UPDATE t_service SET  CLE_CHAUFFEUR=? , DATE_DEBUT=? , DATE_FIN=? , HEURE_DEBUT=? , HEURE_FIN=? , CONDUITE=? , TRAVAIL=? , DISPO=? , REPOS=? , DOUBLE_EQUIPAGE=? , INCONNU=? , EVENEMENT=? , SERVICE=? , COUPURE=? , REPOS_JOURNALIER=? , AMPLITUDE=? , HEURE_NUIT=? , NUIT_PENIBILITE=? , FRAIS=? , DISTANCE=? , FIRST_WORK=? , LAST_WORK=? , FIRST_WORK_AFTER_REST=? , SECOND_WORK_AFTER_REST=?,  ROUND_ID=?,  THEORIC_SERVICE_POINT=?,  CALCULATED_SERVICE_POINT=? WHERE CLE_SERVICE = ?";
        try {
            this.statement = Service.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setTimestamp(2, Timestamp.valueOf(Service.getTimestampToSGBD(this.beginDate)));
            this.statement.setTimestamp(3, Timestamp.valueOf(Service.getTimestampToSGBD(this.endDate)));
            this.statement.setObject(4, (Object)this.beginTime, 4);
            this.statement.setObject(5, (Object)this.endTime, 4);
            this.statement.setObject(6, (Object)this.driving, 4);
            this.statement.setObject(7, (Object)this.work, 4);
            this.statement.setObject(8, (Object)this.availability, 4);
            this.statement.setObject(9, (Object)this.rest, 4);
            this.statement.setObject(10, (Object)this.crew, 4);
            this.statement.setObject(11, (Object)this.unk, 4);
            this.statement.setObject(12, (Object)this.other, 4);
            this.statement.setObject(13, (Object)this.service, 4);
            this.statement.setObject(14, (Object)this.cut, 4);
            this.statement.setObject(15, (Object)this.dailyRest, 4);
            this.statement.setObject(16, (Object)this.amplitude, 4);
            this.statement.setObject(17, (Object)this.night, 4);
            this.statement.setObject(18, (Object)this.nightHardness, 4);
            this.statement.setObject(19, (Object)Float.valueOf(this.expense), 6);
            this.statement.setObject(20, (Object)this.distance, 4);
            this.statement.setObject(21, (Object)this.firstWork, 4);
            this.statement.setObject(22, (Object)this.lastWork, 4);
            this.statement.setObject(23, (Object)this.firstWorkAfterRest, 4);
            this.statement.setObject(24, (Object)this.secondWorkAfterRest, 4);
            this.statement.setObject(25, (Object)this.roundId, 4);
            this.statement.setObject(26, (Object)this.theoricServicePoint, 4);
            this.statement.setObject(27, (Object)this.calculatedServicePoint, 4);
            this.statement.setObject(28, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public void affiche() {
        TimsLogger.info("#Service.affiche# cleConducteur " + this.driverId + " du " + this.beginDate + " " + ConversionTime.heureIntToString(this.beginTime, "h") + " au " + this.endDate + " " + ConversionTime.heureIntToString(this.endTime, "h") + ", s = " + this.service + " dr = " + this.dailyRest + " a = " + this.amplitude);
    }

    public int getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(int amplitude) {
        this.amplitude = amplitude;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int cleConducteur) {
        this.driverId = cleConducteur;
    }

    public String getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(String dateDebut) {
        this.beginDate = dateDebut;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String dateFin) {
        this.endDate = dateFin;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public int getDriving() {
        return this.driving;
    }

    public void setDriving(int dureeConduite) {
        this.driving = dureeConduite;
    }

    public int getCrew() {
        return this.crew;
    }

    public void setCrew(int dureeDE) {
        this.crew = dureeDE;
    }

    public int getAvailability() {
        return this.availability;
    }

    public void setAvailability(int dureeDispo) {
        this.availability = dureeDispo;
    }

    public int getOther() {
        return this.other;
    }

    public void setOther(int dureeEvenement) {
        this.other = dureeEvenement;
    }

    public int getUnk() {
        return this.unk;
    }

    public void setUnk(int dureeInconnu) {
        this.unk = dureeInconnu;
    }

    public int getRest() {
        return this.rest;
    }

    public void setRest(int dureeRepos) {
        this.rest = dureeRepos;
    }

    public int getService() {
        return this.service;
    }

    public void setService(int dureeService) {
        this.service = dureeService;
    }

    public int getWork() {
        return this.work;
    }

    public void setWork(int dureeTravail) {
        this.work = dureeTravail;
    }

    public float getExpense() {
        return this.expense;
    }

    public void setExpense(int frais) {
        this.expense = frais;
    }

    public int getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(int heureDebut) {
        this.beginTime = heureDebut;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int heureFin) {
        this.endTime = heureFin;
    }

    public int getNight() {
        return this.night;
    }

    public void setNight(int heureNuit) {
        this.night = heureNuit;
    }

    public int getNightHardness() {
        return this.nightHardness;
    }

    public void setNightHardness(int nightHardness) {
        this.nightHardness = nightHardness;
    }

    public int getDailyRest() {
        return this.dailyRest;
    }

    public void setDailyRest(int reposJour) {
        this.dailyRest = reposJour;
    }

    public int getFirstWork() {
        return this.firstWork;
    }

    public void setFirstWork(int firstWork) {
        this.firstWork = firstWork;
    }

    public int getFirstWorkAfterRest() {
        return this.firstWorkAfterRest;
    }

    public void setFirstWorkAfterRest(int firstWorkAfterRest) {
        this.firstWorkAfterRest = firstWorkAfterRest;
    }

    public int getLastWork() {
        return this.lastWork;
    }

    public void setLastWork(int lastWork) {
        this.lastWork = lastWork;
    }

    public int getSecondWorkAfterRest() {
        return this.secondWorkAfterRest;
    }

    public void setSecondWorkAfterRest(int secondWorkAfterRest) {
        this.secondWorkAfterRest = secondWorkAfterRest;
    }

    public byte[] write(OutputStream out) {
        this.affiche();
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = ConversionTime.dateStringToBinary(this.beginDate);
            activite = String.valueOf(activite) + ConversionTime.dateStringToBinary(this.endDate);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.beginTime + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.endTime + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.driving + (int)Math.pow(2.0, 16.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.work + (int)Math.pow(2.0, 16.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.availability + (int)Math.pow(2.0, 16.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.rest + (int)Math.pow(2.0, 16.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.crew + (int)Math.pow(2.0, 16.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.unk + (int)Math.pow(2.0, 16.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.other + (int)Math.pow(2.0, 16.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.dailyRest + (int)Math.pow(2.0, 16.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.night + (int)Math.pow(2.0, 12.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.distance + (int)Math.pow(2.0, 12.0)).substring(1);
            int x = 0;
            while (x < 23) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            tmp.write(Float.toString(this.expense).getBytes());
            TimsLogger.debug("service to bytearray " + new String(tmp.toByteArray()));
            out.write((byte)OFFSET);
            out.write((byte)(tmp.size() / 255 + 1));
            out.write((byte)tmp.size());
            tmp.writeTo(out);
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#Service.write# " + ex);
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 23) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            ++x;
        }
        this.beginTime = Integer.parseInt(tmp.substring(26, 37), 2);
        this.endTime = Integer.parseInt(tmp.substring(37, 48), 2);
        this.beginDate = String.valueOf(ConversionTime.binaryToDateString(tmp)) + " " + ConversionTime.heureIntToString(this.beginTime, ":") + ":00";
        this.endDate = String.valueOf(ConversionTime.binaryToDateString(tmp.substring(13))) + " " + ConversionTime.heureIntToString(this.endTime, ":") + ":00";
        this.driving = Integer.parseInt(tmp.substring(48, 64), 2);
        this.work = Integer.parseInt(tmp.substring(64, 80), 2);
        this.availability = Integer.parseInt(tmp.substring(80, 96), 2);
        this.rest = Integer.parseInt(tmp.substring(96, 112), 2);
        this.crew = Integer.parseInt(tmp.substring(112, 128), 2);
        this.unk = Integer.parseInt(tmp.substring(128, 144), 2);
        this.other = Integer.parseInt(tmp.substring(144, 160), 2);
        this.service = this.driving + this.work + this.availability + this.crew;
        this.amplitude = this.driving + this.work + this.availability + this.crew + this.rest + this.unk + this.other;
        this.night = Integer.parseInt(tmp.substring(160, 172), 2);
        this.distance = Integer.parseInt(tmp.substring(172, 184), 2);
        this.expense = Float.parseFloat(new String(fileBuffer).substring(23));
    }

    public int getCut() {
        return this.cut;
    }

    public void setCut(int cut) {
        this.cut = cut;
    }

    public int getRoundId() {
        return this.roundId;
    }

    public void setRoundId(int roundId) {
        this.roundId = roundId;
    }

    public int getTheoricServicePoint() {
        return this.theoricServicePoint;
    }

    public void setTheoricServicePoint(int theoricServicePoint) {
        this.theoricServicePoint = theoricServicePoint;
    }

    public int getCalculatedServicePoint() {
        return this.calculatedServicePoint;
    }

    public void setCalculatedServicePoint(int calculatedServicePoint) {
        this.calculatedServicePoint = calculatedServicePoint;
    }

    private static String getAllFields() {
        return "CLE_SERVICE, t_service.CLE_CHAUFFEUR, SERVICE," + BddTransport.getDateSGBDRToString("DATE_DEBUT", true, "") + "," + BddTransport.getDateSGBDRToString("DATE_FIN", true, "") + ", " + " HEURE_DEBUT, HEURE_FIN, DISPO,REPOS, TRAVAIL, DOUBLE_EQUIPAGE, CONDUITE, INCONNU, EVENEMENT," + " DISTANCE, COUPURE, REPOS_JOURNALIER, AMPLITUDE, HEURE_NUIT, NUIT_PENIBILITE, FRAIS, FIRST_WORK, LAST_WORK," + " FIRST_WORK_AFTER_REST, SECOND_WORK_AFTER_REST, ROUND_ID, THEORIC_SERVICE_POINT, CALCULATED_SERVICE_POINT";
    }

    public static Vector<Service> getService(int cleAgence, int cleConducteur, java.util.Date debut, java.util.Date fin) {
        String res = "";
        res = cleConducteur != 0 ? String.valueOf(res) + " AND t_service.CLE_CHAUFFEUR=" + cleConducteur : String.valueOf(res) + " AND c.ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
        if (debut != null) {
            res = String.valueOf(res) + " AND DATE_DEBUT>=" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(debut, "yyyy-MM-dd"), false);
        }
        if (fin != null) {
            res = String.valueOf(res) + " AND DATE_DEBUT<" + BddTransport.addDayToDate(BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(fin, "yyyy-MM-dd"), false), 1);
        }
        if (cleAgence != 0) {
            res = String.valueOf(res) + " AND c.CLE_AGENCE = " + cleAgence;
        }
        if (!res.equals("")) {
            res = " WHERE " + res.substring(5);
        }
        return Service.getService(res);
    }

    public static Vector<Service> getService(Vector<Agence> agencies, Vector<Conducteur> drivers, java.util.Date debut, java.util.Date fin) {
        String res = "";
        if (agencies != null && agencies.size() != 0) {
            String agencyFilter = Service.buildAgencyFilters(agencies, "c.CLE_AGENCE");
            res = String.valueOf(res) + " AND t_service.CLE_CHAUFFEUR IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE " + agencyFilter + ")" + " AND c.ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
        }
        res = drivers != null && drivers.size() != 0 ? String.valueOf(res) + " AND " + Service.buildDriverFilters(drivers, "t_service.CLE_CHAUFFEUR") : String.valueOf(res) + " AND c.ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
        if (debut != null) {
            res = String.valueOf(res) + " AND DATE_DEBUT>=" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(debut, "yyyy-MM-dd"), false);
        }
        if (fin != null) {
            res = String.valueOf(res) + " AND DATE_DEBUT<" + BddTransport.addDayToDate(BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(fin, "yyyy-MM-dd"), false), 1);
        }
        if (!res.equals("")) {
            res = " WHERE " + res.substring(5);
        }
        return Service.getService(res);
    }

    public static Vector<Service> getService(int agencyId, Vector<Conducteur> drivers, java.util.Date debut, java.util.Date fin) {
        return Service.getService(agencyId, drivers, ConversionTime.dateToString(debut, "yyyy-MM-dd"), ConversionTime.dateToString(fin, "yyyy-MM-dd"));
    }

    public static Vector<Service> getService(int agencyId, Vector<Conducteur> drivers, String debut, String fin) {
        String res = "";
        if (agencyId != 0) {
            res = String.valueOf(res) + " AND c.CLE_AGENCE = " + agencyId;
        }
        if (drivers != null && drivers.size() != 0) {
            res = String.valueOf(res) + " AND " + Service.buildDriverFilters(drivers, "t_service.CLE_CHAUFFEUR");
        }
        if (debut != null) {
            res = String.valueOf(res) + " AND DATE_DEBUT>=" + BddTransport.getDateStringToSGBDR(debut, false);
        }
        if (fin != null) {
            res = String.valueOf(res) + " AND DATE_DEBUT<" + BddTransport.addDayToDate(BddTransport.getDateStringToSGBDR(fin, false), 1);
        }
        if (!res.equals("")) {
            res = " WHERE " + res.substring(5);
        }
        return Service.getService(res);
    }

    public static Vector<Service> getService(String filters) {
        Vector<Service> result;
        block4: {
            String sql = "";
            result = new Vector<Service>();
            try {
                sql = "SELECT NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, " + Service.getAllFields() + " FROM " + table + " JOIN " + "t_conducteur" + " c on " + table + ".CLE_CHAUFFEUR=c.CLE_CHAUFFEUR" + filters + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, DATE_DEBUT";
                Transport.ps.startOperation();
                Statement stm = Service.getConnection().createStatement();
                ResultSet rs = stm.executeQuery(sql);
                long duration = Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate lieux");
                TimsLogger.debug("#Service.getService() => " + duration + " ms# sql = " + sql);
                while (rs.next()) {
                    result.add(new Service(rs.getInt("CLE_CHAUFFEUR"), rs.getString("DATE_DEBUT"), rs.getString("DATE_FIN"), rs.getInt("HEURE_DEBUT"), rs.getInt("HEURE_FIN"), rs.getInt("CONDUITE"), rs.getInt("TRAVAIL"), rs.getInt("DISPO"), rs.getInt("REPOS"), rs.getInt("DOUBLE_EQUIPAGE"), rs.getInt("INCONNU"), rs.getInt("EVENEMENT"), rs.getInt("SERVICE"), rs.getInt("COUPURE"), rs.getInt("REPOS_JOURNALIER"), rs.getInt("AMPLITUDE"), rs.getInt("HEURE_NUIT"), rs.getInt("NUIT_PENIBILITE"), rs.getInt("FRAIS"), rs.getInt("DISTANCE"), rs.getInt("FIRST_WORK"), rs.getInt("LAST_WORK"), rs.getInt("FIRST_WORK_AFTER_REST"), rs.getInt("SECOND_WORK_AFTER_REST"), rs.getInt("ROUND_ID"), rs.getInt("THEORIC_SERVICE_POINT"), rs.getInt("CALCULATED_SERVICE_POINT")));
                }
                rs.close();
                stm.close();
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
            }
            catch (Exception ex) {
                TimsLogger.warn("Service.loadList() : " + ex);
                TimsLogger.debug("sql = " + sql);
                if (Transport.debug < 1) break block4;
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static Vector<Service> find(Vector<Service> toSearch, int driverId, java.util.Date date) {
        Vector<Service> toReturn = new Vector<Service>();
        for (Service serv : toSearch) {
            if (!ConversionTime.stringToDate(serv.getBeginDate().substring(0, 10), "yyyy-MM-dd").equals(date) || serv.getDriverId() != driverId) continue;
            toReturn.add(serv);
        }
        return toReturn;
    }

    public static int getNightHour(int cleConducteur, String begin, String end) {
        int total;
        block4: {
            String sql = "";
            total = 0;
            try {
                sql = "SELECT SUM(HEURE_NUIT) as TOTAL FROM t_service WHERE CLE_CHAUFFEUR = " + cleConducteur + " AND DATE_DEBUT BETWEEN \"" + begin + "\" AND \"" + end + "\"";
                Statement stm = Service.getConnection().createStatement();
                ResultSet rs = stm.executeQuery(sql);
                while (rs.next()) {
                    total = rs.getInt("TOTAL");
                }
                rs.close();
                stm.close();
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
            }
            catch (Exception ex) {
                TimsLogger.warn("Service.getNightHour() : " + ex);
                TimsLogger.debug("sql = " + sql);
                if (Transport.debug < 1) break block4;
                ex.printStackTrace();
            }
        }
        TimsLogger.debug("#Service.getNightHour# Total heure de nuit = " + total);
        return total;
    }

    public static boolean updateKm(int driverId, String date, int km) {
        String sql = "";
        try {
            sql = "UPDATE t_service SET  DISTANCE = ? WHERE " + BddTransport.getDateTruncation("DATE_DEBUT") + " = ? AND CLE_CHAUFFEUR = ?";
            TimsLogger.debug("updateKm() sql : " + sql);
            PreparedStatement stm = Service.getConnection().prepareStatement(sql);
            stm.setObject(1, (Object)km, 4);
            stm.setDate(2, new Date(ConversionTime.stringToDate(date, "yyyy-MM-dd").getTime()));
            stm.setObject(3, (Object)driverId, 4);
            stm.executeUpdate();
            stm.close();
            return true;
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.data.BddTransport.getService() : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return false;
    }

    public static boolean updateHardness(int driverId, String date, int night) {
        String sql = "";
        try {
            sql = "UPDATE t_service SET  NUIT_PENIBILITE = ? WHERE " + BddTransport.getDateTruncation("DATE_DEBUT") + " = ? AND CLE_CHAUFFEUR = ?";
            TimsLogger.debug("updateKm() sql : " + sql);
            PreparedStatement stm = Service.getConnection().prepareStatement(sql);
            stm.setObject(1, (Object)night, 4);
            stm.setDate(2, new Date(ConversionTime.stringToDate(date, "yyyy-MM-dd").getTime()));
            stm.setObject(3, (Object)driverId, 4);
            stm.executeUpdate();
            stm.close();
            return true;
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Service.updateHardness() : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return false;
    }

    public static String getPreviousService(int cleConducteur, String date) {
        String result;
        block4: {
            String sql = "";
            result = null;
            try {
                sql = "SELECT MAX(DATE_DEBUT) as DATE_DEBUT FROM t_service WHERE CLE_CHAUFFEUR = " + cleConducteur + " AND DATE_DEBUT<\"" + date + "\"";
                Statement stm = Service.getConnection().createStatement();
                ResultSet rs = stm.executeQuery(sql);
                if (rs.next() && rs.getString("DATE_DEBUT") != null) {
                    result = rs.getString("DATE_DEBUT").substring(0, 19);
                }
                rs.close();
                stm.close();
                TimsLogger.debug("sql = " + sql);
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
            }
            catch (Exception ex) {
                TimsLogger.warn("Service.getPreviousService() : " + ex);
                TimsLogger.debug("sql = " + sql);
                if (Transport.debug < 1) break block4;
                ex.printStackTrace();
            }
        }
        TimsLogger.debug("#Service.getPreviousService# 1er service avant = " + date + " = " + result);
        return result;
    }

    public static String getNextService(int cleConducteur, String date) {
        String result;
        block4: {
            String sql = "";
            result = null;
            try {
                sql = "SELECT MIN(DATE_DEBUT) as DATE_DEBUT FROM t_service WHERE CLE_CHAUFFEUR = " + cleConducteur + " AND DATE_DEBUT>\"" + date + "\"";
                Statement stm = Service.getConnection().createStatement();
                ResultSet rs = stm.executeQuery(sql);
                while (rs.next()) {
                    if (rs.getString("DATE_DEBUT") == null) continue;
                    result = rs.getString("DATE_DEBUT").substring(0, 19);
                }
                rs.close();
                stm.close();
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
            }
            catch (Exception ex) {
                TimsLogger.warn("Service.getNextService() : " + ex);
                TimsLogger.debug("sql = " + sql);
                if (Transport.debug < 1) break block4;
                ex.printStackTrace();
            }
        }
        TimsLogger.debug("#Service.getNextService# 1er service apr\u00e8s = " + date + " = " + result);
        return result;
    }
}

